/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.TextureAttributesRetained;
import javax.media.j3d.Transform3D;
import javax.vecmath.Color4f;

public class TextureAttributes
extends NodeComponent {
    public static final int ALLOW_MODE_READ = 0;
    public static final int ALLOW_MODE_WRITE = 1;
    public static final int ALLOW_BLEND_COLOR_READ = 2;
    public static final int ALLOW_BLEND_COLOR_WRITE = 3;
    public static final int ALLOW_TRANSFORM_READ = 4;
    public static final int ALLOW_TRANSFORM_WRITE = 5;
    public static final int ALLOW_COLOR_TABLE_READ = 6;
    public static final int ALLOW_COLOR_TABLE_WRITE = 7;
    public static final int FASTEST = 0;
    public static final int NICEST = 1;
    public static final int MODULATE = 2;
    public static final int DECAL = 3;
    public static final int BLEND = 4;
    public static final int REPLACE = 5;

    public TextureAttributes() {
    }

    public TextureAttributes(int n, Transform3D transform3D, Color4f color4f, int n2) {
        if (n < 2 || n > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes10"));
        }
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes9"));
        }
        ((TextureAttributesRetained)this.retained).initTextureMode(n);
        ((TextureAttributesRetained)this.retained).initTextureBlendColor(color4f);
        ((TextureAttributesRetained)this.retained).initTextureTransform(transform3D);
        ((TextureAttributesRetained)this.retained).initPerspectiveCorrectionMode(n2);
    }

    public NodeComponent cloneNodeComponent() {
        TextureAttributes textureAttributes = new TextureAttributes();
        textureAttributes.duplicateNodeComponent(this);
        return textureAttributes;
    }

    void createRetained() {
        this.retained = new TextureAttributesRetained();
        this.retained.setSource(this);
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        TextureAttributesRetained textureAttributesRetained = (TextureAttributesRetained)nodeComponent.retained;
        TextureAttributesRetained textureAttributesRetained2 = (TextureAttributesRetained)this.retained;
        Color4f color4f = new Color4f();
        textureAttributesRetained.getTextureBlendColor(color4f);
        Transform3D transform3D = new Transform3D();
        textureAttributesRetained.getTextureTransform(transform3D);
        textureAttributesRetained2.initTextureMode(textureAttributesRetained.getTextureMode());
        textureAttributesRetained2.initPerspectiveCorrectionMode(textureAttributesRetained.getPerspectiveCorrectionMode());
        textureAttributesRetained2.initTextureBlendColor(color4f);
        textureAttributesRetained2.initTextureTransform(transform3D);
        if (textureAttributesRetained.getNumTextureColorTableComponents() != 0 && textureAttributesRetained.getTextureColorTableSize() != 0) {
            int[][] nArray = new int[textureAttributesRetained.getNumTextureColorTableComponents()][textureAttributesRetained.getTextureColorTableSize()];
            textureAttributesRetained.getTextureColorTable(nArray);
            textureAttributesRetained2.initTextureColorTable(nArray);
        }
    }

    public int getNumTextureColorTableComponents() {
        return ((TextureAttributesRetained)this.retained).getNumTextureColorTableComponents();
    }

    public int getPerspectiveCorrectionMode() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes8"));
        }
        return ((TextureAttributesRetained)this.retained).getPerspectiveCorrectionMode();
    }

    public void getTextureBlendColor(Color4f color4f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes4"));
        }
        ((TextureAttributesRetained)this.retained).getTextureBlendColor(color4f);
    }

    public void getTextureColorTable(int[][] nArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(6)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes12"));
        }
        ((TextureAttributesRetained)this.retained).getTextureColorTable(nArray);
    }

    public int getTextureColorTableSize() {
        return ((TextureAttributesRetained)this.retained).getTextureColorTableSize();
    }

    public int getTextureMode() {
        if (this.isLiveOrCompiled() && !this.capabilities.get(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes1"));
        }
        return ((TextureAttributesRetained)this.retained).getTextureMode();
    }

    public void getTextureTransform(Transform3D transform3D) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(4)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes6"));
        }
        ((TextureAttributesRetained)this.retained).getTextureTransform(transform3D);
    }

    public void setPerspectiveCorrectionMode(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes7"));
        }
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes9"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setPerspectiveCorrectionMode(n);
        } else {
            ((TextureAttributesRetained)this.retained).initPerspectiveCorrectionMode(n);
        }
    }

    public void setTextureBlendColor(float f, float f2, float f3, float f4) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes3"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureBlendColor(f, f2, f3, f4);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureBlendColor(f, f2, f3, f4);
        }
    }

    public void setTextureBlendColor(Color4f color4f) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(3)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes2"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureBlendColor(color4f);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureBlendColor(color4f);
        }
    }

    public void setTextureColorTable(int[][] nArray) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(7)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes11"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureColorTable(nArray);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureColorTable(nArray);
        }
    }

    public void setTextureMode(int n) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes0"));
        }
        if (n < 2 || n > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes10"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureMode(n);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureMode(n);
        }
    }

    public void setTextureTransform(Transform3D transform3D) {
        if (this.isLiveOrCompiled() && !this.capabilities.get(5)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureAttributes5"));
        }
        if (this.isLive()) {
            ((TextureAttributesRetained)this.retained).setTextureTransform(transform3D);
        } else {
            ((TextureAttributesRetained)this.retained).initTextureTransform(transform3D);
        }
    }
}

