/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.geo.proj;

import drasys.or.geom.CoordinateSystemI;
import drasys.or.geom.GeomError;
import drasys.or.geom.GeomException;
import drasys.or.geom.RangeI;
import drasys.or.geom.geo.CoordinateSystem;
import drasys.or.geom.geo.EllipsoidI;
import drasys.or.geom.geo.PointI;
import drasys.or.geom.geo.Range;
import drasys.or.geom.geo.proj.ProjectionI;

public abstract class Projection
implements ProjectionI {
    protected double _easting = 0.0;
    protected double _northing = 0.0;
    protected double _e;
    protected double _e2;
    protected double _er;
    protected double _halfE;
    protected double _oneMinusE2;
    protected EllipsoidI _ellipsoid = CoordinateSystem.getEllipsoid();

    public abstract drasys.or.geom.rect2.PointI forward(PointI var1) throws GeomException;

    public drasys.or.geom.rect2.RangeI forward(drasys.or.geom.geo.RangeI rangeI) throws GeomException {
        return new drasys.or.geom.rect2.Range(this.forward(rangeI.southwest()), this.forward(rangeI.northeast()));
    }

    public drasys.or.geom.PointI forwardTransform(drasys.or.geom.PointI pointI) throws GeomException {
        if (!(pointI instanceof PointI)) {
            throw new GeomError("The argument must be a 'geo.PointI'.");
        }
        return this.forward((PointI)pointI);
    }

    public RangeI forwardTransform(RangeI rangeI) throws GeomException {
        if (!(rangeI instanceof drasys.or.geom.geo.RangeI)) {
            throw new GeomError("The argument must be a 'geo.RangeI'.");
        }
        return this.forward((drasys.or.geom.geo.RangeI)rangeI);
    }

    public double getEasting() {
        return this._easting;
    }

    public EllipsoidI getEllipsoid() {
        return this._ellipsoid;
    }

    public double getNorthing() {
        return this._northing;
    }

    public CoordinateSystemI inputCoordinateSystem() {
        return CoordinateSystem.getInstance();
    }

    public abstract PointI inverse(drasys.or.geom.rect2.PointI var1) throws GeomException;

    public drasys.or.geom.geo.RangeI inverse(drasys.or.geom.rect2.RangeI rangeI) throws GeomException {
        return new Range(this.inverse(rangeI.min()), this.inverse(rangeI.max()));
    }

    public drasys.or.geom.PointI inverseTransform(drasys.or.geom.PointI pointI) throws GeomException {
        if (!(pointI instanceof drasys.or.geom.rect2.PointI)) {
            throw new GeomError("The argument must be a 'rect2.PointI'.");
        }
        return this.inverse((drasys.or.geom.rect2.PointI)pointI);
    }

    public RangeI inverseTransform(RangeI rangeI) throws GeomException {
        if (!(rangeI instanceof drasys.or.geom.rect2.RangeI)) {
            throw new GeomError("The argument must be a 'rect2.RangeI'.");
        }
        return this.inverse((drasys.or.geom.rect2.RangeI)rangeI);
    }

    protected double msfn(double d) {
        return this.msfn(Math.sin(d), Math.cos(d));
    }

    protected double msfn(double d, double d2) {
        return d2 / Math.sqrt(1.0 - this._e2 * d * d);
    }

    public CoordinateSystemI outputCoordinateSystem() {
        return drasys.or.geom.rect2.CoordinateSystem.getInstance();
    }

    protected double phi1(double d) {
        double d2;
        double d3 = Math.asin(0.5 * d);
        if (this._e < CoordinateSystem.getInstance().getAccuracy()) {
            return d3;
        }
        int n = 15;
        do {
            double d4 = Math.sin(d3);
            double d5 = Math.cos(d3);
            double d6 = this._e * d4;
            double d7 = 1.0 - d6 * d6;
            d2 = 0.5 * d7 * d7 / d5 * (d / this._oneMinusE2 - d4 / d7 + 0.5 / this._e * Math.log((1.0 - d6) / (1.0 + d6)));
            d3 += d2;
        } while (Math.abs(d2) > 1.0E-10 && --n != 0);
        return n != 0 ? d3 : Double.MAX_VALUE;
    }

    protected double phi2(double d) {
        double d2;
        double d3 = 1.5707963267948966 - 2.0 * Math.atan(d);
        int n = 15;
        do {
            double d4 = this._e * Math.sin(d3);
            d2 = 1.5707963267948966 - 2.0 * Math.atan(d * Math.pow((1.0 - d4) / (1.0 + d4), this._halfE)) - d3;
            d3 += d2;
        } while (Math.abs(d2) > 1.0E-10 && --n != 0);
        return n != 0 ? d3 : Double.MAX_VALUE;
    }

    protected double qsfn(double d) {
        if (this._e >= CoordinateSystem.getInstance().getAccuracy()) {
            double d2 = this._e * d;
            return this._oneMinusE2 * (d / (1.0 - d2 * d2) - 0.5 / this._e * Math.log((1.0 - d2) / (1.0 + d2)));
        }
        return 2.0 * d;
    }

    public void setEasting(double d) {
        this._easting = d;
    }

    public void setEllipsoid(EllipsoidI ellipsoidI) {
        this._ellipsoid = ellipsoidI;
        this._e = this._ellipsoid.getEccentricity();
        this._e2 = this._ellipsoid.getEccentricitySquared();
        this._er = this._ellipsoid.getEquatorialRadius();
        this._halfE = 0.5 * this._e;
        this._oneMinusE2 = 1.0 - this._e2;
    }

    public void setNorthing(double d) {
        this._northing = d;
    }

    protected double tsfn(double d) {
        return this.tsfn(d, Math.sin(d));
    }

    protected double tsfn(double d, double d2) {
        return Math.tan(0.5 * (1.5707963267948966 - d)) / Math.pow((1.0 - (d2 *= this._e)) / (1.0 + d2), 0.5 * this._e);
    }
}

