/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.rect2;

import drasys.or.geom.rect2.LineSegmentI;
import drasys.or.geom.rect2.Point;
import drasys.or.geom.rect2.PointI;
import drasys.or.geom.rect2.Range;
import drasys.or.geom.rect2.RangeI;
import drasys.or.geom.rect2.Rect2;
import java.io.Serializable;

public class LineSegment
extends Rect2
implements LineSegmentI,
Serializable {
    PointI _point1;
    PointI _point2;
    double _length;

    public LineSegment(double d, double d2, double d3, double d4) {
        this._point1 = new Point(d, d2);
        this._point2 = new Point(d3, d4);
        this._length = this._point1.distanceTo(this._point2);
    }

    public LineSegment(LineSegmentI lineSegmentI) {
        this._point1 = new Point(lineSegmentI.point1());
        this._point2 = new Point(lineSegmentI.point2());
        this._length = this._point1.distanceTo(this._point2);
    }

    public LineSegment(PointI pointI, PointI pointI2) {
        this._point1 = new Point(pointI);
        this._point2 = new Point(pointI2);
        this._length = this._point1.distanceTo(this._point2);
    }

    public PointI centroid() {
        return new Point((this.x1() + this.x2()) * 0.5, (this.y1() + this.y2()) * 0.5);
    }

    public double distanceProxyTo(PointI pointI) {
        double d;
        PointI pointI2 = pointI;
        double d2 = this._point2.x() - this._point1.x();
        double d3 = this._point2.y() - this._point1.y();
        double d4 = pointI2.x() - this._point1.x();
        double d5 = d2 * d4 + d3 * (d = pointI2.y() - this._point1.y());
        if (d5 < 0.0) {
            return d4 * d4 + d * d;
        }
        double d6 = d5 / this._length;
        if (d6 > this._length) {
            double d7 = pointI2.x() - this._point2.x();
            double d8 = pointI2.y() - this._point2.y();
            return d7 * d7 + d8 * d8;
        }
        return d4 * d4 + d * d - d6 * d6;
    }

    public double distanceTo(PointI pointI) {
        return Math.sqrt(this.distanceProxyTo(pointI));
    }

    public boolean equals(Object object) {
        if (!(object instanceof LineSegmentI)) {
            return false;
        }
        LineSegmentI lineSegmentI = (LineSegmentI)object;
        if (!Point.equals(this._point1, lineSegmentI.point1(), this.coordinateSystem().getAccuracy())) {
            return false;
        }
        return Point.equals(this._point2, lineSegmentI.point2(), this.coordinateSystem().getAccuracy());
    }

    public drasys.or.geom.PointI from() {
        return this._point1;
    }

    public drasys.or.geom.PointI getPoint1() {
        return this._point1;
    }

    public drasys.or.geom.PointI getPoint2() {
        return this._point2;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this._point1.x()) + Double.doubleToLongBits(this._point1.y()) + Double.doubleToLongBits(this._point2.x()) + Double.doubleToLongBits(this._point2.y());
        return (int)(l ^ l >> 32);
    }

    public double length() {
        return this._length;
    }

    public PointI nearestPointTo(PointI pointI) {
        double d;
        double d2 = this._point2.x() - this._point1.x();
        double d3 = this._point2.y() - this._point1.y();
        double d4 = pointI.x() - this._point1.x();
        double d5 = d2 * d4 + d3 * (d = pointI.y() - this._point1.y());
        if (d5 < 0.0) {
            return this._point1;
        }
        double d6 = d5 / this._length;
        if (d6 > this._length) {
            return this._point2;
        }
        return new Point(this._point1.x() + (d6 /= this._length) * d2, this._point1.y() + d6 * d3);
    }

    public PointI point1() {
        return this._point1;
    }

    public PointI point2() {
        return this._point2;
    }

    public RangeI range() {
        return new Range(this._point1, this._point2);
    }

    public drasys.or.geom.PointI to() {
        return this._point2;
    }

    public String toString() {
        return "rect2.LineSegment{" + this._point1 + "; " + this._point2 + "}";
    }

    public double x1() {
        return this._point1.x();
    }

    public double x2() {
        return this._point2.x();
    }

    public double y1() {
        return this._point1.y();
    }

    public double y2() {
        return this._point2.y();
    }
}

