/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.rect3;

import drasys.or.geom.rect3.PointI;
import drasys.or.geom.rect3.Range;
import drasys.or.geom.rect3.RangeI;
import drasys.or.geom.rect3.Rect3;
import drasys.or.matrix.VectorI;
import java.io.Serializable;

public class Point
extends Rect3
implements PointI,
Serializable {
    private double _x;
    private double _y;
    private double _z;

    public Point(double d, double d2, double d3) {
        this._x = d;
        this._y = d2;
        this._z = d3;
    }

    public Point(PointI pointI) {
        this._x = pointI.x();
        this._y = pointI.y();
        this._z = pointI.z();
    }

    public Point(VectorI vectorI) {
        this._x = vectorI.elementAt(0);
        this._y = vectorI.elementAt(1);
        this._z = vectorI.elementAt(2);
    }

    public Point(double[] dArray) {
        this._x = dArray[0];
        this._y = dArray[1];
        this._z = dArray[2];
    }

    public PointI centroid() {
        return this;
    }

    public double directionTo(PointI pointI) {
        return Math.atan2(pointI.y() - this._y, pointI.x() - this._x);
    }

    public double distanceProxyTo(PointI pointI) {
        double d = this._x - pointI.x();
        double d2 = this._y - pointI.y();
        double d3 = this._z - pointI.z();
        return d * d + d2 * d2 + d3 * d3;
    }

    public double distanceTo(PointI pointI) {
        double d = this._x - pointI.x();
        double d2 = this._y - pointI.y();
        double d3 = this._z - pointI.z();
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public static boolean equals(PointI pointI, PointI pointI2, double d) {
        if (Math.abs(pointI.x() - pointI2.x()) > d) {
            return false;
        }
        if (Math.abs(pointI.y() - pointI2.y()) > d) {
            return false;
        }
        return !(Math.abs(pointI.z() - pointI2.z()) > d);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PointI)) {
            return false;
        }
        return Point.equals(this, (PointI)object, this.coordinateSystem().getAccuracy());
    }

    public double getCoordinate(int n) {
        return n == 0 ? this._x : (n == 1 ? this._y : this._z);
    }

    public double getDirectionTo(drasys.or.geom.PointI pointI) {
        PointI pointI2 = (PointI)pointI;
        return Math.atan2(pointI2.y() - this._y, pointI2.x() - this._x);
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this._x) + Double.doubleToLongBits(this._y) + Double.doubleToLongBits(this._z);
        return (int)(l ^ l >> 32);
    }

    public PointI nearestPointTo(PointI pointI) {
        return this;
    }

    public RangeI range() {
        return new Range(this, this);
    }

    public String toString() {
        return "rect3.Point(x = " + this._x + ", y = " + this._y + ", z = " + this._z + ")";
    }

    public double x() {
        return this._x;
    }

    public double y() {
        return this._y;
    }

    public double z() {
        return this._z;
    }
}

