/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.tsp;

import drasys.or.graph.GraphI;
import drasys.or.graph.PropertiesI;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.tsp.ConstructI;
import drasys.or.graph.tsp.ImproveI;
import drasys.or.graph.tsp.TSPBase;
import drasys.or.graph.tsp.TSPError;
import drasys.or.graph.tsp.TourNotFoundException;
import java.util.Vector;

public class BestOf
extends TSPBase
implements ConstructI {
    Vector _improve = new Vector();
    Vector _construct = new Vector();
    Vector _improveMax;
    Vector _improveMin = new Vector();
    Vector _constructMin;
    Vector _constructMax;
    Vector _bestOfTour;

    public BestOf() {
        this._improveMax = new Vector();
        this._constructMin = new Vector();
        this._constructMax = new Vector();
    }

    public BestOf(GraphI graphI) {
        this();
        this.setGraph(graphI);
    }

    public void addConstruct(ConstructI constructI) {
        this.addConstruct(constructI, 0, Integer.MAX_VALUE);
    }

    public void addConstruct(ConstructI constructI, int n, int n2) {
        constructI.setEdgeKey(this._edgeKey);
        constructI.setProperties(this._properties);
        if (this._graph != null) {
            constructI.setGraph(this._graph);
        }
        this._construct.addElement(constructI);
        this._constructMin.addElement(new Integer(n));
        this._constructMax.addElement(new Integer(n2));
    }

    public void addImprove(ImproveI improveI) {
        this.addImprove(improveI, 0, Integer.MAX_VALUE);
    }

    public void addImprove(ImproveI improveI, int n, int n2) {
        improveI.setEdgeKey(this._edgeKey);
        improveI.setProperties(this._properties);
        if (this._graph != null) {
            improveI.setGraph(this._graph);
        }
        this._improve.addElement(improveI);
        this._improveMin.addElement(new Integer(n));
        this._improveMax.addElement(new Integer(n2));
    }

    public double constructClosedTour() throws TourNotFoundException {
        this.countVertices();
        this._closed = true;
        this._bestOfTour = null;
        this._bestCost = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < this._construct.size()) {
            if (this._size >= (Integer)this._constructMin.elementAt(n) && this._size <= (Integer)this._constructMax.elementAt(n)) {
                ConstructI constructI = (ConstructI)this._construct.elementAt(n);
                constructI.selectVertex(this._selected);
                double d = constructI.constructClosedTour();
                if (d < this._bestCost) {
                    this._bestCost = d;
                    this._bestOfTour = constructI.getTour();
                }
            }
            ++n;
        }
        if (this._bestOfTour == null) {
            throw new TourNotFoundException();
        }
        int n2 = 0;
        while (n2 < this._improve.size()) {
            ImproveI improveI;
            double d;
            if (this._size >= (Integer)this._improveMin.elementAt(n2) && this._size <= (Integer)this._improveMax.elementAt(n2) && (d = (improveI = (ImproveI)this._improve.elementAt(n2)).improveClosedTour(this._bestOfTour)) < this._bestCost) {
                this._bestCost = d;
                this._bestOfTour = improveI.getTour();
            }
            ++n2;
        }
        return this._bestCost;
    }

    public double constructOpenTour() throws TourNotFoundException {
        this.countVertices();
        this._closed = false;
        this._bestOfTour = null;
        this._bestCost = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < this._construct.size()) {
            if (this._size >= (Integer)this._constructMin.elementAt(n) && this._size <= (Integer)this._constructMax.elementAt(n)) {
                ConstructI constructI = (ConstructI)this._construct.elementAt(n);
                constructI.selectVertex(this._selected);
                double d = constructI.constructOpenTour();
                if (d < this._bestCost) {
                    this._bestCost = d;
                    this._bestOfTour = constructI.getTour();
                }
            }
            ++n;
        }
        if (this._bestOfTour == null) {
            throw new TourNotFoundException();
        }
        int n2 = 0;
        while (n2 < this._improve.size()) {
            ImproveI improveI;
            double d;
            if (this._size >= (Integer)this._improveMin.elementAt(n2) && this._size <= (Integer)this._improveMax.elementAt(n2) && (d = (improveI = (ImproveI)this._improve.elementAt(n2)).improveOpenTour(this._bestOfTour)) < this._bestCost) {
                this._bestCost = d;
                this._bestOfTour = improveI.getTour();
            }
            ++n2;
        }
        return this._bestCost;
    }

    public double constructOpenTour(Object object, Object object2) throws TourNotFoundException, VertexNotFoundException {
        this.countVertices();
        this._closed = false;
        this._bestOfTour = null;
        this._bestCost = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < this._construct.size()) {
            if (this._size >= (Integer)this._constructMin.elementAt(n) && this._size <= (Integer)this._constructMax.elementAt(n)) {
                ConstructI constructI = (ConstructI)this._construct.elementAt(n);
                constructI.selectVertex(this._selected);
                double d = constructI.constructOpenTour(object, object2);
                if (d < this._bestCost) {
                    this._bestCost = d;
                    this._bestOfTour = constructI.getTour();
                }
            }
            ++n;
        }
        if (this._bestOfTour == null) {
            throw new TourNotFoundException();
        }
        int n2 = 0;
        while (n2 < this._improve.size()) {
            ImproveI improveI;
            double d;
            if (this._size >= (Integer)this._improveMin.elementAt(n2) && this._size <= (Integer)this._improveMax.elementAt(n2) && (d = (improveI = (ImproveI)this._improve.elementAt(n2)).improveOpenTour(this._bestOfTour, true, true)) < this._bestCost) {
                this._bestCost = d;
                this._bestOfTour = improveI.getTour();
            }
            ++n2;
        }
        return this._bestCost;
    }

    public double constructOpenTourFrom(Object object) throws TourNotFoundException, VertexNotFoundException {
        this.countVertices();
        this._closed = false;
        this._bestOfTour = null;
        this._bestCost = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < this._construct.size()) {
            if (this._size >= (Integer)this._constructMin.elementAt(n) && this._size <= (Integer)this._constructMax.elementAt(n)) {
                ConstructI constructI = (ConstructI)this._construct.elementAt(n);
                constructI.selectVertex(this._selected);
                double d = constructI.constructOpenTourFrom(object);
                if (d < this._bestCost) {
                    this._bestCost = d;
                    this._bestOfTour = constructI.getTour();
                }
            }
            ++n;
        }
        if (this._bestOfTour == null) {
            throw new TourNotFoundException();
        }
        int n2 = 0;
        while (n2 < this._improve.size()) {
            ImproveI improveI;
            double d;
            if (this._size >= (Integer)this._improveMin.elementAt(n2) && this._size <= (Integer)this._improveMax.elementAt(n2) && (d = (improveI = (ImproveI)this._improve.elementAt(n2)).improveOpenTour(this._bestOfTour, true, false)) < this._bestCost) {
                this._bestCost = d;
                this._bestOfTour = improveI.getTour();
            }
            ++n2;
        }
        return this._bestCost;
    }

    public double constructOpenTourTo(Object object) throws TourNotFoundException, VertexNotFoundException {
        this.countVertices();
        this._closed = false;
        this._bestOfTour = null;
        this._bestCost = Double.POSITIVE_INFINITY;
        int n = 0;
        while (n < this._construct.size()) {
            if (this._size >= (Integer)this._constructMin.elementAt(n) && this._size <= (Integer)this._constructMax.elementAt(n)) {
                ConstructI constructI = (ConstructI)this._construct.elementAt(n);
                constructI.selectVertex(this._selected);
                double d = constructI.constructOpenTourTo(object);
                if (d < this._bestCost) {
                    this._bestCost = d;
                    this._bestOfTour = constructI.getTour();
                }
            }
            ++n;
        }
        if (this._bestOfTour == null) {
            throw new TourNotFoundException();
        }
        int n2 = 0;
        while (n2 < this._improve.size()) {
            ImproveI improveI;
            double d;
            if (this._size >= (Integer)this._improveMin.elementAt(n2) && this._size <= (Integer)this._improveMax.elementAt(n2) && (d = (improveI = (ImproveI)this._improve.elementAt(n2)).improveOpenTour(this._bestOfTour, false, true)) < this._bestCost) {
                this._bestCost = d;
                this._bestOfTour = improveI.getTour();
            }
            ++n2;
        }
        return this._bestCost;
    }

    public double getCost() {
        if (this._bestOfTour == null) {
            throw new TSPError("No solution has been created");
        }
        return this._bestCost;
    }

    public Vector getTour() {
        Vector vector = new Vector(this._bestOfTour.size());
        int n = 0;
        while (n < this._bestOfTour.size()) {
            vector.addElement(this._bestOfTour.elementAt(n));
            ++n;
        }
        return vector;
    }

    public void selectVertex(Object object, boolean bl) throws VertexNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph is not set.");
        }
        this.checkChangeCount();
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException();
        }
        this._selected[vertexI.getIndex()] = bl;
    }

    public void selectVertex(boolean bl) {
        if (this._graph == null) {
            throw new TSPError("The graph is not set.");
        }
        this.checkChangeCount();
        int n = 0;
        while (n < this._selected.length) {
            this._selected[n] = bl;
            ++n;
        }
    }

    public void selectVertex(boolean[] blArray) {
        if (this._graph == null) {
            throw new TSPError("The graph is not set.");
        }
        this.checkChangeCount();
        if (blArray.length != this._graph.sizeOfVertices()) {
            throw new TSPError("The size of the select array  must equal the number of vertices in the graph.");
        }
        int n = 0;
        while (n < this._selected.length) {
            this._selected[n] = blArray[n];
            ++n;
        }
    }

    public void setEdgeKey(Object object) {
        super.setEdgeKey(object);
        int n = 0;
        while (n < this._construct.size()) {
            ((ConstructI)this._construct.elementAt(n)).setEdgeKey(object);
            ++n;
        }
        int n2 = 0;
        while (n2 < this._improve.size()) {
            ((ImproveI)this._improve.elementAt(n2)).setEdgeKey(object);
            ++n2;
        }
    }

    public void setGraph(GraphI graphI) {
        super.setGraph(graphI);
        int n = 0;
        while (n < this._construct.size()) {
            ((ConstructI)this._construct.elementAt(n)).setGraph(graphI);
            ++n;
        }
        int n2 = 0;
        while (n2 < this._improve.size()) {
            ((ImproveI)this._improve.elementAt(n2)).setGraph(graphI);
            ++n2;
        }
    }

    public void setProperties(PropertiesI propertiesI) {
        super.setProperties(propertiesI);
        int n = 0;
        while (n < this._construct.size()) {
            ((ConstructI)this._construct.elementAt(n)).setProperties(propertiesI);
            ++n;
        }
        int n2 = 0;
        while (n2 < this._improve.size()) {
            ((ImproveI)this._improve.elementAt(n2)).setProperties(propertiesI);
            ++n2;
        }
    }
}

