/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.vrp;

import drasys.or.graph.EdgeI;
import drasys.or.graph.GraphI;
import drasys.or.graph.PropertiesAdapter;
import drasys.or.graph.PropertiesI;
import drasys.or.graph.VertexI;
import drasys.or.graph.vrp.SolutionNotFoundException;
import java.util.Vector;

public abstract class VRPBase {
    protected GraphI _graph = null;
    protected boolean _closed = false;
    protected boolean _out = false;
    protected Object _edgeKey = null;
    protected Object _depotKey = null;
    protected double _vehicleCost = 0.0;
    protected double _maxCost = Double.POSITIVE_INFINITY;
    protected double _maxLoad = Double.POSITIVE_INFINITY;
    protected PropertiesI _properties = new PropertiesAdapter();

    protected static Vector[] copyTours(Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        int n = 0;
        while (n < vectorArray.length) {
            Vector vector = vectorArray[n];
            Vector vector2 = vectorArray2[n] = new Vector(vector.size());
            int n2 = 0;
            while (n2 < vector.size()) {
                vector2.addElement(vector.elementAt(n2));
                ++n2;
            }
            ++n;
        }
        return vectorArray2;
    }

    public double getCost(VertexI vertexI, VertexI vertexI2) {
        if (vertexI == vertexI2) {
            return 0.0;
        }
        boolean bl = false;
        EdgeI edgeI = this._graph.getMutableEdge(vertexI, vertexI2, this._edgeKey);
        if (this._properties != null && edgeI != null && this._properties.isEdgeRestricted(edgeI, bl)) {
            edgeI = null;
        }
        if (edgeI == null) {
            bl = true;
            edgeI = this._graph.getMutableEdge(vertexI2, vertexI, this._edgeKey);
            if (edgeI != null && edgeI.isDirected()) {
                edgeI = null;
            }
            if (this._properties != null && edgeI != null && this._properties.isEdgeRestricted(edgeI, bl)) {
                edgeI = null;
            }
        }
        if (edgeI == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this._properties.getEdgeCost(edgeI, bl);
    }

    public GraphI getGraph() {
        return this._graph;
    }

    public double getLoad(VertexI vertexI) {
        return this._properties.getVertexDemand(vertexI)[0];
    }

    protected double[] getLoads(Vector[] vectorArray) throws SolutionNotFoundException {
        return null;
    }

    public void setCapacityConstraint(double d) {
        this._maxLoad = d;
    }

    public void setCostConstraint(double d) {
        this._maxCost = d;
    }

    public void setEdgeKey(Object object) {
        this._edgeKey = object;
    }

    public void setGraph(GraphI graphI) {
        this._graph = graphI;
    }

    public void setProperties(PropertiesI propertiesI) {
        this._properties = propertiesI;
    }

    public void setVehicleCost(double d) {
        this._vehicleCost = d;
    }
}

