/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.linear.blas;

import drasys.or.ComplexI;
import drasys.or.linear.blas.BLAS3I;
import drasys.or.linear.blas.BlasException;
import drasys.or.linear.blas.SmpBLAS3;
import drasys.or.matrix.ContiguousMatrixI;

public class MatrixBLAS3 {
    int _base = 0;
    BLAS3I _blas3;

    public MatrixBLAS3() {
        this._blas3 = new SmpBLAS3();
    }

    public MatrixBLAS3(int n) {
        this._base = n;
        this._blas3 = new SmpBLAS3();
    }

    public MatrixBLAS3(int n, BLAS3I bLAS3I) {
        this._base = n;
        this._blas3 = bLAS3I;
    }

    public void dgemm(boolean bl, boolean bl2, double d, ContiguousMatrixI contiguousMatrixI, ContiguousMatrixI contiguousMatrixI2, double d2, ContiguousMatrixI contiguousMatrixI3) throws BlasException {
        int n;
        int n2 = bl ? contiguousMatrixI.sizeOfColumns() : contiguousMatrixI.sizeOfRows();
        int n3 = bl ? contiguousMatrixI.sizeOfRows() : contiguousMatrixI.sizeOfColumns();
        int n4 = bl2 ? contiguousMatrixI2.sizeOfRows() : contiguousMatrixI2.sizeOfColumns();
        int n5 = n = bl2 ? contiguousMatrixI2.sizeOfColumns() : contiguousMatrixI2.sizeOfRows();
        if (n3 != n) {
            throw new BlasException("The columns of 'A' and the rows of 'B' must match: " + n3 + ", " + n);
        }
        if (contiguousMatrixI3.sizeOfRows() != n2) {
            throw new BlasException("The rows of 'A' and 'C' must match: " + contiguousMatrixI3.sizeOfRows() + ", " + n2);
        }
        if (contiguousMatrixI3.sizeOfColumns() != n4) {
            throw new BlasException("The columns of 'A' and 'C' must match: " + contiguousMatrixI3.sizeOfColumns() + ", " + n4);
        }
        int n6 = bl ? contiguousMatrixI.getColumnIncrement() : contiguousMatrixI.getRowIncrement();
        int n7 = bl ? contiguousMatrixI.getRowIncrement() : contiguousMatrixI.getColumnIncrement();
        int n8 = bl2 ? contiguousMatrixI2.getColumnIncrement() : contiguousMatrixI2.getRowIncrement();
        int n9 = bl2 ? contiguousMatrixI2.getRowIncrement() : contiguousMatrixI2.getColumnIncrement();
        int n10 = contiguousMatrixI3.getRowIncrement();
        int n11 = contiguousMatrixI3.getColumnIncrement();
        this._blas3.dgemm(n2 - this._base, n4 - this._base, n3 - this._base, d, contiguousMatrixI.getValueArray(), this._base * (n6 + n7), n6, n7, contiguousMatrixI2.getValueArray(), this._base * (n8 + n9), n8, n9, d2, contiguousMatrixI3.getValueArray(), this._base * (n10 + n11), n10, n11);
    }

    public void zgemm(boolean bl, boolean bl2, ComplexI complexI, drasys.or.matrix.complex.ContiguousMatrixI contiguousMatrixI, drasys.or.matrix.complex.ContiguousMatrixI contiguousMatrixI2, ComplexI complexI2, drasys.or.matrix.complex.ContiguousMatrixI contiguousMatrixI3) throws BlasException {
        int n;
        int n2 = bl ? contiguousMatrixI.sizeOfColumns() : contiguousMatrixI.sizeOfRows();
        int n3 = bl ? contiguousMatrixI.sizeOfRows() : contiguousMatrixI.sizeOfColumns();
        int n4 = bl2 ? contiguousMatrixI2.sizeOfRows() : contiguousMatrixI2.sizeOfColumns();
        int n5 = n = bl2 ? contiguousMatrixI2.sizeOfColumns() : contiguousMatrixI2.sizeOfRows();
        if (n3 != n) {
            throw new BlasException("The columns of 'A' and the rows of 'B' must match: " + n3 + ", " + n);
        }
        if (contiguousMatrixI3.sizeOfRows() != n2) {
            throw new BlasException("The rows of 'A' and 'C' must match: " + contiguousMatrixI3.sizeOfRows() + ", " + n2);
        }
        if (contiguousMatrixI3.sizeOfColumns() != n4) {
            throw new BlasException("The columns of 'A' and 'C' must match: " + contiguousMatrixI3.sizeOfColumns() + ", " + n4);
        }
        int n6 = bl ? contiguousMatrixI.getColumnIncrement() : contiguousMatrixI.getRowIncrement();
        int n7 = bl ? contiguousMatrixI.getRowIncrement() : contiguousMatrixI.getColumnIncrement();
        int n8 = bl2 ? contiguousMatrixI2.getColumnIncrement() : contiguousMatrixI2.getRowIncrement();
        int n9 = bl2 ? contiguousMatrixI2.getRowIncrement() : contiguousMatrixI2.getColumnIncrement();
        int n10 = contiguousMatrixI3.getRowIncrement();
        int n11 = contiguousMatrixI3.getColumnIncrement();
        this._blas3.zgemm(n2 - this._base, n4 - this._base, n3 - this._base, complexI, contiguousMatrixI.getValueArray(), this._base * (n6 + n7), n6, n7, contiguousMatrixI2.getValueArray(), this._base * (n8 + n9), n8, n9, complexI2, contiguousMatrixI3.getValueArray(), this._base * (n10 + n11), n10, n11);
    }
}

