/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.Matrix;
import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.SizableMatrixI;
import drasys.or.matrix.VectorI;
import drasys.or.util.Array;
import java.util.Enumeration;

public abstract class ArrayMatrix
extends Matrix
implements SizableMatrixI {
    int _sizeOfRows = 0;
    int _sizeOfColumns = 0;
    double[][] _values = null;

    public ArrayMatrix(int n, int n2) {
        this._sizeOfRows = n;
        this._sizeOfColumns = n2;
    }

    public ArrayMatrix(double[][] dArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            double[] dArray2 = dArray[n2];
            if (dArray2 != null && dArray2.length > n) {
                n = dArray2.length;
            }
            ++n2;
        }
        this._sizeOfRows = dArray.length;
        this._sizeOfColumns = n;
    }

    public abstract void addColumn(VectorI var1);

    public abstract void addRow(VectorI var1);

    public abstract int capacityOfColumns();

    public abstract int capacityOfRows();

    public double[][] getArray() {
        double[][] dArray = new double[this.sizeOfRows()][this.sizeOfColumns()];
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            dArray[matrixElementI.getRowIndex()][matrixElementI.getColumnIndex()] = matrixElementI.getValue();
        }
        return dArray;
    }

    public double[][] getValueArray() {
        return this._values;
    }

    public boolean isNull(int n, int n2) {
        return false;
    }

    public abstract void setCapacity(int var1, int var2);

    public void setElements(double d) {
        int n = 0;
        while (n < this._values.length) {
            double[] dArray = this._values[n];
            if (dArray != null) {
                Array.copy(dArray.length, dArray, 0, 1, d);
            }
            ++n;
        }
    }

    public abstract void setSize(int var1, int var2);

    public int sizeOfColumns() {
        return this._sizeOfColumns;
    }

    public int sizeOfRows() {
        return this._sizeOfRows;
    }
}

