/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix.complex;

import drasys.or.Complex;
import drasys.or.ComplexI;
import drasys.or.matrix.complex.ComplexContainer;
import drasys.or.matrix.complex.MatrixElementI;
import drasys.or.matrix.complex.MatrixI;
import drasys.or.matrix.complex.VectorElementI;
import drasys.or.matrix.complex.VectorI;
import java.io.Serializable;
import java.util.Enumeration;

public abstract class Matrix
extends ComplexContainer
implements MatrixI,
Serializable {
    public Matrix() {
    }

    public Matrix(double d) {
        super(d);
    }

    public abstract Enumeration columnElements(int var1);

    public abstract Complex elementAt(int var1, int var2);

    public abstract Complex elementAt(int var1, int var2, Complex var3);

    public abstract Enumeration elements();

    public boolean equals(MatrixI matrixI) {
        if (this.sizeOfRows() != matrixI.sizeOfRows()) {
            return false;
        }
        if (this.sizeOfColumns() != matrixI.sizeOfColumns()) {
            return false;
        }
        Complex complex = new Complex();
        if (this.sizeOfElements() == this.sizeOfRows() * this.sizeOfColumns()) {
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                if (this.equals((ComplexI)matrixI.elementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), complex), matrixElementI.getValue())) continue;
                return false;
            }
        } else if (matrixI.sizeOfElements() == matrixI.sizeOfRows() * matrixI.sizeOfColumns()) {
            Enumeration enumeration = matrixI.elements();
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                if (this.equals((ComplexI)this.elementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), complex), matrixElementI.getValue())) continue;
                return false;
            }
        } else {
            Object object;
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                object = (MatrixElementI)enumeration.nextElement();
                if (this.equals((ComplexI)matrixI.elementAt(object.getRowIndex(), object.getColumnIndex(), complex), object.getValue())) continue;
                return false;
            }
            object = matrixI.elements();
            while (object.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)object.nextElement();
                if (this.equals((ComplexI)this.elementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), complex), matrixElementI.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof MatrixI) {
            return this.equals((MatrixI)object);
        }
        return false;
    }

    public abstract double[][] getArray();

    public abstract boolean isColumnMajor();

    public abstract boolean isNull(int var1, int var2);

    public abstract boolean isRowMajor();

    public abstract Enumeration rowElements(int var1);

    public void setColumn(int n, VectorI vectorI) {
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            this.setElementAt(vectorElementI.getIndex(), n, vectorElementI.getValue());
        }
    }

    public void setDiagonal(VectorI vectorI) {
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            int n = vectorElementI.getIndex();
            this.setElementAt(n, n, vectorElementI.getValue());
        }
    }

    public abstract void setElementAt(int var1, int var2, ComplexI var3);

    public abstract void setElements(ComplexI var1);

    public void setElements(MatrixI matrixI) {
        Enumeration enumeration = matrixI.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            this.setElementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), matrixElementI.getValue());
        }
    }

    public void setRow(int n, VectorI vectorI) {
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            this.setElementAt(n, vectorElementI.getIndex(), vectorElementI.getValue());
        }
    }

    public abstract int sizeOfColumns();

    public abstract int sizeOfElements();

    public abstract int sizeOfRows();

    public Complex sum() {
        return this.sum(0, this.sizeOfRows(), 0, this.sizeOfColumns());
    }

    public Complex sum(int n) {
        return this.sum(n, this.sizeOfRows(), n, this.sizeOfColumns());
    }

    public abstract Complex sum(int var1, int var2, int var3, int var4);

    public abstract Complex sumOfSquaredDifferences(int var1, int var2, int var3, int var4, ComplexI var5);

    public Complex sumOfSquaredDifferences(int n, ComplexI complexI) {
        return this.sumOfSquaredDifferences(n, this.sizeOfRows(), n, this.sizeOfColumns(), complexI);
    }

    public Complex sumOfSquaredDifferences(ComplexI complexI) {
        return this.sumOfSquaredDifferences(0, this.sizeOfRows(), 0, this.sizeOfColumns(), complexI);
    }

    public Complex sumOfSquares() {
        return this.sumOfSquares(0, this.sizeOfRows(), 0, this.sizeOfColumns());
    }

    public Complex sumOfSquares(int n) {
        return this.sumOfSquares(n, this.sizeOfRows(), n, this.sizeOfColumns());
    }

    public abstract Complex sumOfSquares(int var1, int var2, int var3, int var4);

    public String toString() {
        String string = "Matrix[" + this.sizeOfRows() + "][" + this.sizeOfColumns() + "] = \n";
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            ComplexI complexI = matrixElementI.getValue();
            string = String.valueOf(string) + "[" + matrixElementI.getRowIndex() + "][" + matrixElementI.getColumnIndex() + "] (" + complexI.getReal() + ", " + complexI.getImag() + ")\n";
        }
        return string;
    }
}

