/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Arrays;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.PermutationTest;
import org.tigr.microarray.mev.cluster.algorithm.impl.RelNetComparator;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.FloatArray;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.IntArray;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.IntSorter;
import org.tigr.util.FloatMatrix;

public class RN
extends AbstractAlgorithm {
    private static final int c_DecileCount = 10;
    public static final double LOG2 = Math.log(2.0);
    private Algorithm permAlgo;
    private boolean stop = false;
    private int number_of_samples;
    private FloatMatrix expMatrix;
    int validN;

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        int n2;
        int n3;
        int n4;
        this.expMatrix = algorithmData.getMatrix("experiment");
        if (this.expMatrix == null) {
            return null;
        }
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.number_of_samples = this.expMatrix.getColumnDimension();
        boolean bl = algorithmParameters.getBoolean("use-permutation");
        float f = 0.8f;
        if (bl) {
            this.permAlgo = new PermutationTest();
            this.permAlgo.addAlgorithmListener((AlgorithmListener)new SubAlgoListener());
            AlgorithmData algorithmData2 = this.permAlgo.execute(algorithmData);
            f = algorithmData2.getParams().getFloat("threshold", f);
        }
        int n5 = algorithmParameters.getInt("distance-function", 1);
        float f2 = algorithmParameters.getFloat("distance-factor", 1.0f);
        boolean bl2 = algorithmParameters.getBoolean("distance-absolute", true);
        float f3 = bl ? f : algorithmParameters.getFloat("min-threshold", 0.8f);
        float f4 = algorithmParameters.getFloat("max-threshold", 1.0f);
        boolean bl3 = algorithmParameters.getBoolean("filter-by-entropy");
        float f5 = algorithmParameters.getFloat("top-n-percent", 100.0f);
        if (f5 < 0.0f || f5 > 100.0f) {
            throw new AlgorithmException("Filter value is out of range (0, 100)%");
        }
        int n6 = n4 = this.expMatrix.getRowDimension();
        int[] nArray = new int[n4];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        if (bl3) {
            double[] dArray = new double[n4];
            for (n3 = 0; n3 < dArray.length; ++n3) {
                dArray[n3] = this.getEntropy(this.expMatrix.A[n3]);
            }
            IntSorter.sort(nArray, new RelNetComparator(dArray));
            n6 = (int)((float)n4 * f5 / 100.0f);
        }
        AlgorithmEvent algorithmEvent = new AlgorithmEvent((Object)this, 1, 100, "Calculation Network");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        n3 = 0;
        int n7 = 0;
        int n8 = n6 * (n6 + 1) / 2;
        int n9 = n8 / 100 + 1;
        IntArray[] intArrayArray = new IntArray[n4];
        FloatArray[] floatArrayArray = new FloatArray[n4];
        for (n2 = 0; n2 < intArrayArray.length; ++n2) {
            intArrayArray[n2] = new IntArray();
            intArrayArray[n2].add(n2);
            floatArrayArray[n2] = new FloatArray();
            floatArrayArray[n2].add(0.0f);
        }
        for (n2 = 0; n2 < n6; ++n2) {
            if (this.stop) {
                throw new AbortException();
            }
            ++n3;
            for (int i = n2 + 1; i < n6; ++i) {
                float f6 = ExperimentUtil.geneDistance(this.expMatrix, null, nArray[n2], nArray[i], n5, f2, bl2);
                if ((f6 *= f6) >= f3 && f6 <= f4) {
                    ++n7;
                    intArrayArray[nArray[n2]].add(nArray[i]);
                    intArrayArray[nArray[i]].add(nArray[n2]);
                    floatArrayArray[nArray[n2]].add(f6);
                    floatArrayArray[nArray[i]].add(f6);
                }
                if (++n3 % n9 != 0) continue;
                algorithmEvent.setIntValue(n3 / n9);
                algorithmEvent.setDescription("Calculation Network (" + String.valueOf(n7) + " links found)");
                this.fireValueChanged(algorithmEvent);
            }
        }
        AlgorithmData algorithmData3 = new AlgorithmData();
        Cluster cluster = new Cluster();
        NodeList nodeList = cluster.getNodeList();
        nodeList.ensureCapacity(n4);
        FloatMatrix floatMatrix = this.getMeans(intArrayArray);
        algorithmData3.addMatrix("means", floatMatrix);
        algorithmData3.addMatrix("variances", this.getVariances(intArrayArray, floatMatrix));
        for (n = 0; n < n4; ++n) {
            nodeList.addNode(new Node(intArrayArray[n].toArray()));
            intArrayArray[n] = null;
        }
        algorithmData3.addCluster("cluster", cluster);
        cluster = new Cluster();
        nodeList = cluster.getNodeList();
        nodeList.ensureCapacity(n4);
        for (n = 0; n < n4; ++n) {
            nodeList.addNode(new Node(RN.float2int(floatArrayArray[n].toArray())));
            floatArrayArray[n] = null;
        }
        algorithmData3.addCluster("weights", cluster);
        algorithmData3.addParam("links", String.valueOf(n7));
        algorithmData3.addParam("min_threshold", String.valueOf(f3));
        return algorithmData3;
    }

    public void abort() {
        this.stop = true;
        if (this.permAlgo != null) {
            this.permAlgo.abort();
        }
    }

    private static int[] float2int(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        int[] nArray = new int[fArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Float.floatToRawIntBits(fArray[i]);
        }
        return nArray;
    }

    private double getEntropy(float[] fArray) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        int n = 0;
        int[] nArray = new int[10];
        int n2 = fArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (Double.isNaN(fArray[n])) continue;
            d = Math.min(d, (double)fArray[n]);
            d2 = Math.max(d2, (double)fArray[n]);
            ++n3;
        }
        double d3 = (d2 - d) / 10.0;
        if (d3 == 0.0) {
            return -1.0 * Math.log(1.0) / LOG2;
        }
        if (d == Double.MAX_VALUE) {
            return 0.0;
        }
        Arrays.fill(nArray, 0);
        for (n = 0; n < n2; ++n) {
            if (Double.isNaN(fArray[n])) continue;
            int n4 = (int)Math.ceil(((double)fArray[n] - d) / d3) - 1;
            if (n4 < 0) {
                n4 = 0;
            }
            int n5 = n4;
            nArray[n5] = nArray[n5] + 1;
        }
        if (n3 == 0) {
            return 0.0;
        }
        double d4 = 0.0;
        for (n = 0; n < 10; ++n) {
            if (nArray[n] == 0) continue;
            double d5 = (double)nArray[n] / (double)n3;
            d4 += d5 * Math.log(d5) / LOG2;
        }
        return -d4;
    }

    private FloatMatrix getMeans(IntArray[] intArrayArray) {
        FloatMatrix floatMatrix = new FloatMatrix(intArrayArray.length, this.number_of_samples);
        for (int i = 0; i < intArrayArray.length; ++i) {
            FloatMatrix floatMatrix2 = this.getMean(intArrayArray[i]);
            floatMatrix.A[i] = floatMatrix2.A[0];
        }
        return floatMatrix;
    }

    private FloatMatrix getMean(IntArray intArray) {
        FloatMatrix floatMatrix = new FloatMatrix(1, this.number_of_samples);
        int n = intArray.getSize();
        int n2 = 0;
        for (int i = 0; i < this.number_of_samples; ++i) {
            float f = 0.0f;
            n2 = 0;
            for (int j = 0; j < n; ++j) {
                float f2 = this.expMatrix.get(intArray.get(j), i);
                if (Float.isNaN(f2)) continue;
                f += f2;
                ++n2;
            }
            floatMatrix.set(0, i, f / (float)n2);
        }
        return floatMatrix;
    }

    private FloatMatrix getVariances(IntArray[] intArrayArray, FloatMatrix floatMatrix) {
        int n = floatMatrix.getRowDimension();
        int n2 = floatMatrix.getColumnDimension();
        FloatMatrix floatMatrix2 = new FloatMatrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                floatMatrix2.set(i, j, this.getSampleVariance(intArrayArray[i], j, floatMatrix.get(i, j)));
            }
        }
        return floatMatrix2;
    }

    private float getSampleNormalizedSum(IntArray intArray, int n, float f) {
        int n2 = intArray.getSize();
        float f2 = 0.0f;
        this.validN = 0;
        for (int i = 0; i < n2; ++i) {
            float f3 = this.expMatrix.get(intArray.get(i), n);
            if (Float.isNaN(f3)) continue;
            f2 = (float)((double)f2 + Math.pow(f3 - f, 2.0));
            ++this.validN;
        }
        return f2;
    }

    private float getSampleVariance(IntArray intArray, int n, float f) {
        return (float)Math.sqrt(this.getSampleNormalizedSum(intArray, n, f) / (float)(this.validN - 1));
    }

    class SubAlgoListener
    implements AlgorithmListener {
        SubAlgoListener() {
        }

        public void valueChanged(AlgorithmEvent algorithmEvent) {
            RN.this.fireValueChanged(algorithmEvent);
        }
    }
}

