/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.python.antlr.ParseException;
import org.python.antlr.PythonLexer;
import org.python.antlr.runtime.CommonToken;
import org.python.antlr.runtime.CommonTokenStream;
import org.python.antlr.runtime.Token;
import org.python.antlr.runtime.TokenSource;
import org.python.core.Py;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonTokenSource
implements TokenSource {
    public static final int MAX_INDENTS = 100;
    public static final int FIRST_CHAR_POSITION = 0;
    int[] indentStack = new int[100];
    int sp = -1;
    Vector tokens = new Vector();
    CommonTokenStream stream;
    int lastTokenAddedIndex = -1;
    String filename;
    boolean inSingle;

    public PythonTokenSource(PythonLexer lexer) {
    }

    public PythonTokenSource(CommonTokenStream stream, String filename) {
        this(stream, filename, false);
    }

    public PythonTokenSource(CommonTokenStream stream, String filename, boolean single) {
        this.stream = stream;
        this.filename = filename;
        this.inSingle = single;
        this.push(0);
    }

    @Override
    public Token nextToken() {
        if (this.tokens.size() > 0) {
            Token t = (Token)this.tokens.firstElement();
            this.tokens.removeElementAt(0);
            return t;
        }
        this.insertImaginaryIndentDedentTokens();
        return this.nextToken();
    }

    private void generateNewline(Token t) {
        CommonToken newline = new CommonToken(7, "\n");
        newline.setLine(t.getLine());
        newline.setCharPositionInLine(t.getCharPositionInLine());
        this.tokens.addElement(newline);
    }

    private void handleEOF(CommonToken eof, CommonToken prev) {
        if (prev != null) {
            eof.setStartIndex(prev.getStopIndex());
            eof.setStopIndex(prev.getStopIndex());
            eof.setLine(prev.getLine());
            eof.setCharPositionInLine(prev.getCharPositionInLine());
        }
    }

    protected void insertImaginaryIndentDedentTokens() {
        Token t = this.stream.LT(1);
        this.stream.consume();
        if (t.getType() == -1) {
            Token prev = this.stream.LT(-1);
            this.handleEOF((CommonToken)t, (CommonToken)prev);
            if (!this.inSingle) {
                if (prev == null) {
                    this.generateNewline(t);
                } else if (prev.getType() == 8) {
                    this.handleDedents(-1, (CommonToken)t);
                    this.generateNewline(t);
                } else if (prev.getType() != 7) {
                    this.generateNewline(t);
                    this.handleDedents(-1, (CommonToken)t);
                }
            } else {
                this.handleDedents(-1, (CommonToken)t);
            }
            this.enqueue(t);
        } else if (t.getType() == 7) {
            this.enqueueHiddens(t);
            this.tokens.addElement(t);
            Token newline = t;
            t = this.stream.LT(1);
            this.stream.consume();
            List<Token> commentedNewlines = this.enqueueHiddens(t);
            int cpos = t.getCharPositionInLine();
            if (t.getType() == -1) {
                this.handleEOF((CommonToken)t, (CommonToken)newline);
                cpos = -1;
            } else if (t.getType() == 8) {
                Token next = this.stream.LT(1);
                if (next != null && next.getType() == -1) {
                    this.stream.consume();
                    return;
                }
                cpos = t.getText().length();
            }
            int lastIndent = this.peek();
            if (cpos > lastIndent) {
                this.handleIndents(cpos, (CommonToken)t);
            } else if (cpos < lastIndent) {
                this.handleDedents(cpos, (CommonToken)t);
            }
            if (t.getType() == -1 && this.inSingle) {
                String newlines = newline.getText();
                for (int i = 1; i < newlines.length(); ++i) {
                    this.generateNewline(newline);
                }
                for (Token c : commentedNewlines) {
                    this.generateNewline(c);
                }
            }
            if (t.getType() != 8) {
                this.tokens.addElement(t);
            }
        } else {
            this.enqueue(t);
        }
    }

    private void enqueue(Token t) {
        this.enqueueHiddens(t);
        this.tokens.addElement(t);
    }

    private List<Token> enqueueHiddens(Token t) {
        List hiddenTokens;
        Token hidden;
        ArrayList<Token> newlines = new ArrayList<Token>();
        if (this.inSingle && t.getType() == -1 && this.stream.size() > this.lastTokenAddedIndex + 1 && (hidden = this.stream.get(this.lastTokenAddedIndex + 1)).getType() == 99) {
            String text = hidden.getText();
            int i = text.indexOf("\n");
            while (i != -1) {
                newlines.add(hidden);
                i = text.indexOf("\n", i + 1);
            }
        }
        if ((hiddenTokens = this.stream.getTokens(this.lastTokenAddedIndex + 1, t.getTokenIndex() - 1)) != null) {
            this.tokens.addAll(hiddenTokens);
        }
        this.lastTokenAddedIndex = t.getTokenIndex();
        return newlines;
    }

    private void handleIndents(int cpos, CommonToken t) {
        this.push(cpos);
        CommonToken indent = new CommonToken(4, "");
        indent.setCharPositionInLine(t.getCharPositionInLine());
        indent.setLine(t.getLine());
        indent.setStartIndex(t.getStartIndex() - 1);
        indent.setStopIndex(t.getStartIndex() - 1);
        this.tokens.addElement(indent);
    }

    private void handleDedents(int cpos, CommonToken t) {
        int prevIndex = this.findPreviousIndent(cpos, t);
        for (int d = this.sp - 1; d >= prevIndex; --d) {
            CommonToken dedent = new CommonToken(5, "");
            dedent.setCharPositionInLine(t.getCharPositionInLine());
            dedent.setLine(t.getLine());
            dedent.setStartIndex(t.getStartIndex() - 1);
            dedent.setStopIndex(t.getStartIndex() - 1);
            this.tokens.addElement(dedent);
        }
        this.sp = prevIndex;
    }

    protected void push(int i) {
        if (this.sp >= 100) {
            throw new IllegalStateException("stack overflow");
        }
        ++this.sp;
        this.indentStack[this.sp] = i;
    }

    protected int pop() {
        if (this.sp < 0) {
            throw new IllegalStateException("stack underflow");
        }
        int top = this.indentStack[this.sp];
        --this.sp;
        return top;
    }

    protected int peek() {
        return this.indentStack[this.sp];
    }

    protected int findPreviousIndent(int i, Token t) {
        for (int j = this.sp - 1; j >= 0; --j) {
            if (this.indentStack[j] != i) continue;
            return j;
        }
        if (i == -1 || i == -2) {
            return 0;
        }
        ParseException p = new ParseException("unindent does not match any outer indentation level", t.getLine(), t.getCharPositionInLine());
        p.setType(Py.IndentationError);
        throw p;
    }

    public String stackString() {
        StringBuffer buf = new StringBuffer();
        for (int j = this.sp; j >= 0; --j) {
            buf.append(" ");
            buf.append(this.indentStack[j]);
        }
        return buf.toString();
    }

    @Override
    public String getSourceName() {
        return this.filename;
    }
}

