/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import jline.ConsoleReader;
import jline.Terminal;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.util.InteractiveConsole;

public class JLineConsole
extends InteractiveConsole {
    protected ConsoleReader reader;

    public JLineConsole() {
        this(null);
    }

    public JLineConsole(PyObject locals) {
        this(locals, "<stdin>");
        try {
            File historyFile = new File(System.getProperty("user.home"), ".jline-jython.history");
            this.reader.getHistory().setHistoryFile(historyFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public JLineConsole(PyObject locals, String filename) {
        super(locals, filename, true);
        System.setProperty("jline.UnixTerminal.input.encoding", "ISO-8859-1");
        System.setProperty("jline.WindowsTerminal.input.encoding", "ISO-8859-1");
        Terminal.setupTerminal();
        try {
            FileInputStream input = new FileInputStream(FileDescriptor.in);
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(FileDescriptor.out), "ISO-8859-1");
            this.reader = new ConsoleReader(input, output, this.getBindings());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected InputStream getBindings() {
        String userBindings = new File(System.getProperty("user.home"), ".jlinebindings.properties").getAbsolutePath();
        File bindingsFile = new File(System.getProperty("jline.keybindings", userBindings));
        try {
            if (bindingsFile.isFile()) {
                try {
                    return new FileInputStream(bindingsFile);
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return this.getClass().getResourceAsStream("jline-keybindings.properties");
    }

    public String raw_input(PyObject prompt) {
        String line = null;
        try {
            line = this.reader.readLine(prompt.toString());
        }
        catch (IOException io) {
            throw Py.IOError(io);
        }
        if (line == null) {
            throw Py.EOFError("Ctrl-D exit");
        }
        return line.endsWith("\n") ? line.substring(0, line.length() - 1) : line;
    }
}

