/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.ArrayMath;
import JSci.maths.DimensionException;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.ExtraMath;
import JSci.maths.LinearMath;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;

public class DoubleSquareMatrix
extends DoubleMatrix {
    protected transient DoubleSquareMatrix[] LU;
    protected transient int[] LUpivot;

    protected DoubleSquareMatrix(int n, int n2) {
        super(n, n, n2);
    }

    public DoubleSquareMatrix(int n) {
        super(n, n);
    }

    public DoubleSquareMatrix(double[][] dArray) {
        super(dArray);
        if (dArray.length != dArray[0].length) {
            this.matrix = null;
            throw new MatrixDimensionException("The array is not square.");
        }
    }

    public DoubleSquareMatrix(DoubleVector[] doubleVectorArray) {
        super(doubleVectorArray);
        if (doubleVectorArray.length != doubleVectorArray[0].dimension()) {
            this.matrix = null;
            throw new MatrixDimensionException("The array does not form a square matrix.");
        }
    }

    public boolean isSymmetric() {
        return this.equals(this.transpose());
    }

    public boolean isUnitary() {
        return this.multiply(this.transpose()).equals(DoubleDiagonalMatrix.identity(this.numRows));
    }

    public double det() {
        if (this.numRows == 2) {
            return this.matrix[0][0] * this.matrix[1][1] - this.matrix[0][1] * this.matrix[1][0];
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = this.luDecompose(null);
        double d = doubleSquareMatrixArray[1].matrix[0][0];
        int n = 1;
        while (n < this.numRows) {
            d *= doubleSquareMatrixArray[1].matrix[n][n];
            ++n;
        }
        return d * (double)this.LUpivot[this.numRows];
    }

    public double trace() {
        double d = this.matrix[0][0];
        int n = 1;
        while (n < this.numRows) {
            d += this.matrix[n][n];
            ++n;
        }
        return d;
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveSymmetric((DoubleSquareMatrix)this.transpose().multiply(this))));
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] + doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] + doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] + doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] + doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleSquareMatrix);
            }
        }
        if (this.numRows == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] + doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] + doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] - doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] - doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] - doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] - doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleSquareMatrix);
            }
        }
        if (this.numRows == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                dArray[n][0] = this.matrix[n][0] - doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][n2] - doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = d * this.matrix[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = d * this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }

    public double scalarProduct(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleMatrix);
            }
        }
        if (this.numRows == doubleMatrix.rows() && this.numCols == doubleMatrix.columns()) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                d += this.matrix[n][0] * doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    d += this.matrix[n][n2] * doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private double rawScalarProduct(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                d += this.matrix[n][0] * doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    d += this.matrix[n][n2] * doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleSquareMatrix);
            }
        }
        if (this.numRows == doubleSquareMatrix.rows()) {
            double d = 0.0;
            int n = 0;
            while (n < this.numRows) {
                d += this.matrix[n][0] * doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    d += this.matrix[n][n2] * doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        if (this.numCols == doubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                dArray[n] = this.matrix[n][0] * doubleVector.getComponent(0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + this.matrix[n][n2] * doubleVector.getComponent(n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(doubleSquareMatrix);
            }
        }
        if (this.numCols == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][0] * doubleSquareMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[n][n3] * doubleSquareMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.numCols == doubleSquareMatrix.numRows) {
            double[][] dArray = new double[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    dArray[n][n2] = this.matrix[n][0] * doubleSquareMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[n][n3] * doubleSquareMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            dArray[0][n] = this.matrix[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n2][n] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }

    public DoubleSquareMatrix inverse() {
        int n;
        int n2;
        int n3 = this.numRows;
        double[][] dArray = new double[n3][n3];
        double[][] dArray2 = new double[n3][n3];
        DoubleSquareMatrix[] doubleSquareMatrixArray = this.luDecompose(null);
        dArray[0][0] = 1.0 / doubleSquareMatrixArray[0].matrix[0][0];
        dArray2[0][0] = 1.0 / doubleSquareMatrixArray[1].matrix[0][0];
        int n4 = 1;
        while (n4 < n3) {
            dArray[n4][n4] = 1.0 / doubleSquareMatrixArray[0].matrix[n4][n4];
            dArray2[n4][n4] = 1.0 / doubleSquareMatrixArray[1].matrix[n4][n4];
            ++n4;
        }
        n4 = 0;
        while (n4 < n3 - 1) {
            n2 = n4 + 1;
            while (n2 < n3) {
                double d = 0.0;
                double d2 = 0.0;
                n = n4;
                while (n < n2) {
                    d2 -= doubleSquareMatrixArray[0].matrix[n2][n] * dArray[n][n4];
                    d -= dArray2[n4][n] * doubleSquareMatrixArray[1].matrix[n][n2];
                    ++n;
                }
                dArray[n2][n4] = d2 / doubleSquareMatrixArray[0].matrix[n2][n2];
                dArray2[n4][n2] = d / doubleSquareMatrixArray[1].matrix[n2][n2];
                ++n2;
            }
            ++n4;
        }
        double[][] dArray3 = new double[n3][n3];
        n4 = 0;
        while (n4 < n3) {
            n2 = 0;
            while (n2 < n4) {
                n = n4;
                while (n < n3) {
                    double[] dArray4 = dArray3[n4];
                    int n5 = this.LUpivot[n2];
                    dArray4[n5] = dArray4[n5] + dArray2[n4][n] * dArray[n][n2];
                    ++n;
                }
                ++n2;
            }
            n2 = n4;
            while (n2 < n3) {
                n = n2;
                while (n < n3) {
                    double[] dArray5 = dArray3[n4];
                    int n6 = this.LUpivot[n2];
                    dArray5[n6] = dArray5[n6] + dArray2[n4][n] * dArray[n][n2];
                    ++n;
                }
                ++n2;
            }
            ++n4;
        }
        return new DoubleSquareMatrix(dArray3);
    }

    public DoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double[] dArray3 = new double[n];
        if (nArray == null) {
            nArray = new int[n + 1];
        }
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        nArray[n] = 1;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            double d;
            n2 = 0;
            while (n2 < n3) {
                d = this.matrix[nArray[n2]][n3];
                n4 = 0;
                while (n4 < n2) {
                    d -= dArray2[n2][n4] * dArray2[n4][n3];
                    ++n4;
                }
                dArray2[n2][n3] = d;
                ++n2;
            }
            double d2 = 0.0;
            int n5 = n3;
            n2 = n3;
            while (n2 < n) {
                d = this.matrix[nArray[n2]][n3];
                n4 = 0;
                while (n4 < n3) {
                    d -= dArray2[n2][n4] * dArray2[n4][n3];
                    ++n4;
                }
                dArray2[n2][n3] = d;
                if ((d = Math.abs(d)) > d2) {
                    d2 = d;
                    n5 = n2;
                }
                ++n2;
            }
            if (n5 != n3) {
                System.arraycopy(dArray2[n3], 0, dArray3, 0, n3 + 1);
                System.arraycopy(dArray2[n5], 0, dArray2[n3], 0, n3 + 1);
                System.arraycopy(dArray3, 0, dArray2[n5], 0, n3 + 1);
                n4 = nArray[n3];
                nArray[n3] = nArray[n5];
                nArray[n5] = n4;
                nArray[n] = -nArray[n];
            }
            d = dArray2[n3][n3];
            n2 = n3 + 1;
            while (n2 < n) {
                double[] dArray4 = dArray2[n2];
                int n6 = n3;
                dArray4[n6] = dArray4[n6] / d;
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            dArray[n3][n3] = 1.0;
            n2 = n3 + 1;
            while (n2 < n) {
                dArray[n2][n3] = dArray2[n2][n3];
                dArray2[n2][n3] = 0.0;
                ++n2;
            }
            ++n3;
        }
        this.LU = new DoubleSquareMatrix[2];
        this.LU[0] = new DoubleSquareMatrix(dArray);
        this.LU[1] = new DoubleSquareMatrix(dArray2);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        double d;
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double d2 = d = Math.sqrt(this.matrix[0][0]);
        dArray2[0][0] = d2;
        dArray[0][0] = d2;
        int n2 = 1;
        while (n2 < n) {
            double d3 = this.matrix[n2][0] / d;
            dArray2[0][n2] = d3;
            dArray[n2][0] = d3;
            ++n2;
        }
        int n3 = 1;
        while (n3 < n) {
            d = this.matrix[n3][n3];
            n2 = 0;
            while (n2 < n3) {
                d -= dArray[n3][n2] * dArray[n3][n2];
                ++n2;
            }
            double d4 = Math.sqrt(d);
            dArray2[n3][n3] = d4;
            dArray[n3][n3] = d4;
            n2 = n3 + 1;
            while (n2 < n) {
                d = this.matrix[n2][n3];
                int n4 = 0;
                while (n4 < n2) {
                    d -= dArray[n3][n4] * dArray2[n4][n2];
                    ++n4;
                }
                double d5 = d / dArray2[n3][n3];
                dArray2[n3][n2] = d5;
                dArray[n2][n3] = d5;
                ++n2;
            }
            ++n3;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return doubleSquareMatrixArray;
    }

    public DoubleSquareMatrix[] qrDecompose() {
        double d;
        int n;
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double[][] dArray3 = new double[n2][n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3][0] = this.matrix[n3][0];
            n = 1;
            while (n < n2) {
                dArray[n3][n] = this.matrix[n3][n];
                ++n;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            d = dArray[n4][n4];
            n3 = n4 + 1;
            while (n3 < n2) {
                d = ExtraMath.hypot(d, dArray[n3][n4]);
                ++n3;
            }
            if (d != 0.0) {
                if (dArray[n4][n4] < 0.0) {
                    d = -d;
                }
                n3 = n4;
                while (n3 < n2) {
                    double[] dArray4 = dArray[n3];
                    int n5 = n4;
                    dArray4[n5] = dArray4[n5] / d;
                    ++n3;
                }
                double[] dArray5 = dArray[n4];
                int n6 = n4;
                dArray5[n6] = dArray5[n6] + 1.0;
                n = n4 + 1;
                while (n < n2) {
                    double d2 = dArray[n4][n4] * dArray[n4][n];
                    n3 = n4 + 1;
                    while (n3 < n2) {
                        d2 += dArray[n3][n4] * dArray[n3][n];
                        ++n3;
                    }
                    d2 /= dArray[n4][n4];
                    n3 = n4;
                    while (n3 < n2) {
                        double[] dArray6 = dArray[n3];
                        int n7 = n;
                        dArray6[n7] = dArray6[n7] - d2 * dArray[n3][n4];
                        ++n3;
                    }
                    ++n;
                }
            }
            dArray3[n4][n4] = -d;
            ++n4;
        }
        n4 = n2 - 1;
        while (n4 >= 0) {
            dArray2[n4][n4] = 1.0;
            n = n4;
            while (n < n2) {
                if (dArray[n4][n4] != 0.0) {
                    d = dArray[n4][n4] * dArray2[n4][n];
                    n3 = n4 + 1;
                    while (n3 < n2) {
                        d += dArray[n3][n4] * dArray2[n3][n];
                        ++n3;
                    }
                    d /= dArray[n4][n4];
                    n3 = n4;
                    while (n3 < n2) {
                        double[] dArray7 = dArray2[n3];
                        int n8 = n;
                        dArray7[n8] = dArray7[n8] - d * dArray[n3][n4];
                        ++n3;
                    }
                }
                ++n;
            }
            --n4;
        }
        n3 = 0;
        while (n3 < n2) {
            n = n3 + 1;
            while (n < n2) {
                dArray3[n3][n] = dArray[n3][n];
                ++n;
            }
            ++n3;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray2), new DoubleSquareMatrix(dArray3)};
        return doubleSquareMatrixArray;
    }

    public DoubleSquareMatrix[] singularValueDecompose() {
        double d;
        int n;
        int n2 = this.numRows;
        int n3 = n2 - 1;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double[] dArray3 = new double[n2];
        double[][] dArray4 = new double[n2][n2];
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        int n4 = 0;
        while (n4 < n2) {
            dArray[n4][0] = this.matrix[n4][0];
            n = 1;
            while (n < n2) {
                dArray[n4][n] = this.matrix[n4][n];
                ++n;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < n3) {
            double d2;
            dArray3[n5] = dArray[n5][n5];
            n4 = n5 + 1;
            while (n4 < n2) {
                dArray3[n5] = ExtraMath.hypot(dArray3[n5], dArray[n4][n5]);
                ++n4;
            }
            if (dArray3[n5] != 0.0) {
                if (dArray[n5][n5] < 0.0) {
                    dArray3[n5] = -dArray3[n5];
                }
                n4 = n5;
                while (n4 < n2) {
                    double[] dArray7 = dArray[n4];
                    int n6 = n5;
                    dArray7[n6] = dArray7[n6] / dArray3[n5];
                    ++n4;
                }
                double[] dArray8 = dArray[n5];
                int n7 = n5;
                dArray8[n7] = dArray8[n7] + 1.0;
            }
            dArray3[n5] = -dArray3[n5];
            n = n5 + 1;
            while (n < n2) {
                if (dArray3[n5] != 0.0) {
                    d2 = dArray[n5][n5] * dArray[n5][n];
                    n4 = n5 + 1;
                    while (n4 < n2) {
                        d2 += dArray[n4][n5] * dArray[n4][n];
                        ++n4;
                    }
                    d2 /= dArray[n5][n5];
                    n4 = n5;
                    while (n4 < n2) {
                        double[] dArray9 = dArray[n4];
                        int n8 = n;
                        dArray9[n8] = dArray9[n8] - d2 * dArray[n4][n5];
                        ++n4;
                    }
                }
                dArray5[n] = dArray[n5][n];
                ++n;
            }
            n4 = n5;
            while (n4 < n2) {
                dArray2[n4][n5] = dArray[n4][n5];
                ++n4;
            }
            if (n5 < n2 - 2) {
                dArray5[n5] = dArray5[n5 + 1];
                n4 = n5 + 2;
                while (n4 < n2) {
                    dArray5[n5] = ExtraMath.hypot(dArray5[n5], dArray5[n4]);
                    ++n4;
                }
                if (dArray5[n5] != 0.0) {
                    if (dArray5[n5 + 1] < 0.0) {
                        dArray5[n5] = -dArray5[n5];
                    }
                    n4 = n5 + 1;
                    while (n4 < n2) {
                        int n9 = n4++;
                        dArray5[n9] = dArray5[n9] / dArray5[n5];
                    }
                    int n10 = n5 + 1;
                    dArray5[n10] = dArray5[n10] + 1.0;
                }
                dArray5[n5] = -dArray5[n5];
                if (dArray5[n5] != 0.0) {
                    n4 = n5 + 1;
                    while (n4 < n2) {
                        dArray6[n4] = 0.0;
                        n = n5 + 1;
                        while (n < n2) {
                            int n11 = n4;
                            dArray6[n11] = dArray6[n11] + dArray5[n] * dArray[n4][n];
                            ++n;
                        }
                        ++n4;
                    }
                    n = n5 + 1;
                    while (n < n2) {
                        d2 = dArray5[n] / dArray5[n5 + 1];
                        n4 = n5 + 1;
                        while (n4 < n2) {
                            double[] dArray10 = dArray[n4];
                            int n12 = n;
                            dArray10[n12] = dArray10[n12] - d2 * dArray6[n4];
                            ++n4;
                        }
                        ++n;
                    }
                }
                n4 = n5 + 1;
                while (n4 < n2) {
                    dArray4[n4][n5] = dArray5[n4];
                    ++n4;
                }
            }
            ++n5;
        }
        int n13 = n2;
        dArray3[n3] = dArray[n3][n3];
        dArray5[n2 - 2] = dArray[n2 - 2][n3];
        dArray5[n3] = 0.0;
        dArray2[n3][n3] = 1.0;
        n5 = n2 - 2;
        while (n5 >= 0) {
            if (dArray3[n5] != 0.0) {
                n = n5 + 1;
                while (n < n2) {
                    d = dArray2[n5][n5] * dArray2[n5][n];
                    n4 = n5 + 1;
                    while (n4 < n2) {
                        d += dArray2[n4][n5] * dArray2[n4][n];
                        ++n4;
                    }
                    d /= dArray2[n5][n5];
                    n4 = n5;
                    while (n4 < n2) {
                        double[] dArray11 = dArray2[n4];
                        int n14 = n;
                        dArray11[n14] = dArray11[n14] - d * dArray2[n4][n5];
                        ++n4;
                    }
                    ++n;
                }
                n4 = n5;
                while (n4 < n2) {
                    dArray2[n4][n5] = -dArray2[n4][n5];
                    ++n4;
                }
                double[] dArray12 = dArray2[n5];
                int n15 = n5;
                dArray12[n15] = dArray12[n15] + 1.0;
                n4 = 0;
                while (n4 < n5 - 1) {
                    dArray2[n4][n5] = 0.0;
                    ++n4;
                }
            } else {
                n4 = 0;
                while (n4 < n2) {
                    dArray2[n4][n5] = 0.0;
                    ++n4;
                }
                dArray2[n5][n5] = 1.0;
            }
            --n5;
        }
        n5 = n3;
        while (n5 >= 0) {
            if (n5 < n2 - 2 && dArray5[n5] != 0.0) {
                n = n5 + 1;
                while (n < n2) {
                    d = dArray4[n5 + 1][n5] * dArray4[n5 + 1][n];
                    n4 = n5 + 2;
                    while (n4 < n2) {
                        d += dArray4[n4][n5] * dArray4[n4][n];
                        ++n4;
                    }
                    d /= dArray4[n5 + 1][n5];
                    n4 = n5 + 1;
                    while (n4 < n2) {
                        double[] dArray13 = dArray4[n4];
                        int n16 = n;
                        dArray13[n16] = dArray13[n16] - d * dArray4[n4][n5];
                        ++n4;
                    }
                    ++n;
                }
            }
            n4 = 0;
            while (n4 < n2) {
                dArray4[n4][n5] = 0.0;
                ++n4;
            }
            dArray4[n5][n5] = 1.0;
            --n5;
        }
        d = Math.pow(2.0, -52.0);
        int n17 = 0;
        block34: while (n13 > 0) {
            int n18;
            n5 = n13 - 2;
            while (n5 >= -1) {
                if (n5 == -1) break;
                if (Math.abs(dArray5[n5]) <= d * (Math.abs(dArray3[n5]) + Math.abs(dArray3[n5 + 1]))) {
                    dArray5[n5] = 0.0;
                    break;
                }
                --n5;
            }
            if (n5 == n13 - 2) {
                n18 = 4;
            } else {
                int n19 = n13 - 1;
                while (n19 >= n5) {
                    if (n19 == n5) break;
                    double d3 = (n19 != n13 ? Math.abs(dArray5[n19]) : 0.0) + (n19 != n5 + 1 ? Math.abs(dArray5[n19 - 1]) : 0.0);
                    if (Math.abs(dArray3[n19]) <= d * d3) {
                        dArray3[n19] = 0.0;
                        break;
                    }
                    --n19;
                }
                if (n19 == n5) {
                    n18 = 3;
                } else if (n19 == n13 - 1) {
                    n18 = 1;
                } else {
                    n18 = 2;
                    n5 = n19;
                }
            }
            ++n5;
            switch (n18) {
                case 1: {
                    double d4;
                    double d5;
                    double d6;
                    double d7 = dArray5[n13 - 2];
                    dArray5[n13 - 2] = 0.0;
                    n = n13 - 2;
                    while (n >= n5) {
                        d6 = ExtraMath.hypot(dArray3[n], d7);
                        d5 = dArray3[n] / d6;
                        d4 = d7 / d6;
                        dArray3[n] = d6;
                        if (n != n5) {
                            d7 = -d4 * dArray5[n - 1];
                            int n20 = n - 1;
                            dArray5[n20] = dArray5[n20] * d5;
                        }
                        n4 = 0;
                        while (n4 < n2) {
                            d6 = d5 * dArray4[n4][n] + d4 * dArray4[n4][n13 - 1];
                            dArray4[n4][n13 - 1] = -d4 * dArray4[n4][n] + d5 * dArray4[n4][n13 - 1];
                            dArray4[n4][n] = d6;
                            ++n4;
                        }
                        --n;
                    }
                    continue block34;
                }
                case 2: {
                    double d4;
                    double d5;
                    double d6;
                    double d8 = dArray5[n5 - 1];
                    dArray5[n5 - 1] = 0.0;
                    n = n5;
                    while (n < n13) {
                        d6 = ExtraMath.hypot(dArray3[n], d8);
                        d5 = dArray3[n] / d6;
                        d4 = d8 / d6;
                        dArray3[n] = d6;
                        d8 = -d4 * dArray5[n];
                        int n21 = n;
                        dArray5[n21] = dArray5[n21] * d5;
                        n4 = 0;
                        while (n4 < n2) {
                            d6 = d5 * dArray2[n4][n] + d4 * dArray2[n4][n5 - 1];
                            dArray2[n4][n5 - 1] = -d4 * dArray2[n4][n] + d5 * dArray2[n4][n5 - 1];
                            dArray2[n4][n] = d6;
                            ++n4;
                        }
                        ++n;
                    }
                    continue block34;
                }
                case 3: {
                    double d9 = Math.max(Math.max(Math.max(Math.max(Math.abs(dArray3[n13 - 1]), Math.abs(dArray3[n13 - 2])), Math.abs(dArray5[n13 - 2])), Math.abs(dArray3[n5])), Math.abs(dArray5[n5]));
                    double d6 = dArray3[n13 - 1] / d9;
                    double d5 = dArray3[n13 - 2] / d9;
                    double d4 = dArray5[n13 - 2] / d9;
                    double d10 = dArray3[n5] / d9;
                    double d11 = dArray5[n5] / d9;
                    double d12 = ((d5 + d6) * (d5 - d6) + d4 * d4) / 2.0;
                    double d13 = d6 * d4 * (d6 * d4);
                    double d14 = 0.0;
                    if (d12 != 0.0 || d13 != 0.0) {
                        d14 = Math.sqrt(d12 * d12 + d13);
                        if (d12 < 0.0) {
                            d14 = -d14;
                        }
                        d14 = d13 / (d12 + d14);
                    }
                    double d15 = (d10 + d6) * (d10 - d6) + d14;
                    double d16 = d10 * d11;
                    n = n5;
                    while (n < n13 - 1) {
                        double d17 = ExtraMath.hypot(d15, d16);
                        double d18 = d15 / d17;
                        double d19 = d16 / d17;
                        if (n != n5) {
                            dArray5[n - 1] = d17;
                        }
                        d15 = d18 * dArray3[n] + d19 * dArray5[n];
                        dArray5[n] = d18 * dArray5[n] - d19 * dArray3[n];
                        d16 = d19 * dArray3[n + 1];
                        int n22 = n + 1;
                        dArray3[n22] = dArray3[n22] * d18;
                        n4 = 0;
                        while (n4 < n2) {
                            d17 = d18 * dArray4[n4][n] + d19 * dArray4[n4][n + 1];
                            dArray4[n4][n + 1] = -d19 * dArray4[n4][n] + d18 * dArray4[n4][n + 1];
                            dArray4[n4][n] = d17;
                            ++n4;
                        }
                        d17 = ExtraMath.hypot(d15, d16);
                        d18 = d15 / d17;
                        d19 = d16 / d17;
                        dArray3[n] = d17;
                        d15 = d18 * dArray5[n] + d19 * dArray3[n + 1];
                        dArray3[n + 1] = -d19 * dArray5[n] + d18 * dArray3[n + 1];
                        d16 = d19 * dArray5[n + 1];
                        int n23 = n + 1;
                        dArray5[n23] = dArray5[n23] * d18;
                        if (n < n3) {
                            n4 = 0;
                            while (n4 < n2) {
                                d17 = d18 * dArray2[n4][n] + d19 * dArray2[n4][n + 1];
                                dArray2[n4][n + 1] = -d19 * dArray2[n4][n] + d18 * dArray2[n4][n + 1];
                                dArray2[n4][n] = d17;
                                ++n4;
                            }
                        }
                        ++n;
                    }
                    dArray5[n13 - 2] = d15;
                    ++n17;
                    break;
                }
                case 4: {
                    if (dArray3[n5] <= 0.0) {
                        dArray3[n5] = -dArray3[n5];
                        n4 = 0;
                        while (n4 < n13) {
                            dArray4[n4][n5] = -dArray4[n4][n5];
                            ++n4;
                        }
                    }
                    while (n5 < n13 - 1) {
                        if (dArray3[n5] >= dArray3[n5 + 1]) break;
                        double d20 = dArray3[n5];
                        dArray3[n5] = dArray3[n5 + 1];
                        dArray3[n5 + 1] = d20;
                        if (n5 < n3) {
                            n4 = 0;
                            while (n4 < n2) {
                                d20 = dArray2[n4][n5 + 1];
                                dArray2[n4][n5 + 1] = dArray2[n4][n5];
                                dArray2[n4][n5] = d20;
                                d20 = dArray4[n4][n5 + 1];
                                dArray4[n4][n5 + 1] = dArray4[n4][n5];
                                dArray4[n4][n5] = d20;
                                ++n4;
                            }
                        }
                        ++n5;
                    }
                    n17 = 0;
                    --n13;
                }
            }
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray2), new DoubleDiagonalMatrix(dArray3), new DoubleSquareMatrix(dArray4)};
        return doubleSquareMatrixArray;
    }

    public DoubleSquareMatrix[] polarDecompose() {
        double[] dArray;
        int n = this.numRows;
        DoubleVector[] doubleVectorArray = new DoubleVector[n];
        try {
            dArray = LinearMath.eigenSolveSymmetric(this, doubleVectorArray);
        }
        catch (MaximumIterationsExceededException maximumIterationsExceededException) {
            return null;
        }
        double[][] dArray2 = new double[n][n];
        double[][] dArray3 = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            double d = Math.abs(dArray[n2]);
            dArray2[n2][0] = dArray[n2] * doubleVectorArray[n2].getComponent(0) / d;
            dArray3[n2][0] = d * doubleVectorArray[n2].getComponent(0);
            int n3 = 1;
            while (n3 < n) {
                dArray2[n2][n3] = dArray[n2] * doubleVectorArray[n2].getComponent(n3) / d;
                dArray3[n2][n3] = d * doubleVectorArray[n2].getComponent(n3);
                ++n3;
            }
            ++n2;
        }
        double[][] dArray4 = new double[n][n];
        double[][] dArray5 = new double[n][n];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n) {
                dArray4[n4][n5] = doubleVectorArray[0].getComponent(n4) * dArray2[0][n5];
                dArray5[n4][n5] = doubleVectorArray[0].getComponent(n4) * dArray3[0][n5];
                int n6 = 1;
                while (n6 < n) {
                    double[] dArray6 = dArray4[n4];
                    int n7 = n5;
                    dArray6[n7] = dArray6[n7] + doubleVectorArray[n6].getComponent(n4) * dArray2[n6][n5];
                    double[] dArray7 = dArray5[n4];
                    int n8 = n5;
                    dArray7[n8] = dArray7[n8] + doubleVectorArray[n6].getComponent(n4) * dArray3[n6][n5];
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray4), new DoubleSquareMatrix(dArray5)};
        return doubleSquareMatrixArray;
    }

    public DoubleMatrix mapElements(Mapping mapping) {
        double[][] dArray = new double[this.numRows][this.numCols];
        int n = 0;
        while (n < this.numRows) {
            dArray[n][0] = mapping.map(this.matrix[n][0]);
            int n2 = 1;
            while (n2 < this.numCols) {
                dArray[n][n2] = mapping.map(this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new DoubleSquareMatrix(dArray);
    }
}

