/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.ExtraMath;
import JSci.maths.MathInteger;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public final class MathDouble
implements Comparable,
Field.Member {
    private static final long serialVersionUID = 8616680319093653108L;
    private final double x;

    public MathDouble(double d) {
        this.x = d;
    }

    public MathDouble(String string) throws NumberFormatException {
        this.x = Double.parseDouble(string);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MathDouble) {
            return Math.abs(this.x - ((MathDouble)object).value()) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public int compareTo(Object object) throws IllegalArgumentException {
        if (object != null && object instanceof MathDouble) {
            if (Math.abs(this.x - ((MathDouble)object).value()) <= GlobalSettings.ZERO_TOL) {
                return 0;
            }
            return (int)(this.x - ((MathDouble)object).value());
        }
        throw new IllegalArgumentException("Invalid object.");
    }

    public String toString() {
        return Double.toString(this.x);
    }

    public double value() {
        return this.x;
    }

    public boolean isNaN() {
        return this.x == Double.NaN;
    }

    public boolean isInfinite() {
        return this.x == Double.POSITIVE_INFINITY || this.x == Double.NEGATIVE_INFINITY;
    }

    public AbelianGroup.Member negate() {
        return new MathDouble(-this.x);
    }

    public Field.Member inverse() {
        return new MathDouble(1.0 / this.x);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof MathDouble) {
            return this.add((MathDouble)member);
        }
        if (member instanceof MathInteger) {
            return this.add(new MathDouble(((MathInteger)member).value()));
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathDouble add(MathDouble mathDouble) {
        return new MathDouble(this.x + mathDouble.x);
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof MathDouble) {
            return this.subtract((MathDouble)member);
        }
        if (member instanceof MathInteger) {
            return this.subtract(new MathDouble(((MathInteger)member).value()));
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathDouble subtract(MathDouble mathDouble) {
        return new MathDouble(this.x - mathDouble.x);
    }

    public Ring.Member multiply(Ring.Member member) {
        if (member instanceof MathDouble) {
            return this.multiply((MathDouble)member);
        }
        if (member instanceof MathInteger) {
            return this.multiply(new MathDouble(((MathInteger)member).value()));
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathDouble multiply(MathDouble mathDouble) {
        return new MathDouble(this.x * mathDouble.x);
    }

    public Field.Member divide(Field.Member member) {
        if (member instanceof MathDouble) {
            return this.divide((MathDouble)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathDouble divide(MathDouble mathDouble) {
        return new MathDouble(this.x / mathDouble.x);
    }

    public static MathDouble exp(MathDouble mathDouble) {
        return new MathDouble(Math.exp(mathDouble.x));
    }

    public static MathDouble log(MathDouble mathDouble) {
        return new MathDouble(Math.log(mathDouble.x));
    }

    public static MathDouble sin(MathDouble mathDouble) {
        return new MathDouble(Math.sin(mathDouble.x));
    }

    public static MathDouble cos(MathDouble mathDouble) {
        return new MathDouble(Math.cos(mathDouble.x));
    }

    public static MathDouble tan(MathDouble mathDouble) {
        return new MathDouble(Math.tan(mathDouble.x));
    }

    public static MathDouble sinh(MathDouble mathDouble) {
        return new MathDouble(ExtraMath.sinh(mathDouble.x));
    }

    public static MathDouble cosh(MathDouble mathDouble) {
        return new MathDouble(ExtraMath.cosh(mathDouble.x));
    }

    public static MathDouble tanh(MathDouble mathDouble) {
        return new MathDouble(ExtraMath.tanh(mathDouble.x));
    }

    public static MathDouble asin(MathDouble mathDouble) {
        return new MathDouble(Math.asin(mathDouble.x));
    }

    public static MathDouble acos(MathDouble mathDouble) {
        return new MathDouble(Math.acos(mathDouble.x));
    }

    public static MathDouble atan(MathDouble mathDouble) {
        return new MathDouble(Math.atan(mathDouble.x));
    }

    public static MathDouble asinh(MathDouble mathDouble) {
        return new MathDouble(ExtraMath.asinh(mathDouble.x));
    }

    public static MathDouble acosh(MathDouble mathDouble) {
        return new MathDouble(ExtraMath.acosh(mathDouble.x));
    }

    public static MathDouble atanh(MathDouble mathDouble) {
        return new MathDouble(ExtraMath.atanh(mathDouble.x));
    }
}

