/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.maths.Complex;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.fields.FieldMember;
import JSci.maths.polynomials.ComplexLagrangeBasis;
import JSci.maths.polynomials.ComplexPolynomial;
import JSci.maths.polynomials.Polynomial;
import JSci.maths.polynomials.RealLagrangeBasis;
import JSci.maths.polynomials.RealPolynomial;

public class PolynomialMath {
    public static ComplexSquareMatrix getFrobeniusMatrix(Polynomial polynomial) {
        ComplexPolynomial complexPolynomial = PolynomialMath.normalize(PolynomialMath.toComplex(polynomial));
        int n = complexPolynomial.degree();
        if (n < 2) {
            throw new IllegalArgumentException("Cannot get Frobenius matrix for a linear factor");
        }
        ComplexSquareMatrix complexSquareMatrix = new ComplexSquareMatrix(n - 1);
        int n2 = 0;
        while (n2 < n - 2) {
            complexSquareMatrix.setElement(n2 + 1, n2, 1.0, 0.0);
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            complexSquareMatrix.setElement(n3, n - 2, complexPolynomial.getCoefficientAsComplex(n3));
            ++n3;
        }
        return complexSquareMatrix;
    }

    public static int maxDegree(Polynomial polynomial, Polynomial polynomial2) {
        return Math.max(polynomial.degree(), polynomial2.degree());
    }

    public static int minDegree(Polynomial polynomial, Polynomial polynomial2) {
        return Math.min(polynomial.degree(), polynomial2.degree());
    }

    public static Complex[] getNullPoints(Polynomial polynomial) {
        ComplexSquareMatrix complexSquareMatrix = PolynomialMath.getFrobeniusMatrix(polynomial);
        throw new UnsupportedOperationException();
    }

    public static double evalPolynomial(double[] dArray, double d) {
        int n = dArray.length - 1;
        double d2 = dArray[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            d2 = dArray[n2] + d2 * d;
            --n2;
        }
        return d2;
    }

    public static Complex evalPolynomial(Complex[] complexArray, Complex complex) {
        int n = complexArray.length - 1;
        Complex complex2 = complexArray[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            complex2 = complexArray[n2].add(complex2.multiply(complex));
            --n2;
        }
        return complex2;
    }

    public static double[] interpolateLagrange(double[][] dArray) {
        RealLagrangeBasis realLagrangeBasis = new RealLagrangeBasis(dArray[0]);
        return realLagrangeBasis.superposition(dArray[1]).getCoefficientsAsDoubles();
    }

    public static double interpolateLagrange(double[][] dArray, double d) {
        return PolynomialMath.evalPolynomial(PolynomialMath.interpolateLagrange(dArray), d);
    }

    public static Complex[] interpolateLagrange(Complex[][] complexArray) {
        ComplexLagrangeBasis complexLagrangeBasis = new ComplexLagrangeBasis((FieldMember[])complexArray[0]);
        return complexLagrangeBasis.superposition(complexArray[1]).getCoefficientsAsComplexes();
    }

    public static Complex interpolateLagrange(Complex[][] complexArray, Complex complex) {
        return PolynomialMath.evalPolynomial(PolynomialMath.interpolateLagrange(complexArray), complex);
    }

    public static ComplexPolynomial normalize(ComplexPolynomial complexPolynomial) {
        int n = complexPolynomial.degree();
        Complex complex = complexPolynomial.getCoefficientAsComplex(n - 1);
        Complex[] complexArray = new Complex[n];
        complexArray[n - 1] = Complex.ONE;
        int n2 = 0;
        while (n2 < n - 1) {
            complexArray[n2] = complexPolynomial.getCoefficientAsComplex(n2).divide(complex);
            ++n2;
        }
        return new ComplexPolynomial(complexArray);
    }

    public static ComplexPolynomial toComplex(Polynomial polynomial) {
        if (polynomial instanceof ComplexPolynomial) {
            return (ComplexPolynomial)polynomial;
        }
        if (polynomial instanceof RealPolynomial) {
            double[] dArray = ((RealPolynomial)polynomial).getCoefficientsAsDoubles();
            Complex[] complexArray = new Complex[dArray.length];
            int n = 0;
            while (n < dArray.length) {
                complexArray[n] = new Complex(dArray[n], 0.0);
                ++n;
            }
            return new ComplexPolynomial(complexArray);
        }
        throw new UnsupportedOperationException();
    }
}

