/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.dataio;

import at.tugraz.genome.arraynormcore.dataio.FileLoader;
import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayData;
import at.tugraz.genome.arraynormcore.microarrayobjects.SlideMatrix;
import at.tugraz.genome.utils.StringTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class AgilentLoader
implements FileLoader {
    private static int b532_col_;
    private static int b635_col_;
    int cnt = 0;
    private static int columns_header_line_;
    int[] ctrl_type_;
    private static int ctrltype_col_;
    private static int data_line_count_;
    private static int data_lines_;
    private static int data_start_line_;
    SlideMatrix dummy_1;
    private static int f532_col_;
    private static int f635_col_;
    private static int flag_col_;
    int[] g_is_satur_;
    int[] g_is_wellabovebkg_;
    private static int g_issaturatedcol_;
    private static int g_iswellabovbkg_col_;
    private static boolean import_ok_;
    private static int max_lines_;
    private static int pval_lograt_col_;
    float[] pval_logratio_;
    int[] r_is_satur_;
    int[] r_is_wellabovebkg_;
    private static int r_issaturatedcol_;
    private static int r_iswellabovbkg_col_;
    private static int xpos_col_;
    private static int ypos_col_;
    private static int zone_col_;

    static {
        max_lines_ = 0;
        data_start_line_ = 0;
        columns_header_line_ = 0;
        data_lines_ = 0;
        import_ok_ = true;
    }

    private void getInputFileInfo(File file_name) throws Exception {
        int first_row = 0;
        try {
            String read_line;
            BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
            while ((read_line = file_reader.readLine()) != null) {
                if (read_line.equals(null)) continue;
                ++max_lines_;
                StringTokenizer tokenizer = new StringTokenizer(read_line);
                tokenizer.getCount();
                if (read_line.indexOf("FeatureNum") <= -1) continue;
                data_start_line_ = max_lines_ + 1;
                columns_header_line_ = max_lines_;
                ++first_row;
                int gpr_cols = tokenizer.getCount();
                int i = 0;
                while (i < gpr_cols) {
                    String col_name = tokenizer.nextToken();
                    if (col_name.equals("rProcessedSignal")) {
                        f635_col_ = i;
                    }
                    if (col_name.equals("rBGMeanSignal")) {
                        b635_col_ = i;
                    }
                    if (col_name.equals("gProcessedSignal")) {
                        f532_col_ = i;
                    }
                    if (col_name.equals("rBGMeanSignal")) {
                        b532_col_ = i;
                    }
                    if (col_name.equals("ErrorModel")) {
                        flag_col_ = i;
                    }
                    if (col_name.equals("ControlType")) {
                        ctrltype_col_ = i;
                    }
                    if (col_name.equals("gIsSaturated")) {
                        g_issaturatedcol_ = i;
                    }
                    if (col_name.equals("rIsSaturated")) {
                        r_issaturatedcol_ = i;
                    }
                    if (col_name.equals("gIsWellAboveBG")) {
                        g_iswellabovbkg_col_ = i;
                    }
                    if (col_name.equals("rIsWellAboveBG")) {
                        r_iswellabovbkg_col_ = i;
                    }
                    if (col_name.equals("Zone")) {
                        zone_col_ = i;
                    }
                    if (col_name.equals("PValueLogRatio")) {
                        pval_lograt_col_ = i;
                    }
                    if (col_name.equals("PositionX")) {
                        xpos_col_ = i;
                    }
                    if (col_name.equals("PositionY")) {
                        ypos_col_ = i;
                    }
                    ++i;
                }
            }
            file_reader.close();
            data_lines_ = ++max_lines_ - data_start_line_;
        }
        catch (IOException e) {
            e.printStackTrace();
            import_ok_ = false;
        }
    }

    public MicroArrayData loadFile(File input_file, Vector info_set) {
        max_lines_ = 0;
        data_start_line_ = 0;
        data_lines_ = 0;
        data_line_count_ = 0;
        MicroArrayData dummy_ma = null;
        try {
            this.getInputFileInfo(input_file);
            this.dummy_1 = this.uploadAgilentFileAdaptive(input_file);
            this.setControlTypes();
            dummy_ma = new MicroArrayData(this.dummy_1, info_set);
        }
        catch (Exception e) {
            e.printStackTrace();
            import_ok_ = false;
        }
        return dummy_ma;
    }

    private void setControlTypes() {
        int i = 0;
        while (i < data_lines_) {
            if (this.ctrl_type_[i] == 1) {
                this.dummy_1.gene_name_[i] = "CP_" + this.dummy_1.gene_name_[i];
            } else if (this.ctrl_type_[i] == -1) {
                this.dummy_1.gene_name_[i] = "CN_" + this.dummy_1.gene_name_[i];
            }
            ++i;
        }
    }

    private SlideMatrix uploadAgilentFileAdaptive(File file_name) throws Exception {
        String read_line;
        int line = 0;
        data_line_count_ = 0;
        SlideMatrix dummy_slide_matrix = new SlideMatrix(data_lines_, 4);
        dummy_slide_matrix.spot_nbr_[0] = 0;
        this.ctrl_type_ = new int[data_lines_];
        this.g_is_satur_ = new int[data_lines_];
        this.r_is_satur_ = new int[data_lines_];
        this.g_is_wellabovebkg_ = new int[data_lines_];
        this.r_is_wellabovebkg_ = new int[data_lines_];
        this.pval_logratio_ = new float[data_lines_];
        BufferedReader file_reader = new BufferedReader(new FileReader(file_name));
        while ((read_line = file_reader.readLine()) != null) {
            if (read_line.equals(null)) continue;
            dummy_slide_matrix.spot_nbr_[AgilentLoader.data_line_count_] = data_line_count_ + 1;
            StringTokenizer tokenizer = new StringTokenizer(read_line);
            int tokens_in_line = tokenizer.getCount();
            if (++line < data_start_line_) continue;
            try {
                dummy_slide_matrix.bloc_[AgilentLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(zone_col_));
                dummy_slide_matrix.column_[AgilentLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(3));
                dummy_slide_matrix.row_[AgilentLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(2));
                dummy_slide_matrix.gene_name_[AgilentLoader.data_line_count_] = tokenizer.getToken(16);
                dummy_slide_matrix.gene_id_[AgilentLoader.data_line_count_] = tokenizer.getToken(17);
                dummy_slide_matrix.x_coord_[AgilentLoader.data_line_count_] = (int)Float.parseFloat(tokenizer.getToken(xpos_col_));
                dummy_slide_matrix.y_coord_[AgilentLoader.data_line_count_] = (int)Float.parseFloat(tokenizer.getToken(ypos_col_));
                dummy_slide_matrix.setValue(data_line_count_, 0, Float.parseFloat(tokenizer.getToken(f635_col_)));
                dummy_slide_matrix.setValue(data_line_count_, 1, Float.parseFloat(tokenizer.getToken(b635_col_)));
                dummy_slide_matrix.setValue(data_line_count_, 2, Float.parseFloat(tokenizer.getToken(f532_col_)));
                dummy_slide_matrix.setValue(data_line_count_, 3, Float.parseFloat(tokenizer.getToken(b532_col_)));
                dummy_slide_matrix.flag_[AgilentLoader.data_line_count_] = 0;
                this.ctrl_type_[AgilentLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(ctrltype_col_));
                this.g_is_satur_[AgilentLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(g_issaturatedcol_));
                this.r_is_satur_[AgilentLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(r_issaturatedcol_));
                this.g_is_wellabovebkg_[AgilentLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(g_iswellabovbkg_col_));
                this.r_is_wellabovebkg_[AgilentLoader.data_line_count_] = Integer.parseInt(tokenizer.getToken(r_iswellabovbkg_col_));
                this.pval_logratio_[AgilentLoader.data_line_count_] = Float.parseFloat(tokenizer.getToken(pval_lograt_col_));
                if (this.pval_logratio_[data_line_count_] > 0.05f) {
                    dummy_slide_matrix.flag_[AgilentLoader.data_line_count_] = -100;
                    ++this.cnt;
                }
            }
            catch (NumberFormatException ex) {
                System.out.println("crashed while reading file _ " + ex);
                import_ok_ = false;
                ex.printStackTrace();
            }
            ++data_line_count_;
        }
        file_reader.close();
        return dummy_slide_matrix;
    }
}

