/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.filtering;

import at.tugraz.genome.arraynormcore.filtering.FilterFunctions;
import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;

public class FilteringManager {
    private boolean DEBUG = true;
    private ExperimentData.ExpClass exp_class_;
    private ExperimentData experiment_;
    private boolean filter_foreback_;
    private boolean filter_maxintens_;
    private boolean filter_minintens_;
    private boolean filter_sumforegrounds_;

    public FilteringManager(ExperimentData.ExpClass exp_class) {
        this.exp_class_ = exp_class;
        this.filter_foreback_ = true;
        this.filter_maxintens_ = true;
        this.filter_minintens_ = true;
        this.applyFilterToClass(this.exp_class_);
    }

    private void applyFilterToClass(ExperimentData.ExpClass exp_class) {
        if (this.filter_minintens_) {
            FilterFunctions.filterMinCriterion(exp_class, 300.0f);
        }
        if (this.filter_maxintens_) {
            FilterFunctions.filterMaxCriterion(exp_class, 65000.0f);
        }
        if (this.filter_foreback_) {
            FilterFunctions.filterForeBackCriterion(exp_class);
        }
        if (this.filter_sumforegrounds_) {
            FilterFunctions.filterSumOfForegroundsCriterion(exp_class, 1000.0f);
        }
    }
}

