/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.microarrayobjects;

import at.tugraz.genome.arraynormcore.dataio.FileLoader;
import at.tugraz.genome.arraynormcore.dataio.FileLoaderFactory;
import at.tugraz.genome.arraynormcore.dataio.MAResultsFileWriter;
import at.tugraz.genome.arraynormcore.dataio.PValuesFileWriter;
import at.tugraz.genome.arraynormcore.dataio.ResultsFileWriter;
import at.tugraz.genome.arraynormcore.gui.ParentFrame;
import at.tugraz.genome.arraynormcore.mars.MarsUploadSlide;
import at.tugraz.genome.arraynormcore.mars.MarsUploadSlideInformation;
import at.tugraz.genome.arraynormcore.math.MADFunction;
import at.tugraz.genome.arraynormcore.microarrayobjects.ExpAnalyzeResults;
import at.tugraz.genome.arraynormcore.microarrayobjects.ExpClassHistory;
import at.tugraz.genome.arraynormcore.microarrayobjects.ExpGeneralResults;
import at.tugraz.genome.arraynormcore.microarrayobjects.GeneIdIndexMap;
import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayData;
import at.tugraz.genome.arraynormcore.microarrayobjects.TransformedSlideVO;
import at.tugraz.genome.math.MathFunctions;
import java.io.File;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ExperimentData {
    boolean DEBUG = true;
    public String additional_info_;
    public Vector biocond_list_;
    int chip_physio_;
    int count1_;
    int count_;
    String design_vector_;
    public int[] dgroffreedom_;
    public String[] exp_class_name_;
    public boolean exp_is_bkg_corrected_;
    public boolean exp_is_from_mars_ = false;
    public boolean exp_is_normalized_;
    public String exp_shortinf_;
    public MicroArrayData[] exp_slides_;
    public Long[] expclass_ids_;
    public Object[][] expdata_defin_table_;
    public ExpAnalyzeResults experiment_analyze_results_;
    public ExpClass[] experiment_class_;
    public ExpGeneralResults experiment_general_results_;
    public String experiment_name_;
    public float[][] final_exp_avalues_;
    public int[] final_exp_ctrlmarks_;
    public String[] final_exp_geneids_;
    public String[] final_exp_genenames_;
    public float[][] final_exp_log2_ratios_;
    public float[][] final_exp_ratios_;
    public String[] final_gene_ids_;
    public String[] final_gene_names_;
    public boolean final_results_available_;
    public boolean[] has_ctrls_;
    public boolean[] has_repspots_;
    public boolean[] is_dyeswapped_;
    public int[] is_experiment_ctrl_spot_;
    public MarsUploadSlideInformation[] mars_slide_info_;
    public MarsUploadSlide[] mars_slide_upload_;
    float max_intens_val_;
    float min_intens_val_;
    public int num_expe_classes_ = 1;
    public int num_experiment_ctrls_;
    public int num_genes_on_slide_;
    public int num_slides_ = 1;
    public int num_spots_on_slide_;
    public int[] paired_slides_index_;
    public ParentFrame parent_gui_;
    public float[] pvalue_;
    public int[] significance_mark_;
    int slide_count_;
    public Vector slide_list_;
    public Long[] slides_ids_;
    public int[] src_biocond_;
    public File[] src_file_;
    public String[] src_file_name_;
    public String[] src_file_short_info_;
    public int[] src_index_;
    public String srcfiles_vendor_;
    public Vector tablemodel_data_ = new Vector();
    public TransformedSlideVO[] transformed_slide_vo_;
    public float[] tvalue_;
    public String user_name_;

    public ExperimentData(ParentFrame parent, Object[][] fin_tabmod, Vector exp_info, boolean isfrommars) {
        this.parent_gui_ = parent;
        this.expdata_defin_table_ = fin_tabmod;
        this.experiment_name_ = (String)exp_info.get(0);
        this.user_name_ = (String)exp_info.get(1);
        this.exp_shortinf_ = (String)exp_info.get(2);
        Integer fetchint = (Integer)exp_info.get(3);
        this.num_expe_classes_ = fetchint;
        fetchint = (Integer)exp_info.get(4);
        this.num_slides_ = fetchint;
        this.srcfiles_vendor_ = (String)exp_info.get(5);
        fetchint = (Integer)exp_info.get(6);
        this.chip_physio_ = fetchint;
        this.exp_class_name_ = new String[this.num_expe_classes_];
        this.exp_class_name_ = (String[])exp_info.get(7);
        this.expclass_ids_ = new Long[this.num_expe_classes_];
        this.slides_ids_ = new Long[this.num_slides_];
        this.expclass_ids_ = (Long[])exp_info.get(8);
        this.slides_ids_ = (Long[])exp_info.get(9);
        this.exp_is_bkg_corrected_ = false;
        this.final_results_available_ = false;
        this.exp_is_from_mars_ = isfrommars;
        this.setSrcControlVars(this.expdata_defin_table_);
        this.importSourceFiles();
        this.createExperimentClasses();
    }

    private void checkConformityOfClasses() {
        boolean spots_ok = true;
        boolean ctrls_ok = true;
        this.num_experiment_ctrls_ = this.experiment_class_[0].num_ctrls_;
        this.num_spots_on_slide_ = this.experiment_class_[0].num_spots_;
        int cnt_1 = 0;
        while (cnt_1 < this.num_expe_classes_) {
            if (this.experiment_class_[cnt_1].num_spots_ != this.num_spots_on_slide_) {
                spots_ok = false;
                break;
            }
            ++cnt_1;
        }
        int cnt_12 = 0;
        while (cnt_12 < this.num_expe_classes_) {
            if (this.experiment_class_[cnt_12].num_ctrls_ != this.num_experiment_ctrls_) {
                ctrls_ok = false;
                break;
            }
            ++cnt_12;
        }
        if (!spots_ok || !ctrls_ok) {
            JOptionPane.showMessageDialog(this.parent_gui_, "Your files do not confirm. Something is corrupted.", "Error", 0);
        }
    }

    public void correctBackgroundAllClasses() {
        if (!this.exp_is_bkg_corrected_) {
            int i = 0;
            while (i < this.num_expe_classes_) {
                if (!this.experiment_class_[i].class_is_bkg_corrected_) {
                    this.experiment_class_[i].correctBkgrd();
                } else {
                    JOptionPane.showMessageDialog(this.parent_gui_, "Class[" + i + "] was already background-corrected.", "Information", 1);
                }
                ++i;
            }
            this.exp_is_bkg_corrected_ = true;
        } else {
            JOptionPane.showMessageDialog(this.parent_gui_, "Experiment is already background-corrected.", "Information", 1);
        }
    }

    private void createExperimentClasses() {
        Vector<MicroArrayData> class_slides = new Vector<MicroArrayData>();
        int i_ = 0;
        while (i_ < this.num_expe_classes_) {
            int cid = i_;
            int j_ = 0;
            while (j_ < this.num_slides_) {
                if (this.src_biocond_[j_] == cid) {
                    class_slides.add(this.exp_slides_[j_]);
                }
                ++j_;
            }
            MicroArrayData[] ma_dummy = new MicroArrayData[class_slides.size()];
            int k_ = 0;
            while (k_ < ma_dummy.length) {
                ma_dummy[k_] = (MicroArrayData)class_slides.get(k_);
                ++k_;
            }
            this.experiment_class_[i_] = new ExpClass(ma_dummy);
            this.experiment_class_[i_].class_name_ = this.exp_class_name_[i_];
            this.experiment_class_[i_].class_id_ = this.expclass_ids_[i_];
            class_slides.clear();
            ++i_;
        }
        this.checkConformityOfClasses();
    }

    public void createSrcControlVars() {
        this.src_index_ = new int[this.num_slides_];
        this.src_biocond_ = new int[this.num_slides_];
        this.src_file_ = new File[this.num_slides_];
        this.is_dyeswapped_ = new boolean[this.num_slides_];
        this.paired_slides_index_ = new int[this.num_slides_];
        this.has_repspots_ = new boolean[this.num_slides_];
        this.has_ctrls_ = new boolean[this.num_slides_];
        this.src_file_short_info_ = new String[this.num_slides_];
        this.src_file_name_ = new String[this.num_slides_];
        this.count_ = 0;
        while (this.count_ < this.slide_list_.size()) {
            this.src_file_[this.count_] = (File)this.slide_list_.get(this.count_);
            this.src_index_[this.count_] = this.count_;
            this.src_biocond_[this.count_] = ((int[])this.biocond_list_.get(this.count_))[0];
            this.is_dyeswapped_[this.count_] = false;
            this.paired_slides_index_[this.count_] = 0;
            this.has_repspots_[this.count_] = false;
            this.has_ctrls_[this.count_] = false;
            this.src_file_name_[this.count_] = "";
            this.src_file_short_info_[this.count_] = "";
            ++this.count_;
        }
        this.tablemodel_data_.add(this.src_index_);
        this.tablemodel_data_.add(this.src_biocond_);
        this.tablemodel_data_.add(this.src_file_);
        this.tablemodel_data_.add(this.is_dyeswapped_);
        this.tablemodel_data_.add(this.has_repspots_);
        this.tablemodel_data_.add(this.has_ctrls_);
        this.tablemodel_data_.add(this.src_file_name_);
        this.tablemodel_data_.add(this.src_file_short_info_);
    }

    public void disposeExperiment() {
        this.experiment_class_ = null;
        this.biocond_list_ = null;
        this.exp_slides_ = null;
        this.final_gene_ids_ = null;
        this.final_gene_names_ = null;
        this.tablemodel_data_ = null;
        System.gc();
    }

    public Vector experimentReport() {
        Vector<Object> exp_report = new Vector<Object>();
        int[] add_int = new int[2];
        boolean[] add_bool = new boolean[2];
        add_int[0] = this.num_expe_classes_;
        add_int[1] = this.num_slides_;
        add_bool[0] = this.exp_is_bkg_corrected_;
        add_bool[1] = this.exp_is_normalized_;
        exp_report.add(this.experiment_name_);
        exp_report.add(this.exp_shortinf_);
        exp_report.add(add_int);
        exp_report.add(add_bool);
        return exp_report;
    }

    public void exportMAValuesToFile(File file, int deal_ctrls) {
        MAResultsFileWriter mawriter = new MAResultsFileWriter(this.parent_gui_, this, file);
        mawriter.writeFinalMAResultsFile(deal_ctrls);
    }

    public void exportPValuesToFile(File file) {
        PValuesFileWriter writer2 = new PValuesFileWriter(this.parent_gui_, this, file);
        writer2.writePValuesFile();
    }

    public void exportResultsToFile(File file, int deal_ctrls) {
        ResultsFileWriter writer1 = new ResultsFileWriter(this.parent_gui_, this, file);
        writer1.writeFinalExpResultsFile(deal_ctrls);
    }

    public void generateMarsUploadFiles() {
        int cnter = 0;
        File dummy = new File(System.getProperty("user.dir") + File.separator + "marsupload");
        dummy.mkdir();
        File[] mars_list = dummy.listFiles();
        int i = 0;
        while (i < mars_list.length) {
            mars_list[i].delete();
            ++i;
        }
        dummy.delete();
        System.gc();
        this.mars_slide_upload_ = new MarsUploadSlide[this.num_slides_];
        this.mars_slide_info_ = new MarsUploadSlideInformation[this.num_slides_];
        int i2 = 0;
        while (i2 < this.num_expe_classes_) {
            int j = 0;
            while (j < this.experiment_class_[i2].num_normal_slides_) {
                this.mars_slide_upload_[cnter] = new MarsUploadSlide();
                this.mars_slide_info_[cnter] = new MarsUploadSlideInformation();
                this.mars_slide_upload_[cnter].setF635_(this.experiment_class_[i2].expclass_normal_data_[j][0]);
                this.mars_slide_upload_[cnter].setF532_(this.experiment_class_[i2].expclass_normal_data_[j][1]);
                this.mars_slide_upload_[cnter].setSlide_name_(this.experiment_class_[i2].class_normal_slidenames_[j]);
                this.mars_slide_upload_[cnter].setMars_id_(this.experiment_class_[i2].class_normal_slide_[j].mars_id_);
                this.mars_slide_upload_[cnter].setGene_id_(this.experiment_class_[i2].gene_id_);
                this.mars_slide_upload_[cnter].setGene_names_(this.experiment_class_[i2].gene_name_);
                this.mars_slide_upload_[cnter].setSlide_netto_history_(this.experiment_class_[i2].class_histo_.getNettoHistoryString());
                this.mars_slide_info_[cnter].setFile_history_(this.experiment_class_[i2].class_histo_.getNettoHistoryString());
                this.mars_slide_info_[cnter].setFile_add_info_("normal labeled");
                this.mars_slide_info_[cnter].setMicroarray_id_(this.experiment_class_[i2].class_normal_slide_[j].slide_id_);
                this.mars_slide_info_[cnter].setClass_id_(this.experiment_class_[i2].class_id_);
                this.mars_slide_upload_[cnter].writeSlideFile();
                ++cnter;
                ++j;
            }
            int k = 0;
            while (k < this.experiment_class_[i2].num_dysw_slides_) {
                this.mars_slide_upload_[cnter] = new MarsUploadSlide();
                this.mars_slide_info_[cnter] = new MarsUploadSlideInformation();
                this.mars_slide_upload_[cnter].setF635_(this.experiment_class_[i2].expclass_dysw_data_[k][0]);
                this.mars_slide_upload_[cnter].setF532_(this.experiment_class_[i2].expclass_dysw_data_[k][1]);
                this.mars_slide_upload_[cnter].setSlide_name_(this.experiment_class_[i2].class_dysw_slidenames_[k]);
                this.mars_slide_upload_[cnter].setMars_id_(this.experiment_class_[i2].class_dysw_slide_[k].mars_id_);
                this.mars_slide_upload_[cnter].setGene_id_(this.experiment_class_[i2].gene_id_);
                this.mars_slide_upload_[cnter].setGene_names_(this.experiment_class_[i2].gene_name_);
                this.mars_slide_upload_[cnter].setSlide_netto_history_(this.experiment_class_[i2].class_histo_.getNettoHistoryString());
                this.mars_slide_info_[cnter].setFile_history_(this.experiment_class_[i2].class_histo_.getNettoHistoryString());
                this.mars_slide_info_[cnter].setFile_add_info_("reverse labeled");
                this.mars_slide_info_[cnter].setMicroarray_id_(this.experiment_class_[i2].class_dysw_slide_[k].slide_id_);
                this.mars_slide_info_[cnter].setClass_id_(this.experiment_class_[i2].class_id_);
                this.mars_slide_upload_[cnter].writeSlideFile();
                ++cnter;
                ++k;
            }
            ++i2;
        }
    }

    public void generateTransformedSlideVo(File targetdir) {
        int cnter = 0;
        this.transformed_slide_vo_ = new TransformedSlideVO[this.num_slides_];
        int cnt_class = 0;
        while (cnt_class < this.num_expe_classes_) {
            String[] genename_dumy;
            String[] geneid_dumy;
            float[] a_val;
            float[] m_val;
            float[] f532_dumy;
            float[] f635_dumy;
            String class_name = this.experiment_class_[cnt_class].class_name_;
            int normslid_cnt = 0;
            while (normslid_cnt < this.experiment_class_[cnt_class].num_normal_slides_) {
                this.transformed_slide_vo_[cnter] = new TransformedSlideVO();
                f635_dumy = (float[])this.experiment_class_[cnt_class].expclass_normal_data_[normslid_cnt][0].clone();
                f532_dumy = (float[])this.experiment_class_[cnt_class].expclass_normal_data_[normslid_cnt][1].clone();
                m_val = MathFunctions.ratioOfArrays(f635_dumy, f532_dumy);
                m_val = MathFunctions.log2(m_val);
                a_val = MathFunctions.innerProduct(f635_dumy, f532_dumy);
                a_val = MathFunctions.sqrtArray(a_val);
                a_val = MathFunctions.log2(a_val);
                geneid_dumy = (String[])this.experiment_class_[cnt_class].gene_id_.clone();
                genename_dumy = (String[])this.experiment_class_[cnt_class].gene_name_.clone();
                String slidename = this.experiment_class_[cnt_class].class_normal_slidenames_[normslid_cnt];
                this.transformed_slide_vo_[cnter].setF635(f635_dumy);
                this.transformed_slide_vo_[cnter].setF532(f532_dumy);
                this.transformed_slide_vo_[cnter].setMValue(m_val);
                this.transformed_slide_vo_[cnter].setAValue(a_val);
                this.transformed_slide_vo_[cnter].setGeneId(geneid_dumy);
                this.transformed_slide_vo_[cnter].setGeneName(genename_dumy);
                this.transformed_slide_vo_[cnter].setSlideName(slidename);
                this.transformed_slide_vo_[cnter].setClassName(class_name);
                this.transformed_slide_vo_[cnter].setReverseLabeled(false);
                this.transformed_slide_vo_[cnter].writeSlideFile(targetdir);
                ++cnter;
                ++normslid_cnt;
            }
            int revslid_cnt = 0;
            while (revslid_cnt < this.experiment_class_[cnt_class].num_dysw_slides_) {
                this.transformed_slide_vo_[cnter] = new TransformedSlideVO();
                f635_dumy = (float[])this.experiment_class_[cnt_class].expclass_dysw_data_[revslid_cnt][0].clone();
                f532_dumy = (float[])this.experiment_class_[cnt_class].expclass_dysw_data_[revslid_cnt][1].clone();
                m_val = MathFunctions.ratioOfArrays(f635_dumy, f532_dumy);
                m_val = MathFunctions.log2(m_val);
                a_val = MathFunctions.innerProduct(f635_dumy, f532_dumy);
                a_val = MathFunctions.sqrtArray(a_val);
                a_val = MathFunctions.log2(a_val);
                geneid_dumy = (String[])this.experiment_class_[cnt_class].gene_id_.clone();
                genename_dumy = (String[])this.experiment_class_[cnt_class].gene_name_.clone();
                String slidename = this.experiment_class_[cnt_class].class_dysw_slidenames_[revslid_cnt];
                this.transformed_slide_vo_[cnter].setF635(f635_dumy);
                this.transformed_slide_vo_[cnter].setF532(f532_dumy);
                this.transformed_slide_vo_[cnter].setMValue(m_val);
                this.transformed_slide_vo_[cnter].setAValue(a_val);
                this.transformed_slide_vo_[cnter].setGeneId(geneid_dumy);
                this.transformed_slide_vo_[cnter].setGeneName(genename_dumy);
                this.transformed_slide_vo_[cnter].setSlideName(slidename);
                this.transformed_slide_vo_[cnter].setClassName(class_name);
                this.transformed_slide_vo_[cnter].setReverseLabeled(true);
                this.transformed_slide_vo_[cnter].writeSlideFile(targetdir);
                ++cnter;
                ++revslid_cnt;
            }
            ++cnt_class;
        }
    }

    public void importSourceFiles() {
        Vector<Object> slide_info_vector = new Vector<Object>();
        int[] add_int = new int[2];
        boolean[] add_bool = new boolean[3];
        int progress = 0;
        this.exp_slides_ = new MicroArrayData[this.num_slides_];
        this.experiment_class_ = new ExpClass[this.num_expe_classes_];
        progress = 100 / this.num_slides_;
        int i = 0;
        while (i < this.num_slides_) {
            add_int[0] = this.src_index_[i];
            add_int[1] = this.src_biocond_[i];
            slide_info_vector.add(add_int);
            slide_info_vector.add(this.src_file_[i]);
            add_bool[0] = this.is_dyeswapped_[i];
            add_bool[1] = this.has_repspots_[i];
            add_bool[2] = this.has_ctrls_[i];
            slide_info_vector.add(add_bool);
            slide_info_vector.add(this.src_file_name_[i]);
            slide_info_vector.add(this.src_file_short_info_[i]);
            slide_info_vector.add(this.slides_ids_[i]);
            this.parent_gui_.setGUIStatusLine("Loading File  " + this.src_file_name_[i] + " ...");
            FileLoader file_loader = FileLoaderFactory.createInstance(this.srcfiles_vendor_);
            System.out.println("[ExperimentData::importsrcfiles] -> try to load...");
            this.exp_slides_[i] = file_loader.loadFile(this.src_file_[i], slide_info_vector);
            this.exp_slides_[i].selfnorm_pair_ = this.paired_slides_index_[i];
            slide_info_vector.clear();
            this.parent_gui_.setGUIProgressBarValue(progress * (i + 1));
            ++i;
        }
    }

    public void makeResults(int ave_repl_spots, int deal_ctrls, int deal_revlab_slides, int transfo) {
        this.final_exp_ratios_ = null;
        this.final_exp_log2_ratios_ = null;
        this.final_exp_avalues_ = null;
        System.gc();
        try {
            int i = 0;
            while (i < this.num_expe_classes_) {
                this.experiment_class_[i].averageReplSpotsWithinSlides(ave_repl_spots);
                this.experiment_class_[i].mergeAllClassSlides(deal_revlab_slides);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.final_exp_geneids_ = this.experiment_class_[0].final_class_geneids_;
        this.final_exp_genenames_ = this.experiment_class_[0].final_class_genenames_;
        this.final_exp_ctrlmarks_ = this.experiment_class_[0].final_class_ctrlmarks_;
        this.final_exp_ratios_ = new float[this.num_expe_classes_][this.num_genes_on_slide_];
        this.final_exp_log2_ratios_ = new float[this.num_expe_classes_][this.num_genes_on_slide_];
        this.final_exp_avalues_ = new float[this.num_expe_classes_][this.num_genes_on_slide_];
        int i = 0;
        while (i < this.num_expe_classes_) {
            this.final_exp_ratios_[i] = this.experiment_class_[i].merged_ratios_;
            this.final_exp_log2_ratios_[i] = MathFunctions.log2(this.final_exp_ratios_[i]);
            this.final_exp_avalues_[i] = this.experiment_class_[i].merged_avalues_;
            this.experiment_class_[i].significanc_mark_ = new int[this.num_genes_on_slide_];
            ++i;
        }
        this.experiment_general_results_ = new ExpGeneralResults(this);
        this.transformResults(transfo);
        this.final_results_available_ = true;
        this.parent_gui_.updateExperimentResultsFolder();
        this.experiment_analyze_results_ = new ExpAnalyzeResults(this);
        this.parent_gui_.updateAnalysisResultsFolder();
        this.parent_gui_.showGeneralResultsTable();
        if (this.exp_is_from_mars_) {
            this.generateMarsUploadFiles();
        }
    }

    public void resetExperimentData() {
        int i = 0;
        while (i < this.num_expe_classes_) {
            int num_dysw = this.experiment_class_[i].num_dysw_slides_;
            int num_normal = this.experiment_class_[i].num_normal_slides_;
            int j = 0;
            while (j < num_normal) {
                this.experiment_class_[i].expclass_normal_data_[j][0] = this.experiment_class_[i].class_normal_slide_[j].getF635median_();
                this.experiment_class_[i].expclass_normal_data_[j][1] = this.experiment_class_[i].class_normal_slide_[j].getF532median_();
                this.experiment_class_[i].expclass_normal_data_[j][3] = this.experiment_class_[i].class_normal_slide_[j].getB635median_();
                this.experiment_class_[i].expclass_normal_data_[j][4] = this.experiment_class_[i].class_normal_slide_[j].getB532median_();
                ++j;
            }
            int k = 0;
            while (k < num_dysw) {
                this.experiment_class_[i].expclass_dysw_data_[k][0] = this.experiment_class_[i].class_dysw_slide_[k].getF635median_();
                this.experiment_class_[i].expclass_dysw_data_[k][1] = this.experiment_class_[i].class_dysw_slide_[k].getF532median_();
                this.experiment_class_[i].expclass_dysw_data_[k][3] = this.experiment_class_[i].class_dysw_slide_[k].getB635median_();
                this.experiment_class_[i].expclass_dysw_data_[k][4] = this.experiment_class_[i].class_dysw_slide_[k].getB532median_();
                ++k;
            }
            this.experiment_class_[i].class_is_bkg_corrected_ = false;
            this.experiment_class_[i].class_is_normalized_ = false;
            this.experiment_class_[i].the_norm_method_ = "not normalized";
            this.experiment_class_[i].class_histo_.setReset();
            ++i;
        }
        this.exp_is_bkg_corrected_ = false;
        this.exp_is_normalized_ = false;
    }

    public void scaleAdjustmentAllSlides() {
        float[] mad = new float[this.num_slides_];
        double[] scaleconst = new double[this.num_slides_];
        int cnter = 0;
        int cnt_class = 0;
        while (cnt_class < this.num_expe_classes_) {
            float[] m_dumy;
            float[] f532_dumy;
            float[] f635_dumy;
            int normslid_cnt = 0;
            while (normslid_cnt < this.experiment_class_[cnt_class].num_normal_slides_) {
                f635_dumy = (float[])this.experiment_class_[cnt_class].expclass_normal_data_[normslid_cnt][0].clone();
                f532_dumy = (float[])this.experiment_class_[cnt_class].expclass_normal_data_[normslid_cnt][1].clone();
                m_dumy = MathFunctions.ratioOfArrays(f635_dumy, f532_dumy);
                m_dumy = MathFunctions.log2(m_dumy);
                mad[cnter] = MADFunction.MAD(m_dumy);
                ++cnter;
                ++normslid_cnt;
            }
            int revslid_cnt = 0;
            while (revslid_cnt < this.experiment_class_[cnt_class].num_dysw_slides_) {
                f635_dumy = (float[])this.experiment_class_[cnt_class].expclass_dysw_data_[revslid_cnt][0].clone();
                f532_dumy = (float[])this.experiment_class_[cnt_class].expclass_dysw_data_[revslid_cnt][1].clone();
                m_dumy = MathFunctions.ratioOfArrays(f635_dumy, f532_dumy);
                m_dumy = MathFunctions.log2(m_dumy);
                mad[cnter] = MADFunction.MAD(m_dumy);
                ++cnter;
                ++revslid_cnt;
            }
            ++cnt_class;
        }
        scaleconst = MADFunction.varscale(mad);
        scaleconst = MathFunctions.powerArray(scaleconst, -1);
        cnter = 0;
        int cnt_class2 = 0;
        while (cnt_class2 < this.num_expe_classes_) {
            int normslid_cnt = 0;
            while (normslid_cnt < this.experiment_class_[cnt_class2].num_normal_slides_) {
                this.experiment_class_[cnt_class2].expclass_normal_data_[normslid_cnt][0] = MathFunctions.powerArray(this.experiment_class_[cnt_class2].expclass_normal_data_[normslid_cnt][0], scaleconst[cnter]);
                this.experiment_class_[cnt_class2].expclass_normal_data_[normslid_cnt][1] = MathFunctions.powerArray(this.experiment_class_[cnt_class2].expclass_normal_data_[normslid_cnt][1], scaleconst[cnter]);
                ++cnter;
                ++normslid_cnt;
            }
            int revslid_cnt = 0;
            while (revslid_cnt < this.experiment_class_[cnt_class2].num_dysw_slides_) {
                this.experiment_class_[cnt_class2].expclass_dysw_data_[revslid_cnt][0] = MathFunctions.powerArray(this.experiment_class_[cnt_class2].expclass_dysw_data_[revslid_cnt][0], scaleconst[cnter]);
                this.experiment_class_[cnt_class2].expclass_dysw_data_[revslid_cnt][1] = MathFunctions.powerArray(this.experiment_class_[cnt_class2].expclass_dysw_data_[revslid_cnt][1], scaleconst[cnter]);
                ++cnter;
                ++revslid_cnt;
            }
            ++cnt_class2;
        }
    }

    public void setAnalysisResults() {
        this.parent_gui_.updateAnalysisResultsFolder();
    }

    private void setSrcControlVars(Object[][] expdef_table) {
        this.src_index_ = new int[this.num_slides_];
        this.src_file_ = new File[this.num_slides_];
        this.src_biocond_ = new int[this.num_slides_];
        this.is_dyeswapped_ = new boolean[this.num_slides_];
        this.has_ctrls_ = new boolean[this.num_slides_];
        this.has_repspots_ = new boolean[this.num_slides_];
        this.paired_slides_index_ = new int[this.num_slides_];
        this.src_file_name_ = new String[this.num_slides_];
        this.src_file_short_info_ = new String[this.num_slides_];
        int i = 0;
        while (i < this.num_slides_) {
            this.src_index_[i] = (Integer)expdef_table[i][0];
            this.src_file_[i] = (File)expdef_table[i][1];
            this.src_biocond_[i] = (Integer)expdef_table[i][2];
            this.is_dyeswapped_[i] = (Boolean)expdef_table[i][3];
            this.paired_slides_index_[i] = (Integer)expdef_table[i][4];
            this.src_file_name_[i] = (String)expdef_table[i][5];
            this.src_file_short_info_[i] = (String)expdef_table[i][6];
            ++i;
        }
    }

    private void transformResults(int transfo) {
        if (transfo == 2220) {
            this.final_exp_ratios_ = this.final_exp_log2_ratios_;
        } else if (transfo == 2221 || transfo == 2222) {
            // empty if block
        }
    }

    public void updateSrcControlVars(Object[][] tab_data) {
        this.count_ = 0;
        while (this.count_ < this.slide_list_.size()) {
            this.src_index_[this.count_] = (Integer)tab_data[this.count_][0];
            this.src_biocond_[this.count_] = (Integer)tab_data[this.count_][1];
            this.src_file_[this.count_] = (File)tab_data[this.count_][2];
            this.is_dyeswapped_[this.count_] = (Boolean)tab_data[this.count_][3];
            this.paired_slides_index_[this.count_] = (Integer)tab_data[this.count_][4];
            this.has_repspots_[this.count_] = (Boolean)tab_data[this.count_][5];
            this.has_ctrls_[this.count_] = (Boolean)tab_data[this.count_][6];
            this.src_file_name_[this.count_] = (String)tab_data[this.count_][7];
            this.src_file_short_info_[this.count_] = (String)tab_data[this.count_][8];
            ++this.count_;
        }
    }

    public class ExpClass {
        public boolean all_dyeswapped_;
        public boolean any_dyeswapt_;
        public int[] bloc_;
        public float[][] class_ave_avalue_dysw_;
        public float[][] class_ave_avalue_normal_;
        public float[][] class_ave_ratio_dysw_;
        public float[][] class_ave_ratio_normal_;
        public MicroArrayData[] class_dysw_slide_;
        public String[] class_dysw_slidenames_;
        public int[][] class_grid_information_;
        public ExpClassHistory class_histo_;
        public Long class_id_;
        public boolean class_is_bkg_corrected_;
        public boolean class_is_normalized_;
        public String class_name_;
        public String class_norm_method_ = "none";
        public MicroArrayData[] class_normal_slide_;
        public String[] class_normal_slidenames_;
        public float[][] class_result_;
        MicroArrayData[] class_slide_;
        public int[] column_;
        public float[][][] dummy_results_normal;
        public float[][][] expclass_dysw_data_;
        public float[][][] expclass_normal_data_;
        public int[] final_class_ctrlmarks_;
        public String[] final_class_geneids_;
        public String[] final_class_genenames_;
        public int[] flag_;
        public String[] gene_id_;
        public String[] gene_name_;
        public boolean has_ctrls_;
        public boolean has_repspots_;
        public GeneIdIndexMap id_index_map_;
        public int[] index_;
        public boolean[] index_dyeswapt_;
        public int[] is_averaged;
        public int[] is_ctrl_;
        public int[] mars_id_;
        public float[] merged_avalues_;
        public float[] merged_ratios_;
        public float[] merged_ratios_log_;
        public int[] meta_column_;
        public int[] meta_row_;
        public int num_bad_spots_;
        public int num_class_slides_;
        public int num_ctrls_;
        public int num_dysw_slides_;
        public int num_normal_slides_;
        public int num_of_dyeswapped_;
        public int num_pos_ctrls_;
        public int num_signif_gens_down_;
        public int num_signif_gens_up_;
        public int num_signific_genes_;
        public int num_spots_;
        public float[] p_values_;
        public int[] pairs_index_dysw_;
        public int[] pairs_index_normal_;
        public float[][] results_data_;
        public int[] row_;
        public String short_info_;
        public int[] significanc_mark_;
        public float[] stddev_ratios_log_;
        public float[] t_values_;
        public String the_norm_method_ = "not normalized";
        public int[] ttest_samp_size_;

        public ExpClass(MicroArrayData[] class_slides) {
            this.num_class_slides_ = class_slides.length;
            this.class_slide_ = new MicroArrayData[this.num_class_slides_];
            this.index_dyeswapt_ = new boolean[this.num_class_slides_];
            this.any_dyeswapt_ = false;
            this.all_dyeswapped_ = false;
            this.has_ctrls_ = false;
            this.has_repspots_ = false;
            this.num_of_dyeswapped_ = 0;
            int i_ = 0;
            while (i_ < this.num_class_slides_) {
                this.class_slide_[i_] = class_slides[i_];
                this.index_dyeswapt_[i_] = class_slides[i_].is_dyeswapped_;
                if (this.index_dyeswapt_[i_]) {
                    this.any_dyeswapt_ = true;
                    ++this.num_of_dyeswapped_;
                }
                if (this.class_slide_[i_].has_controls_) {
                    this.has_ctrls_ = true;
                }
                if (this.class_slide_[i_].has_rep_spots_) {
                    this.has_repspots_ = true;
                }
                ++i_;
            }
            if (this.num_of_dyeswapped_ == this.num_class_slides_) {
                this.all_dyeswapped_ = true;
            }
            this.num_spots_ = this.class_slide_[0].num_spots_;
            this.extractSlideData();
            this.countBadFlags();
            this.markControlSpots();
            this.id_index_map_ = new GeneIdIndexMap(this.gene_id_, this.gene_name_, this.is_ctrl_);
            this.class_histo_ = new ExpClassHistory();
        }

        public void averageReplSpotsWithinSlides(int ave_or_not) {
            block13: {
                block14: {
                    block12: {
                        if (ave_or_not != 2202) break block12;
                        this.class_ave_ratio_normal_ = new float[this.num_normal_slides_][this.num_spots_];
                        this.class_ave_ratio_dysw_ = new float[this.num_dysw_slides_][this.num_spots_];
                        this.class_ave_avalue_normal_ = new float[this.num_normal_slides_][this.num_spots_];
                        this.class_ave_avalue_dysw_ = new float[this.num_dysw_slides_][this.num_spots_];
                        int i = 0;
                        while (i < this.num_normal_slides_) {
                            this.class_ave_ratio_normal_[i] = MathFunctions.ratioOfArrays(this.expclass_normal_data_[i][0], this.expclass_normal_data_[i][1]);
                            this.class_ave_avalue_normal_[i] = MathFunctions.innerProduct(this.expclass_normal_data_[i][0], this.expclass_normal_data_[i][1]);
                            this.class_ave_avalue_normal_[i] = MathFunctions.sqrtArray(this.class_ave_avalue_normal_[i]);
                            this.class_ave_avalue_normal_[i] = MathFunctions.log2(this.class_ave_avalue_normal_[i]);
                            ++i;
                        }
                        int j = 0;
                        while (j < this.num_dysw_slides_) {
                            this.class_ave_ratio_dysw_[j] = MathFunctions.ratioOfArrays(this.expclass_dysw_data_[j][0], this.expclass_dysw_data_[j][1]);
                            this.class_ave_avalue_dysw_[j] = MathFunctions.innerProduct(this.expclass_dysw_data_[j][0], this.expclass_dysw_data_[j][1]);
                            this.class_ave_avalue_dysw_[j] = MathFunctions.sqrtArray(this.class_ave_avalue_dysw_[j]);
                            this.class_ave_avalue_dysw_[j] = MathFunctions.log2(this.class_ave_avalue_dysw_[j]);
                            ++j;
                        }
                        this.final_class_geneids_ = this.gene_id_;
                        this.final_class_genenames_ = this.gene_name_;
                        this.final_class_ctrlmarks_ = this.is_ctrl_;
                        ExperimentData.this.num_genes_on_slide_ = this.num_spots_;
                        break block13;
                    }
                    if (ave_or_not != 2200) break block14;
                    this.final_class_geneids_ = this.id_index_map_.getListOfUniqIds();
                    this.final_class_genenames_ = this.id_index_map_.getListOfUniqNames();
                    this.final_class_ctrlmarks_ = this.id_index_map_.getListOfControls();
                    ExperimentData.this.num_genes_on_slide_ = this.final_class_geneids_.length;
                    this.class_ave_ratio_normal_ = new float[this.num_normal_slides_][ExperimentData.this.num_genes_on_slide_];
                    this.class_ave_ratio_dysw_ = new float[this.num_dysw_slides_][ExperimentData.this.num_genes_on_slide_];
                    this.class_ave_avalue_normal_ = new float[this.num_normal_slides_][ExperimentData.this.num_genes_on_slide_];
                    this.class_ave_avalue_dysw_ = new float[this.num_dysw_slides_][ExperimentData.this.num_genes_on_slide_];
                    int i = 0;
                    while (i < ExperimentData.this.num_genes_on_slide_) {
                        String key = this.final_class_geneids_[i];
                        int[] index_match = this.id_index_map_.getIndicesFromKey(key);
                        float[] ratio_match = new float[index_match.length];
                        float[] avalues_match = new float[index_match.length];
                        int sl_c = 0;
                        while (sl_c < this.num_normal_slides_) {
                            int j = 0;
                            while (j < ratio_match.length) {
                                ratio_match[j] = this.expclass_normal_data_[sl_c][0][index_match[j]] / this.expclass_normal_data_[sl_c][1][index_match[j]];
                                avalues_match[j] = this.expclass_normal_data_[sl_c][0][index_match[j]] * this.expclass_normal_data_[sl_c][1][index_match[j]];
                                avalues_match[j] = (float)Math.sqrt(avalues_match[j]);
                                avalues_match[j] = MathFunctions.log2(avalues_match[j]);
                                ++j;
                            }
                            this.class_ave_ratio_normal_[sl_c][i] = MathFunctions.mean(ratio_match);
                            this.class_ave_avalue_normal_[sl_c][i] = MathFunctions.mean(avalues_match);
                            ++sl_c;
                        }
                        int sl_cr = 0;
                        while (sl_cr < this.num_dysw_slides_) {
                            int j = 0;
                            while (j < ratio_match.length) {
                                ratio_match[j] = this.expclass_dysw_data_[sl_cr][0][index_match[j]] / this.expclass_dysw_data_[sl_cr][1][index_match[j]];
                                avalues_match[j] = this.expclass_dysw_data_[sl_cr][0][index_match[j]] * this.expclass_dysw_data_[sl_cr][1][index_match[j]];
                                avalues_match[j] = (float)Math.sqrt(avalues_match[j]);
                                avalues_match[j] = MathFunctions.log2(avalues_match[j]);
                                ++j;
                            }
                            this.class_ave_ratio_dysw_[sl_cr][i] = MathFunctions.mean(ratio_match);
                            this.class_ave_avalue_dysw_[sl_cr][i] = MathFunctions.mean(avalues_match);
                            ++sl_cr;
                        }
                        ++i;
                    }
                    break block13;
                }
                if (ave_or_not != 2201) break block13;
                this.final_class_geneids_ = this.id_index_map_.getListOfUniqIds();
                this.final_class_genenames_ = this.id_index_map_.getListOfUniqNames();
                this.final_class_ctrlmarks_ = this.id_index_map_.getListOfControls();
                ExperimentData.this.num_genes_on_slide_ = this.id_index_map_.getListOfUniqIds().length;
                this.class_ave_ratio_normal_ = new float[this.num_normal_slides_][ExperimentData.this.num_genes_on_slide_];
                this.class_ave_ratio_dysw_ = new float[this.num_dysw_slides_][ExperimentData.this.num_genes_on_slide_];
                int i = 0;
                while (i < ExperimentData.this.num_genes_on_slide_) {
                    String key = this.final_class_geneids_[i];
                    int[] index_match = this.id_index_map_.getIndicesFromKey(key);
                    float[] ratio_match = new float[index_match.length];
                    float[] avalues_match = new float[index_match.length];
                    int sl_c = 0;
                    while (sl_c < this.num_normal_slides_) {
                        int j = 0;
                        while (j < ratio_match.length) {
                            ratio_match[j] = this.expclass_normal_data_[sl_c][0][index_match[j]] / this.expclass_normal_data_[sl_c][1][index_match[j]];
                            avalues_match[j] = this.expclass_normal_data_[sl_c][0][index_match[j]] * this.expclass_normal_data_[sl_c][1][index_match[j]];
                            avalues_match[j] = (float)Math.sqrt(avalues_match[j]);
                            avalues_match[j] = MathFunctions.log2(avalues_match[j]);
                            ++j;
                        }
                        this.class_ave_ratio_normal_[sl_c][i] = MathFunctions.firstReliableValue(ratio_match);
                        this.class_ave_avalue_normal_[sl_c][i] = MathFunctions.mean(avalues_match);
                        ++sl_c;
                    }
                    int sl_cr = 0;
                    while (sl_cr < this.num_dysw_slides_) {
                        int j = 0;
                        while (j < ratio_match.length) {
                            ratio_match[j] = this.expclass_dysw_data_[sl_cr][0][index_match[j]] / this.expclass_dysw_data_[sl_cr][1][index_match[j]];
                            avalues_match[j] = this.expclass_dysw_data_[sl_cr][0][index_match[j]] * this.expclass_dysw_data_[sl_cr][1][index_match[j]];
                            avalues_match[j] = (float)Math.sqrt(avalues_match[j]);
                            avalues_match[j] = MathFunctions.log2(avalues_match[j]);
                            ++j;
                        }
                        this.class_ave_ratio_normal_[sl_cr][i] = MathFunctions.firstReliableValue(ratio_match);
                        this.class_ave_avalue_dysw_[sl_cr][i] = MathFunctions.mean(avalues_match);
                        ++sl_cr;
                    }
                    ++i;
                }
            }
        }

        public Vector classReport() {
            Vector<Object> class_report = new Vector<Object>();
            int[] add_int = new int[2];
            boolean[] add_bool = new boolean[2];
            add_int[0] = this.num_class_slides_;
            add_bool[0] = this.class_is_bkg_corrected_;
            add_bool[1] = this.class_is_normalized_;
            class_report.add(this.class_name_);
            class_report.add(this.short_info_);
            class_report.add(add_int);
            class_report.add(add_bool);
            return class_report;
        }

        public void correctBkgrd() {
            if (!this.class_is_bkg_corrected_) {
                int j = 0;
                while (j < this.num_normal_slides_) {
                    this.expclass_normal_data_[j][0] = MathFunctions.subtractArrays(this.expclass_normal_data_[j][0], this.expclass_normal_data_[j][3]);
                    this.expclass_normal_data_[j][1] = MathFunctions.subtractArrays(this.expclass_normal_data_[j][1], this.expclass_normal_data_[j][4]);
                    this.expclass_normal_data_[j][2] = MathFunctions.ratioOfArrays(this.expclass_normal_data_[j][0], this.expclass_normal_data_[j][1]);
                    ++j;
                }
                int j2 = 0;
                while (j2 < this.num_dysw_slides_) {
                    this.expclass_dysw_data_[j2][0] = MathFunctions.subtractArrays(this.expclass_dysw_data_[j2][0], this.expclass_dysw_data_[j2][3]);
                    this.expclass_dysw_data_[j2][1] = MathFunctions.subtractArrays(this.expclass_dysw_data_[j2][1], this.expclass_dysw_data_[j2][4]);
                    this.expclass_dysw_data_[j2][2] = MathFunctions.ratioOfArrays(this.expclass_dysw_data_[j2][0], this.expclass_dysw_data_[j2][1]);
                    ++j2;
                }
                int lo_cnt = 0;
                int i = 0;
                while (i < this.expclass_normal_data_[0][0].length) {
                    if (this.expclass_normal_data_[0][0][i] < 0.0f) {
                        ++lo_cnt;
                    }
                    ++i;
                }
                if (lo_cnt > 0) {
                    ExperimentData.this.resetExperimentData();
                }
                this.class_is_bkg_corrected_ = true;
                this.class_histo_.setBkgcorr();
            } else {
                JOptionPane.showMessageDialog(ExperimentData.this.parent_gui_, "Class is already background-corrected.", "Information", 1);
            }
        }

        public void countBadFlags() {
            this.num_bad_spots_ = 0;
            int i = 0;
            while (i < this.num_spots_) {
                if (this.flag_[i] == -100) {
                    ++this.num_bad_spots_;
                }
                ++i;
            }
        }

        public void extractSlideData() {
            this.index_ = new int[this.num_spots_];
            this.bloc_ = new int[this.num_spots_];
            this.meta_column_ = new int[this.num_spots_];
            this.meta_row_ = new int[this.num_spots_];
            this.column_ = new int[this.num_spots_];
            this.row_ = new int[this.num_spots_];
            this.gene_id_ = new String[this.num_spots_];
            this.gene_name_ = new String[this.num_spots_];
            this.mars_id_ = new int[this.num_spots_];
            this.is_averaged = new int[this.num_spots_];
            this.flag_ = new int[this.num_spots_];
            this.index_ = this.class_slide_[0].index_;
            this.bloc_ = this.class_slide_[0].meta_bloc_;
            this.meta_column_ = this.class_slide_[0].meta_column_;
            this.meta_row_ = this.class_slide_[0].meta_row_;
            this.column_ = this.class_slide_[0].column_;
            this.row_ = this.class_slide_[0].row_;
            this.gene_id_ = this.class_slide_[0].gene_id_;
            this.gene_name_ = this.class_slide_[0].gene_name_;
            this.mars_id_ = this.class_slide_[0].mars_id_;
            this.flag_ = this.class_slide_[0].flag_;
            this.class_grid_information_ = new int[6][this.num_spots_];
            this.class_grid_information_[0] = this.bloc_;
            this.class_grid_information_[1] = this.meta_column_;
            this.class_grid_information_[2] = this.meta_row_;
            this.class_grid_information_[3] = this.column_;
            this.class_grid_information_[4] = this.row_;
            this.class_grid_information_[5] = this.flag_;
            this.num_dysw_slides_ = this.num_of_dyeswapped_;
            this.num_normal_slides_ = this.num_class_slides_ - this.num_dysw_slides_;
            this.expclass_dysw_data_ = new float[this.num_dysw_slides_][5][this.num_spots_];
            this.expclass_normal_data_ = new float[this.num_normal_slides_][5][this.num_spots_];
            this.class_normal_slide_ = new MicroArrayData[this.num_normal_slides_];
            this.class_dysw_slide_ = new MicroArrayData[this.num_dysw_slides_];
            this.class_normal_slidenames_ = new String[this.num_normal_slides_];
            this.class_dysw_slidenames_ = new String[this.num_dysw_slides_];
            this.pairs_index_normal_ = new int[this.num_normal_slides_];
            this.pairs_index_dysw_ = new int[this.num_dysw_slides_];
            int i = 0;
            while (i < this.num_spots_) {
                this.is_averaged[i] = 0;
                ++i;
            }
            int cnt_dysw = 0;
            int cnt_normal = 0;
            int i_ = 0;
            while (i_ < this.num_class_slides_) {
                if (this.class_slide_[i_].is_dyeswapped_) {
                    this.expclass_dysw_data_[cnt_dysw][0] = this.class_slide_[i_].getF635median_();
                    this.expclass_dysw_data_[cnt_dysw][1] = this.class_slide_[i_].getF532median_();
                    this.expclass_dysw_data_[cnt_dysw][3] = this.class_slide_[i_].getB635median_();
                    this.expclass_dysw_data_[cnt_dysw][4] = this.class_slide_[i_].getB532median_();
                    this.class_dysw_slide_[cnt_dysw] = this.class_slide_[i_];
                    this.class_dysw_slidenames_[cnt_dysw] = this.class_slide_[i_].slide_name_;
                    this.pairs_index_dysw_[cnt_dysw] = this.class_slide_[i_].selfnorm_pair_;
                    ++cnt_dysw;
                } else if (!this.class_slide_[i_].is_dyeswapped_) {
                    this.expclass_normal_data_[cnt_normal][0] = this.class_slide_[i_].getF635median_();
                    this.expclass_normal_data_[cnt_normal][1] = this.class_slide_[i_].getF532median_();
                    this.expclass_normal_data_[cnt_normal][3] = this.class_slide_[i_].getB635median_();
                    this.expclass_normal_data_[cnt_normal][4] = this.class_slide_[i_].getB532median_();
                    this.class_normal_slide_[cnt_normal] = this.class_slide_[i_];
                    this.class_normal_slidenames_[cnt_normal] = this.class_slide_[i_].slide_name_;
                    this.pairs_index_normal_[cnt_normal] = this.class_slide_[i_].selfnorm_pair_;
                    ++cnt_normal;
                }
                ++i_;
            }
            this.class_slide_ = null;
            System.gc();
        }

        public void flipTheIntensityChannels() {
            int dat_len = this.expclass_normal_data_[0][0].length;
            float[] dummy_f = new float[dat_len];
            float[] dummy_b = new float[dat_len];
            int j = 0;
            while (j < this.num_normal_slides_) {
                dummy_f = this.expclass_normal_data_[j][1];
                this.expclass_normal_data_[j][1] = this.expclass_normal_data_[j][0];
                this.expclass_normal_data_[j][0] = dummy_f;
                dummy_b = this.expclass_normal_data_[j][4];
                this.expclass_normal_data_[j][4] = this.expclass_normal_data_[j][3];
                this.expclass_normal_data_[j][3] = dummy_b;
                this.expclass_normal_data_[j][2] = MathFunctions.ratioOfArrays(this.expclass_normal_data_[j][0], this.expclass_normal_data_[j][1]);
                ++j;
            }
            int j2 = 0;
            while (j2 < this.num_dysw_slides_) {
                dummy_f = this.expclass_dysw_data_[j2][1];
                this.expclass_dysw_data_[j2][1] = this.expclass_dysw_data_[j2][0];
                this.expclass_dysw_data_[j2][0] = dummy_f;
                dummy_b = this.expclass_dysw_data_[j2][4];
                this.expclass_dysw_data_[j2][4] = this.expclass_dysw_data_[j2][3];
                this.expclass_dysw_data_[j2][3] = dummy_b;
                this.expclass_dysw_data_[j2][2] = MathFunctions.ratioOfArrays(this.expclass_dysw_data_[j2][0], this.expclass_dysw_data_[j2][1]);
                ++j2;
            }
        }

        public void markControlSpots() {
            this.is_ctrl_ = new int[this.num_spots_];
            this.num_ctrls_ = 0;
            this.num_pos_ctrls_ = 0;
            int c_s = 2000;
            int c_n = 2001;
            int c_p = 2002;
            int c_p_g = 2003;
            int c_p_h = 2004;
            int c_p_s = 2005;
            int c_p_m = 2006;
            int cnt_1 = 0;
            while (cnt_1 < this.num_spots_) {
                String dummy_name = this.gene_name_[cnt_1];
                try {
                    if (dummy_name.startsWith("C_")) {
                        this.is_ctrl_[cnt_1] = c_s;
                        ++this.num_ctrls_;
                    } else if (dummy_name.startsWith("CN_")) {
                        this.is_ctrl_[cnt_1] = c_n;
                        ++this.num_ctrls_;
                    } else if (dummy_name.startsWith("CP_")) {
                        this.is_ctrl_[cnt_1] = c_p;
                        ++this.num_ctrls_;
                        ++this.num_pos_ctrls_;
                    } else if (dummy_name.startsWith("CPG_")) {
                        this.is_ctrl_[cnt_1] = c_p_g;
                        ++this.num_ctrls_;
                        ++this.num_pos_ctrls_;
                    } else if (dummy_name.startsWith("CPH_")) {
                        this.is_ctrl_[cnt_1] = c_p_h;
                        ++this.num_ctrls_;
                        ++this.num_pos_ctrls_;
                    } else if (dummy_name.startsWith("CPS_")) {
                        this.is_ctrl_[cnt_1] = c_p_s;
                        ++this.num_ctrls_;
                        ++this.num_pos_ctrls_;
                    } else if (dummy_name.startsWith("CPM_")) {
                        this.is_ctrl_[cnt_1] = c_p_m;
                        ++this.num_ctrls_;
                        ++this.num_pos_ctrls_;
                    } else {
                        this.is_ctrl_[cnt_1] = 0;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++cnt_1;
            }
            if (this.num_ctrls_ > 0) {
                this.has_ctrls_ = true;
            }
            if (ExperimentData.this.is_experiment_ctrl_spot_ == null) {
                ExperimentData.this.is_experiment_ctrl_spot_ = new int[this.num_spots_];
                ExperimentData.this.is_experiment_ctrl_spot_ = this.is_ctrl_;
            }
        }

        public void mergeAllClassSlides(int deal_revlab_slides) {
            block16: {
                block14: {
                    int i_;
                    block15: {
                        this.merged_ratios_ = new float[ExperimentData.this.num_genes_on_slide_];
                        this.merged_avalues_ = new float[ExperimentData.this.num_genes_on_slide_];
                        this.merged_ratios_log_ = new float[ExperimentData.this.num_genes_on_slide_];
                        this.stddev_ratios_log_ = new float[ExperimentData.this.num_genes_on_slide_];
                        this.ttest_samp_size_ = new int[ExperimentData.this.num_genes_on_slide_];
                        if (deal_revlab_slides != 2301) break block14;
                        float[] dummy = new float[this.num_normal_slides_];
                        float[] dummy_a = new float[this.num_normal_slides_];
                        if (this.num_class_slides_ <= 1) break block15;
                        int i_2 = 0;
                        while (i_2 < ExperimentData.this.num_genes_on_slide_) {
                            int j_ = 0;
                            while (j_ < this.num_normal_slides_) {
                                dummy[j_] = this.class_ave_ratio_normal_[j_][i_2];
                                dummy_a[j_] = this.class_ave_avalue_normal_[j_][i_2];
                                ++j_;
                            }
                            this.merged_ratios_[i_2] = MathFunctions.mean(dummy);
                            this.merged_avalues_[i_2] = MathFunctions.mean(dummy_a);
                            float[] dummy_log = MathFunctions.log2(dummy);
                            this.ttest_samp_size_[i_2] = MathFunctions.countReliableValues(dummy_log);
                            this.merged_ratios_log_[i_2] = MathFunctions.mean(dummy_log);
                            this.stddev_ratios_log_[i_2] = MathFunctions.stddeviation(dummy_log);
                            ++i_2;
                        }
                        break block16;
                    }
                    if (this.num_normal_slides_ == 1) {
                        i_ = 0;
                        while (i_ < ExperimentData.this.num_genes_on_slide_) {
                            this.merged_ratios_[i_] = this.class_ave_ratio_normal_[0][i_];
                            this.merged_avalues_[i_] = this.class_ave_avalue_normal_[0][i_];
                            this.ttest_samp_size_[i_] = 1;
                            this.merged_ratios_log_[i_] = MathFunctions.log2(this.class_ave_ratio_normal_[0][i_]);
                            this.stddev_ratios_log_[i_] = Float.NaN;
                            ++i_;
                        }
                    }
                    if (this.num_dysw_slides_ != 1) break block16;
                    i_ = 0;
                    while (i_ < ExperimentData.this.num_genes_on_slide_) {
                        this.merged_ratios_[i_] = (float)Math.pow(this.class_ave_ratio_dysw_[0][i_], -1.0);
                        this.merged_avalues_[i_] = this.class_ave_avalue_dysw_[0][i_];
                        this.ttest_samp_size_[i_] = 1;
                        this.merged_ratios_log_[i_] = -MathFunctions.log2(this.class_ave_ratio_dysw_[0][i_]);
                        this.stddev_ratios_log_[i_] = Float.NaN;
                        ++i_;
                    }
                    break block16;
                }
                if (deal_revlab_slides == 2300) {
                    float[] dummy1 = new float[this.num_normal_slides_];
                    float[] dummy2 = new float[this.num_dysw_slides_];
                    float[] dummy_a1 = new float[this.num_normal_slides_];
                    float[] dummy_a2 = new float[this.num_dysw_slides_];
                    if (this.num_class_slides_ > 1) {
                        int i_ = 0;
                        while (i_ < ExperimentData.this.num_genes_on_slide_) {
                            int j_ = 0;
                            while (j_ < this.num_normal_slides_) {
                                dummy1[j_] = this.class_ave_ratio_normal_[j_][i_];
                                dummy_a1[j_] = this.class_ave_avalue_normal_[j_][i_];
                                ++j_;
                            }
                            int j_2 = 0;
                            while (j_2 < this.num_dysw_slides_) {
                                dummy2[j_2] = (float)Math.pow(this.class_ave_ratio_dysw_[j_2][i_], -1.0);
                                dummy_a2[j_2] = this.class_ave_avalue_dysw_[j_2][i_];
                                ++j_2;
                            }
                            float[] dummy = MathFunctions.join2Arrays(dummy1, dummy2);
                            float[] dummy_a = MathFunctions.join2Arrays(dummy_a1, dummy_a2);
                            this.merged_ratios_[i_] = MathFunctions.mean(dummy);
                            this.merged_avalues_[i_] = MathFunctions.mean(dummy_a);
                            float[] dummy_log = MathFunctions.log2(dummy);
                            this.ttest_samp_size_[i_] = MathFunctions.countReliableValues(dummy_log);
                            this.merged_ratios_log_[i_] = MathFunctions.mean(dummy_log);
                            this.stddev_ratios_log_[i_] = MathFunctions.stddeviation(dummy_log);
                            ++i_;
                        }
                    } else {
                        int i_ = 0;
                        while (i_ < ExperimentData.this.num_genes_on_slide_) {
                            if (this.num_normal_slides_ == 1) {
                                this.merged_ratios_[i_] = this.class_ave_ratio_normal_[0][i_];
                                this.merged_avalues_[i_] = this.class_ave_avalue_normal_[0][i_];
                            } else {
                                this.merged_ratios_[i_] = (float)Math.pow(this.class_ave_ratio_dysw_[0][i_], -1.0);
                                this.merged_ratios_[i_] = this.class_ave_avalue_dysw_[0][i_];
                            }
                            this.ttest_samp_size_[i_] = 1;
                            this.merged_ratios_log_[i_] = MathFunctions.log2(this.merged_ratios_[i_]);
                            this.stddev_ratios_log_[i_] = Float.NaN;
                            ++i_;
                        }
                    }
                }
            }
        }

        public void scaleAcrossSlides() {
            if (this.num_class_slides_ > 1) {
                float[] f635_all = new float[this.num_normal_slides_];
                float[] f532_all = new float[this.num_normal_slides_];
                int cnt_1 = 0;
                while (cnt_1 < this.num_spots_) {
                    int cnt_2 = 0;
                    while (cnt_2 < this.num_normal_slides_) {
                        f635_all[cnt_2] = this.expclass_normal_data_[cnt_2][0][cnt_1];
                        f532_all[cnt_2] = this.expclass_normal_data_[cnt_2][1][cnt_1];
                        ++cnt_2;
                    }
                    ++cnt_1;
                }
            }
        }

        /*
         * Handled impossible loop by adding 'first' condition
         * Enabled aggressive block sorting
         */
        public float[][] splitExpClassDataIntoBlocs(float[] dummy_array) {
            int max_blocs = 0;
            int spots_per_bloc = 0;
            max_blocs = MathFunctions.max(this.bloc_);
            int max_cols = MathFunctions.max(this.column_);
            int max_rows = MathFunctions.max(this.row_);
            spots_per_bloc = max_cols * max_rows;
            float[][] meta_array = new float[max_blocs][spots_per_bloc];
            int bloc_cnt = 0;
            while (bloc_cnt < max_blocs) {
                int spot_cnt = 0;
                boolean bl = true;
                do {
                    if (!bl || (bl = false) || !true) {
                        meta_array[bloc_cnt][spot_cnt] = dummy_array[spot_cnt + bloc_cnt * spots_per_bloc];
                        ++spot_cnt;
                    }
                    if (spot_cnt + bloc_cnt * spots_per_bloc >= this.num_spots_) break;
                } while (this.bloc_[spot_cnt + bloc_cnt * spots_per_bloc] == bloc_cnt + 1);
                ++bloc_cnt;
            }
            return meta_array;
        }
    }
}

