/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.normalize;

import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;
import at.tugraz.genome.arraynormcore.microarrayobjects.SpotData;
import at.tugraz.genome.arraynormcore.normalize.LowessAlgorithm;
import at.tugraz.genome.arraynormcore.normalize.NormalizeMethod;
import at.tugraz.genome.arraynormcore.util.SpotAValueComparator;
import at.tugraz.genome.arraynormcore.util.SpotIndexComparator;
import at.tugraz.genome.math.MathFunctions;
import java.util.ArrayList;
import java.util.Collections;

public class LowessSubgridMethod
implements NormalizeMethod {
    private float[] calculateLowess(float[] x_in, float[] y_in) {
        Object[] result = LowessAlgorithm.lowess(x_in, y_in, x_in.length, 0.1f, 0, 0.0f);
        float[] y_fit = (float[])result[0];
        return y_fit;
    }

    public void normalize(ExperimentData.ExpClass exp_class) {
        int indy1 = 0;
        int[] meta_block = exp_class.bloc_;
        int[] sing_col = exp_class.column_;
        int[] sing_row = exp_class.row_;
        int max_blocks = MathFunctions.max(meta_block);
        int max_cols = MathFunctions.max(sing_col);
        int max_rows = MathFunctions.max(sing_row);
        int spots_per_block = max_cols * max_rows;
        int ns_cnt = 0;
        while (ns_cnt < exp_class.num_normal_slides_) {
            float[] dummy_1 = (float[])exp_class.expclass_normal_data_[ns_cnt][0].clone();
            float[] dummy_2 = (float[])exp_class.expclass_normal_data_[ns_cnt][1].clone();
            float[][] meta_keep_red = exp_class.class_normal_slide_[0].splitSlideIntoBlocs(dummy_1);
            float[][] meta_keep_green = exp_class.class_normal_slide_[0].splitSlideIntoBlocs(dummy_2);
            float[] m_in = MathFunctions.ratioOfArrays(dummy_1, dummy_2);
            m_in = MathFunctions.log2(m_in);
            float[] dummy_3 = MathFunctions.addArrays(MathFunctions.log2(dummy_1), MathFunctions.log2(dummy_2));
            float[] a_in = MathFunctions.multArrayWithConst(dummy_3, 0.5f);
            float[][] meta_array_1 = exp_class.class_normal_slide_[0].splitSlideIntoBlocs(a_in);
            float[][] meta_array_2 = exp_class.class_normal_slide_[0].splitSlideIntoBlocs(m_in);
            int bloc_cnt = 0;
            while (bloc_cnt < max_blocks) {
                ArrayList<SpotData> spotlist = new ArrayList<SpotData>();
                SpotData[] spots = new SpotData[spots_per_block];
                int i = 0;
                while (i < spots_per_block) {
                    spots[i] = new SpotData();
                    spots[i].setIndex(new Integer(i));
                    spots[i].setF635(new Float(meta_keep_red[bloc_cnt][i]));
                    spots[i].setF532(new Float(meta_keep_green[bloc_cnt][i]));
                    spots[i].setAvalue(new Float(meta_array_1[bloc_cnt][i]));
                    spots[i].setMValue(new Float(meta_array_2[bloc_cnt][i]));
                    spotlist.add(spots[i]);
                    ++i;
                }
                SpotAValueComparator compi_a = new SpotAValueComparator();
                Collections.sort(spotlist, compi_a);
                float[] m_sorted = new float[spots_per_block];
                float[] a_sorted = new float[spots_per_block];
                float[] f532_sorted = new float[spots_per_block];
                int i2 = 0;
                while (i2 < spots_per_block) {
                    m_sorted[i2] = ((SpotData)spotlist.get(i2)).getMValue().floatValue();
                    a_sorted[i2] = ((SpotData)spotlist.get(i2)).getAvalue().floatValue();
                    f532_sorted[i2] = ((SpotData)spotlist.get(i2)).getF532().floatValue();
                    ++i2;
                }
                float[] ys = this.calculateLowess(a_sorted, m_sorted);
                float[] const_1 = MathFunctions.exp2(ys);
                f532_sorted = MathFunctions.innerProduct(f532_sorted, const_1);
                int i3 = 0;
                while (i3 < spots_per_block) {
                    ((SpotData)spotlist.get(i3)).setF532(new Float(f532_sorted[i3]));
                    ++i3;
                }
                int i4 = 0;
                while (i4 < spots_per_block) {
                    float f635_dummy = ((SpotData)spotlist.get(i4)).getF635().floatValue();
                    float f532_dummy = ((SpotData)spotlist.get(i4)).getF532().floatValue();
                    float m_corr = f635_dummy / f532_dummy;
                    m_corr = MathFunctions.log2(m_corr);
                    float a_corr = (MathFunctions.log2(f635_dummy) + MathFunctions.log2(f532_dummy)) / 2.0f;
                    ((SpotData)spotlist.get(i4)).setAvalue(new Float(a_corr));
                    ((SpotData)spotlist.get(i4)).setMValue(new Float(m_corr));
                    ++i4;
                }
                SpotIndexComparator compi_index = new SpotIndexComparator();
                Collections.sort(spotlist, compi_index);
                int i5 = 0;
                while (i5 < spots_per_block) {
                    meta_keep_red[bloc_cnt][i5] = ((SpotData)spotlist.get(i5)).getF635().floatValue();
                    meta_keep_green[bloc_cnt][i5] = ((SpotData)spotlist.get(i5)).getF532().floatValue();
                    ++i5;
                }
                compi_a = null;
                compi_index = null;
                spots = null;
                spotlist = null;
                ++bloc_cnt;
            }
            indy1 = 0;
            int i_ = 0;
            while (i_ < max_blocks) {
                int j_ = 0;
                while (j_ < spots_per_block) {
                    indy1 = i_ * spots_per_block + j_;
                    dummy_1[indy1] = meta_keep_red[i_][j_];
                    dummy_2[indy1] = meta_keep_green[i_][j_];
                    ++j_;
                }
                ++i_;
            }
            exp_class.expclass_normal_data_[ns_cnt][0] = (float[])dummy_1.clone();
            exp_class.expclass_normal_data_[ns_cnt][1] = (float[])dummy_2.clone();
            dummy_3 = MathFunctions.ratioOfArrays(exp_class.expclass_normal_data_[ns_cnt][0], exp_class.expclass_normal_data_[ns_cnt][1]);
            exp_class.expclass_normal_data_[ns_cnt][2] = dummy_3;
            ++ns_cnt;
        }
    }
}

