/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.plot;

import at.tugraz.genome.arraynormcore.math.StatisticFunctions;
import at.tugraz.genome.arraynormcore.plot.SimpleBasisPlot;
import at.tugraz.genome.arraynormcore.plot.VisualDataModel;
import at.tugraz.genome.math.MathFunctions;
import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.data.JCDefaultDataSource;
import java.text.NumberFormat;
import javax.swing.JLabel;

public class TwoSlidesRegressionPlot
extends SimpleBasisPlot {
    VisualDataModel complete_model_ = null;
    ChartDataModel data_model_ = null;
    double itcpt_;
    double r2_;
    String slide_name_;
    double slop_;

    public TwoSlidesRegressionPlot(VisualDataModel complete_model, String slide_name) {
        this.complete_model_ = complete_model;
        this.slide_name_ = slide_name;
        String[] slide_names = new String[2];
        slide_names = this.slide_name_.split(" vs ");
        this.scat_chart_.getDataView(0).setDataSource(this.complete_model_.createScatDataModel());
        this.scat_chart_.getDataView(1).setDataSource(this.complete_model_.createScatZerolineModel());
        double[] x_mod = this.complete_model_.getXSeries(0);
        double[] y_mod = this.complete_model_.getYSeries(0);
        double[] linreg = StatisticFunctions.calcLinRegression(x_mod, y_mod);
        this.slop_ = linreg[0];
        this.itcpt_ = linreg[1];
        this.r2_ = Math.pow(linreg[2], 2.0);
        this.scat_chart_.getDataView(3).setDataSource(this.createReglineDataModel());
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(4);
        this.x_axis_.setTitle(new JCAxisTitle("log2(R/G): " + slide_names[0]));
        this.y_axis_.setTitle(new JCAxisTitle("log2(R/G): " + slide_names[1]));
        ((JLabel)this.scat_chart_.getHeader()).setText("Regression Plot 2 Slides (log2 ratios)");
        ((JLabel)this.scat_chart_.getFooter()).setText("Reg-Line:   Y = " + nf.format(this.slop_) + "*X + " + nf.format(this.itcpt_) + "  ,   R^2 =  " + nf.format(this.r2_));
        this.y_axis_.getTitle().setPlacement(2);
        this.y_axis_.getTitle().setRotation(3);
    }

    public ChartDataModel createReglineDataModel() {
        double[] x_mod = this.complete_model_.getXSeries(0);
        double x_max = MathFunctions.max(x_mod);
        double[][] x_in = new double[1][2];
        double[][] y_in = new double[1][2];
        x_in[0][0] = 0.0;
        x_in[0][1] = x_max;
        y_in[0][0] = this.itcpt_;
        y_in[0][1] = x_max * this.slop_ + this.itcpt_;
        JCDefaultDataSource sepp = new JCDefaultDataSource();
        sepp.setData(x_in, y_in);
        sepp.setName("Line R/G = 1");
        return sepp;
    }
}

