/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.dbutilities;

import at.tugraz.genome.dbutilities.AbstractEJBException;
import at.tugraz.genome.dbutilities.exception.EJBCreateException;
import at.tugraz.genome.dbutilities.exception.EJBFinderException;
import at.tugraz.genome.dbutilities.exception.EJBRemoveException;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.dbutilities.exception.ForeignKeyException;
import at.tugraz.genome.dbutilities.exception.UniqueException;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class OracleEJBException
extends AbstractEJBException {
    Logger log_ = Logger.getLogger(this.getClass());

    public void throwEJBCreateException(CreateException createExc) throws UniqueException, ForeignKeyException, EJBCreateException {
        this.log_.info("throwEJBCreateException");
        if (createExc.getMessage().indexOf("ORA-00001") != -1) {
            this.log_.info("Entry not Unique");
            throw new UniqueException("Entry not Unique " + createExc.getMessage());
        }
        if (createExc.getMessage().indexOf("ORA-02291") != -1) {
            this.log_.info("Superior key not found");
            throw new ForeignKeyException("Superior key not found " + createExc.getMessage());
        }
        if (createExc.getMessage().indexOf("ORA-01400") != -1) {
            this.log_.info("Insert of NULL not allowed");
            throw new EJBCreateException("Insert of NULL not allowed " + createExc.getMessage());
        }
        this.log_.info("UNKNOWN CREATE EXCEPTION: " + createExc.getMessage());
        throw new EJBCreateException("Could not create entity " + createExc.getMessage());
    }

    public void throwEJBFinderException(FinderException finderExc) throws EJBFinderException {
        this.log_.info("throwEJBFinderException");
        throw new EJBFinderException(finderExc.getMessage());
    }

    public void throwEJBServerException(NamingException namingExc) throws EJBServerException {
        this.log_.info("throwEJBServerException");
        throw new EJBServerException(namingExc.getMessage());
    }

    public void throwEJBRemoveException(RemoveException removeExc) throws EJBRemoveException {
        this.log_.info("removeEJBException");
        throw new EJBRemoveException(removeExc.getMessage());
    }
}

