/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsclient;

import at.tugraz.genome.util.swing.TableSorter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class DatabaseTable
extends JTable {
    static /* synthetic */ Class class$java$lang$Object;
    private DefaultTableCellRenderer myCellRenderer;
    private MyTableModel myTableModel;
    private Vector rows;

    public DatabaseTable(Vector rows) {
        this.rows = rows;
        this.myTableModel = new MyTableModel();
        TableSorter mySorter = new TableSorter(this.myTableModel);
        mySorter.addMouseListenerToHeaderInTable(this);
        this.setModel(mySorter);
        this.showHorizontalLines = false;
        this.showVerticalLines = false;
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setBackground(Color.white);
        this.setAutoResizeMode(0);
        Object column = null;
        int n = this.getColumnModel().getColumnCount();
        this.myCellRenderer = new GeneTableCellRenderer();
        this.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = DatabaseTable.class$("java.lang.Object")) : class$java$lang$Object, this.myCellRenderer);
        this.setRowHeight(17);
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        JLabel l = (JLabel)((Object)this.getTableHeader().getDefaultRenderer());
        l.setPreferredSize(new Dimension(0, 20));
        int i = 0;
        while (i < n) {
            int maxWidth = 0;
            String data = this.myTableModel.getColumnName(i);
            maxWidth = metrics.stringWidth(data);
            int j = 0;
            while (j < this.myTableModel.getRowCount()) {
                int width;
                if (this.myTableModel.getValueAt(j, i) != null && (width = metrics.stringWidth(this.myTableModel.getValueAt(j, i).toString())) > maxWidth) {
                    maxWidth = width;
                }
                ++j;
            }
            Insets insets = ((JComponent)((Object)this.getCellRenderer(0, i))).getInsets();
            this.getColumnModel().getColumn(i).setPreferredWidth(maxWidth + 20);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class GeneTableCellRenderer
    extends DefaultTableCellRenderer {
        public GeneTableCellRenderer() {
            this.setBackground(Color.white);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel cell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setOpaque(true);
            cell.setHorizontalAlignment(0);
            cell.setFont(new Font("Dialog", 1, 10));
            if (row % 2 == 1) {
                cell.setBackground(new Color(237, 243, 254));
            } else {
                cell.setBackground(Color.white);
            }
            int rightborder = 0;
            int bottomborder = 0;
            if (row + 1 == DatabaseTable.this.myTableModel.getRowCount()) {
                bottomborder = 1;
            }
            if (column + 1 != DatabaseTable.this.myTableModel.getColumnCount()) {
                rightborder = 1;
            }
            MatteBorder cellBorder = BorderFactory.createMatteBorder(0, 0, bottomborder, rightborder, new Color(217, 217, 217));
            if (column > 0) {
                cell.setHorizontalAlignment(2);
                cell.setBorder(BorderFactory.createCompoundBorder(cellBorder, BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            } else {
                cell.setHorizontalAlignment(0);
                cell.setBorder(cellBorder);
            }
            if (isSelected) {
                cell.setBackground(new Color(49, 106, 197));
                cell.setForeground(Color.white);
            } else {
                cell.setForeground(Color.black);
            }
            return cell;
        }

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paint(g);
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = null;
        private Method[] methods = null;

        public MyTableModel() {
            Method[] allMethods = DatabaseTable.this.rows.get(0).getClass().getMethods();
            this.columnNames = new String[allMethods.length];
            Vector<String> columnNamesVector = new Vector<String>();
            Vector<Method> methodsVector = new Vector<Method>();
            int i = 0;
            while (i < allMethods.length) {
                String dummy = allMethods[i].toString();
                if (dummy.indexOf("get") >= 0) {
                    if ((dummy = dummy.substring(dummy.indexOf("get") + 3, dummy.length() - 2)).indexOf("Class") < 0) {
                        columnNamesVector.add(dummy);
                        methodsVector.add(allMethods[i]);
                    }
                    this.columnNames[i] = dummy;
                }
                ++i;
            }
            this.columnNames = new String[columnNamesVector.size()];
            this.methods = new Method[columnNamesVector.size()];
            int i2 = 0;
            while (i2 < this.columnNames.length) {
                this.columnNames[i2] = (String)columnNamesVector.get(i2);
                this.methods[i2] = (Method)methodsVector.get(i2);
                ++i2;
            }
        }

        public int getColumnCount() {
            if (this.columnNames == null) {
                return 0;
            }
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getRowCount() {
            return DatabaseTable.this.rows.size();
        }

        public Object getValueAt(int row, int col) {
            Object returnObject = null;
            try {
                returnObject = this.methods[col].invoke(DatabaseTable.this.rows.get(row), new Object[0]);
            }
            catch (Exception ex) {
                returnObject = "" + ex;
            }
            return returnObject;
        }
    }
}

