/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb;

import at.tugraz.genome.dbutilities.SimpleValueObject;
import at.tugraz.genome.marsejb.utils.vo.FileUploadTypeVO;
import at.tugraz.genome.marsservice.ServerSettings;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GlobalConstants {
    public static final String VERSION = "Alpha 0.9.6";
    public static final String MYAPPLICATIONNAME = "mars";
    public static final String MYAPPLICATIONKEY = "T6so1Sf9hVHSB7s6uTfAiivaXFy6P02gx2Bxrg1PvqYO2244Jhv5MjBJwsBHQ787hgMzB3prvxamAKhvPQVBSQ45";
    public static final String KEY_COMMON = "Common";
    public static final String KEY_CHANNEL = "Channel";
    public static final String IMAGE_FALSE_COLOR = "False Color Image";
    public static final int VO_LEVEL_FINAL = 0;
    public static final int VO_LEVEL_FULL = 10000;
    public static final int VO_LEVEL_MINIMUM = 1;
    public static final int VO_LEVEL_DETAIL = 5;
    public static final int ID_OFFSET = 99;
    private static GlobalConstants instance_ = null;
    public static final String[] MICROTITERROWS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    public static final String IMAGETYPE_HYBRIDIZATION = "Hybridization";
    public static final String IMAGETYPE_PREHYBRIDIZATION = "PreHybridization";
    public static final String IMAGETYPE_QCARRAY = "QCArray";
    public static final String UNKNOWNCLONE = "unknown";
    private static ServerSettings serverSettings = null;
    public static FileUploadTypeVO E_PLATE = new FileUploadTypeVO("Plate", "plates");
    public static FileUploadTypeVO E_MERGEPLATE = new FileUploadTypeVO("Plate merge algorithm", "mergeplatealgorithms");
    public static FileUploadTypeVO E_ARRAYDESIGN = new FileUploadTypeVO("Arraydesign", "arraydesigns");
    public static FileUploadTypeVO E_PREHYB_IMAGE = new FileUploadTypeVO("Prehybridization image", "prehybridizationimages");
    public static FileUploadTypeVO E_HYB_IMAGE = new FileUploadTypeVO("Hybridization image", "hybridizationimages");
    public static FileUploadTypeVO E_QCIMAGE = new FileUploadTypeVO("QC Image", "qcimages");
    public static FileUploadTypeVO E_RAWBIOASSAY = new FileUploadTypeVO("Rawdataset", "rawdatasets");
    public static FileUploadTypeVO E_PROTOCOL = new FileUploadTypeVO("Protocol", "protocols");
    public static FileUploadTypeVO E_SPOTTINGRUN = new FileUploadTypeVO("Spottingrun", "spottingrun");
    public static final String MEASUREMENT_UNIT_MICRON = "Micrometer";
    public static final String MEASUREMENT_UNIT_PIXEL = "Pixel";
    private static FileUploadTypeVO[] ENUM_FILETYPES_LOCAL = new FileUploadTypeVO[]{E_PLATE, E_MERGEPLATE, E_ARRAYDESIGN, E_PREHYB_IMAGE, E_HYB_IMAGE, E_QCIMAGE, E_RAWBIOASSAY};
    private static FileUploadTypeVO[] ENUM_FILETYPES;

    private GlobalConstants() {
    }

    public static GlobalConstants getInstance() {
        block5: {
            System.out.println("GlobalConstants.getInstance()");
            if (instance_ != null) break block5;
            instance_ = new GlobalConstants();
            try {
                InitialContext ctx = new InitialContext();
                serverSettings = (ServerSettings)ctx.lookup("java:/MARSServerSettings");
                Vector eVect = GlobalConstants.loadFileUploadTypeXML();
                if (eVect != null) {
                    System.out.println("Using FileUploadTypeVO from XML File");
                    ENUM_FILETYPES = new FileUploadTypeVO[eVect.size()];
                    int i = 0;
                    while (i < eVect.size()) {
                        GlobalConstants.ENUM_FILETYPES[i] = (FileUploadTypeVO)eVect.get(i);
                        ++i;
                    }
                } else {
                    System.out.println("Using FileUploadTypeVO from Global Utils Class");
                    ENUM_FILETYPES = ENUM_FILETYPES_LOCAL;
                }
            }
            catch (NamingException ex) {
                ex.printStackTrace();
                System.out.println(ex);
            }
        }
        return instance_;
    }

    public static FileUploadTypeVO[] getFileUploadTypes() {
        if (instance_ == null) {
            instance_ = GlobalConstants.getInstance();
        }
        return ENUM_FILETYPES;
    }

    public static String getDatabase() {
        String databaseString = "ORACLE";
        if (instance_ == null) {
            instance_ = GlobalConstants.getInstance();
        }
        databaseString = serverSettings.getProperty("DATABASE");
        return databaseString;
    }

    public static String getDataRootDirectory() {
        if (instance_ == null) {
            instance_ = GlobalConstants.getInstance();
        }
        String dataRootDirectory = serverSettings.getProperty("DATAROOTDIRECTORY");
        return dataRootDirectory;
    }

    public static boolean getGuestUserAllowed() {
        if (instance_ == null) {
            instance_ = GlobalConstants.getInstance();
        }
        String guestUserAllowed = serverSettings.getProperty("GUESTUSERALLOWED");
        boolean retValue = false;
        try {
            retValue = new Boolean(guestUserAllowed);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retValue;
    }

    public static int getMicrotiterRow(String row) {
        int i = 0;
        while (i < MICROTITERROWS.length) {
            if (MICROTITERROWS[i].equals(row.toUpperCase())) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    public static String getMicrotiterRow(int row) {
        return MICROTITERROWS[row - 1];
    }

    public static Collection getSearchOperators() {
        Vector<SimpleValueObject> vector = new Vector<SimpleValueObject>();
        SimpleValueObject svo = new SimpleValueObject("Like", "Like");
        vector.add(svo);
        svo = new SimpleValueObject(">", ">");
        vector.add(svo);
        svo = new SimpleValueObject(">=", ">=");
        vector.add(svo);
        svo = new SimpleValueObject("=", "=");
        vector.add(svo);
        svo = new SimpleValueObject("<>", "<>");
        vector.add(svo);
        svo = new SimpleValueObject("<=", "<=");
        vector.add(svo);
        svo = new SimpleValueObject("<", "<");
        vector.add(svo);
        svo = new SimpleValueObject("Between", "Between");
        vector.add(svo);
        svo = new SimpleValueObject("Not Between", "Not Between");
        vector.add(svo);
        svo = new SimpleValueObject("In", "In");
        vector.add(svo);
        svo = new SimpleValueObject("Not In", "Not In");
        vector.add(svo);
        return vector;
    }

    private static Vector loadFileUploadTypeXML() {
        System.out.println("loadFileUploadTypeXML");
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Vector eVector = new Vector();
            DocumentBuilder builder = factory.newDocumentBuilder();
            File f = new File(GlobalConstants.getDataRootDirectory() + "/config/FileUploadTypes.xml");
            document = builder.parse(f);
            Element root = document.getDocumentElement();
            root.normalize();
            GlobalConstants.parseXMLDocument(root, eVector);
            builder = null;
            factory = null;
            return eVector;
        }
        catch (SAXParseException spe) {
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            x.printStackTrace();
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static void parseXMLDocument(Node currentNode, Vector eVector) {
        String displayName = "";
        String pathName = "";
        if (currentNode.getNodeName().compareTo("FileUploadType") == 0) {
            displayName = currentNode.getAttributes().getNamedItem("DisplayName").getNodeValue();
            pathName = currentNode.getAttributes().getNamedItem("PathName").getNodeValue();
            FileUploadTypeVO fileUploadTypeVO = new FileUploadTypeVO(displayName, pathName);
            eVector.add(fileUploadTypeVO);
        }
        NodeList list = currentNode.getChildNodes();
        int k = 0;
        while (k < list.getLength()) {
            Node nd = list.item(k);
            GlobalConstants.parseXMLDocument(nd, eVector);
            ++k;
        }
    }
}

