/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.experiment.vo;

import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassRawbioassayDTO;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.experiment.ejb.Experimentclassrawbioassay;
import at.tugraz.genome.marsejb.experiment.vo.ExperimentClassVO;
import at.tugraz.genome.marsejb.rawbioassaydata.vo.RawbioassayVO;
import java.io.Serializable;

public class ExperimentClassRawbioassayVO
implements Serializable {
    private Long id;
    private Long rawbioassayid;
    private Long pairsindex;
    private String dyeswap;
    private ExperimentClassVO classVO;
    private Long classID;
    private RawbioassayVO rbaVO;

    public ExperimentClassRawbioassayVO(RawbioassayVO rawbioassayVO, Long pairsIndex, String dyeswap, ExperimentClassVO classVO) throws ValidationException {
        this.rbaVO = rawbioassayVO;
        this.setRawbioassayid(this.rbaVO.getId());
        this.pairsindex = pairsIndex;
        this.dyeswap = dyeswap;
        this.classVO = classVO;
        if (classVO != null) {
            this.classID = classVO.getId();
        }
    }

    public ExperimentClassRawbioassayVO(Experimentclassrawbioassay entity, boolean reantrant) {
        System.out.println("ExperimentClassRawbioassayVO: " + reantrant);
        this.id = entity.getId();
        this.setRawbioassayid(entity.getRawbioassayid());
        this.pairsindex = entity.getPairsindex();
        this.dyeswap = entity.getDyeswap();
        if (!reantrant) {
            this.classVO = new ExperimentClassVO(entity.getExperimentclass(), !reantrant);
        }
        if (this.classVO != null) {
            this.classID = this.classVO.getId();
        }
        try {
            this.rbaVO = entity.getRawBioassayVO();
        }
        catch (Exception e) {
            System.out.println("Unexpected Exception " + e);
        }
    }

    public ExperimentClassRawbioassayVO(Experimentclassrawbioassay entity, boolean reantrant, int level) {
        block4: {
            System.out.println("ExperimentClassRawbioassayVO: " + level + " " + reantrant);
            this.id = entity.getId();
            this.setRawbioassayid(entity.getRawbioassayid());
            this.pairsindex = entity.getPairsindex();
            this.dyeswap = entity.getDyeswap();
            if (level <= 0) break block4;
            if (!reantrant) {
                this.classVO = new ExperimentClassVO(entity.getExperimentclass(), !reantrant, level - 1);
            }
            if (this.classVO != null) {
                this.classID = this.classVO.getId();
            }
            try {
                this.rbaVO = entity.getRawBioassayVO(0);
            }
            catch (Exception e) {
                System.out.println("Unexpected Exception " + e);
            }
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getRawbioassayid() {
        return this.rawbioassayid;
    }

    public Long getPairsindex() {
        return this.pairsindex;
    }

    public String getDyeswap() {
        return this.dyeswap;
    }

    public void setId(Long id) throws ValidationException {
        if (this.id != null) {
            throw new ValidationException("Id is already set !", this.getClass());
        }
        if (id == null) {
            throw new ValidationException("null not allowed !", this.getClass());
        }
        this.id = id;
    }

    public void setRawbioassayid(Long rawbioassayid) {
        this.rawbioassayid = rawbioassayid;
    }

    public void setPairsindex(Long pairsindex) throws ValidationException {
        if (pairsindex == null) {
            throw new ValidationException("pairs must be set to a number", this.getClass());
        }
        this.pairsindex = pairsindex;
    }

    public void setDyeswap(String dyeswap) throws ValidationException {
        if (dyeswap == null || dyeswap.length() == 0) {
            dyeswap = "FALSE";
        }
        if (!dyeswap.equalsIgnoreCase("TRUE") && !dyeswap.equalsIgnoreCase("FALSE")) {
            throw new ValidationException("DYESWAP Must Be True or False", this.getClass());
        }
        this.dyeswap = dyeswap.toUpperCase();
    }

    public void setClassVO(ExperimentClassVO classVO) throws ValidationException {
        if (classVO == null) {
            throw new ValidationException("ClassVO must be set! ", this.getClass());
        }
        this.classVO = classVO;
    }

    public ExperimentClassVO getClassVO() {
        return this.classVO;
    }

    public void setClassID(Long id) throws ValidationException {
        this.classID = id;
    }

    public Long getClassID() {
        if (this.classVO != null) {
            return this.classVO.getId();
        }
        return null;
    }

    public RawbioassayVO getRawbioassayVO() {
        return this.rbaVO;
    }

    public ExperimentClassRawbioassayDTO createExperimentClassRawbioassayDTO() {
        ExperimentClassRawbioassayDTO experimentClassRawbioassayDTO = new ExperimentClassRawbioassayDTO();
        experimentClassRawbioassayDTO.setClassID(this.getClassID());
        if (this.getClassVO() != null) {
            experimentClassRawbioassayDTO.setExperimentClassDTO(this.getClassVO().createExperimentClassDTO());
        }
        experimentClassRawbioassayDTO.setId(this.getId());
        experimentClassRawbioassayDTO.setPairsindex(this.getPairsindex());
        experimentClassRawbioassayDTO.setDyeSwap(new Boolean(this.getDyeswap()));
        if (this.getRawbioassayVO() != null) {
            experimentClassRawbioassayDTO.setRawbioassayDTO(this.getRawbioassayVO().createRawbioassayDTO());
            experimentClassRawbioassayDTO.getRawbioassayDTO().setDyeswap(experimentClassRawbioassayDTO.getDyeSwap());
        }
        return experimentClassRawbioassayDTO;
    }

    public String toString() {
        StringBuffer _ret = new StringBuffer("at.tugraz.genome.marsejb.experiment.vo.ExperimentClassRawbioassayVO {");
        _ret.append("\n");
        _ret.append("java.math.BigDecimal id=");
        _ret.append(this.id);
        _ret.append(",\n");
        _ret.append("java.lang.Long rawbioassayid=");
        _ret.append(this.rawbioassayid);
        _ret.append(",\n");
        _ret.append("java.lang.Long pairsindex=");
        _ret.append(this.pairsindex);
        _ret.append(",\n");
        _ret.append("java.lang.String dyeswap=");
        _ret.append(this.dyeswap);
        _ret.append("\n");
        _ret.append("}");
        return _ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ExperimentClassRawbioassayVO) {
            ExperimentClassRawbioassayVO obj = (ExperimentClassRawbioassayVO)o;
            boolean res = true;
            boolean bl = res = this.getId() == obj.getId() || this.getId() != null && obj.getId() != null && this.getId().equals(obj.getId());
            if (res) {
                boolean bl2 = res = this.getRawbioassayid() == obj.getRawbioassayid() || this.getRawbioassayid() != null && obj.getRawbioassayid() != null && this.getRawbioassayid().equals(obj.getRawbioassayid());
                if (res) {
                    boolean bl3 = res = this.getPairsindex() == obj.getPairsindex() || this.getPairsindex() != null && obj.getPairsindex() != null && this.getPairsindex().equals(obj.getPairsindex());
                    if (res) {
                        boolean bl4 = res = this.getDyeswap() == obj.getDyeswap() || this.getDyeswap() != null && obj.getDyeswap() != null && this.getDyeswap().equals(obj.getDyeswap());
                        if (!res) {
                            // empty if block
                        }
                    }
                }
            }
            return res;
        }
        return false;
    }
}

