/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.experiment.vo;

import at.tugraz.genome.dbutilities.exception.EJBFinderException;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentannotationDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.SubexperimentDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.SubmitterDTO;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.experiment.ejb.Experiment;
import at.tugraz.genome.marsejb.experiment.vo.ExperimentannotationVO;
import at.tugraz.genome.marsejb.experiment.vo.SubexperimentVO;
import at.tugraz.genome.marsejb.utils.vo.SubmitterVO;
import java.io.Serializable;
import java.sql.Date;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class ExperimentVO
implements Serializable {
    private Long id;
    private String name;
    private String descr;
    private Long userid;
    private Date addeddate;
    private Long usecount;
    private String qcreplicatesonarray;
    private String qcreplicatesofslides;
    private String qcdyeswap;
    private String qcdescription;
    private Collection experimentannotationVOs;
    private Collection hybridizationVOs;
    private SubmitterVO submitterVO;
    private Collection subexperimentVOs;

    public ExperimentVO(String name, String descr, Long userid, Date addeddate, String qcreplicatesonarray, String qcreplicatesofslides, String qcdyeswap, String qcdescription, Collection experimentannotationVOs, Collection publicationVOs) throws ValidationException {
        if (userid == null) {
            throw new ValidationException("Userid null not allowed", this.getClass());
        }
        if (name == null || name.length() == 0) {
            throw new ValidationException("Name is required", this.getClass());
        }
        this.name = name;
        this.descr = descr;
        this.userid = userid;
        this.addeddate = addeddate;
        this.qcreplicatesonarray = qcreplicatesonarray;
        this.qcreplicatesofslides = qcreplicatesofslides;
        this.qcdyeswap = qcdyeswap;
        this.qcdescription = qcdescription;
        this.experimentannotationVOs = experimentannotationVOs;
    }

    public ExperimentVO(Experiment entity) {
        this.id = entity.getId();
        this.setName(entity.getName());
        this.setDescr(entity.getDescr());
        this.setUserid(entity.getUserid());
        this.setAddeddate(entity.getAddeddate());
        this.setUsecount(entity.getUsecount());
        this.setQcreplicatesonarray(entity.getQcreplicatesonarray());
        this.setQcreplicatesofslides(entity.getQcreplicatesofslides());
        this.setQcdyeswap(entity.getQcdyeswap());
        this.setQcdescription(entity.getQcdescription());
        try {
            this.experimentannotationVOs = entity.getExperimentannotationVOs();
            this.hybridizationVOs = entity.getExperimenthybridizationVOs();
            this.subexperimentVOs = entity.getSubExperimentVOs();
            this.setSubmitterVO(entity.getSubmitterVO());
        }
        catch (EJBFinderException finderExc) {
            System.out.println(finderExc);
        }
        catch (EJBServerException serverExc) {
            System.out.println(serverExc);
        }
    }

    public ExperimentVO(Experiment entity, int level) {
        this.id = entity.getId();
        this.setName(entity.getName());
        this.setDescr(entity.getDescr());
        this.setUserid(entity.getUserid());
        this.setAddeddate(entity.getAddeddate());
        this.setUsecount(entity.getUsecount());
        this.setQcreplicatesonarray(entity.getQcreplicatesonarray());
        this.setQcreplicatesofslides(entity.getQcreplicatesofslides());
        this.setQcdyeswap(entity.getQcdyeswap());
        this.setQcdescription(entity.getQcdescription());
        try {
            if (level > 0) {
                this.experimentannotationVOs = entity.getExperimentannotationVOs();
                this.hybridizationVOs = entity.getExperimenthybridizationVOs(level - 1);
                this.subexperimentVOs = entity.getSubExperimentVOs(level - 1);
                this.setSubmitterVO(entity.getSubmitterVO());
            }
        }
        catch (EJBFinderException finderExc) {
            System.out.println(finderExc);
        }
        catch (EJBServerException serverExc) {
            System.out.println(serverExc);
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescr() {
        return this.descr;
    }

    public Long getUserid() {
        return this.userid;
    }

    public Date getAddeddate() {
        return this.addeddate;
    }

    public Long getUsecount() {
        return this.usecount;
    }

    public String getQcreplicatesonarray() {
        return this.qcreplicatesonarray;
    }

    public String getQcreplicatesofslides() {
        return this.qcreplicatesofslides;
    }

    public String getQcdyeswap() {
        return this.qcdyeswap;
    }

    public String getQcdescription() {
        return this.qcdescription;
    }

    public void setId(Long id) throws ValidationException {
        if (this.id != null) {
            throw new ValidationException("Id is already set !", this.getClass());
        }
        if (id == null) {
            throw new ValidationException("null not allowed !", this.getClass());
        }
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescr(String descr) {
        this.descr = descr;
    }

    public void setUserid(Long userid) {
        this.userid = userid;
    }

    public void setAddeddate(Date addeddate) {
        this.addeddate = addeddate;
    }

    public void setUsecount(Long usecount) {
        this.usecount = usecount;
    }

    public void setQcreplicatesonarray(String qcreplicatesonarray) {
        this.qcreplicatesonarray = qcreplicatesonarray;
    }

    public void setQcreplicatesofslides(String qcreplicatesofslides) {
        this.qcreplicatesofslides = qcreplicatesofslides;
    }

    public void setQcdyeswap(String qcdyeswap) {
        this.qcdyeswap = qcdyeswap;
    }

    public void setQcdescription(String qcdescription) {
        this.qcdescription = qcdescription;
    }

    public void setExperimantannotationVOs(Collection experimentAnnotations) {
        this.experimentannotationVOs = experimentAnnotations;
    }

    public Collection getExperimentannotationVOs() {
        return this.experimentannotationVOs;
    }

    public Collection getHybridizationVOs() {
        return this.hybridizationVOs;
    }

    public Collection getSubExperimentsVOs() {
        return this.subexperimentVOs;
    }

    public void setSubmitterVO(SubmitterVO submitterVO) {
        this.submitterVO = submitterVO;
    }

    public SubmitterVO getSubmitterVO() {
        return this.submitterVO;
    }

    public ExperimentDTO createExperimentDTO() {
        ExperimentDTO experimentDTO = new ExperimentDTO();
        experimentDTO.setDescription(this.getDescr());
        experimentDTO.setId(this.getId());
        experimentDTO.setName(this.getName());
        experimentDTO.setQcdescription(this.getQcdescription());
        experimentDTO.setQcdyeswap(this.getQcdyeswap());
        experimentDTO.setQcreplicatesofslides(this.getQcreplicatesofslides());
        experimentDTO.setQcreplicatesonarray(this.getQcreplicatesonarray());
        experimentDTO.setUserid(this.getUserid());
        Iterator annotationVOsIt = this.getExperimentannotationVOs().iterator();
        Vector<ExperimentannotationDTO> annotationDTOs = new Vector<ExperimentannotationDTO>();
        while (annotationVOsIt.hasNext()) {
            ExperimentannotationVO expAnnotationVO = (ExperimentannotationVO)annotationVOsIt.next();
            ExperimentannotationDTO expAnnotationDTO = expAnnotationVO.createExperimentannotationDTO();
            annotationDTOs.add(expAnnotationDTO);
        }
        experimentDTO.setExperimantannotationDTOs(annotationDTOs);
        if (this.getSubExperimentsVOs() != null) {
            Iterator subExperimentVOs = this.getSubExperimentsVOs().iterator();
            Vector<SubexperimentDTO> subExperimentDTOs = new Vector<SubexperimentDTO>();
            while (subExperimentVOs.hasNext()) {
                SubexperimentVO subExperimentVO = (SubexperimentVO)subExperimentVOs.next();
                SubexperimentDTO subExperimentDTO = subExperimentVO.createSubExperimentDTO();
                subExperimentDTOs.add(subExperimentDTO);
            }
            experimentDTO.setSubExperimentsDTOs(subExperimentDTOs);
        }
        SubmitterDTO submitterDTO = this.getSubmitterVO().createSubmitterDTO();
        experimentDTO.setSubmitterDTO(submitterDTO);
        return experimentDTO;
    }

    public String toString() {
        StringBuffer _ret = new StringBuffer("at.tugraz.genome.marsejb.experiment.vo.ExperimentVO {");
        _ret.append("\n");
        _ret.append("java.lang.Long id=");
        _ret.append(this.id);
        _ret.append(",\n");
        _ret.append("java.lang.String name=");
        _ret.append(this.name);
        _ret.append(",\n");
        _ret.append("java.lang.String descr=");
        _ret.append(this.descr);
        _ret.append(",\n");
        _ret.append("java.lang.Long userid=");
        _ret.append(this.userid);
        _ret.append(",\n");
        _ret.append("java.sql.Date addeddate=");
        _ret.append(this.addeddate);
        _ret.append(",\n");
        _ret.append("java.lang.Long usecount=");
        _ret.append(this.usecount);
        _ret.append(",\n");
        _ret.append("java.lang.String qcreplicatesonarray=");
        _ret.append(this.qcreplicatesonarray);
        _ret.append(",\n");
        _ret.append("java.lang.String qcreplicatesofslides=");
        _ret.append(this.qcreplicatesofslides);
        _ret.append(",\n");
        _ret.append("java.lang.String qcdyeswap=");
        _ret.append(this.qcdyeswap);
        _ret.append(",\n");
        _ret.append("java.lang.String qcdescription=");
        _ret.append(this.qcdescription);
        _ret.append("\n");
        _ret.append("}");
        return _ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ExperimentVO) {
            ExperimentVO obj = (ExperimentVO)o;
            boolean res = true;
            boolean bl = res = this.getId() == obj.getId() || this.getId() != null && obj.getId() != null && this.getId().equals(obj.getId());
            if (res) {
                boolean bl2 = res = this.getName() == obj.getName() || this.getName() != null && obj.getName() != null && this.getName().equals(obj.getName());
                if (res) {
                    boolean bl3 = res = this.getDescr() == obj.getDescr() || this.getDescr() != null && obj.getDescr() != null && this.getDescr().equals(obj.getDescr());
                    if (res) {
                        boolean bl4 = res = this.getUserid() == obj.getUserid() || this.getUserid() != null && obj.getUserid() != null && this.getUserid().equals(obj.getUserid());
                        if (res) {
                            boolean bl5 = res = this.getAddeddate() == obj.getAddeddate() || this.getAddeddate() != null && obj.getAddeddate() != null && this.getAddeddate().equals(obj.getAddeddate());
                            if (res) {
                                boolean bl6 = res = this.getUsecount() == obj.getUsecount() || this.getUsecount() != null && obj.getUsecount() != null && this.getUsecount().equals(obj.getUsecount());
                                if (res) {
                                    boolean bl7 = res = this.getQcreplicatesonarray() == obj.getQcreplicatesonarray() || this.getQcreplicatesonarray() != null && obj.getQcreplicatesonarray() != null && this.getQcreplicatesonarray().equals(obj.getQcreplicatesonarray());
                                    if (res) {
                                        boolean bl8 = res = this.getQcreplicatesofslides() == obj.getQcreplicatesofslides() || this.getQcreplicatesofslides() != null && obj.getQcreplicatesofslides() != null && this.getQcreplicatesofslides().equals(obj.getQcreplicatesofslides());
                                        if (res) {
                                            boolean bl9 = res = this.getQcdyeswap() == obj.getQcdyeswap() || this.getQcdyeswap() != null && obj.getQcdyeswap() != null && this.getQcdyeswap().equals(obj.getQcdyeswap());
                                            if (res) {
                                                boolean bl10 = res = this.getQcdescription() == obj.getQcdescription() || this.getQcdescription() != null && obj.getQcdescription() != null && this.getQcdescription().equals(obj.getQcdescription());
                                                if (!res) {
                                                    // empty if block
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return res;
        }
        return false;
    }
}

