/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.rawbioassaydata.vo;

import at.tugraz.genome.dbutilities.exception.EJBFinderException;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.marsejb.clientconnector.vo.LabeledextractDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.RawbioassayDTO;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.rawbioassaydata.ejb.Rawbioassay;
import at.tugraz.genome.marsejb.rawbioassaydata.vo.ImageacquisitionVO;
import at.tugraz.genome.marsejb.rawbioassaydata.vo.SoftwareVO;
import at.tugraz.genome.marsejb.samplehybridization.vo.LabeledextractVO;
import at.tugraz.genome.marsejb.utils.vo.FileUploadVO;
import at.tugraz.genome.marsejb.utils.vo.SubmitterVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class RawbioassayVO
implements Serializable {
    private Long id;
    private String name;
    private String description;
    private Long userid;
    private SubmitterVO submitterVO;
    private Date addeddate;
    private Date featuredate;
    private String filename;
    private BigDecimal usecount;
    private BigDecimal spots;
    private ImageacquisitionVO imageacquisition;
    private SoftwareVO software;
    private Long uploadID;
    private FileUploadVO uploadVO;
    private Hashtable labeledExtractVOs;
    private String measurementunit;

    public RawbioassayVO(Rawbioassay entity, int level) {
        block11: {
            this.uploadID = null;
            this.uploadVO = null;
            this.labeledExtractVOs = null;
            this.measurementunit = "Micrometer";
            System.out.println("RawbioassayVO(Rawbioassay entity, int level): " + level);
            try {
                this.setId(entity.getId());
                this.setName(entity.getName());
                this.setDescription(entity.getDescription());
                this.setUserid(entity.getUserid());
                this.setAddeddate(entity.getAddeddate());
                this.setFeaturedate(entity.getFeaturedate());
                this.setFilename(entity.getFilename());
                this.setUsecount(entity.getUsecount());
                this.setSpots(entity.getSpots());
                this.setUploadID(entity.getUpload());
                if (entity.getMeasurementunit() != null && entity.getMeasurementunit().length() == 0) {
                    this.setMeasurementunit("Micrometer");
                } else {
                    this.setMeasurementunit(entity.getMeasurementunit());
                }
                if (level <= 0) break block11;
                try {
                    this.labeledExtractVOs = entity.getLabeledExtracts();
                }
                catch (EJBFinderException ex1) {
                    ex1.printStackTrace();
                }
                catch (EJBServerException ex1) {
                    ex1.printStackTrace();
                }
                try {
                    this.setSubmitterVO(entity.getSubmitterVO());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.imageacquisition = new ImageacquisitionVO(entity.getImageacquisition(), level - 1);
                this.software = new SoftwareVO(entity.getSoftware());
                if (entity.getUpload() == null) break block11;
                try {
                    this.uploadVO = entity.getUploadVO();
                }
                catch (Exception ex) {
                    System.out.println(ex);
                }
            }
            catch (ValidationException validationExc) {
                validationExc.printStackTrace();
            }
        }
    }

    public RawbioassayVO(Rawbioassay entity, boolean reantrant, int level) {
        block13: {
            this.uploadID = null;
            this.uploadVO = null;
            this.labeledExtractVOs = null;
            this.measurementunit = "Micrometer";
            System.out.println("RawbioassayVO(Rawbioassay entity, boolean reantrant, int level): " + level);
            try {
                this.setId(entity.getId());
                this.setName(entity.getName());
                this.setDescription(entity.getDescription());
                this.setUserid(entity.getUserid());
                this.setAddeddate(entity.getAddeddate());
                this.setFeaturedate(entity.getFeaturedate());
                this.setFilename(entity.getFilename());
                this.setUsecount(entity.getUsecount());
                this.setSpots(entity.getSpots());
                this.setUploadID(entity.getUpload());
                if (entity.getMeasurementunit() != null && entity.getMeasurementunit().length() == 0) {
                    this.setMeasurementunit("Micrometer");
                } else {
                    this.setMeasurementunit(entity.getMeasurementunit());
                }
                if (level <= 0) break block13;
                try {
                    this.labeledExtractVOs = entity.getLabeledExtracts();
                }
                catch (EJBFinderException ex1) {
                    ex1.printStackTrace();
                }
                catch (EJBServerException ex1) {
                    ex1.printStackTrace();
                }
                try {
                    this.setSubmitterVO(entity.getSubmitterVO());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!reantrant) {
                    this.imageacquisition = new ImageacquisitionVO(entity.getImageacquisition(), level - 1);
                }
                this.software = new SoftwareVO(entity.getSoftware());
                if (entity.getUpload() == null) break block13;
                try {
                    this.uploadVO = entity.getUploadVO();
                }
                catch (EJBFinderException ex) {
                    System.out.println(ex);
                }
                catch (EJBServerException ex) {
                    System.out.println(ex);
                }
            }
            catch (ValidationException validationExc) {
                validationExc.printStackTrace();
            }
        }
    }

    public RawbioassayVO(String name, String description, Long userID, Date addedDate, Date featureDate, String fileName, BigDecimal useCount, BigDecimal spots, ImageacquisitionVO imageAcquisitionVO, SoftwareVO softwareVO, FileUploadVO uploadVO, String measurementunit) throws ValidationException {
        this.uploadID = null;
        this.uploadVO = null;
        this.labeledExtractVOs = null;
        this.measurementunit = "Micrometer";
        this.setName(name);
        this.setDescription(description);
        this.setUserid(userID);
        this.setAddeddate(addedDate);
        this.setFeaturedate(featureDate);
        this.setFilename(fileName);
        this.setUsecount(useCount);
        this.setSpots(spots);
        this.setImageacquisition(imageAcquisitionVO);
        this.setSoftware(softwareVO);
        this.setUploadVO(uploadVO);
        this.setMeasurementunit(measurementunit);
    }

    public Hashtable getLabeledExtractVOs() {
        return this.labeledExtractVOs;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public SubmitterVO getSubmitterVO() {
        return this.submitterVO;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getUserid() {
        return this.userid;
    }

    public Date getAddeddate() {
        return this.addeddate;
    }

    public Date getFeaturedate() {
        return this.featuredate;
    }

    public String getFilename() {
        return this.filename;
    }

    public BigDecimal getUsecount() {
        return this.usecount;
    }

    public BigDecimal getSpots() {
        return this.spots;
    }

    public ImageacquisitionVO getImageacquisition() {
        return this.imageacquisition;
    }

    public SoftwareVO getSoftware() {
        return this.software;
    }

    public void setId(Long id) throws ValidationException {
        if (id == null) {
            throw new ValidationException("id in RawbioassayVO is NULL", this.getClass());
        }
        if (this.id != null) {
            throw new ValidationException("id in RawbioassayVO was already set", this.getClass());
        }
        this.id = id;
    }

    public void setName(String name) throws ValidationException {
        if (name == null) {
            throw new ValidationException("name in RawbioassayVO is NULL", this.getClass());
        }
        if (name.trim().length() < 1) {
            throw new ValidationException("name in RawbioassayVO must have more than 0 characters", this.getClass());
        }
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUserid(Long userid) throws ValidationException {
        if (userid == null) {
            throw new ValidationException("userid in RawbioassayVO is NULL", this.getClass());
        }
        this.userid = userid;
    }

    public void setAddeddate(Date addeddate) throws ValidationException {
        if (addeddate == null) {
            throw new ValidationException("addeddate in RawbioassayVO is NULL", this.getClass());
        }
        this.addeddate = addeddate;
    }

    public void setSubmitterVO(SubmitterVO submitterVO) {
        this.submitterVO = submitterVO;
    }

    public void setFeaturedate(Date featuredate) throws ValidationException {
        if (featuredate == null) {
            throw new ValidationException("featuredate in RawbioassayVO is NULL", this.getClass());
        }
        this.featuredate = featuredate;
    }

    public void setFilename(String filename) throws ValidationException {
        if (filename == null) {
            throw new ValidationException("filename in RawbioassayVO is NULL", this.getClass());
        }
        if (filename.trim().length() < 1) {
            throw new ValidationException("filename in RawbioassayVO must have more than 0 characters", this.getClass());
        }
        this.filename = filename;
    }

    public void setUsecount(BigDecimal usecount) throws ValidationException {
        if (usecount == null) {
            throw new ValidationException("usecount in RawbioassayVO is NULL", this.getClass());
        }
        this.usecount = usecount;
    }

    public void setSpots(BigDecimal spots) throws ValidationException {
        if (spots == null) {
            throw new ValidationException("spots in RawbioassayVO is NULL", this.getClass());
        }
        this.spots = spots;
    }

    public void setImageacquisition(ImageacquisitionVO imageacquisition) {
        this.imageacquisition = imageacquisition;
    }

    public void setSoftware(SoftwareVO software) {
        this.software = software;
    }

    public void setUploadID(Long uploadID) {
        this.uploadID = uploadID;
    }

    public Long getUploadID() {
        return this.uploadID;
    }

    public void setUploadVO(FileUploadVO uploadVO) {
        this.uploadVO = uploadVO;
        if (uploadVO != null) {
            this.uploadID = uploadVO.getId();
        }
    }

    public FileUploadVO getUploadVO() {
        return this.uploadVO;
    }

    public RawbioassayDTO createRawbioassayDTO() {
        RawbioassayDTO rawBioassayDTO = new RawbioassayDTO();
        rawBioassayDTO.setAddeddate(this.getAddeddate().toString());
        rawBioassayDTO.setDescription(this.getDescription());
        rawBioassayDTO.setId(this.getId());
        rawBioassayDTO.setName(this.getName());
        if (this.getImageacquisition() != null) {
            rawBioassayDTO.setImageacquisitionName(this.getImageacquisition().getName());
        }
        if (this.getSoftware() != null) {
            rawBioassayDTO.setSoftwareName(this.getSoftware().getName());
        }
        if (this.labeledExtractVOs != null) {
            Enumeration enumeration = this.labeledExtractVOs.keys();
            Hashtable dtoHash = new Hashtable();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                LabeledextractVO labeledExtractVO = (LabeledextractVO)this.labeledExtractVOs.get(key);
                LabeledextractDTO labeledExtractDTO = labeledExtractVO.createLabeledextractDTO();
                dtoHash.put(key, labeledExtractDTO);
            }
            rawBioassayDTO.setLabeledExtracts(dtoHash);
        }
        return rawBioassayDTO;
    }

    public String toString() {
        StringBuffer _ret = new StringBuffer();
        _ret.append("at.tugraz.genome.marsejb.rawbioassaydata.vo.RawbioassayVO {");
        _ret.append("\n");
        _ret.append("java.lang.Long id = ");
        _ret.append(this.id);
        _ret.append("\n");
        _ret.append("java.lang.String name = ");
        _ret.append(this.name);
        _ret.append("\n");
        _ret.append("java.lang.String description = ");
        _ret.append(this.description);
        _ret.append("\n");
        _ret.append("java.lang.Long userid = ");
        _ret.append(this.userid);
        _ret.append("\n");
        _ret.append("java.sql.Date addeddate = ");
        _ret.append(this.addeddate);
        _ret.append("\n");
        _ret.append("java.sql.Date featuredate = ");
        _ret.append(this.featuredate);
        _ret.append("\n");
        _ret.append("java.lang.String filename = ");
        _ret.append(this.filename);
        _ret.append("\n");
        _ret.append("java.math.BigDecimal usecount = ");
        _ret.append(this.usecount);
        _ret.append("\n");
        _ret.append("java.math.BigDecimal spots = ");
        _ret.append(this.spots);
        _ret.append("\n");
        _ret.append("at.tugraz.genome.marsejb.rawbioassaydata.ejb.Imageacquisition imageacquisition = ");
        _ret.append(this.imageacquisition);
        _ret.append("\n");
        _ret.append("at.tugraz.genome.marsejb.rawbioassaydata.ejb.Software software = ");
        _ret.append(this.software);
        _ret.append("\n");
        _ret.append("}");
        return _ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof RawbioassayVO) {
            RawbioassayVO obj = (RawbioassayVO)o;
            boolean res = true;
            boolean bl = res = this.id == obj.getId() || this.id != null && obj.getId() != null && this.id.equals(obj.getId());
            if (res) {
                boolean bl2 = res = this.name == obj.getName() || this.name != null && obj.getName() != null && this.name.equals(obj.getName());
                if (res) {
                    boolean bl3 = res = this.description == obj.getDescription() || this.description != null && obj.getDescription() != null && this.description.equals(obj.getDescription());
                    if (res) {
                        boolean bl4 = res = this.userid == obj.getUserid() || this.userid != null && obj.getUserid() != null && this.userid.equals(obj.getUserid());
                        if (res) {
                            boolean bl5 = res = this.addeddate == obj.getAddeddate() || this.addeddate != null && obj.getAddeddate() != null && this.addeddate.equals(obj.getAddeddate());
                            if (res) {
                                boolean bl6 = res = this.featuredate == obj.getFeaturedate() || this.featuredate != null && obj.getFeaturedate() != null && this.featuredate.equals(obj.getFeaturedate());
                                if (res) {
                                    boolean bl7 = res = this.filename == obj.getFilename() || this.filename != null && obj.getFilename() != null && this.filename.equals(obj.getFilename());
                                    if (res) {
                                        boolean bl8 = res = this.usecount == obj.getUsecount() || this.usecount != null && obj.getUsecount() != null && this.usecount.equals(obj.getUsecount());
                                        if (res) {
                                            boolean bl9 = res = this.spots == obj.getSpots() || this.spots != null && obj.getSpots() != null && this.spots.equals(obj.getSpots());
                                            if (res) {
                                                boolean bl10 = res = this.imageacquisition == obj.getImageacquisition() || this.imageacquisition != null && obj.getImageacquisition() != null && this.imageacquisition.equals(obj.getImageacquisition());
                                                if (res) {
                                                    boolean bl11 = res = this.software == obj.getSoftware() || this.software != null && obj.getSoftware() != null && this.software.equals(obj.getSoftware());
                                                    if (!res) {
                                                        // empty if block
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return res;
        }
        return false;
    }

    public int hashCode() {
        return (this.name + this.addeddate.toString()).hashCode();
    }

    public void setMeasurementunit(String unit) {
        this.measurementunit = unit;
    }

    public String getMeasurementunit() {
        return this.measurementunit;
    }
}

