/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.rawbioassaydata.vo;

import at.tugraz.genome.dbutilities.exception.EJBFinderException;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.rawbioassaydata.ejb.Software;
import at.tugraz.genome.marsejb.utils.vo.SubmitterVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;

public class SoftwareVO
implements Serializable {
    private Long id;
    private String name;
    private String description;
    private Long userid;
    private Date addeddate;
    private String version;
    private Boolean shown;
    private BigDecimal usecount;
    private SubmitterVO submitterVO;

    public SoftwareVO(Software entity) {
        try {
            this.setId(entity.getId());
            this.setName(entity.getName());
            this.setDescription(entity.getDescription());
            this.setUserid(entity.getUserid());
            this.setAddeddate(entity.getAddeddate());
            this.setVersion(entity.getVersion());
            this.setShown(new Boolean(entity.getShown().toString()));
            this.setUsecount(entity.getUsecount());
            if (entity.getUserid() != null) {
                this.submitterVO = entity.getSubmitterVO();
            }
        }
        catch (ValidationException validationExc) {
            validationExc.printStackTrace();
        }
        catch (EJBFinderException ejbFinderExc) {
            ejbFinderExc.printStackTrace();
        }
        catch (EJBServerException ejbServerExc) {
            ejbServerExc.printStackTrace();
        }
    }

    public SoftwareVO(String name, String description, Long userID, Date addedDate, String version, Boolean shown, BigDecimal useCount) throws ValidationException {
        this.setName(name);
        this.setDescription(description);
        this.setUserid(userID);
        this.setAddeddate(addedDate);
        this.setVersion(version);
        this.setShown(shown);
        this.setUsecount(useCount);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getUserid() {
        return this.userid;
    }

    public Date getAddeddate() {
        return this.addeddate;
    }

    public String getVersion() {
        return this.version;
    }

    public Boolean getShown() {
        return this.shown;
    }

    public BigDecimal getUsecount() {
        return this.usecount;
    }

    public SubmitterVO getSubmitterVO() {
        return this.submitterVO;
    }

    public void setId(Long id) throws ValidationException {
        if (id == null) {
            throw new ValidationException("id in SoftwareVO is NULL", this.getClass());
        }
        if (this.id != null) {
            throw new ValidationException("id in SoftwareVO was already set", this.getClass());
        }
        this.id = id;
    }

    public void setName(String name) throws ValidationException {
        if (name == null) {
            throw new ValidationException("name in SoftwareVO is NULL", this.getClass());
        }
        if (name.trim().length() < 1) {
            throw new ValidationException("name in SoftwareVO must have more than 0 characters", this.getClass());
        }
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUserid(Long userid) throws ValidationException {
        if (userid == null) {
            throw new ValidationException("userid in SoftwareVO is NULL", this.getClass());
        }
        this.userid = userid;
    }

    public void setAddeddate(Date addeddate) throws ValidationException {
        if (addeddate == null) {
            throw new ValidationException("addeddate in SoftwareVO is NULL", this.getClass());
        }
        this.addeddate = addeddate;
    }

    public void setVersion(String version) throws ValidationException {
        if (version == null) {
            throw new ValidationException("version in SoftwareVO is NULL", this.getClass());
        }
        if (version.trim().length() < 1) {
            throw new ValidationException("version in SoftwareVO must have more than 0 characters", this.getClass());
        }
        this.version = version;
    }

    public void setShown(Boolean shown) throws ValidationException {
        if (shown == null) {
            throw new ValidationException("shown in SoftwareVO is NULL", this.getClass());
        }
        this.shown = shown;
    }

    public void setUsecount(BigDecimal usecount) throws ValidationException {
        if (usecount == null) {
            throw new ValidationException("usecount in SoftwareVO is NULL", this.getClass());
        }
        this.usecount = usecount;
    }

    public String toString() {
        StringBuffer _ret = new StringBuffer();
        _ret.append("at.tugraz.genome.marsejb.rawbioassaydata.vo.SoftwareVO {");
        _ret.append("\n");
        _ret.append("java.lang.Long id = ");
        _ret.append(this.id);
        _ret.append("\n");
        _ret.append("java.lang.String name = ");
        _ret.append(this.name);
        _ret.append("\n");
        _ret.append("java.lang.String description = ");
        _ret.append(this.description);
        _ret.append("\n");
        _ret.append("java.lang.Long userid = ");
        _ret.append(this.userid);
        _ret.append("\n");
        _ret.append("java.sql.Date addeddate = ");
        _ret.append(this.addeddate);
        _ret.append("\n");
        _ret.append("java.lang.String version = ");
        _ret.append(this.version);
        _ret.append("\n");
        _ret.append("java.lang.String shown = ");
        _ret.append(this.shown);
        _ret.append("\n");
        _ret.append("java.math.BigDecimal usecount = ");
        _ret.append(this.usecount);
        _ret.append("\n");
        _ret.append("}");
        return _ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof SoftwareVO) {
            SoftwareVO obj = (SoftwareVO)o;
            boolean res = true;
            boolean bl = res = this.id == obj.getId() || this.id != null && obj.getId() != null && this.id.equals(obj.getId());
            if (res) {
                boolean bl2 = res = this.name == obj.getName() || this.name != null && obj.getName() != null && this.name.equals(obj.getName());
                if (res) {
                    boolean bl3 = res = this.description == obj.getDescription() || this.description != null && obj.getDescription() != null && this.description.equals(obj.getDescription());
                    if (res) {
                        boolean bl4 = res = this.userid == obj.getUserid() || this.userid != null && obj.getUserid() != null && this.userid.equals(obj.getUserid());
                        if (res) {
                            boolean bl5 = res = this.addeddate == obj.getAddeddate() || this.addeddate != null && obj.getAddeddate() != null && this.addeddate.equals(obj.getAddeddate());
                            if (res) {
                                boolean bl6 = res = this.version == obj.getVersion() || this.version != null && obj.getVersion() != null && this.version.equals(obj.getVersion());
                                if (res) {
                                    boolean bl7 = res = this.shown == obj.getShown() || this.shown != null && obj.getShown() != null && this.shown.equals(obj.getShown());
                                    if (res) {
                                        boolean bl8 = res = this.usecount == obj.getUsecount() || this.usecount != null && obj.getUsecount() != null && this.usecount.equals(obj.getUsecount());
                                        if (!res) {
                                            // empty if block
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return res;
        }
        return false;
    }
}

