/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.math;

import at.tugraz.genome.math.ArrayOp;
import at.tugraz.genome.math.SimpleMatrix;

public abstract class Function {
    private double chi_squared_;
    private double correlation_of_determination_;
    private int degrees_of_freedom_ = 1;
    private int iterations_ = 0;
    private double[] m_x_ = null;
    private double[] m_y_ = null;
    private double[] oos2_ = null;
    private String[] parameter_names_ = null;
    private double[] parameters_ = null;
    private double[] sigma_ = null;

    private double Alpha(double[] parm, double[] weight, int k, int l) {
        double sum = 0.0;
        int i = 0;
        while (i < this.m_x_.length) {
            double f = this.getValue(parm, this.m_x_[i]);
            double dk = this.getGradient(parm, k, this.m_x_[i]);
            double dl = this.getGradient(parm, l, this.m_x_[i]);
            double dkl = this.getHessian(parm, k, l, this.m_x_[i]);
            sum += weight[i] * (dk * dl - (this.m_y_[i] - f) * dkl);
            ++i;
        }
        return sum;
    }

    private double AlphaPrime(double[] parm, double[] weight, int pk, int pl, double lambda) {
        double alpha_prime = this.Alpha(parm, weight, pk, pl);
        if (pk == pl) {
            alpha_prime *= 1.0 + lambda;
        }
        return alpha_prime;
    }

    private double Beta(double[] parm, double[] weight, int k) {
        double sum = 0.0;
        int i = 0;
        while (i < this.m_x_.length) {
            double f = this.getValue(parm, this.m_x_[i]);
            double dk = this.getGradient(parm, k, this.m_x_[i]);
            sum += weight[i] * (this.m_y_[i] - f) * dk;
            ++i;
        }
        return sum;
    }

    private double calcCorrelationOfDetermination(double[] params, double[] oos2) {
        double sum_y = 0.0;
        double sum_w = 0.0;
        int i = 0;
        while (i < this.m_x_.length) {
            sum_y += this.getValue(params, this.m_x_[i]) * oos2[i];
            sum_w += oos2[i];
            ++i;
        }
        sum_y /= sum_w;
        double sum_var = 0.0;
        int i2 = 0;
        while (i2 < this.m_x_.length) {
            sum_var += (this.m_y_[i2] - sum_y) * (this.m_y_[i2] - sum_y) * oos2[i2];
            ++i2;
        }
        this.correlation_of_determination_ = 1.0 - this.chi_squared_ / sum_var;
        return this.correlation_of_determination_;
    }

    protected double calculateXAtY50(double[] x, double[] y) {
        int last_index = y.length - 1;
        double y50 = (ArrayOp.min(y) + ArrayOp.max(y)) / 2.0;
        int index_2 = 0;
        int index_1 = 0;
        index_2 = ArrayOp.getIndexOfClosestBigger(y, y50);
        index_1 = ArrayOp.getIndexOfClosestSmaller(y, y50);
        double k = (y[index_2] - y[index_1]) / (x[index_2] - x[index_1]);
        double d = y[index_2] - k * x[index_2];
        double x_at_y50 = (y50 - d) / k;
        return x_at_y50;
    }

    private double chiSquared(double[] parm, double[] sigma) {
        double sum = 0.0;
        int i = 0;
        while (i < this.m_x_.length) {
            double residual = (this.m_y_[i] - this.getValue(parm, this.m_x_[i])) / sigma[i];
            sum += residual * residual;
            ++i;
        }
        return sum;
    }

    public double[] fit(double[] xs1, double[] ys1, double[] sigma1, double tolerance) {
        int i;
        boolean debug = false;
        int NumberParms = this.getNumberOfParameters();
        if (xs1 == null || ys1 == null) {
            throw new IllegalArgumentException("X & y arrays must not be null");
        }
        if (xs1.length != ys1.length) {
            throw new IllegalArgumentException("Number of values in x & y arrays do not match");
        }
        if (sigma1 != null && xs1.length != sigma1.length) {
            throw new IllegalArgumentException("Number of values in x & sigma arrays do not match");
        }
        if (xs1.length < NumberParms) {
            throw new IllegalArgumentException("Insufficient number of data points for fit");
        }
        int len_1 = xs1.length;
        int len_2 = 0;
        double[] dummy1 = new double[len_1];
        double[] dummy2 = new double[len_1];
        double[] dummy3 = new double[len_1];
        if (sigma1 == null) {
            sigma1 = new double[len_1];
            i = 0;
            while (i < len_1) {
                sigma1[i] = 1.0;
                ++i;
            }
        }
        i = 0;
        while (i < len_1) {
            double val1 = xs1[i];
            double val2 = ys1[i];
            double val3 = sigma1[i];
            if (!(Double.isNaN(val1) || Double.isNaN(val2) || Double.isNaN(val3))) {
                dummy1[len_2] = val1;
                dummy2[len_2] = val2;
                dummy3[len_2] = val3;
                ++len_2;
            }
            ++i;
        }
        if (len_2 < len_1) {
            System.out.println("Attention, there are some NaNs in your dataset!");
        }
        double[] xs = new double[len_2];
        double[] ys = new double[len_2];
        double[] sigma = new double[len_2];
        int i2 = 0;
        while (i2 < len_2) {
            xs[i2] = dummy1[i2];
            ys[i2] = dummy2[i2];
            sigma[i2] = dummy3[i2];
            ++i2;
        }
        this.m_x_ = xs;
        this.m_y_ = ys;
        this.sigma_ = sigma;
        this.oos2_ = new double[this.sigma_.length];
        int i3 = 0;
        while (i3 < this.sigma_.length) {
            this.oos2_[i3] = 1.0 / (this.sigma_[i3] * this.sigma_[i3]);
            ++i3;
        }
        this.degrees_of_freedom_ = Math.max(1, this.m_x_.length - NumberParms);
        double[] fitted_params = new double[NumberParms];
        double[] newparm = new double[NumberParms];
        double[] parm = this.getStartParameters(this.m_x_, this.m_y_);
        double lambda = 0.001;
        double factor = 10.0;
        factor = 5.0;
        double SS = this.chiSquared(parm, this.sigma_);
        double newSS = 0.0;
        double[][] alpha = new double[NumberParms][NumberParms];
        double[][] beta = new double[NumberParms][1];
        this.iterations_ = 0;
        while (Math.abs(SS - newSS) > tolerance) {
            ++this.iterations_;
            if (debug) {
                System.out.println("SS: " + SS + "  newSS: " + newSS + "  SS-newSS: " + (SS - newSS) + "   lambda: " + lambda);
            }
            int i4 = 0;
            while (i4 < NumberParms) {
                int j = 0;
                while (j < NumberParms) {
                    alpha[i4][j] = this.AlphaPrime(parm, this.oos2_, i4, j, lambda);
                    ++j;
                }
                beta[i4][0] = this.Beta(parm, this.oos2_, i4);
                ++i4;
            }
            if (debug) {
                SimpleMatrix.print(alpha, 15);
                SimpleMatrix.print(beta, 15);
            }
            double[][] result = SimpleMatrix.solve(alpha, beta);
            int i5 = 0;
            while (i5 < NumberParms) {
                newparm[i5] = parm[i5] + result[i5][0];
                ++i5;
            }
            if (debug) {
                ArrayOp.dumpArray("parm:    ", parm, 15, 6);
                ArrayOp.dumpArray("newparm: ", newparm, 15, 6);
            }
            SS = this.chiSquared(parm, this.sigma_);
            newSS = this.chiSquared(newparm, this.sigma_);
            if (debug) {
                System.out.println("SS: " + SS + "  newSS: " + newSS + "  SS-newSS: " + (SS - newSS));
            }
            if (newSS >= SS) {
                lambda *= factor;
                continue;
            }
            lambda /= factor;
            ArrayOp.ArrayCopy(parm, newparm);
        }
        ArrayOp.ArrayCopy(fitted_params, parm);
        this.chi_squared_ = newSS;
        this.calcCorrelationOfDetermination(fitted_params, this.oos2_);
        if (debug) {
            double[] chisquare = new double[]{this.getChiSquare(), this.getChiSquareReduced()};
            ArrayOp.dumpArray("chi2: ", chisquare, 15, 6);
            System.out.println("Iterations: " + this.iterations_);
            int i6 = 0;
            while (i6 < NumberParms) {
                int j = 0;
                while (j < NumberParms) {
                    alpha[i6][j] = this.AlphaPrime(fitted_params, this.oos2_, i6, j, 0.0);
                    ++j;
                }
                ++i6;
            }
            double[][] c = SimpleMatrix.invert(alpha);
            SimpleMatrix.print(c, 15);
            double[][] r = new double[NumberParms][NumberParms + 3];
            int i7 = 0;
            while (i7 < NumberParms) {
                int j = 0;
                while (j < NumberParms) {
                    r[i7][j] = Math.pow(c[i7][j] / Math.sqrt(c[i7][i7] * c[j][j]), 1.0);
                    ++j;
                }
                r[i7][NumberParms] = fitted_params[i7];
                r[i7][NumberParms + 1] = Math.sqrt(c[i7][i7] * chisquare[1]);
                r[i7][NumberParms + 2] = 1.0 - 1.0 / Math.sqrt(c[i7][i7] * c[i7][i7]);
                ++i7;
            }
            SimpleMatrix.print(r, 15);
            System.out.flush();
        }
        return fitted_params;
    }

    public double getChiSquare() {
        return this.chi_squared_;
    }

    public double getChiSquareReduced() {
        return this.chi_squared_ / (double)this.degrees_of_freedom_;
    }

    public double getCorrelationCoefficient() {
        return Math.sqrt(this.getCorrelationOfDetermination());
    }

    public double getCorrelationOfDetermination() {
        return this.correlation_of_determination_;
    }

    public abstract String getFunctionDefinition();

    public abstract String getFunctionName();

    abstract double getGradient(double[] var1, int var2, double var3);

    abstract double getHessian(double[] var1, int var2, int var3, double var4);

    public int getIterations() {
        return this.iterations_;
    }

    public abstract int getNumberOfParameters();

    public double getParameter(int index) {
        return this.parameters_[index];
    }

    public String getParameterName(int index) {
        return this.parameter_names_[index];
    }

    public double[] getParameters() {
        return this.parameters_;
    }

    public double getRMS() {
        return Math.sqrt(this.getChiSquareReduced());
    }

    abstract double[] getStartParameters(double[] var1, double[] var2);

    public double getValue(double x) {
        return this.getValue(this.getParameters(), x);
    }

    public abstract double getValue(double[] var1, double var2);

    public double getXValue(double y) {
        return this.getXValue(this.getParameters(), y);
    }

    public abstract double getXValue(double[] var1, double var2);

    public void setParameter(int index, double new_value) {
        this.parameters_[index] = new_value;
        this.chi_squared_ = this.chiSquared(this.parameters_, this.sigma_);
        this.calcCorrelationOfDetermination(this.parameters_, this.oos2_);
    }

    protected void setParameterNames(String[] names) {
        this.parameter_names_ = names;
    }

    public void setParameters(double[] new_params) {
        if (new_params.length != this.getNumberOfParameters()) {
            throw new IllegalArgumentException("Error in number of parameters supplied: " + new_params.length + " - required: " + this.getNumberOfParameters());
        }
        this.parameters_ = new_params;
        this.chi_squared_ = this.chiSquared(this.parameters_, this.sigma_);
        this.calcCorrelationOfDetermination(this.parameters_, this.oos2_);
    }
}

