/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.math;

import at.tugraz.genome.math.ArrayOp;
import at.tugraz.genome.math.Function;

public class HillFunction
extends Function {
    public HillFunction() {
        this.setParameterNames(new String[]{"smax", "k", "n", "smin"});
    }

    public String getFunctionDefinition() {
        return "y = smax * x^n / (k^n + x^n) + smin";
    }

    public String getFunctionName() {
        return "Hill";
    }

    double getGradient(double[] parm, int pk, double x) {
        double xn;
        double gradient = 0.0;
        if (x <= 0.0) {
            x = Double.MIN_VALUE;
        }
        if (Double.isInfinite(xn = Math.pow(x, parm[2])) || xn > 3.4028234663852886E38) {
            xn = 3.4028234663852886E38;
        }
        double kn = Math.pow(parm[1], parm[2]);
        double quot = kn + xn;
        switch (pk) {
            case 0: {
                gradient = xn / quot;
                break;
            }
            case 1: {
                gradient = -parm[0] * xn * kn * parm[2] / (quot * quot * parm[1]);
                break;
            }
            case 2: {
                double lnx = Math.log(x);
                double lnk = Math.log(parm[1]);
                gradient = parm[0] * xn * lnx / quot - parm[0] * xn * (kn * lnk + xn * lnx) / (quot * quot);
                break;
            }
            case 3: {
                gradient = 1.0;
                break;
            }
            default: {
                System.err.println("HillFunction.getGradient: Hit default case in parameter switch");
            }
        }
        return gradient;
    }

    double getHessian(double[] parm, int pk, int l, double x) {
        double xn;
        double hessian = 0.0;
        if (x <= 0.0) {
            x = Double.MIN_VALUE;
        }
        if (Double.isInfinite(xn = Math.pow(x, parm[2])) || xn > 3.4028234663852886E38) {
            xn = 3.4028234663852886E38;
        }
        double kn = Math.pow(parm[1], parm[2]);
        double quot = kn + xn;
        double lnx = Math.log(x);
        double lnk = Math.log(parm[1]);
        block0 : switch (pk) {
            case 0: {
                switch (l) {
                    case 0: {
                        hessian = 0.0;
                        break;
                    }
                    case 1: {
                        hessian = -xn * kn * parm[2] / (quot * quot * parm[1]);
                        break;
                    }
                    case 2: {
                        hessian = xn * lnx / quot - xn * (kn * lnk + xn * lnx) / (quot * quot);
                    }
                }
                break;
            }
            case 1: {
                switch (l) {
                    case 0: {
                        hessian = -xn * kn * parm[2] / (quot * quot * parm[1]);
                        break;
                    }
                    case 1: {
                        double quotk2 = quot * parm[1] * (quot * parm[1]);
                        double smax_xn_kn_n = parm[0] * xn * kn * parm[2];
                        hessian = 2.0 * smax_xn_kn_n * kn * parm[2] / (quotk2 * quot) - smax_xn_kn_n * parm[2] / quotk2 + smax_xn_kn_n / quotk2;
                        break;
                    }
                    case 2: {
                        double quot2 = quot * quot;
                        double smax_xn = parm[0] * xn;
                        hessian = -smax_xn * lnx * kn * parm[2] / (quot2 * parm[1]) + 2.0 * smax_xn * (kn * lnk + xn * lnx) * kn * parm[2] / (quot2 * quot * parm[1]) + smax_xn * ((kn * parm[2] * lnk + kn) / parm[1]) / quot2;
                    }
                }
                break;
            }
            case 2: {
                switch (l) {
                    case 0: {
                        hessian = xn * lnx / quot - xn * (kn * lnk + xn * lnx) / (quot * quot);
                        break block0;
                    }
                    case 1: {
                        double quot2k = quot * quot * parm[1];
                        double smax_xn_kn = parm[0] * xn * kn;
                        hessian = -smax_xn_kn * lnx * parm[2] / quot2k + 2.0 * smax_xn_kn * (kn * lnk + xn * lnx) * parm[2] / (quot2k * quot) - smax_xn_kn * lnk * parm[2] / quot2k - smax_xn_kn / quot2k;
                        break block0;
                    }
                    case 2: {
                        double quot2 = quot * quot;
                        double smax_xn = parm[0] * xn;
                        hessian = smax_xn * lnx * lnx / quot - 2.0 * smax_xn * lnx * (kn * lnk + xn * lnx) / quot2 + 2.0 * smax_xn * Math.pow(kn * lnk + xn * lnx, 2.0) / (quot2 * quot) - smax_xn * (kn * lnk * lnk + xn * lnx * lnx) / quot2;
                    }
                }
            }
        }
        return hessian;
    }

    public int getNumberOfParameters() {
        return 4;
    }

    double[] getStartParameters(double[] x, double[] y) {
        double[] start_values = new double[this.getNumberOfParameters()];
        start_values[0] = ArrayOp.max(y);
        double k = this.calculateXAtY50(x, y);
        double xmax = ArrayOp.max(x);
        double xmin = ArrayOp.max(x);
        if (k < 0.0 || k > xmax) {
            k = (xmax + xmin) / 2.0;
        }
        start_values[1] = k;
        start_values[2] = y[ArrayOp.minpos(x)] <= y[ArrayOp.maxpos(x)] ? 1.0 : -1.0;
        start_values[3] = ArrayOp.min(y);
        return start_values;
    }

    public double getValue(double[] param, double x) {
        double y = 0.0;
        if (x <= 0.0) {
            x = Double.MIN_VALUE;
        }
        double n = param[2] <= 0.0 ? Double.MIN_VALUE : param[2];
        n = param[2];
        double xn = Math.pow(x, n);
        if (Double.isInfinite(xn) || xn > 3.4028234663852886E38) {
            xn = 3.4028234663852886E38;
        }
        double kn = Math.pow(param[1], n);
        if (param[1] < 0.0) {
            kn = Double.MIN_VALUE;
        }
        y = param[0] * xn / (kn + xn) + param[3];
        return y;
    }

    public double getXValue(double[] param, double y) {
        double xn = (y - param[3]) * Math.pow(param[1], param[2]) / (param[3] + param[0] - y);
        double x_val = Double.NaN;
        if (xn >= 0.0) {
            x_val = Math.pow(xn, 1.0 / param[2]);
        }
        return x_val;
    }
}

