/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.math;

import java.util.Arrays;

public class Statistics {
    static Object[] clowess(double[] x, double[] y, int n, double f, int nsteps, double delta) {
        boolean ok = false;
        double[] ys = new double[x.length];
        double[] rw = new double[x.length];
        double[] res = new double[x.length];
        int z = 0;
        while (z < x.length) {
            ys[z] = 0.0;
            rw[z] = 0.0;
            res[z] = 0.0;
            ++z;
        }
        if (n < 2) {
            ys[0] = y[0];
            return new Object[]{ys, rw, res};
        }
        int ns = Math.max(2, Math.min(n, (int)(f * (double)n + 1.0E-7))) - 1;
        int iter = 1;
        while (iter <= nsteps + 1) {
            double cmad;
            int nleft = 0;
            int nright = ns;
            int last = -1;
            int i = 0;
            while (true) {
                double d2;
                double d1;
                if (nright < n - 1 && (d1 = x[i] - x[nleft]) > (d2 = x[nright + 1] - x[i])) {
                    ++nleft;
                    ++nright;
                    continue;
                }
                Object[] dummyResult = Statistics.lowest(x, y, n, x[i], nleft, nright, res, iter > 1, rw);
                ys[i] = (Double)dummyResult[0];
                res = (double[])dummyResult[1];
                ok = (Boolean)dummyResult[2];
                if (!ok) {
                    ys[i] = y[i];
                }
                if (last < i - 1) {
                    double denom = x[i] - x[last];
                    int j = last + 1;
                    while (j < i) {
                        double alpha = (x[j] - x[last]) / denom;
                        ys[j] = alpha * ys[i] + (1.0 - alpha) * ys[last];
                        ++j;
                    }
                }
                last = i;
                double cut = x[last] + delta;
                i = last + 1;
                while (i <= n - 1) {
                    if (x[i] > cut) break;
                    if (x[i] == x[last]) {
                        ys[i] = ys[last];
                        last = i;
                    }
                    ++i;
                }
                i = Math.max(last + 1, i - 1);
                if (last >= n - 1) break;
            }
            i = 0;
            while (i < n) {
                res[i] = y[i] - ys[i];
                ++i;
            }
            if (iter > nsteps) break;
            i = 0;
            while (i < n) {
                rw[i] = Math.abs(res[i]);
                ++i;
            }
            int m1 = n / 2;
            Arrays.sort(rw, 0, n);
            if (n % 2 == 0) {
                int m2 = n - m1 - 1;
                cmad = 3.0 * (rw[m1] + rw[m2]);
            } else {
                cmad = 6.0 * rw[m1];
            }
            double c9 = 0.999 * cmad;
            double c1 = 0.001 * cmad;
            i = 0;
            while (i < n) {
                double r = Math.abs(res[i]);
                rw[i] = r <= c1 ? 1.0 : (r <= c9 ? Statistics.fsquare(1.0 - Statistics.fsquare(r / cmad)) : 0.0);
                ++i;
            }
            ++iter;
        }
        return new Object[]{ys, rw, res};
    }

    static double fcube(double x) {
        return x * x * x;
    }

    static double fsquare(double x) {
        return x * x;
    }

    public static Object[] lowess(double[] x, double[] y, int n, double f, int nsteps, double delta) {
        return Statistics.clowess(x, y, n, f, nsteps, delta);
    }

    static Object[] lowest(double[] x, double[] y, int n, double xs, int nleft, int nright, double[] w, boolean userw, double[] rw) {
        double ys = 0.0;
        boolean ok = false;
        double range = x[n - 1] - x[0];
        double h = Math.max(xs - x[nleft], x[nright] - xs);
        double h9 = 0.999 * h;
        double h1 = 0.001 * h;
        double a = 0.0;
        int j = nleft;
        while (j <= n - 1) {
            w[j] = 0.0;
            double r = Math.abs(x[j] - xs);
            if (r <= h9) {
                w[j] = r <= h1 ? 1.0 : Statistics.fcube(1.0 - Statistics.fcube(r / h));
                if (userw) {
                    int n2 = j;
                    w[n2] = w[n2] * rw[j];
                }
                a += w[j];
            } else if (x[j] > xs) break;
            ++j;
        }
        int nrt = j - 1;
        if (a <= 0.0) {
            ok = false;
        } else {
            ok = true;
            j = nleft;
            while (j <= nrt) {
                int n3 = j++;
                w[n3] = w[n3] / a;
            }
            if (h > 0.0) {
                a = 0.0;
                j = nleft;
                while (j <= nrt) {
                    a += w[j] * x[j];
                    ++j;
                }
                double b = xs - a;
                double c = 0.0;
                j = nleft;
                while (j <= nrt) {
                    c += w[j] * Statistics.fsquare(x[j] - a);
                    ++j;
                }
                if (Math.sqrt(c) > 0.001 * range) {
                    b /= c;
                    j = nleft;
                    while (j <= nrt) {
                        int n4 = j;
                        w[n4] = w[n4] * (b * (x[j] - a) + 1.0);
                        ++j;
                    }
                }
            }
            ys = 0.0;
            j = nleft;
            while (j <= nrt) {
                ys += w[j] * y[j];
                ++j;
            }
        }
        return new Object[]{new Double(ys), w, new Boolean(ok)};
    }

    public static void main(String[] args) {
        double[] x = new double[]{6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 1.0, 2.0, 3.0, 4.0, 5.0, 8.0, 10.0, 12.0, 14.0};
        double[] y = new double[]{4.0, 16.0, 11.0, 7.0, 3.0, 14.0, 17.0, 20.0, 12.0, 9.0, 18.0, 2.0, 15.0, 6.0, 10.0, 13.0, 1.0, 8.0, 5.0};
        Object[] result = Statistics.lowess(x, y, x.length, 0.25, 2, 0.0);
        double[] ys = (double[])result[0];
        double[] rw = (double[])result[1];
        double[] res = (double[])result[2];
        System.out.println("ys: ");
        int i = 0;
        while (i < ys.length) {
            System.out.print(" " + ys[i]);
            ++i;
        }
        System.out.println("------------------------------");
        System.out.println("rw: ");
        int i2 = 0;
        while (i2 < ys.length) {
            System.out.print(" " + rw[i2]);
            ++i2;
        }
        System.out.println("-------------------------------");
        System.out.println("res: ");
        int i3 = 0;
        while (i3 < ys.length) {
            System.out.print(" " + res[i3]);
            ++i3;
        }
        System.out.println("---------------------------------");
    }
}

