/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.javamail;

import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class JavaMail {
    public static final String NO_FROM_ADDRESS = "No from-address provided!";
    public static final String NO_SERVER_ADDRESS = "No server-address provided!";
    public static final String NO_TO_ADDRESS = "No to-address provided!";
    MimeBodyPart[] attachments;
    Authenticator authentication;
    InternetAddress[] bccAddresses;
    InternetAddress[] ccAddresses;
    private Exception e;
    InternetAddress fromAddress;
    int port;
    String server;
    InternetAddress[] toAddresses;

    public JavaMail(String server, String fromAddress, String[] toAddresses, String[] ccAddresses, String[] bccAddresses) throws NullPointerException, AddressException {
        this(server, fromAddress, toAddresses, ccAddresses);
        if (bccAddresses != null) {
            this.bccAddresses = new InternetAddress[bccAddresses.length];
            int i = 0;
            while (i < bccAddresses.length) {
                this.bccAddresses[i] = new InternetAddress(bccAddresses[i]);
                ++i;
            }
        }
    }

    public JavaMail(String server, String fromAddress, String[] toAddresses, String[] ccAddresses) throws NullPointerException, AddressException {
        this(server, fromAddress, toAddresses);
        if (ccAddresses != null) {
            this.ccAddresses = new InternetAddress[ccAddresses.length];
            int i = 0;
            while (i < ccAddresses.length) {
                this.ccAddresses[i] = new InternetAddress(ccAddresses[i]);
                ++i;
            }
        }
    }

    public JavaMail(String server, String fromAddress, String[] toAddresses) throws NullPointerException, AddressException {
        try {
            this.server = server;
            this.fromAddress = new InternetAddress(fromAddress);
            this.toAddresses = new InternetAddress[toAddresses.length];
            int i = 0;
            while (i < toAddresses.length) {
                this.toAddresses[i] = new InternetAddress(toAddresses[i]);
                ++i;
            }
            this.port = 25;
            this.authentication = null;
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    public Exception getException() {
        return this.e;
    }

    public static void main(String[] argv) {
        try {
            String server = "fbmtal04.tu-graz.ac.at";
            String from = "Slave <slave.trajanoski@tugraz.at>";
            String temp = "slave.trajanoski@tugraz.at";
            String[] to = new String[]{"slave.trajanoski@tugraz.at"};
            String subject = "Work in progress...2";
            String message = "This message was sent by JavaMail. \nJavaMail was developed in Feb. 2002 by Christof Rath";
            String[] attachments = new String[]{"C:\\class.bat"};
            JavaMail mail = new JavaMail(server, temp, to);
            mail.setAttachments(attachments);
            mail.sendMessage(subject, message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean sendMessage(String subject, String message) throws MessagingException {
        int i;
        System.out.println("Host:        " + this.server + " (Port: " + this.port + "; Authentication: " + (this.authentication != null) + ")");
        System.out.println("From:        " + this.fromAddress);
        System.out.println("To:          " + this.toAddresses[0]);
        int i2 = 1;
        while (i2 < this.toAddresses.length) {
            System.out.println("             " + this.toAddresses[i2]);
            ++i2;
        }
        if (this.ccAddresses != null) {
            System.out.println("Cc:          " + this.ccAddresses[0]);
            i = 1;
            while (i < this.ccAddresses.length) {
                System.out.println("             " + this.ccAddresses[i]);
                ++i;
            }
        }
        if (this.bccAddresses != null) {
            System.out.println("Bcc:         " + this.bccAddresses[0]);
            i = 1;
            while (i < this.bccAddresses.length) {
                System.out.println("             " + this.bccAddresses[i]);
                ++i;
            }
        }
        if (this.attachments != null) {
            System.out.println("Attachments: " + this.attachments[0].getFileName());
            i = 1;
            while (i < this.attachments.length) {
                System.out.println("             " + this.attachments[i].getFileName());
                ++i;
            }
        }
        System.out.println("Subject:     " + subject);
        System.out.println("Message:");
        System.out.println("========");
        System.out.println(message);
        System.out.println("------------------------------------------------");
        System.out.println("please stand by...");
        Properties props = System.getProperties();
        ((Hashtable)props).put("mail.smtp.host", this.server);
        new String();
        ((Hashtable)props).put("mail.smtp.port", String.valueOf(this.port));
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)this.authentication);
        session.setDebug(false);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)this.fromAddress);
        msg.setRecipients(Message.RecipientType.TO, (Address[])this.toAddresses);
        if (this.ccAddresses != null) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])this.ccAddresses);
        }
        if (this.bccAddresses != null) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])this.bccAddresses);
        }
        msg.setSubject(subject);
        MimeBodyPart messagePart = new MimeBodyPart();
        messagePart.setText(message);
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)messagePart);
        if (this.attachments != null) {
            int i3 = 0;
            while (i3 < this.attachments.length) {
                mp.addBodyPart((BodyPart)this.attachments[i3]);
                ++i3;
            }
        }
        msg.setContent((Multipart)mp);
        msg.setSentDate(new Date());
        try {
            Transport.send((Message)msg);
            System.out.println("Message successful sent...");
            return true;
        }
        catch (SendFailedException e) {
            this.setException((Exception)((Object)e));
            return false;
        }
    }

    public void setAttachments(String[] attachments) throws MessagingException {
        this.attachments = new MimeBodyPart[attachments.length];
        int i = 0;
        while (i < attachments.length) {
            this.attachments[i] = new MimeBodyPart();
            FileDataSource fds = new FileDataSource(attachments[i]);
            this.attachments[i].setDataHandler(new DataHandler(fds));
            this.attachments[i].setFileName(fds.getName());
            ++i;
        }
    }

    public void setAuthentication(Authenticator authentication) {
        this.authentication = authentication;
    }

    public void setException(Exception e) {
        this.e = e;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

