/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.straightlinedata;

import at.tugraz.genome.utils.straightlinedata.DoubleRef;

class ChiXY {
    DoubleRef aa;
    int nn;
    DoubleRef offs;
    DoubleRef[] sx;
    DoubleRef[] sy;
    DoubleRef[] ww;
    DoubleRef[] xx;
    DoubleRef[] yy;

    public ChiXY(int nn, DoubleRef[] xx, DoubleRef[] yy, DoubleRef[] sx, DoubleRef[] sy, DoubleRef[] ww, DoubleRef aa, DoubleRef offs) {
        this.nn = nn;
        this.xx = xx;
        this.yy = yy;
        this.sx = sx;
        this.sy = sy;
        this.ww = ww;
        this.aa = aa;
        this.offs = offs;
    }

    public double chixy(double bang) {
        double avex = 0.0;
        double avey = 0.0;
        double sumw = 0.0;
        double b = Math.tan(bang);
        int j = 0;
        while (j < this.nn) {
            this.ww[j].value = Math.pow(b * this.sx[j].value, 2.0) + Math.pow(this.sy[j].value, 2.0);
            this.ww[j].value = this.ww[j].value < 9.999999999999999E-31 ? 1.0E30 : 1.0 / this.ww[j].value;
            sumw += this.ww[j].value;
            avex += this.ww[j].value * this.xx[j].value;
            avey += this.ww[j].value * this.yy[j].value;
            ++j;
        }
        this.aa.value = (avey /= sumw) - b * (avex /= sumw);
        double ans = -this.offs.value;
        j = 0;
        while (j < this.nn) {
            ans += this.ww[j].value * Math.pow(this.yy[j].value - this.aa.value - b * this.xx[j].value, 2.0);
            ++j;
        }
        return ans;
    }
}

