/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.straightlinedata;

import at.tugraz.genome.utils.straightlinedata.Avevar;
import at.tugraz.genome.utils.straightlinedata.Brent;
import at.tugraz.genome.utils.straightlinedata.ChixyMnbrakPararmeterFunction;
import at.tugraz.genome.utils.straightlinedata.DoubleRef;
import at.tugraz.genome.utils.straightlinedata.Fit;
import at.tugraz.genome.utils.straightlinedata.Gammq;
import at.tugraz.genome.utils.straightlinedata.Mnbrak;
import at.tugraz.genome.utils.straightlinedata.Zbrent;

class FiteXY {
    FiteXY() {
    }

    public static void fitexy(double[] x, double[] y, int ndat, double[] sigx, double[] sigy, DoubleRef a, DoubleRef b, DoubleRef siga, DoubleRef sigb, DoubleRef chi2, DoubleRef q) {
        DoubleRef[] xx = new DoubleRef[ndat];
        DoubleRef[] yy = new DoubleRef[ndat];
        DoubleRef[] sx = new DoubleRef[ndat];
        DoubleRef[] sy = new DoubleRef[ndat];
        DoubleRef[] ww = new DoubleRef[ndat];
        DoubleRef aa = new DoubleRef();
        DoubleRef offs = new DoubleRef();
        DoubleRef varx = new DoubleRef();
        DoubleRef vary = new DoubleRef();
        DoubleRef dum1 = new DoubleRef();
        DoubleRef dum2 = new DoubleRef();
        DoubleRef dum3 = new DoubleRef();
        DoubleRef dum4 = new DoubleRef();
        DoubleRef dum5 = new DoubleRef();
        DoubleRef[] ang = new DoubleRef[6];
        DoubleRef[] ch = new DoubleRef[6];
        int j = 0;
        while (j < 6) {
            ang[j] = new DoubleRef();
            ch[j] = new DoubleRef();
            ++j;
        }
        Avevar.avevar(x, ndat, dum1, varx);
        Avevar.avevar(y, ndat, dum1, vary);
        double scale = Math.sqrt(varx.value / vary.value);
        int nn = ndat;
        j = 0;
        while (j < ndat) {
            xx[j] = new DoubleRef(x[j]);
            yy[j] = new DoubleRef(y[j] * scale);
            sx[j] = new DoubleRef(sigx[j]);
            sy[j] = new DoubleRef(sigy[j] * scale);
            ww[j] = new DoubleRef(Math.sqrt(Math.pow(sx[j].value, 2.0) + Math.pow(sy[j].value, 2.0)));
            ++j;
        }
        Fit.fit(xx, yy, nn, ww, 1, dum1, b, dum2, dum3, dum4, dum5);
        ChixyMnbrakPararmeterFunction chixyMnbrakPararmeterFunction = new ChixyMnbrakPararmeterFunction(nn, xx, yy, sx, sy, ww, aa, offs);
        ang[0] = new DoubleRef();
        ang[1] = new DoubleRef(Math.atan(b.value));
        ang[3] = new DoubleRef();
        ang[4] = new DoubleRef(ang[1].value);
        ang[5] = new DoubleRef(1.571);
        j = 3;
        while (j <= 5) {
            ch[j] = new DoubleRef(chixyMnbrakPararmeterFunction.execute(ang[j].value));
            ++j;
        }
        Mnbrak.mnbrak(ang[0], ang[1], ang[2], ch[0], ch[1], ch[2], chixyMnbrakPararmeterFunction);
        chi2.value = Brent.brent(ang[0].value, ang[1].value, ang[2].value, chixyMnbrakPararmeterFunction, 0.001, b);
        chi2.value = chixyMnbrakPararmeterFunction.execute(b.value);
        a.value = aa.value;
        q.value = Gammq.gammq(0.5 * (double)(nn - 2), chi2.value * 0.5);
        double r2 = 0.0;
        j = 0;
        while (j < nn) {
            r2 += ww[j].value;
            ++j;
        }
        r2 = 1.0 / r2;
        double bmx = 1.0E30;
        double bmn = 1.0E30;
        offs.value = chi2.value + 1.0;
        j = 0;
        while (j < 6) {
            if (ch[j].value > offs.value) {
                double d1 = Math.abs(ang[j].value - b.value);
                while (d1 >= Math.PI) {
                    d1 -= Math.PI;
                }
                double d2 = Math.PI - d1;
                if (ang[j].value < b.value) {
                    double swap = d1;
                    d1 = d2;
                    d2 = swap;
                }
                if (d1 < bmx) {
                    bmx = d1;
                }
                if (d2 < bmn) {
                    bmn = d2;
                }
            }
            ++j;
        }
        if (bmx < 1.0E30) {
            bmx = Zbrent.zbrent(chixyMnbrakPararmeterFunction, b.value, b.value + bmx, 0.001) - b.value;
            double amx = aa.value - a.value;
            bmn = Zbrent.zbrent(chixyMnbrakPararmeterFunction, b.value, b.value - bmn, 0.001) - b.value;
            double amn = aa.value - a.value;
            sigb.value = Math.sqrt(0.5 * (bmx * bmx + bmn * bmn)) / (scale * Math.pow(Math.cos(b.value), 2.0));
            siga.value = Math.sqrt(0.5 * (amx * amx + amn * amn) + r2) / scale;
        } else {
            siga.value = 1.0E30;
            sigb.value = 1.0E30;
        }
        a.value /= scale;
        b.value = Math.tan(b.value) / scale;
    }
}

