/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.straightlinedata;

import at.tugraz.genome.utils.straightlinedata.DoubleRef;
import at.tugraz.genome.utils.straightlinedata.Gammln;

class Gcf {
    Gcf() {
    }

    public static void gcf(DoubleRef gammcf, double a, double x, DoubleRef gln) throws IllegalArgumentException {
        double d;
        gln.value = Gammln.gammln(a);
        double b = x + 1.0 - a;
        double c = 9.999999999999999E29;
        double h = d = 1.0 / b;
        int i = 0;
        while (i < 100) {
            double an = (double)(~i) * ((double)i - a);
            if (Math.abs(d = an * d + (b += 2.0)) < 1.0E-30) {
                d = 1.0E-30;
            }
            if (Math.abs(c = b + an / c) < 1.0E-30) {
                c = 1.0E-30;
            }
            d = 1.0 / d;
            double del = d * c;
            h *= del;
            if (Math.abs(del - 1.0) < 3.0E-7) break;
            ++i;
        }
        if (i > 100) {
            throw new IllegalArgumentException("a too large, ITMAX too small in gcf");
        }
        gammcf.value = Math.exp(-x + a * Math.log(x) - gln.value) * h;
    }
}

