/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.straightlinedata;

import at.tugraz.genome.utils.LogUtility;
import at.tugraz.genome.utils.straightlinedata.DoubleRef;
import at.tugraz.genome.utils.straightlinedata.FiteXY;

public class LinearRegression {
    private double a_ = 0.0;
    private double b_ = 1.0;
    private static LinearRegression instance_ = null;

    private LinearRegression() {
    }

    public double[] fit(double[] x, double[] y, double[] stdDeviation) {
        double S = 0.0;
        double Sx = 0.0;
        double Sxx = 0.0;
        double Sy = 0.0;
        double Syy = 0.0;
        double Sxy = 0.0;
        double Stt = 0.0;
        double _covariance = 0.0;
        double meanX = 0.0;
        double meanY = 0.0;
        double r = 0.0;
        int i = 0;
        while (i < x.length) {
            double weigth = 1.0 / this.square(stdDeviation[i]);
            S += weigth;
            Sx += x[i] * weigth;
            Sy += y[i] * weigth;
            Sxx += x[i] * x[i] * weigth;
            meanX += x[i];
            meanY += y[i];
            ++i;
        }
        meanX /= (double)x.length;
        meanY /= (double)y.length;
        double SxOverS = Sx / S;
        this.b_ = 0.0;
        int i2 = 0;
        while (i2 < x.length) {
            double t = (x[i2] - SxOverS) / stdDeviation[i2];
            Stt += t * t;
            this.b_ += t * y[i2] / stdDeviation[i2];
            ++i2;
        }
        this.b_ /= Stt;
        this.a_ = (Sy - Sx * this.b_) / S;
        return new double[]{this.a_, this.b_};
    }

    public double[] fitLogXY(double[] x, double[] y, double[] sigX, double[] sigY, boolean stDev) {
        int i = 0;
        while (i < x.length) {
            x[i] = x[i] != 0.0 && x[i] > 0.0 ? Math.log(x[i]) / Math.log(10.0) : 0.0;
            y[i] = y[i] != 0.0 && y[i] > 0.0 ? Math.log(y[i]) / Math.log(10.0) : 0.0;
            ++i;
        }
        if (stDev) {
            return this.fitXYWithStDev(x, y, sigX, sigY);
        }
        return this.fitXY(x, y, sigX, sigY);
    }

    public double[] fitXY(double[] x, double[] y, double[] sigX, double[] sigY) throws ArithmeticException {
        LogUtility.log("x: " + x.length + "    y = " + y.length + "    sigX = " + sigX.length + "    sigY = " + sigY.length);
        if (x.length != y.length || sigX.length != 0 && x.length != sigX.length || sigY.length != 0 && y.length != sigY.length) {
            throw new IllegalArgumentException("Input array size mismatch (" + x.length + "," + y.length + "," + sigX.length + "," + sigY.length + ")");
        }
        if (sigX.length != 0 && sigY.length != 0) {
            LogUtility.log("    sigX[0] = " + sigX[0]);
            LogUtility.log("    sigY[0] = " + sigY[0]);
            if (sigY[0] == 0.0) {
                int i = 0;
                while (i < y.length) {
                    sigY[i] = 1.0;
                    ++i;
                }
            }
            this.fit(x, y, sigY);
        } else {
            double[] sDev = new double[y.length];
            if (sigY.length == 0) {
                int i = 0;
                while (i < y.length) {
                    sDev[i] = 1.0;
                    ++i;
                }
            } else {
                sDev = sigY;
            }
            this.fit(x, y, sDev);
        }
        LogUtility.log("d(a) = " + this.a_ + "    k(b) = " + this.b_);
        return new double[]{this.b_, this.a_};
    }

    public double[] fitXYWithStDev(double[] x, double[] y, double[] sigx, double[] sigy) {
        int ndat = y.length;
        DoubleRef a = new DoubleRef(this.a_);
        DoubleRef b = new DoubleRef(this.b_);
        DoubleRef siga = new DoubleRef(0.0);
        DoubleRef sigb = new DoubleRef(0.0);
        DoubleRef chi2 = new DoubleRef(0.0);
        DoubleRef q = new DoubleRef(0.0);
        FiteXY.fitexy(x, y, ndat, sigx, sigy, a, b, siga, sigb, chi2, q);
        return new double[]{b.value, a.value};
    }

    public static LinearRegression getInstance() {
        if (instance_ == null) {
            instance_ = new LinearRegression();
        }
        return instance_;
    }

    private double square(double value) {
        return value * value;
    }
}

