/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.straightlinedata;

import at.tugraz.genome.utils.straightlinedata.Constants;
import at.tugraz.genome.utils.straightlinedata.MnbrakPararmeterFunction;

class Zbrent {
    Zbrent() {
    }

    public static double zbrent(MnbrakPararmeterFunction func, double x1, double x2, double tol) throws IllegalArgumentException {
        double a = x1;
        double b = x2;
        double c = x2;
        double e = 0.0;
        double d = 0.0;
        double fa = func.execute(a);
        double fb = func.execute(b);
        if (fa > 0.0 && fb > 0.0 || fa < 0.0 && fb < 0.0) {
            throw new IllegalArgumentException("Root must be bracketed in zbrent");
        }
        double fc = fb;
        int iter = 0;
        while (iter < 100) {
            if (fb > 0.0 && fc > 0.0 || fb < 0.0 && fc < 0.0) {
                c = a;
                fc = fa;
                e = d = b - a;
            }
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tol1 = 6.0E-8 * Math.abs(b) + 0.5 * tol;
            double xm = 0.5 * (c - b);
            if (Math.abs(xm) <= tol1 || fb == 0.0) {
                return b;
            }
            if (Math.abs(e) >= tol1 && Math.abs(fa) > Math.abs(fb)) {
                double min2;
                double q;
                double p;
                double s = fb / fa;
                if (a == c) {
                    p = 2.0 * xm * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                p = Math.abs(p);
                double min1 = 3.0 * xm * q - Math.abs(tol1 * q);
                double d2 = min1 < (min2 = Math.abs(e * q)) ? min1 : min2;
                if (2.0 * p < d2) {
                    e = d;
                    d = p / q;
                } else {
                    e = d = xm;
                }
            } else {
                e = d = xm;
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tol1 ? (b += d) : (b += Constants.sign(tol1, xm));
            fb = func.execute(b);
            ++iter;
        }
        throw new IllegalArgumentException("Maximum number of iterations exceeded in zbrent");
    }
}

