/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.AspectPicker;
import com.borland.jbcl.control.BevelPanel;
import com.borland.jbcl.control.ButtonDialog;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.control.ShapeControl;
import com.borland.jbcl.layout.PaneConstraints;
import com.borland.jbcl.layout.PaneLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ColorChooserPanel
extends BevelPanel
implements AdjustmentListener,
KeyListener,
ItemListener,
Serializable {
    public static final String CUSTOM_TAG = Res._CustomColorTag;
    private boolean showColorList = true;
    boolean changing;
    public static final String[][] colorNames = new String[][]{{Res._White, Res._LightGray, Res._Gray, Res._DarkGray, Res._Black, Res._Red, Res._Pink, Res._Orange, Res._Yellow, Res._Green, Res._Magenta, Res._Cyan, Res._Blue, Res._Desktop, Res._ActiveCaption, Res._ActiveCaptionText, Res._ActiveCaptionBorder, Res._InactiveCaption, Res._InactiveCaptionText, Res._InactiveCaptionBorder, Res._Window, Res._WindowBorder, Res._WindowText, Res._Menu, Res._MenuText, Res._Text, Res._TextText, Res._Highlight, Res._HighlightText, Res._InactiveText, Res._Control, Res._ControlText, Res._ControlHighlight, Res._ControlLtHighlight, Res._ControlShadow, Res._ControlDkShadow, Res._Scrollbar, Res._Info, Res._InfoText}, {"Color.white", "Color.lightGray", "Color.gray", "Color.darkGray", "Color.black", "Color.red", "Color.pink", "Color.orange", "Color.yellow", "Color.green", "Color.magenta", "Color.cyan", "Color.blue", "SystemColor.desktop", "SystemColor.activeCaption", "SystemColor.activeCaptionText", "SystemColor.activeCaptionBorder", "SystemColor.inactiveCaption", "SystemColor.inactiveCaptionText", "SystemColor.inactiveCaptionBorder", "SystemColor.window", "SystemColor.windowBorder", "SystemColor.windowText", "SystemColor.menu", "SystemColor.menuText", "SystemColor.text", "SystemColor.textText", "SystemColor.textHighlight", "SystemColor.textHighlightText", "SystemColor.textInactiveText", "SystemColor.control", "SystemColor.controlText", "SystemColor.controlHighlight", "SystemColor.controlLtHighlight", "SystemColor.controlShadow", "SystemColor.controlDkShadow", "SystemColor.scrollbar", "SystemColor.info", "SystemColor.infoText"}};
    static final Color[] colorValues = new Color[]{Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue, SystemColor.desktop, SystemColor.activeCaption, SystemColor.activeCaptionText, SystemColor.activeCaptionBorder, SystemColor.inactiveCaption, SystemColor.inactiveCaptionText, SystemColor.inactiveCaptionBorder, SystemColor.window, SystemColor.windowBorder, SystemColor.windowText, SystemColor.menu, SystemColor.menuText, SystemColor.text, SystemColor.textText, SystemColor.textHighlight, SystemColor.textHighlightText, SystemColor.textInactiveText, SystemColor.control, SystemColor.controlText, SystemColor.controlHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlDkShadow, SystemColor.scrollbar, SystemColor.info, SystemColor.infoText};
    static Hashtable textToValueMap;
    static Hashtable localizedTextToValueMap;
    private Color value;
    private ShapeControl sample = new ShapeControl(1);
    private JRadioButton[] checkbox = new JRadioButton[2];
    private String[] rgbLabels = new String[]{Res._RedLabel, Res._GreenLabel, Res._BlueLabel};
    private String[] hsbLabels = new String[]{Res._Hue, Res._Saturation, Res._Brightness};
    private int[] comp = new int[3];
    private boolean hsbMode = false;
    private boolean changed = false;
    private String[] text = new String[3];
    private JComboBox choice = new JComboBox();
    private AspectPicker[] pickers = new AspectPicker[3];

    public ColorChooserPanel() {
        this(true);
    }

    public ColorChooserPanel(boolean showColorList) {
        this.showColorList = showColorList;
        this.setBevelInner(0);
        this.setMargins(new Insets(0, 5, 5, 5));
        try {
            this.jbInit();
            this.hsbMode = true;
            this.setHsbMode(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.value = Color.white;
    }

    public ColorChooserPanel(Color value, boolean showColorList) {
        this(showColorList);
        this.value = value;
    }

    public ColorChooserPanel(Color value) {
        this(true);
        this.value = value;
    }

    ButtonDialog findButtonDialog() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof ButtonDialog); c = c.getParent()) {
        }
        if (c instanceof ButtonDialog) {
            return (ButtonDialog)c;
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        ButtonDialog bd = this.findButtonDialog();
        if (bd != null) {
            bd.setEnterOK(true);
            bd.setEscapeCancel(true);
        }
    }

    void jbInit() throws Exception {
        JPanel choicePan = new JPanel();
        choicePan.setLayout(new GridLayout(2, 0));
        choicePan.add(new JLabel(Res._StandardColors));
        this.fillChoice();
        this.choice.addItemListener(this);
        choicePan.add(this.choice);
        JPanel pickPan = new JPanel();
        pickPan.setLayout(new GridLayout(0, 3));
        for (int i = 0; i < 3; ++i) {
            this.pickers[i] = new AspectPicker();
            this.pickers[i].text.addKeyListener(this);
            this.pickers[i].scrollbar.addAdjustmentListener(this);
            pickPan.add(this.pickers[i]);
        }
        JPanel checkPan = new JPanel();
        ButtonGroup g = new ButtonGroup();
        this.checkbox[0] = new JRadioButton("RGB", true);
        checkPan.add(this.checkbox[0]);
        this.checkbox[1] = new JRadioButton("HSB", false);
        checkPan.add(this.checkbox[1]);
        g.add(this.checkbox[0]);
        g.add(this.checkbox[1]);
        this.checkbox[0].addItemListener(this);
        this.checkbox[1].addItemListener(this);
        JPanel customPan = new JPanel();
        customPan.setBorder(BorderFactory.createTitledBorder(Res._CustomColorGroupBox));
        customPan.setLayout(new BorderLayout());
        customPan.add((Component)pickPan, "Center");
        customPan.add((Component)checkPan, "South");
        JPanel samplePan = new JPanel();
        samplePan.setLayout(new BorderLayout());
        samplePan.add((Component)new JLabel(Res._Sample), "North");
        samplePan.add((Component)this.sample, "Center");
        PaneConstraints pc = new PaneConstraints();
        pc.position = "Root";
        JPanel split = new JPanel();
        split.setLayout(new PaneLayout());
        split.add((Component)customPan, pc);
        pc.position = "Right";
        pc.proportion = 0.3f;
        split.add((Component)samplePan, pc);
        this.setLayout(new BorderLayout(0, 5));
        if (this.showColorList) {
            this.add((Component)choicePan, "North");
        }
        this.add((Component)split, "Center");
    }

    public Color getColorValue() {
        return this.value;
    }

    public void setColorValue(Color value) {
        this.changeColor(value);
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void colorChanged(Color newColor) {
        this.changed = true;
    }

    protected void changeColor(Color value) {
        this.changeColor(value, false, false);
    }

    protected void changeColor(Color value, boolean suppressText, boolean suppressScroll) {
        String oldText;
        if (value != null && value.equals(this.value)) {
            return;
        }
        this.value = value;
        if (value == null) {
            return;
        }
        if (!this.hsbMode) {
            this.comp[0] = value.getRed();
            this.comp[1] = value.getGreen();
            this.comp[2] = value.getBlue();
        } else {
            float[] hsbComp = Color.RGBtoHSB(value.getRed(), value.getGreen(), value.getBlue(), null);
            this.comp[0] = (int)(hsbComp[0] * (float)100);
            this.comp[1] = (int)(hsbComp[1] * (float)100);
            this.comp[2] = (int)(hsbComp[2] * (float)100);
        }
        this.changing = true;
        for (int i = 0; i < 3; ++i) {
            int max;
            if (!suppressText) {
                String t = Integer.toString(this.comp[i]);
                if (this.text[i] == null || !this.text[i].equals(t)) {
                    this.text[i] = t;
                    this.pickers[i].text.setText(t);
                }
            }
            int n = max = this.hsbMode ? 100 : 255;
            if (suppressScroll || this.pickers[i].scrollbar.getValue() == this.comp[i]) continue;
            this.pickers[i].scrollbar.setValues(this.comp[i], 0, 0, i == 0 && this.hsbMode ? max : max + 1);
        }
        String text = ColorChooserPanel.valueToText(value, true);
        if (text != null && this.showColorList && !text.equals(oldText = (String)this.choice.getSelectedItem())) {
            this.choice.setSelectedItem(text);
        }
        if (value != this.sample.getForeground()) {
            this.sample.setForeground(value);
        }
        if (!this.hsbMode) {
            this.pickers[0].sample.setForeground(new Color(255, 255 - this.comp[0], 255 - this.comp[0]));
            this.pickers[1].sample.setForeground(new Color(255 - this.comp[1], 255, 255 - this.comp[1]));
            this.pickers[2].sample.setForeground(new Color(255 - this.comp[2], 255 - this.comp[2], 255));
        }
        this.changing = false;
        this.colorChanged(value);
    }

    public void setHsbMode(boolean hsbMode) {
        if (this.hsbMode != hsbMode) {
            this.changing = true;
            this.hsbMode = hsbMode;
            int max = hsbMode ? 100 : 255;
            for (int i = 0; i < 3; ++i) {
                this.pickers[i].label.setText(hsbMode ? this.hsbLabels[i] : this.rgbLabels[i]);
                this.pickers[i].scrollbar.setValues(this.comp[i], 0, 0, i == 0 && hsbMode ? max : max + 1);
                this.pickers[i].sample.setVisible(!hsbMode);
            }
            this.changing = false;
            if (this.checkbox[1].isSelected() != hsbMode) {
                this.checkbox[1].setSelected(hsbMode);
            }
            Color newValue = this.value;
            this.value = null;
            this.changeColor(newValue);
        }
    }

    public boolean isHsbMode() {
        return this.hsbMode;
    }

    public void adjustmentValueChanged(AdjustmentEvent event) {
        if (this.changing) {
            return;
        }
        int[] cValue = new int[3];
        int[] max = new int[3];
        for (int i = 0; i < 3; ++i) {
            cValue[i] = this.pickers[i].scrollbar.getValue();
            max[i] = this.pickers[i].scrollbar.getMaximum() - 1;
            if (cValue[i] < 0) {
                cValue[i] = 0;
                continue;
            }
            if (cValue[i] <= max[i]) continue;
            cValue[i] = max[i];
        }
        Color c = this.hsbMode ? Color.getHSBColor(Math.min((float)cValue[0] / 100.0f, 0.999999f), (float)cValue[1] / 100.0f, (float)cValue[2] / 100.0f) : new Color(cValue[0], cValue[1], cValue[2]);
        if (!c.equals(this.value)) {
            this.changeColor(c, false, false);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        try {
            Color c;
            int[] t = new int[3];
            boolean bad = false;
            int max = this.hsbMode ? 100 : 255;
            for (int i = 0; i < 3; ++i) {
                t[i] = Integer.parseInt(this.pickers[i].text.getText());
                if (t[i] >= 0 && t[i] <= max) continue;
                bad = true;
            }
            if (!bad && !(c = this.hsbMode ? Color.getHSBColor(Math.min((float)t[0] / 100.0f, 0.999999f), (float)t[1] / 100.0f, (float)t[2] / 100.0f) : new Color(t[0], t[1], t[2])).equals(this.value)) {
                this.changeColor(c, true, false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2 || this.changing) {
            return;
        }
        if (e.getSource() == this.choice) {
            Color c = ColorChooserPanel.textToValue((String)this.choice.getSelectedItem(), true);
            if (c != null) {
                this.changeColor(c, false, false);
            }
        } else {
            this.setHsbMode(e.getItemSelectable() == this.checkbox[1]);
        }
    }

    void fillChoice() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.choice.getModel();
        model.addElement(CUSTOM_TAG);
        for (int i = 0; i < colorValues.length; ++i) {
            model.addElement(colorNames[0][i]);
        }
    }

    public static String valueToText(Color c, boolean localized) {
        int i;
        for (i = 0; i < colorValues.length; ++i) {
            if (c != colorValues[i]) continue;
            return localized ? colorNames[0][i] : colorNames[1][i];
        }
        for (i = 0; i < colorValues.length; ++i) {
            if (!c.equals(colorValues[i])) continue;
            return localized ? colorNames[0][i] : colorNames[1][i];
        }
        return CUSTOM_TAG;
    }

    public static Color textToValue(String text, boolean localized) {
        return localized ? (Color)localizedTextToValueMap.get(text) : (Color)textToValueMap.get(text);
    }

    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        ps.width += 40;
        return ps;
    }

    static {
        int i = 0;
        try {
            textToValueMap = new Hashtable();
            localizedTextToValueMap = new Hashtable();
            for (i = 0; i < colorValues.length; ++i) {
                if (colorValues[i] == null) continue;
                localizedTextToValueMap.put(colorNames[0][i], colorValues[i]);
                textToValueMap.put(colorNames[1][i], colorValues[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(String.valueOf(String.valueOf(new StringBuffer("color values len ").append(i).append(" ").append(colorValues[i]).append(colorNames[0][i]).append(colorNames[1][i]))));
        }
    }
}

