/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModelEvent;
import com.borland.jbcl.model.GraphModelListener;
import com.borland.jbcl.model.LinkedTreeNode;
import com.borland.jbcl.model.WritableGraphModel;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;

public class LinkedTreeContainer
implements WritableGraphModel,
Serializable {
    protected LinkedTreeNode root;
    protected transient EventMulticaster listeners = new EventMulticaster();
    protected boolean events = true;

    public LinkedTreeContainer() {
    }

    public LinkedTreeContainer(LinkedTreeNode root) {
        this.root = root;
    }

    public GraphLocation getRoot() {
        return this.root;
    }

    public Object get(GraphLocation gl) {
        return gl;
    }

    public GraphLocation find(Object data) {
        if (data instanceof GraphLocation) {
            return (GraphLocation)data;
        }
        return null;
    }

    public void addModelListener(GraphModelListener listener) {
        this.listeners.add((EventListener)listener);
    }

    public void removeModelListener(GraphModelListener listener) {
        this.listeners.remove((EventListener)listener);
    }

    public GraphLocation setRoot(Object data) {
        this.root = (LinkedTreeNode)data;
        this.processModelEvent(new GraphModelEvent(this, 2));
        return this.root;
    }

    public boolean canSet(GraphLocation gl) {
        return true;
    }

    public void set(GraphLocation gl, Object data) {
        if (gl != data) {
            LinkedTreeNode node = (LinkedTreeNode)gl;
            node.parent.insertChild((LinkedTreeNode)data, node);
            node.parent.removeChild(node);
            this.processModelEvent(new GraphModelEvent(this, 50, gl));
        } else {
            this.processModelEvent(new GraphModelEvent(this, 17, gl));
        }
    }

    public void touched(GraphLocation gl) {
        this.processModelEvent(new GraphModelEvent(this, 33, gl));
    }

    public boolean isVariableSize() {
        return true;
    }

    public GraphLocation addChild(GraphLocation gl, Object data) {
        ((LinkedTreeNode)gl).appendChild((LinkedTreeNode)data);
        this.processModelEvent(new GraphModelEvent(this, 18, (GraphLocation)data));
        return (GraphLocation)data;
    }

    public GraphLocation addChild(GraphLocation parent, GraphLocation aheadOf, Object data) {
        ((LinkedTreeNode)parent).insertChild((LinkedTreeNode)data, (LinkedTreeNode)aheadOf);
        this.processModelEvent(new GraphModelEvent(this, 18, (GraphLocation)data));
        return (GraphLocation)data;
    }

    public void removeChildren(GraphLocation parent) {
        Enumeration i = ((LinkedTreeNode)parent).getChildIterator();
        while (i.hasMoreElements()) {
            LinkedTreeNode node = (LinkedTreeNode)i.nextElement();
            node.parent.removeChild(node);
        }
        this.processModelEvent(new GraphModelEvent(this, 50, parent));
    }

    public void remove(GraphLocation gl) {
        LinkedTreeNode node = (LinkedTreeNode)gl;
        if (node.parent != null) {
            node.parent.removeChild(node);
            this.processModelEvent(new GraphModelEvent(this, 34, gl));
        } else if (node == this.root) {
            this.root = null;
            this.processModelEvent(new GraphModelEvent(this, 2));
        }
    }

    public void removeAll() {
        this.root = null;
        this.processModelEvent(new GraphModelEvent(this, 2));
    }

    public void enableModelEvents(boolean enable) {
        if (this.events != enable) {
            this.events = enable;
            if (enable) {
                this.processModelEvent(new GraphModelEvent(this, 2));
            }
        }
    }

    public Enumeration elements() {
        Vector nodes = new Vector();
        this.fillNodes(this.root, nodes);
        return nodes.elements();
    }

    protected void fillNodes(LinkedTreeNode node, Vector nodes) {
        while (node != null) {
            nodes.addElement(node);
            if (node.firstChild != null) {
                this.fillNodes(node.firstChild, nodes);
            }
            node = node.nextSibling;
        }
    }

    public void processModelEvent(GraphModelEvent e) {
        if (this.events && this.listeners.hasListeners()) {
            this.listeners.dispatch((DispatchableEvent)e);
        }
    }
}

