/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field;

import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.Field;
import com.klg.jclass.field.JCFieldComponent;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCVersion;
import com.klg.jclass.field.validate.JCValidator;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.plaf.ComboBoxUI;

public class JCComboField
extends JComboBox
implements JCFieldComponent {
    protected Field field;
    transient JTextField text;
    protected boolean required = true;
    protected ListModel original_picklist = null;
    boolean autoComplete = false;
    boolean autoSuggest = false;
    boolean autoRefinement = false;
    boolean autoAppend = true;
    protected String[] prefixList = null;
    public static final String version = JCVersion.getVersionString();

    public JCComboField() {
        this.setEditable(true);
        this.text = this.getTextFieldEditor();
        this.createField(null);
        this.field.addListDataListener(this);
    }

    public JCComboField(JCValueModel jCValueModel) {
        this();
        this.field.setValueModel(jCValueModel);
    }

    public JCComboField(JCValueModel jCValueModel, JCValidator jCValidator) {
        this();
        this.field.setValidator(jCValidator);
        this.field.setValueModel(jCValueModel);
    }

    public JCComboField(Class clazz) {
        this();
        this.field.setClass(clazz);
    }

    public JCComboField(Class clazz, JCValidator jCValidator) {
        this();
        this.field.setValidator(jCValidator);
        this.field.setClass(clazz);
    }

    public void add(String string) {
        this.addItem(string);
    }

    public void addActionListener(ActionListener actionListener) {
        this.text.addActionListener(actionListener);
    }

    public void addNotify() {
        super.addNotify();
        this.field.addNotify();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.field != null) {
            this.field.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void addValueListener(JCValueListener jCValueListener) {
        this.field.addValueListener(jCValueListener);
    }

    public void commitEdit() {
        this.field.commitEdit();
    }

    protected void createField(JCValidator jCValidator) {
        this.field = new Field(this, jCValidator);
    }

    public String getAbout() {
        return version;
    }

    public DataProperties getDataProperties() {
        return this.field.getDataProperties();
    }

    public JCInvalidInfo getInvalidInfo() {
        return this.field.getInvalidInfo();
    }

    protected ListModel getOriginalPickList() {
        return this.original_picklist;
    }

    public ListModel getPickList() {
        JCValidator jCValidator = this.field.getValidator();
        if (jCValidator == null) {
            return null;
        }
        return jCValidator.getPickList();
    }

    public String[] getPrefixList() {
        return this.prefixList;
    }

    public boolean getSelectOnEnter() {
        return this.field.getSelectOnEnter();
    }

    public int getState() {
        return this.field.getState();
    }

    protected JTextField getTextFieldEditor() {
        return (JTextField)this.getEditor().getEditorComponent();
    }

    public JCValidator getValidator() {
        return this.field.getValidator();
    }

    public Object getValue() {
        return this.field.getValue();
    }

    public JCValueModel getValueModel() {
        return this.field.getValueModel();
    }

    public boolean isAutoAppend() {
        return this.autoAppend;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public boolean isAutoRefinement() {
        return this.autoRefinement;
    }

    public boolean isAutoSuggest() {
        return this.autoSuggest;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void removeActionListener(ActionListener actionListener) {
        this.text.removeActionListener(actionListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.field != null) {
            this.field.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeValueListener(JCValueListener jCValueListener) {
        this.field.removeValueListener(jCValueListener);
    }

    protected void restoreOriginalPickList() {
        this.setTemporaryPickList(this.original_picklist);
    }

    public synchronized void setAbout(String string) {
    }

    public void setAutoComplete(boolean bl, boolean bl2, boolean bl3, boolean bl4, String[] stringArray) {
        if (this.autoComplete != bl && !bl) {
            this.field.turnOffAutoCompleteMode();
        }
        this.autoComplete = bl;
        this.autoAppend = bl2;
        this.autoSuggest = bl3;
        this.autoRefinement = bl3 ? bl4 : false;
        this.prefixList = stringArray;
    }

    public void setBackground(Color color) {
        if (this.field == null || this.field.internalBackgroundChange) {
            super.setBackground(color);
        } else {
            this.field.validBackground = color;
            if (this.field.getState() != 3) {
                super.setBackground(color);
            }
        }
    }

    public void setDataProperties(DataProperties dataProperties) {
        this.field.setDataProperties(dataProperties);
    }

    public void setForeground(Color color) {
        if (this.field == null || this.field.internalForegroundChange) {
            super.setForeground(color);
        } else {
            this.field.validForeground = color;
            if (this.field.getState() != 3) {
                super.setForeground(color);
            }
        }
    }

    public void setInvalidInfo(JCInvalidInfo jCInvalidInfo) {
        this.field.setInvalidInfo(jCInvalidInfo);
    }

    public void setItems(String[] stringArray) {
        if (this.getItemCount() > 0) {
            this.removeAllItems();
        }
        int n = 0;
        while (n < stringArray.length) {
            this.add(stringArray[n]);
            ++n;
        }
    }

    public void setPickList(ListModel listModel) {
        this.setTemporaryPickList(listModel);
        this.original_picklist = listModel;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public void setSelectOnEnter(boolean bl) {
        this.field.setSelectOnEnter(bl);
    }

    protected void setTemporaryPickList(ListModel listModel) {
        JCValidator jCValidator = this.field.getValidator();
        if (jCValidator == null) {
            return;
        }
        jCValidator.setPickList(listModel);
        this.field.fireContentsChanged(this.field, 0, listModel.getSize());
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        super.setUI(comboBoxUI);
        this.text = this.getTextFieldEditor();
        if (this.field != null) {
            JCValueModel jCValueModel = this.field.getValueModel();
            this.createField(this.field.getValidator());
            this.setValueModel(jCValueModel);
        }
    }

    public void setValidator(JCValidator jCValidator) {
        this.field.setValidator(jCValidator);
        this.original_picklist = jCValidator == null ? null : jCValidator.getPickList();
    }

    public void setValue(Object object) {
        this.field.setValue(object);
    }

    public void setValueModel(JCValueModel jCValueModel) {
        this.field.setValueModel(jCValueModel);
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
    }
}

