/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing;

import com.klg.jclass.swing.JCMDIFrame;
import com.klg.jclass.swing.JCMDIWindowMenu;
import com.klg.jclass.swing.Version;
import com.klg.jclass.swing.util.LayoutButton;
import com.klg.jclass.swing.util.LayoutButtonBox;
import com.klg.jclass.swing.util.ShrinkWrapLayout;
import com.klg.jclass.swing.util.UserMenuItem;
import com.klg.jclass.swing.util.WindowMenuItem;
import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCLocaleManager;
import com.klg.jclass.util.swing.JCAction;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class JCMDIPane
extends JDesktopPane {
    public static final int DEFAULT = 2;
    public static final int WIREFRAME = 1;
    public static final int TILE_HORIZONTAL = 1;
    public static final int TILE_VERTICAL = 2;
    public static final int CASCADE = 3;
    protected int initialLayout = 0;
    protected JMenuBar menubar = null;
    protected JToolBar toolbar = null;
    protected Listener listener = new Listener();
    protected FrameListener frameListener = new FrameListener();
    protected ActionListener menuListener = new WindowsMenuListener();
    protected boolean maximized = false;
    protected LayoutButtonBox layoutButtonBox = null;
    protected String savedTitle = null;
    protected boolean titleIsSaved = false;
    protected JCAction maxMinAction = null;
    protected JMenuItem maxMinItem = null;
    protected JCAction cascadeAction = null;
    protected JCAction tileHorizAction = null;
    protected JCAction tileVertAction = null;
    protected JCAction arrangeIconsAction = null;
    protected int frameManipulationStyle = 1;
    protected JToolBar lastToolBarSetToRoot = null;
    protected Icon selectedIcon;
    protected Icon nonSelectedIcon;
    protected JMenuBar currentMenuBar = null;
    protected JInternalFrame activatingFrame = null;
    private static final String[] selectedIconPixels = new String[]{"             ", "             ", "         bbb ", "        bbb  ", "       bbb   ", "bbbb  bbb    ", " bbb bbb     ", "  bbbbb      ", "   bbb       ", "    b        ", "             ", "             ", "             "};
    private static final String[] nonSelectedIconPixels = new String[]{"             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             "};
    protected static JCLocaleManager li = JCLocaleManager.getDefault();
    protected JInternalFrame activeFrame = null;
    protected JPanel maximizedPanel = new JPanel(new ShrinkWrapLayout());
    protected JInternalFrame maximizedFrame = null;
    protected int cascadeX = 0;
    protected int cascadeY = 0;
    protected int cascadeXIncrement = 15;
    protected int cascadeYIncrement = 20;
    private Dimension cascadeSize = new Dimension(0, 0);
    private int fudge2 = 0;
    private int fudge1 = 0;
    static /* synthetic */ Class class$javax$swing$JScrollPane;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public JCMDIPane() {
        this.setMinimumSize(new Dimension(300, 200));
        this.addContainerListener(this.listener);
        this.setSelectedIcon(JCMDIPane.makeImage(selectedIconPixels));
        this.setNonSelectedIcon(JCMDIPane.makeImage(nonSelectedIconPixels));
    }

    public void activateFrame(JInternalFrame jInternalFrame) {
        if (this.activeFrame == jInternalFrame) {
            return;
        }
        this.activatingFrame = jInternalFrame;
        if (jInternalFrame instanceof JCMDIFrame) {
            JCDebug.println("mdipane", "\tactivating MDIFRAME");
            JCMDIFrame jCMDIFrame = (JCMDIFrame)jInternalFrame;
            this.setMenuAndToolBarsToRootPane(jCMDIFrame, this.getMDIMenuBar(jCMDIFrame), this.getMDIToolBar(jCMDIFrame));
        }
        if (this.maximized) {
            this.updateIconsInMenuBar(jInternalFrame);
        }
        this.updateWindowsMenu();
        this.activeFrame = jInternalFrame;
    }

    public void addNotify() {
        JCDebug.println("mdipane", "addNotify()");
        this.selectNextFrame();
        super.addNotify();
        this.checkIfMenuOrToolBarsNeeded();
        this.updateWindowsMenu();
    }

    public void arrangeIcons() {
        JInternalFrame.JDesktopIcon[] jDesktopIconArray = this.getAllIconifiedFrames();
        if (jDesktopIconArray.length == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < jDesktopIconArray.length) {
            int n3 = jDesktopIconArray[n2].getWidth();
            int n4 = jDesktopIconArray[n2].getHeight();
            jDesktopIconArray[n2].setBounds(n, this.getHeight() - n4, n3, n4);
            n += jDesktopIconArray[n2].getWidth();
            ++n2;
        }
        this.repaint();
    }

    protected void buildWindowsMenu(JMenu jMenu) {
        JCDebug.println("mdipane", "buildWindowMenu()");
        if (jMenu.getMenuComponentCount() != 0) {
            jMenu.removeAll();
        }
        int n = this.getOpenInternalFrameCount();
        this.cascadeAction = new CascadeAction();
        JMenuItem jMenuItem = this.cascadeAction.createMenuItem();
        jMenu.add(jMenuItem);
        if (n == 0) {
            jMenuItem.setEnabled(false);
        }
        this.maxMinAction = new MaxMinAction();
        jMenuItem = this.maxMinAction.createMenuItem();
        if (this.maximized) {
            jMenuItem.setText(li.getString("ActionUndomax"));
        } else {
            jMenuItem.setText(li.getString("ActionMaximize"));
        }
        this.maxMinItem = jMenuItem;
        jMenu.add(jMenuItem);
        if (n == 0 || this.activatingFrame != null && !this.activatingFrame.isMaximizable()) {
            jMenuItem.setEnabled(false);
        }
        this.tileHorizAction = new TileHAction();
        jMenuItem = this.tileHorizAction.createMenuItem();
        jMenu.add(jMenuItem);
        if (n == 0) {
            jMenuItem.setEnabled(false);
        }
        this.tileVertAction = new TileVAction();
        jMenuItem = this.tileVertAction.createMenuItem();
        jMenu.add(jMenuItem);
        if (n == 0) {
            jMenuItem.setEnabled(false);
        }
        this.arrangeIconsAction = new ArrangeAction();
        jMenuItem = this.arrangeIconsAction.createMenuItem();
        jMenu.add(jMenuItem);
        if (this.getIconifiedFrameCount() == 0) {
            jMenuItem.setEnabled(false);
        }
        jMenu.add(new JSeparator());
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        int n3 = 0;
        while (n3 < componentArray.length) {
            JInternalFrame jInternalFrame = null;
            if (componentArray[n3] instanceof JInternalFrame) {
                jInternalFrame = (JInternalFrame)componentArray[n3];
            } else if (componentArray[n3] instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = ((JInternalFrame.JDesktopIcon)componentArray[n3]).getInternalFrame()).getParent() != null) {
                jInternalFrame = null;
            }
            if (jInternalFrame != null) {
                JCDebug.println("mdipane", "\tadd window item = " + jInternalFrame.getTitle());
                WindowMenuItem windowMenuItem = new WindowMenuItem(n2++ + " ", Integer.toString(n3).charAt(0), (Object)jInternalFrame);
                if (n2 == 1) {
                    windowMenuItem.setIcon(this.getSelectedIcon());
                } else {
                    windowMenuItem.setIcon(this.getNonSelectedIcon());
                }
                windowMenuItem.addActionListener(this.menuListener);
                jMenu.add(windowMenuItem);
            }
            ++n3;
        }
    }

    protected Dimension calcCascadeSize() {
        this.cascadeSize.width = (int)(0.8 * (double)this.getSize().width);
        this.cascadeSize.height = (int)(0.8 * (double)this.getSize().height);
        return this.cascadeSize;
    }

    protected void cascadeFrame(JInternalFrame jInternalFrame) {
        if (!this.isDisplayable()) {
            return;
        }
        Dimension dimension = this.calcCascadeSize();
        JCDebug.println("mdipane", "\tcascading unbound frame to size = " + dimension.width + ", " + dimension.height);
        jInternalFrame.setBounds(this.cascadeX, this.cascadeY, dimension.width, dimension.height);
        this.cascadeX += this.cascadeXIncrement;
        this.cascadeY += this.cascadeYIncrement;
    }

    protected void cascadeFrameByPreferredSize(JInternalFrame jInternalFrame) {
        Dimension dimension = jInternalFrame.getPreferredSize();
        JCDebug.println("mdipane", "\tcascading unbound frame to size = " + dimension.width + ", " + dimension.height);
        jInternalFrame.setBounds(this.cascadeX, this.cascadeY, dimension.width, dimension.height);
        this.cascadeX += this.cascadeXIncrement;
        this.cascadeY += this.cascadeYIncrement;
    }

    public void cascadeWindows() {
        JInternalFrame[] jInternalFrameArray = this.getAllNonIconifiedAndNonPaletteFrames();
        if (jInternalFrameArray.length == 0) {
            return;
        }
        this.cascadeX = 0;
        this.cascadeY = 0;
        int n = jInternalFrameArray.length - 1;
        while (n >= 0) {
            this.cascadeFrame(jInternalFrameArray[n]);
            --n;
        }
        this.sizingToScrollPane();
    }

    protected void checkIfMenuOrToolBarsNeeded() {
        JCMDIFrame jCMDIFrame = null;
        JToolBar jToolBar = null;
        JMenuBar jMenuBar = null;
        if (this.isDisplayable()) {
            Component[] componentArray = this.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JCMDIFrame && (jCMDIFrame = (JCMDIFrame)componentArray[n]).isSelected()) {
                    jMenuBar = jCMDIFrame.getMDIMenuBar();
                    jToolBar = jCMDIFrame.getMDIToolBar();
                    break;
                }
                ++n;
            }
            if (jMenuBar == null && jToolBar == null) {
                jCMDIFrame = null;
            }
            if (jMenuBar == null) {
                jMenuBar = this.menubar;
            }
            if (jToolBar == null) {
                jToolBar = this.toolbar;
            }
            this.setMenuAndToolBarsToRootPane(null, jMenuBar, jToolBar);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void closeFrame(JInternalFrame jInternalFrame) {
        JCDebug.println("mdipane", "Closing Frame");
        int n = this.getOpenInternalFrameCount();
        if (jInternalFrame != this.maximizedFrame) {
            if (n == 0 && this.activatingFrame == null) {
                this.checkIfMenuOrToolBarsNeeded();
            }
            return;
        }
        if (n < 1) {
            JCDebug.println("mdipane", "\tnot many frames around");
            this.maximizeFrame(null);
        } else {
            JCDebug.println("mdipane", "\ttrying to select another frame");
            Component[] componentArray = this.getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                if (componentArray[n2] != jInternalFrame && componentArray[n2] instanceof JInternalFrame) {
                    try {
                        JInternalFrame jInternalFrame2 = (JInternalFrame)componentArray[n2];
                        jInternalFrame2.setSelected(true);
                        this.updateIconsInMenuBar(jInternalFrame2);
                        if (!jInternalFrame2.isMaximizable()) break;
                        this.maximizeFrame(jInternalFrame2);
                        break;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        JCDebug.assert(false);
                    }
                }
                ++n2;
            }
        }
        this.repaint();
    }

    public void deactivateFrame(JInternalFrame jInternalFrame) {
        this.activeFrame = null;
    }

    public void doLayout() {
        JCDebug.println("mdipane", "DoLayout()");
        if (this.maximized) {
            this.maximizedPanel.setBounds(0, 0, this.getVisibleSize().width, this.getVisibleSize().height);
        }
        Component[] componentArray = this.getComponents();
        JCDebug.println("mdipane", "\twe have nkids = " + componentArray.length);
        int n = 0;
        while (n < componentArray.length) {
            JCDebug.println("mdipane", "\tkid[" + n + "] is of class = " + componentArray[n].getClass().getName());
            if (componentArray[n] instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)componentArray[n];
            }
            ++n;
        }
        super.doLayout();
    }

    public String getAbout() {
        return Version.getVersionString();
    }

    public JInternalFrame.JDesktopIcon[] getAllIconifiedFrames() {
        Object object;
        Vector<Object[]> vector = new Vector<Object[]>(this.getComponentCount());
        int n = 0;
        while (n < this.getComponentCount()) {
            JInternalFrame jInternalFrame;
            object = this.getComponent(n);
            if (object instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = ((JInternalFrame.JDesktopIcon)object).getInternalFrame()) != null) {
                vector.addElement((Object[])object);
            }
            ++n;
        }
        object = new JInternalFrame.JDesktopIcon[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public JInternalFrame[] getAllNonIconifiedAndNonPaletteFrames() {
        Object object;
        Vector<Object> vector = new Vector<Object>(this.getComponentCount());
        int n = 0;
        while (n < this.getComponentCount()) {
            if (this.getComponent(n) instanceof JInternalFrame && ((JInternalFrame)(object = (JInternalFrame)this.getComponent(n))).getLayer() != JLayeredPane.PALETTE_LAYER.intValue()) {
                vector.addElement(object);
            }
            ++n;
        }
        object = new JInternalFrame[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public int getFrameManipulationStyle() {
        return this.frameManipulationStyle;
    }

    protected int getIconifiedFrameCount() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (componentArray[n2] instanceof JInternalFrame.JDesktopIcon) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    protected JMenuBar getJMenuBar() {
        if (this.currentMenuBar != null) {
            return this.currentMenuBar;
        }
        JMenuBar jMenuBar = null;
        JCDebug.println("mdipane", "getJMenuBar()");
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane == null) {
            JCDebug.println("mdipane", "\tNo rootPane returning null");
            return null;
        }
        this.currentMenuBar = jMenuBar = jRootPane.getJMenuBar();
        return jMenuBar;
    }

    protected LayoutButtonBox getLayoutButtonBox() {
        if (this.layoutButtonBox == null) {
            this.layoutButtonBox = new LayoutButtonBox(new LayoutListener());
        }
        return this.layoutButtonBox;
    }

    public JMenuBar getMDIMenuBar() {
        return this.menubar;
    }

    public JMenuBar getMDIMenuBar(JInternalFrame jInternalFrame) {
        JMenuBar jMenuBar;
        if (jInternalFrame != null && jInternalFrame instanceof JCMDIFrame && (jMenuBar = ((JCMDIFrame)jInternalFrame).getMDIMenuBar()) != null) {
            return jMenuBar;
        }
        return this.menubar;
    }

    public JToolBar getMDIToolBar() {
        return this.toolbar;
    }

    public JToolBar getMDIToolBar(JInternalFrame jInternalFrame) {
        JToolBar jToolBar;
        if (jInternalFrame != null && jInternalFrame instanceof JCMDIFrame && (jToolBar = ((JCMDIFrame)jInternalFrame).getMDIToolBar()) != null) {
            return jToolBar;
        }
        return this.toolbar;
    }

    public Dimension getMaximumSize() {
        JCDebug.println("mdipane", "getMaximumSize()");
        return new Dimension(100, 100);
    }

    public Icon getNonSelectedIcon() {
        return this.nonSelectedIcon;
    }

    protected int getOpenInternalFrameCount() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        int n2 = 0;
        while (n2 < componentArray.length) {
            JInternalFrame jInternalFrame;
            if (componentArray[n2] instanceof JInternalFrame && !(jInternalFrame = (JInternalFrame)componentArray[n2]).isClosed() && jInternalFrame.getLayer() != JLayeredPane.PALETTE_LAYER.intValue()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public Dimension getPreferredSize() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane != null ? class$javax$swing$JScrollPane : (class$javax$swing$JScrollPane = JCMDIPane.class$("javax.swing.JScrollPane")), this);
        if (jScrollPane == null || this.getComponentCount() == 0) {
            return this.getMinimumSize();
        }
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        int n = 0;
        while (n < this.getComponentCount()) {
            rectangle = rectangle.union(this.getComponent(n).getBounds());
            ++n;
        }
        JCDebug.println("mdipane", "getPreferredSize returns " + rectangle.getSize());
        return rectangle.getSize();
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public JInternalFrame getTopFrame() {
        JInternalFrame[] jInternalFrameArray = this.getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER);
        return jInternalFrameArray.length > 0 ? jInternalFrameArray[0] : null;
    }

    protected Dimension getVisibleSize() {
        if (this.getParent() != null && this.getParent().getParent() instanceof JScrollPane) {
            this.fudge1 = 3;
            this.fudge2 = 1;
            return this.getParent().getParent().getSize();
        }
        this.fudge1 = 0;
        this.fudge2 = 0;
        return this.getSize();
    }

    public JMenu getWindowsMenuFromMenuBar() {
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return null;
        }
        MenuElement[] menuElementArray = jMenuBar.getSubElements();
        int n = 0;
        while (n < menuElementArray.length) {
            if (menuElementArray[n] instanceof JCMDIWindowMenu) {
                return (JMenu)menuElementArray[n];
            }
            ++n;
        }
        JCMDIWindowMenu jCMDIWindowMenu = new JCMDIWindowMenu();
        jMenuBar.add(jCMDIWindowMenu);
        return jCMDIWindowMenu;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    protected static Icon makeImage(String[] stringArray) {
        JCIconCreator jCIconCreator = new JCIconCreator(13, 13);
        jCIconCreator.setColor('g', Color.green);
        jCIconCreator.setColor('l', Color.blue);
        jCIconCreator.setColor('X', Color.lightGray);
        jCIconCreator.setColor('w', Color.white);
        jCIconCreator.setColor('b', Color.black);
        jCIconCreator.setColor('r', new Color(220, 50, 0));
        jCIconCreator.setPixels(stringArray);
        ImageIcon imageIcon = jCIconCreator.getIcon();
        jCIconCreator.clear();
        return imageIcon;
    }

    public void maximize(JInternalFrame jInternalFrame) {
        if (jInternalFrame.isMaximizable()) {
            this.maximized = true;
            this.maximizeFrame(jInternalFrame);
        }
    }

    protected void maximizeFrame(JInternalFrame jInternalFrame) {
        Object object;
        Frame frame;
        if (jInternalFrame != null) {
            JCDebug.println("mdipane", "maximizeFrame(" + jInternalFrame.getTitle() + ")");
        }
        this.activeFrame = jInternalFrame;
        if (this.maximizedFrame == jInternalFrame) {
            JCDebug.println("mdipane", "returning because frame is already maxed");
            return;
        }
        if (this.maximizedFrame != null) {
            try {
                this.maximizedFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                JCDebug.assert(false);
            }
        }
        if (jInternalFrame != null) {
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        if ((frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = JCMDIPane.class$("java.awt.Frame")), this)) != null && !this.titleIsSaved) {
            this.savedTitle = frame.getTitle();
            this.titleIsSaved = true;
        }
        if (this.maximizedFrame != null && this.maximizedPanel.getComponentCount() != 0) {
            this.moveChildren(this.maximizedPanel, this.maximizedFrame);
        }
        if (jInternalFrame != null) {
            this.moveChildren(jInternalFrame, this.maximizedPanel);
            if (this.maximizedPanel.getParent() == null) {
                if (this.getParent() != null && this.getParent().getParent() != null && this.getParent().getParent() instanceof JScrollPane) {
                    object = (JScrollPane)this.getParent().getParent();
                    ((JScrollPane)object).setHorizontalScrollBarPolicy(31);
                    ((JScrollPane)object).setVerticalScrollBarPolicy(21);
                    ((JComponent)object).revalidate();
                }
                this.add(this.maximizedPanel);
            }
            this.maximizedPanel.setBounds(0, 0, this.getVisibleSize().width, this.getVisibleSize().height);
            this.moveToFront(this.maximizedPanel);
        } else if (this.maximizedPanel.getParent() != null) {
            ((Container)this).remove(this.maximizedPanel);
        }
        if (jInternalFrame == null) {
            JCDebug.println("mdipane", "Setting maximized frame to null");
        } else {
            JCDebug.println("mdipane", "Setting maximized frame to " + jInternalFrame.getTitle());
        }
        this.maximizedFrame = jInternalFrame;
        if (this.titleIsSaved) {
            object = this.savedTitle == null ? "" : this.savedTitle;
            if (this.maximizedFrame != null) {
                object = String.valueOf(object) + " - " + this.maximizedFrame.getTitle();
            }
            frame.setTitle((String)object);
        }
        this.checkIfMenuOrToolBarsNeeded();
        this.updateIconsInMenuBar(jInternalFrame);
        if (this.maximizedFrame != null) {
            this.maximizedFrame.grabFocus();
        }
    }

    protected void moveChildren(Container container, Container container2) {
        Component component;
        if (container instanceof JCMDIFrame) {
            component = ((JCMDIFrame)container).getContentPane();
        } else {
            if (container instanceof RootPaneContainer) {
                container = ((RootPaneContainer)((Object)container)).getContentPane();
            }
            if (container.getComponentCount() < 1) {
                return;
            }
            component = container.getComponent(0);
        }
        if (container2 instanceof JCMDIFrame) {
            ((JCMDIFrame)container2).restoreContainer((Container)component);
        } else {
            if (container2 instanceof RootPaneContainer) {
                container2 = ((RootPaneContainer)((Object)container2)).getContentPane();
            }
            container2.add(component);
        }
        container2.invalidate();
        container2.validate();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        switch (this.initialLayout) {
            case 1: {
                this.tileWindowsHorizontally();
                break;
            }
            case 2: {
                this.tileWindowsVertically();
                break;
            }
            case 3: {
                this.cascadeWindows();
                break;
            }
        }
        this.initialLayout = 0;
    }

    protected void resizingScrollPane() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane != null ? class$javax$swing$JScrollPane : (class$javax$swing$JScrollPane = JCMDIPane.class$("javax.swing.JScrollPane")), this);
        if (jScrollPane != null) {
            this.revalidate();
        }
    }

    protected void selectNextFrame() {
        JCDebug.println("mdipane", "selectNextFrame()");
        if (this.activatingFrame != null) {
            JCDebug.println("mdipane", "\taborting because activateingFrame not null");
            return;
        }
        Component[] componentArray = this.getComponents();
        JInternalFrame jInternalFrame = null;
        if (componentArray.length != 0) {
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JInternalFrame && ((JInternalFrame)componentArray[n]).isMaximizable()) {
                    jInternalFrame = (JInternalFrame)componentArray[n];
                    break;
                }
                ++n;
            }
        } else {
            this.activateFrame(null);
        }
        if (jInternalFrame != null) {
            JCDebug.println("mdipane", "\tselecting next frame");
            try {
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            JCDebug.println("mdipane", "\tno next frame :-(");
            this.setMenuAndToolBarsToRootPane(null, this.menubar, this.toolbar);
        }
    }

    public void setAbout(String string) {
    }

    public void setFrameManipulationStyle(int n) {
        if (n < 2 && n > 1) {
            throw new IllegalArgumentException("invalid parameter: " + n);
        }
        if (n == this.frameManipulationStyle) {
            return;
        }
        this.frameManipulationStyle = n;
    }

    public void setInitialLayout(int n) {
        this.initialLayout = n;
    }

    public void setLayout() {
    }

    public void setMDIMenuBar(JMenuBar jMenuBar) {
        this.menubar = jMenuBar;
        this.checkIfMenuOrToolBarsNeeded();
    }

    public void setMDIToolBar(JToolBar jToolBar) {
        this.toolbar = jToolBar;
        this.checkIfMenuOrToolBarsNeeded();
    }

    public void setMaximized(boolean bl) {
        if (this.maximized == bl) {
            return;
        }
        if (bl) {
            if (this.activeFrame != null) {
                this.maximize(this.activeFrame);
            } else {
                this.maximized = true;
            }
        } else {
            this.unmaximize();
        }
    }

    protected void setMenuAndToolBarsToRootPane(JInternalFrame jInternalFrame, JMenuBar jMenuBar, JToolBar jToolBar) {
        if (jMenuBar == null && jToolBar == null) {
            return;
        }
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane == null) {
            return;
        }
        if (jMenuBar != null) {
            this.currentMenuBar = jMenuBar;
            this.updateWindowsMenu();
            this.updateIconsInMenuBar(jInternalFrame);
            jRootPane.setJMenuBar(jMenuBar);
            JCDebug.println("mdipane", "SWITCHING MENUBAR to " + jMenuBar);
            this.updateWindowsMenu();
        } else {
            JCDebug.println("mdipane", "NOOOT!!! SWITCHING MENUBAR");
        }
        if (jToolBar != null && jToolBar != this.lastToolBarSetToRoot) {
            if (this.lastToolBarSetToRoot != null && SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = JCMDIPane.class$("javax.swing.JFrame")), jRootPane) == SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = JCMDIPane.class$("javax.swing.JFrame")), this.lastToolBarSetToRoot)) {
                this.lastToolBarSetToRoot.getParent().remove(this.lastToolBarSetToRoot);
            }
            jRootPane.getContentPane().add((Component)jToolBar, "North");
            this.lastToolBarSetToRoot = jToolBar;
        }
        jRootPane.invalidate();
        jRootPane.validate();
        jRootPane.repaint();
    }

    public void setNonSelectedIcon(Icon icon) {
        this.nonSelectedIcon = icon;
    }

    public void setSelectedIcon(Icon icon) {
        this.selectedIcon = icon;
    }

    protected void setTitleBar() {
        String string;
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = JCMDIPane.class$("java.awt.Frame")), this);
        if (frame == null) {
            return;
        }
        if (this.maximized) {
            this.savedTitle = frame.getTitle();
            string = this.savedTitle == null ? "" : this.savedTitle;
            string = String.valueOf(string) + " - " + this.maximizedFrame.getTitle();
        } else {
            string = this.savedTitle;
        }
        frame.setTitle(string);
    }

    protected void sizingToScrollPane() {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane != null ? class$javax$swing$JScrollPane : (class$javax$swing$JScrollPane = JCMDIPane.class$("javax.swing.JScrollPane")), this);
        if (jScrollPane != null) {
            this.revalidate();
        }
    }

    public void tileWindowsHorizontally() {
        JInternalFrame[] jInternalFrameArray = this.getAllNonIconifiedAndNonPaletteFrames();
        if (jInternalFrameArray.length == 0) {
            return;
        }
        JInternalFrame.JDesktopIcon[] jDesktopIconArray = this.getAllIconifiedFrames();
        int n = jDesktopIconArray.length > 0 ? jDesktopIconArray[0].getHeight() : 0;
        int n2 = this.getVisibleSize().height - n - this.fudge2;
        int n3 = n2 / jInternalFrameArray.length - 1;
        int n4 = n2 % jInternalFrameArray.length;
        int n5 = 0;
        while (n5 < jInternalFrameArray.length) {
            if (n5 < n4) {
                jInternalFrameArray[n5].setBounds(0, n5 * n3, this.getVisibleSize().width - this.fudge1, n3 + 1);
            } else {
                jInternalFrameArray[n5].setBounds(0, n5 * n3, this.getVisibleSize().width - this.fudge1, n3);
            }
            ++n5;
        }
        this.repaint();
        this.sizingToScrollPane();
    }

    public void tileWindowsVertically() {
        JInternalFrame[] jInternalFrameArray = this.getAllNonIconifiedAndNonPaletteFrames();
        if (jInternalFrameArray.length == 0) {
            return;
        }
        JInternalFrame.JDesktopIcon[] jDesktopIconArray = this.getAllIconifiedFrames();
        int n = jDesktopIconArray.length > 0 ? jDesktopIconArray[0].getHeight() : 0;
        int n2 = this.getVisibleSize().width - this.fudge2;
        int n3 = n2 / jInternalFrameArray.length - 1;
        int n4 = n2 % jInternalFrameArray.length;
        int n5 = 0;
        while (n5 < jInternalFrameArray.length) {
            if (n5 < n4) {
                jInternalFrameArray[n5].setBounds(n5 * n3, 0, n3 + 1, this.getVisibleSize().height - n - this.fudge1);
            } else {
                jInternalFrameArray[n5].setBounds(n5 * n3, 0, n3, this.getVisibleSize().height - n - this.fudge1);
            }
            ++n5;
        }
        this.sizingToScrollPane();
        this.repaint();
    }

    public void unmaximize() {
        this.maximized = false;
        if (this.maximizedFrame != null) {
            try {
                this.maximizedFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                JCDebug.assert(false);
            }
        }
        this.unmaximizeFrame();
        if (this.maxMinItem != null) {
            this.maxMinItem.setText(li.getString("ActionMaximize"));
        }
        this.updateIconsInMenuBar(null);
        this.repaint();
    }

    protected void unmaximizeFrame() {
        Container container;
        if (this.maximizedFrame == null) {
            return;
        }
        JCDebug.println("mdipane", "unxmaimizing frame " + this.maximizedFrame.getTitle());
        if (this.maximizedPanel.getParent() != null) {
            if (this.getParent() != null && this.getParent().getParent() != null && this.getParent().getParent() instanceof JScrollPane) {
                container = (JScrollPane)this.getParent().getParent();
                ((JScrollPane)container).setHorizontalScrollBarPolicy(30);
                ((JScrollPane)container).setVerticalScrollBarPolicy(20);
                ((JComponent)container).revalidate();
            }
            ((Container)this).remove(this.maximizedPanel);
        }
        this.moveChildren(this.maximizedPanel, this.maximizedFrame);
        if (this.maximizedFrame != null) {
            this.maximizedFrame.grabFocus();
        }
        this.maximizedFrame = null;
        container = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = JCMDIPane.class$("java.awt.Frame")), this);
        if (container != null && this.titleIsSaved) {
            ((Frame)container).setTitle(this.savedTitle);
        }
    }

    protected void updateIconsInMenuBar(JInternalFrame jInternalFrame) {
        LayoutButtonBox layoutButtonBox = this.getLayoutButtonBox();
        if (jInternalFrame == null || !this.maximized) {
            Container container = layoutButtonBox.getParent();
            if (container != null) {
                container.remove(layoutButtonBox);
                container.repaint();
            }
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar == null) {
            return;
        }
        layoutButtonBox.setMaximizedFrame(jInternalFrame);
        if (layoutButtonBox.getParent() != jMenuBar) {
            jMenuBar.add(layoutButtonBox);
            jMenuBar.validate();
            jMenuBar.repaint();
        }
    }

    protected void updateWindowsMenu() {
        JMenu jMenu = this.getWindowsMenuFromMenuBar();
        if (jMenu != null) {
            this.buildWindowsMenu(jMenu);
        }
    }

    class Listener
    implements ContainerListener,
    Serializable {
        Listener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            JCDebug.println("mdipane", "MDI.componentAdded" + containerEvent.getChild().getClass().getName());
            if (containerEvent.getChild() instanceof JInternalFrame) {
                JInternalFrame jInternalFrame = (JInternalFrame)containerEvent.getChild();
                jInternalFrame.addInternalFrameListener(JCMDIPane.this.frameListener);
                jInternalFrame.addVetoableChangeListener(JCMDIPane.this.frameListener);
                DesktopManager desktopManager = jInternalFrame.getDesktopPane().getDesktopManager();
                if (!(desktopManager instanceof MDIDesktopManager)) {
                    jInternalFrame.getDesktopPane().setDesktopManager(new MDIDesktopManager(desktopManager));
                }
                Rectangle rectangle = jInternalFrame.getBounds();
                if (rectangle.x == 0 && rectangle.y == 0 && rectangle.width == 0 && rectangle.height == 0) {
                    JCMDIPane.this.cascadeFrameByPreferredSize(jInternalFrame);
                }
                if (JCMDIPane.this.isDisplayable()) {
                    try {
                        jInternalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            }
            JCMDIPane.this.updateWindowsMenu();
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JCDebug.println("mdipane", "MDI.componentRemoved = " + containerEvent.getChild().getClass().getName());
            if (containerEvent.getChild() instanceof JInternalFrame) {
                JCMDIPane.this.closeFrame((JInternalFrame)containerEvent.getChild());
                JCMDIPane.this.selectNextFrame();
                JCMDIPane.this.updateWindowsMenu();
            }
        }
    }

    class FrameListener
    implements InternalFrameListener,
    VetoableChangeListener,
    Serializable {
        FrameListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            JCDebug.println("mdipane", "internalFramActivated");
            JCMDIPane.this.activateFrame((JInternalFrame)internalFrameEvent.getSource());
            JCMDIPane.this.activatingFrame = null;
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            JCDebug.println("mdipane", "internalFrameClosed");
            JCMDIPane.this.updateWindowsMenu();
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            JCDebug.println("mdipane", "internalFramDeactivated");
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            ((JInternalFrame)internalFrameEvent.getSource()).moveToFront();
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
            JCDebug.println("mdipane", "internalFrameOpened");
            JCMDIPane.this.updateWindowsMenu();
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("maximum")) {
                JCMDIPane.this.maximize((JInternalFrame)propertyChangeEvent.getSource());
                throw new PropertyVetoException("MDI Override", propertyChangeEvent);
            }
        }
    }

    class WindowsMenuListener
    implements ActionListener,
    Serializable {
        WindowsMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCDebug.println("mdipane", "ActionEvent(maximized = " + JCMDIPane.this.maximized + ")");
            JInternalFrame jInternalFrame = (JInternalFrame)((UserMenuItem)actionEvent.getSource()).getUserData();
            if (JCMDIPane.this.maximized && jInternalFrame.isMaximizable()) {
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    JCDebug.assert(false);
                }
                JCMDIPane.this.maximizeFrame(jInternalFrame);
            } else {
                if (jInternalFrame.isIcon()) {
                    try {
                        jInternalFrame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        JCDebug.assert(false);
                    }
                }
                try {
                    jInternalFrame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    JCDebug.assert(false);
                }
            }
        }
    }

    class MaxMinAction
    extends JCAction
    implements Serializable {
        public MaxMinAction() {
            super(li.getString("ActionMaximize"), li.getMnemonic("ActionMaximizeMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JCMDIPane.this.maximized) {
                JCMDIPane.this.unmaximize();
            } else {
                JCMDIPane.this.maximize(JCMDIPane.this.activeFrame);
            }
        }
    }

    class CascadeAction
    extends JCAction
    implements Serializable {
        public CascadeAction() {
            super(li.getString("ActionCascade"), li.getMnemonic("ActionCascadeMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JCMDIPane.this.maximized) {
                JCMDIPane.this.unmaximize();
            }
            JCMDIPane.this.cascadeWindows();
        }
    }

    class TileHAction
    extends JCAction
    implements Serializable {
        public TileHAction() {
            super(li.getString("ActionTileh"), li.getMnemonic("ActionTilehMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JCMDIPane.this.maximized) {
                JCMDIPane.this.unmaximize();
            }
            JCMDIPane.this.tileWindowsHorizontally();
        }
    }

    class TileVAction
    extends JCAction
    implements Serializable {
        public TileVAction() {
            super(li.getString("ActionTilev"), li.getMnemonic("ActionTilevMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (JCMDIPane.this.maximized) {
                JCMDIPane.this.unmaximize();
            }
            JCMDIPane.this.tileWindowsVertically();
        }
    }

    class ArrangeAction
    extends JCAction
    implements Serializable {
        public ArrangeAction() {
            super(li.getString("ActionArrange"), li.getMnemonic("ActionArrangeMnemonic"), (KeyStroke)null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCMDIPane.this.arrangeIcons();
        }
    }

    class LayoutListener
    implements ActionListener,
    Serializable {
        LayoutListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = JCMDIPane.this.maximizedFrame;
            LayoutButton layoutButton = (LayoutButton)actionEvent.getSource();
            switch (layoutButton.getControlType()) {
                case 3: {
                    if (jInternalFrame == null) break;
                    try {
                        JCDebug.println("mdipane", "MAX Closing " + jInternalFrame.getTitle());
                        jInternalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        JCDebug.assert(false);
                    }
                    break;
                }
                case 1: {
                    JCMDIPane.this.unmaximize();
                    break;
                }
                case 2: {
                    JCMDIPane.this.unmaximize();
                    if (jInternalFrame == null) break;
                    try {
                        jInternalFrame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        JCDebug.assert(false);
                    }
                    break;
                }
            }
        }
    }

    public class MDIDesktopManager
    implements DesktopManager,
    Serializable {
        DesktopManager manager;
        final int INVALID_X = -999;
        private Rectangle rect = new Rectangle(-999, 0, 0, 0);
        boolean dragging = false;

        public MDIDesktopManager(DesktopManager desktopManager) {
            this.setDesktopManager(desktopManager);
        }

        public void activateFrame(JInternalFrame jInternalFrame) {
            block2: {
                JCMDIPane.this.activateFrame(jInternalFrame);
                this.manager.activateFrame(jInternalFrame);
                if (!JCMDIPane.this.maximized || !jInternalFrame.isMaximizable()) break block2;
                try {
                    jInternalFrame.setMaximum(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }

        public void beginDraggingFrame(JComponent jComponent) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.beginDraggingFrame(jComponent);
            }
        }

        public void beginResizingFrame(JComponent jComponent, int n) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.beginResizingFrame(jComponent, n);
            }
        }

        public void closeFrame(JInternalFrame jInternalFrame) {
            JCMDIPane.this.closeFrame(jInternalFrame);
            this.manager.closeFrame(jInternalFrame);
        }

        public void deactivateFrame(JInternalFrame jInternalFrame) {
            JCMDIPane.this.deactivateFrame(jInternalFrame);
            this.manager.deactivateFrame(jInternalFrame);
        }

        public void deiconifyFrame(JInternalFrame jInternalFrame) {
            this.manager.deiconifyFrame(jInternalFrame);
        }

        public void dragFrame(JComponent jComponent, int n, int n2) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.dragFrame(jComponent, n, n2);
            } else {
                this.dragging = true;
                this.setBounds(jComponent, n, n2, jComponent.getWidth(), jComponent.getHeight());
            }
        }

        private void drawRect(boolean bl, JComponent jComponent, int n, int n2, int n3, int n4) {
            JDesktopPane jDesktopPane;
            if (!bl) {
                this.rect.setBounds(n, n2, n3, n4);
            } else if (this.rect.x == -999) {
                return;
            }
            if (jComponent instanceof JInternalFrame) {
                jDesktopPane = ((JInternalFrame)jComponent).getDesktopPane();
            } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
                jDesktopPane = ((JInternalFrame.JDesktopIcon)jComponent).getDesktopPane();
            } else {
                JCDebug.assert(false);
                return;
            }
            Graphics graphics = jDesktopPane.getGraphics();
            graphics.setXORMode(jDesktopPane.getBackground());
            graphics.drawRect(this.rect.x, this.rect.y, this.rect.width - 1, this.rect.height - 1);
            graphics.dispose();
        }

        public void endDraggingFrame(JComponent jComponent) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.endDraggingFrame(jComponent);
            } else if (this.dragging) {
                this.drawRect(true, jComponent, 0, 0, 0, 0);
                this.dragging = false;
                this.setBoundsForFrame(jComponent, this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            }
            JCMDIPane.this.resizingScrollPane();
        }

        public void endResizingFrame(JComponent jComponent) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.endResizingFrame(jComponent);
            } else if (this.dragging) {
                JCDebug.println("mdipane", "ending resizing of component f = " + ((JInternalFrame)jComponent).getTitle());
                this.drawRect(true, jComponent, 0, 0, 0, 0);
                this.dragging = false;
                this.setBoundsForFrame(jComponent, this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            }
        }

        public DesktopManager getDesktopManager() {
            return this.manager;
        }

        public void iconifyFrame(JInternalFrame jInternalFrame) {
            this.manager.iconifyFrame(jInternalFrame);
        }

        public void maximizeFrame(JInternalFrame jInternalFrame) {
            JCDebug.println("mdipane", "Request for maximization");
        }

        public void minimizeFrame(JInternalFrame jInternalFrame) {
            this.manager.minimizeFrame(jInternalFrame);
        }

        public void openFrame(JInternalFrame jInternalFrame) {
            JCDebug.println("mdipane", "OPEN FRAME");
            this.manager.openFrame(jInternalFrame);
        }

        public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
            if (JCMDIPane.this.frameManipulationStyle != 1) {
                this.manager.resizeFrame(jComponent, n, n2, n3, n4);
            } else {
                this.dragging = true;
                this.setBounds(jComponent, n, n2, n3, n4);
            }
        }

        private void setBounds(JComponent jComponent, int n, int n2, int n3, int n4) {
            this.drawRect(true, jComponent, 0, 0, 0, 0);
            this.drawRect(false, jComponent, n, n2, n3, n4);
        }

        public void setBoundsForFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
            this.manager.setBoundsForFrame(jComponent, n, n2, n3, n4);
            this.rect.x = -999;
            if (JCMDIPane.this.frameManipulationStyle == 1) {
                return;
            }
            JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JScrollPane != null ? class$javax$swing$JScrollPane : (class$javax$swing$JScrollPane = JCMDIPane.class$("javax.swing.JScrollPane")), jComponent);
            if (jScrollPane != null) {
                jComponent.revalidate();
            }
        }

        public void setDesktopManager(DesktopManager desktopManager) {
            this.manager = desktopManager;
        }
    }
}

