/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.JCTick;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;

public abstract class JCScale
extends JComponent {
    static final long serialVersionUID = 964248061930031369L;
    protected Direction direction = Direction.COUNTERCLOCKWISE;
    protected double min = 0.0;
    protected double max = 100.0;
    protected Vector ticks = new Vector();

    public JCScale() {
        this.setLayout(new GridLayout(1, 1));
    }

    public JCScale(Direction direction, double d, double d2, Color color) {
        this.setLayout(new GridLayout(1, 1));
        this.direction = direction;
        this.min = d;
        this.max = d2;
        this.setForeground(color);
    }

    public void addTick(JCTick jCTick) {
        this.addTick(jCTick, 0);
    }

    public void addTick(JCTick jCTick, int n) {
        this.ticks.addElement(jCTick);
        this.add((Component)jCTick, n);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public Vector getTicks() {
        return this.ticks;
    }

    public boolean inBounds(double d) {
        return d >= this.getMin() && d <= this.getMax();
    }

    public void redraw() {
    }

    public void removeTick(JCTick jCTick) {
        if (this.ticks.contains(jCTick)) {
            this.ticks.removeElement(jCTick);
            this.remove(jCTick);
        }
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
        this.redraw();
    }

    public void setMax(double d) {
        this.max = d;
        this.redraw();
    }

    public void setMin(double d) {
        this.min = d;
        this.redraw();
    }

    public static class Direction
    implements Serializable {
        public static final Direction CLOCKWISE = new Direction("clockwise");
        public static final Direction COUNTERCLOCKWISE = new Direction("counterclockwise");
        String string;

        private Direction(String string) {
            this.string = string;
        }

        public boolean equals(Direction direction) {
            return direction.string.equals(this.string);
        }
    }
}

