/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.data;

import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.data.AbstractVectorDataSource;
import java.util.Vector;

public class JCCachedDataSource
extends AbstractVectorDataSource
implements JCTableDataListener {
    protected TableDataModel dataSource;
    protected Vector cached_row_labels = AbstractVectorDataSource.createVector();
    protected Vector cached_column_labels = AbstractVectorDataSource.createVector();
    protected Vector cached_cells = AbstractVectorDataSource.createVector();

    public JCCachedDataSource(TableDataModel tableDataModel) {
        this.dataSource = tableDataModel;
        this.dataSource.addTableDataListener(this);
    }

    public void dataChanged(JCTableDataEvent jCTableDataEvent) {
        int n = jCTableDataEvent.getRow();
        int n2 = jCTableDataEvent.getColumn();
        switch (jCTableDataEvent.getCommand()) {
            case 1: {
                try {
                    AbstractVectorDataSource.setElementAt((Vector)this.cached_cells.elementAt(n), n2, null);
                }
                catch (Exception exception) {
                    System.out.println("An error in JCCachedDataSource.dataChanged()");
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 12: {
                this.cached_row_labels = AbstractVectorDataSource.createVector();
                this.cached_cells = AbstractVectorDataSource.createVector();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                this.cached_column_labels = AbstractVectorDataSource.createVector();
                this.cached_cells = AbstractVectorDataSource.createVector();
                break;
            }
            case 8: {
                AbstractVectorDataSource.setElementAt(this.cached_row_labels, n, null);
                break;
            }
            case 9: {
                AbstractVectorDataSource.setElementAt(this.cached_column_labels, n2, null);
                break;
            }
            case 14: {
                this.cached_row_labels = AbstractVectorDataSource.createVector();
                this.cached_column_labels = AbstractVectorDataSource.createVector();
                this.cached_cells = AbstractVectorDataSource.createVector();
                break;
            }
        }
        this.fireTableDataEvent(jCTableDataEvent);
    }

    public int getNumColumns() {
        return this.dataSource.getNumColumns();
    }

    public int getNumRows() {
        return this.dataSource.getNumRows();
    }

    public Object getTableColumnLabel(int n) {
        if (n > this.cached_column_labels.size() - 1 || this.cached_column_labels.elementAt(n) == null) {
            Object object = this.dataSource.getTableColumnLabel(n);
            AbstractVectorDataSource.setElementAt(this.cached_column_labels, n, object);
            return object;
        }
        return this.cached_column_labels.elementAt(n);
    }

    public Object getTableDataItem(int n, int n2) {
        if (n > this.cached_cells.size() - 1) {
            Object object = this.dataSource.getTableDataItem(n, n2);
            Vector vector = AbstractVectorDataSource.createVector();
            AbstractVectorDataSource.setElementAt(vector, n2, object);
            AbstractVectorDataSource.setElementAt(this.cached_cells, n, vector);
            return object;
        }
        Vector vector = (Vector)this.cached_cells.elementAt(n);
        if (vector == null) {
            vector = AbstractVectorDataSource.createVector();
        }
        if (n2 > vector.size() - 1 || vector.elementAt(n2) == null) {
            Object object = this.dataSource.getTableDataItem(n, n2);
            AbstractVectorDataSource.setElementAt(vector, n2, object);
            AbstractVectorDataSource.setElementAt(this.cached_cells, n, vector);
            return object;
        }
        return ((Vector)this.cached_cells.elementAt(n)).elementAt(n2);
    }

    public Object getTableRowLabel(int n) {
        if (n > this.cached_row_labels.size() - 1 || this.cached_row_labels.elementAt(n) == null) {
            Object object = this.dataSource.getTableRowLabel(n);
            AbstractVectorDataSource.setElementAt(this.cached_row_labels, n, object);
            return object;
        }
        return this.cached_row_labels.elementAt(n);
    }
}

