/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.treetable;

import com.klg.jclass.swing.JCTreeTable;
import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.swing.DefaultRowSortTableModel;
import com.klg.jclass.util.swing.JCAction;
import com.klg.jclass.util.swing.JCRowSortModel;
import com.klg.jclass.util.swing.JCRowSortTableModel;
import com.klg.jclass.util.treetable.DefaultTreeIconRenderer;
import com.klg.jclass.util.treetable.EmptyTreeTableModel;
import com.klg.jclass.util.treetable.JCTreeIconRenderer;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import com.klg.jclass.util.treetable.TableFromTreeTable;
import com.klg.jclass.util.treetable.TreeWithSortableChildren;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;

public class TreeTableSupport
implements TableModel,
JCRowSortTableModel,
TableModelListener,
RowMapper,
Serializable {
    public static final int TREE = 1;
    public static final int TABLE = 2;
    public static final int NODE_LINES_SHOW = 1;
    public static final int NODE_LINES_HIDE = 2;
    public static final int NODE_LINES_USE_PLAF = 3;
    protected boolean sortable = true;
    protected int sortColumn = -1;
    protected int sortOrder = 1;
    protected int[][] keyColumnsArray;
    protected boolean autoSort = true;
    protected int showNodeLines = 3;
    protected JComponent visualComponent;
    protected int view = 1;
    protected JCTreeTableModel treetable = null;
    protected TableModel table;
    protected TreeModelListener treeListener = new TreeListener();
    protected JCListenerList tableListeners = null;
    protected int treeColumn = 0;
    protected JCListenerList treeExpansionListeners;
    protected JCListenerList treeSelectionListeners;
    protected JCListenerList treeWillExpandListeners;
    protected boolean rootVisible = true;
    protected boolean showsRootHandles = false;
    protected JCTreeIconRenderer iconRenderer = new DefaultTreeIconRenderer();
    protected boolean scrollsOnExpand;
    protected Icon expandedIcon;
    protected Icon collapsedIcon;
    protected int leftLevelSpacing;
    protected int rightLevelSpacing;
    protected int levelIndent;
    protected Icon openIcon;
    protected Icon closedIcon;
    protected Icon leafIcon;
    protected Color lineColor;
    protected int lineThickness;
    protected Stroke lineStroke;
    protected boolean drawLines;
    protected Color tableBackground;
    private boolean isMotif = false;
    protected int cellHeight;
    protected RemovableVector rowMap = null;
    protected Hashtable expandedState = null;
    static /* synthetic */ Class class$javax$swing$tree$TreePath;

    public TreeTableSupport(JComponent jComponent) {
        this.visualComponent = jComponent;
        this.inferLookAndFeel();
    }

    public TreeTableSupport(JComponent jComponent, JCTreeTableModel jCTreeTableModel) {
        this(jComponent);
        this.setTreeTableModel(jCTreeTableModel);
    }

    protected void addKids(Object object, TreePath treePath, Vector vector) {
        int n = this.treetable.getChildCount(object);
        int n2 = 0;
        while (n2 < n) {
            Object object2 = this.treetable.getChild(object, n2);
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            vector.add(treePath2);
            if (this.isExpanded(treePath2)) {
                this.addKids(object2, treePath2, vector);
            }
            ++n2;
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.tableListeners = JCListenerList.add(this.tableListeners, tableModelListener);
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.treeExpansionListeners = JCListenerList.add(this.treeExpansionListeners, treeExpansionListener);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.treeWillExpandListeners = JCListenerList.add(this.treeWillExpandListeners, treeWillExpandListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void collapsePath(TreePath treePath) {
        this.collapsePathRow(treePath, this.getRowForPath(treePath));
    }

    public void collapsePathRow(TreePath treePath, int n) {
        if (!this.isExpanded(treePath)) {
            return;
        }
        TreeExpansionEvent treeExpansionEvent = new TreeExpansionEvent(this.visualComponent, treePath);
        Enumeration enumeration = JCListenerList.elements(this.treeWillExpandListeners);
        while (enumeration.hasMoreElements()) {
            TreeWillExpandListener treeWillExpandListener = (TreeWillExpandListener)enumeration.nextElement();
            try {
                treeWillExpandListener.treeWillCollapse(treeExpansionEvent);
            }
            catch (ExpandVetoException expandVetoException) {
                return;
            }
        }
        int n2 = this.countKidsToRemove(this.getNode(n), treePath);
        this.expandedState.put(treePath, Boolean.FALSE);
        this.rowMap.remove(n + 1, n + 1 + n2);
        TableModelEvent tableModelEvent = new TableModelEvent(this, n + 1, n + n2, -1, -1);
        this.postTableModelChanged(tableModelEvent);
        enumeration = JCListenerList.elements(this.treeExpansionListeners);
        while (enumeration.hasMoreElements()) {
            TreeExpansionListener treeExpansionListener = (TreeExpansionListener)enumeration.nextElement();
            treeExpansionListener.treeCollapsed(treeExpansionEvent);
        }
    }

    public void collapseRow(int n) {
        this.collapsePathRow(this.getPathForRow(n), n);
    }

    protected int countKidsToRemove(Object object, TreePath treePath) {
        int n;
        int n2 = n = this.treetable.getChildCount(object);
        int n3 = 0;
        while (n3 < n) {
            Object object2 = this.treetable.getChild(object, n3);
            TreePath treePath2 = treePath.pathByAddingChild(object2);
            if (this.isExpanded(treePath2)) {
                n2 += this.countKidsToRemove(object2, treePath2);
            }
            ++n3;
        }
        return n2;
    }

    public void expandPath(TreePath treePath) {
        this.isExpanded(treePath);
        this.expandPathRow(treePath, this.getRowForPath(treePath));
    }

    protected void expandPathRow(TreePath treePath, int n) {
        Object object;
        Serializable serializable;
        if (this.isExpanded(treePath)) {
            return;
        }
        if (n == -1) {
            serializable = null;
            int n2 = -1;
            int n3 = this.rootVisible ? 0 : 1;
            while (n3 < treePath.getPathCount() - 1) {
                Object object2 = treePath.getPathComponent(n3);
                if (serializable == null) {
                    serializable = new TreePath(treePath.getPathComponent(0));
                    if (n3 != 0) {
                        serializable = ((TreePath)serializable).pathByAddingChild(object2);
                    }
                    n2 = this.getRowForPath((TreePath)serializable);
                } else {
                    serializable = ((TreePath)serializable).pathByAddingChild(treePath.getPathComponent(n3));
                    n2 = this.getRowForPath((TreePath)serializable);
                }
                if (!this.isExpanded((TreePath)serializable)) {
                    this.expandPathRow((TreePath)serializable, n2);
                }
                ++n3;
            }
            if (treePath.getPathCount() > 1) {
                n += n2 + this.treetable.getIndexOfChild(treePath.getPathComponent(treePath.getPathCount() - 2), treePath.getPathComponent(treePath.getPathCount() - 1)) + 2;
            }
        }
        serializable = new TreeExpansionEvent(this.visualComponent, treePath);
        Enumeration enumeration = JCListenerList.elements(this.treeWillExpandListeners);
        while (enumeration.hasMoreElements()) {
            TreeWillExpandListener treeWillExpandListener = (TreeWillExpandListener)enumeration.nextElement();
            try {
                treeWillExpandListener.treeWillExpand((TreeExpansionEvent)serializable);
            }
            catch (ExpandVetoException expandVetoException) {
                return;
            }
        }
        Object object3 = TreeTableSupport.getNode(treePath);
        boolean bl = false;
        this.expandedState.put(treePath, Boolean.TRUE);
        if (!this.isExpanded(treePath)) {
            return;
        }
        TreePath treePath2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.visualComponent instanceof JTable && ((JTable)this.visualComponent).getSelectionModel().isSelectedIndex(n + 1)) {
            treePath2 = this.getPathForRow(n + 1);
            if (((JTable)this.visualComponent).getSelectionModel().getSelectionMode() == 0) {
                bl2 = true;
            } else {
                bl3 = true;
            }
        }
        Vector vector = new Vector();
        this.addKids(object3, treePath, vector);
        this.rowMap.addAll(n + 1, vector);
        TableModelEvent tableModelEvent = new TableModelEvent(this, n + 1, n + vector.size(), -1, 1);
        this.postTableModelChanged(tableModelEvent);
        enumeration = JCListenerList.elements(this.treeExpansionListeners);
        while (enumeration.hasMoreElements()) {
            object = (TreeExpansionListener)enumeration.nextElement();
            object.treeExpanded((TreeExpansionEvent)serializable);
        }
        if (bl2) {
            ((JTable)this.visualComponent).setRowSelectionInterval(this.getRowForPath(treePath2), this.getRowForPath(treePath2));
        } else if (bl3) {
            ((JTable)this.visualComponent).getSelectionModel().removeIndexInterval(n + 1, this.getRowForPath(treePath2));
            ((JTable)this.visualComponent).addRowSelectionInterval(this.getRowForPath(treePath2), this.getRowForPath(treePath2));
        }
        if (this.getScrollsOnExpand() && this.visualComponent instanceof JTable && this.visualComponent.getParent() instanceof JViewport) {
            object = (JViewport)this.visualComponent.getParent();
            if (!(((Component)object).getParent() instanceof JScrollPane)) {
                return;
            }
            JTable jTable = (JTable)this.visualComponent;
            Point point = ((JViewport)object).getViewPosition();
            int n4 = ((JViewport)object).getExtentSize().height;
            Rectangle rectangle = jTable.getCellRect(n + vector.size(), 0, true);
            if (rectangle.y + rectangle.height <= point.y + n4) {
                return;
            }
            Rectangle rectangle2 = jTable.getCellRect(n, 0, true);
            Rectangle rectangle3 = new Rectangle(rectangle);
            rectangle3.height = n4;
            int n5 = rectangle.y - rectangle2.y + rectangle.height;
            rectangle3.y = n5 <= n4 ? rectangle.y + rectangle.height - n4 - point.y : rectangle2.y - point.y;
            ((JViewport)object).scrollRectToVisible(rectangle3);
        }
    }

    public void expandRow(int n) {
        this.expandPathRow(this.getPathForRow(n), n);
    }

    public boolean getAutoSort() {
        if (!this.sortable) {
            this.autoSort = false;
        }
        return this.autoSort;
    }

    public Class getColumnClass(int n) {
        Class clazz = null;
        clazz = this.view == 1 && n == this.getTreeColumn() ? (class$javax$swing$tree$TreePath != null ? class$javax$swing$tree$TreePath : (class$javax$swing$tree$TreePath = TreeTableSupport.class$("javax.swing.tree.TreePath"))) : this.treetable.getColumnClass(n);
        return clazz;
    }

    public int getColumnCount() {
        return this.treetable.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.treetable.getColumnName(n);
    }

    public Enumeration getExpandedDescendants(TreePath treePath) {
        if (!this.isExpanded(treePath)) {
            return null;
        }
        Vector vector = new Vector();
        this.getExpandedKids(treePath, vector);
        return vector.elements();
    }

    protected void getExpandedKids(TreePath treePath, Vector vector) {
        if (!this.isExpanded(treePath)) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        int n = this.treetable.getChildCount(object);
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath2 = treePath.pathByAddingChild(this.treetable.getChild(object, n2));
            vector.add(treePath2);
            if (!this.treetable.isLeaf(this.treetable.getChild(object, n2))) {
                this.getExpandedKids(treePath2, vector);
            }
            ++n2;
        }
    }

    public int[] getKeyColumns(int n) {
        return this.keyColumnsArray[n];
    }

    protected int getLevel(int n) {
        TreePath treePath = this.getPathForRow(n);
        return treePath.getPathCount();
    }

    public int getLevelIndent() {
        return this.levelIndent;
    }

    public int getMaxIconHeight() {
        return this.cellHeight;
    }

    protected Object getNode(int n) {
        TreePath treePath = (TreePath)this.rowMap.elementAt(n);
        if (treePath == null) {
            return null;
        }
        return treePath.getLastPathComponent();
    }

    protected static Object getNode(TreePath treePath) {
        return treePath.getLastPathComponent();
    }

    public int getNodeIndent(TreePath treePath) {
        int n = treePath.getPath().length;
        if (!this.rootVisible) {
            --n;
        }
        if (!this.showsRootHandles) {
            --n;
        }
        return n * this.getLevelIndent();
    }

    protected static Object getParent(TreePath treePath) {
        if (treePath.getPathCount() == 1) {
            return null;
        }
        return treePath.getPathComponent(treePath.getPathCount() - 2);
    }

    public TreePath getPathForRow(int n) {
        if (this.view == 1) {
            return (TreePath)this.rowMap.elementAt(n);
        }
        if (this.table instanceof DefaultRowSortTableModel && ((DefaultRowSortTableModel)this.table).getModel() instanceof TableFromTreeTable) {
            DefaultRowSortTableModel defaultRowSortTableModel = (DefaultRowSortTableModel)this.table;
            TableFromTreeTable tableFromTreeTable = (TableFromTreeTable)defaultRowSortTableModel.getModel();
            int n2 = defaultRowSortTableModel.getUnsortedRow(n);
            return tableFromTreeTable.rowToTreePath(n2);
        }
        return null;
    }

    public int getRendererIndent(TreePath treePath) {
        int n = this.getNodeIndent(treePath);
        if (this.iconRenderer != null) {
            n += this.openIcon.getIconWidth();
        }
        return n;
    }

    public int getRowCount() {
        JCDebug.println("tts", "num rows = " + this.rowMap.size());
        if (this.view == 1) {
            return this.rowMap.size();
        }
        if (this.table != null) {
            return this.table.getRowCount();
        }
        return 0;
    }

    public int getRowForPath(TreePath treePath) {
        int n = 0;
        while (n < this.rowMap.size()) {
            if (((TreePath)this.rowMap.elementAt(n)).equals(treePath)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected JCRowSortModel getRowSortModel() {
        if (this.sortable && this.view == 1 && this.treetable instanceof JCRowSortModel) {
            return (JCRowSortModel)((Object)this.treetable);
        }
        if (this.sortable && this.view == 2 && this.table != null) {
            return (JCRowSortModel)((Object)this.table);
        }
        return null;
    }

    public int[] getRowsForPaths(TreePath[] treePathArray) {
        int[] nArray = new int[treePathArray.length];
        int n = 0;
        int n2 = 0;
        while (n < treePathArray.length) {
            int n3 = this.getRowForPath(treePathArray[n]);
            if (n3 >= 0) {
                nArray[n2++] = n3;
            }
            ++n;
        }
        if (n != n2) {
            int[] nArray2 = new int[n2];
            int n4 = 0;
            while (n4 < n2) {
                nArray2[n4] = nArray[n4];
                ++n4;
            }
            nArray = nArray2;
        }
        return nArray;
    }

    public boolean getScrollsOnExpand() {
        return this.scrollsOnExpand;
    }

    public int getShowNodeLines() {
        return this.showNodeLines;
    }

    public boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public int getTreeColumn() {
        return this.treeColumn;
    }

    public Class getTreeColumnClass() {
        return this.treetable.getColumnClass(this.getTreeColumn());
    }

    public Object getTreeColumnValue(Object object) {
        return this.treetable.getValueAt(object, this.getTreeColumn());
    }

    public JCTreeIconRenderer getTreeIconRenderer() {
        return this.iconRenderer;
    }

    public JCTreeTableModel getTreeTableModel() {
        return this.treetable;
    }

    public int getUnsortedRow(int n) {
        throw new IllegalArgumentException("Not Implemeted");
    }

    public Object getValueAt(int n, int n2) {
        if (this.view == 1) {
            if (n2 == this.getTreeColumn()) {
                return this.rowMap.elementAt(n);
            }
            return this.treetable.getValueAt(this.getNode(n), n2);
        }
        if (this.table != null) {
            return this.table.getValueAt(n, n2);
        }
        return null;
    }

    public int getView() {
        return this.view;
    }

    public boolean hasBeenExpanded(TreePath treePath) {
        return treePath != null && this.expandedState.get(treePath) != null;
    }

    public void inferLookAndFeel() {
        this.expandedIcon = (Icon)UIManager.get("Tree.expandedIcon");
        if (this.expandedIcon == null) {
            this.expandedIcon = new DefaultIcon(false);
        }
        this.collapsedIcon = (Icon)UIManager.get("Tree.collapsedIcon");
        if (this.collapsedIcon == null) {
            this.collapsedIcon = new DefaultIcon(true);
        }
        this.leftLevelSpacing = (Integer)UIManager.get("Tree.leftChildIndent");
        this.rightLevelSpacing = (Integer)UIManager.get("Tree.rightChildIndent");
        this.openIcon = (Icon)UIManager.get("Tree.openIcon");
        this.closedIcon = (Icon)UIManager.get("Tree.closedIcon");
        this.leafIcon = (Icon)UIManager.get("Tree.leafIcon");
        this.lineColor = (Color)UIManager.get("Tree.hash");
        this.scrollsOnExpand = (Boolean)UIManager.get("Tree.scrollsOnExpand");
        this.levelIndent = this.leftLevelSpacing + this.rightLevelSpacing;
        this.tableBackground = (Color)UIManager.get("Table.background");
        this.cellHeight = Math.max(this.openIcon.getIconHeight(), this.closedIcon.getIconHeight());
        this.cellHeight = Math.max(this.cellHeight, this.leafIcon.getIconHeight());
        String string = UIManager.getLookAndFeel().getClass().getName();
        if (string.indexOf("metal.MetalLookAndFeel") != -1) {
            this.drawLines = false;
        } else if (string.indexOf("MotifLookAndFeel") != -1) {
            this.drawLines = true;
            this.lineThickness = 2;
            this.isMotif = true;
            this.lineStroke = new BasicStroke(this.lineThickness, 0, 2, 5.0f, null, 0.0f);
        } else {
            this.drawLines = true;
            this.lineThickness = 1;
            float[] fArray = new float[]{this.lineThickness, this.lineThickness};
            this.lineStroke = new BasicStroke(this.lineThickness, 0, 2, 5.0f, fArray, 0.0f);
        }
        if (this.showNodeLines != 3) {
            this.drawLines = this.showNodeLines == 1;
        }
    }

    protected void initTableViewModels() {
        this.table = new TableFromTreeTable(this.treetable);
        if (!(this.table instanceof JCRowSortTableModel)) {
            this.table = new DefaultRowSortTableModel(this.table);
        }
        this.table.addTableModelListener(this);
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.view == 1) {
            return this.treetable.isCellEditable(this.getNode(n), n2);
        }
        if (this.table != null) {
            return this.table.isCellEditable(n, n2);
        }
        return false;
    }

    public boolean isDataSorted() {
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            return jCRowSortModel.isDataSorted();
        }
        return false;
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object v = this.expandedState.get(treePath);
        if (v == null) {
            return false;
        }
        if (!((Boolean)v).booleanValue()) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            return this.isExpanded(treePath2);
        }
        return true;
    }

    protected static boolean isLastChild(JCTreeTableModel jCTreeTableModel, TreePath treePath) {
        Object object = TreeTableSupport.getParent(treePath);
        if (object == null) {
            return true;
        }
        return jCTreeTableModel.getIndexOfChild(object, TreeTableSupport.getNode(treePath)) == jCTreeTableModel.getChildCount(object) - 1;
    }

    protected boolean isPointInControlBox(Point point, int n, int n2, int n3) {
        --n3;
        if (!this.showsRootHandles) {
            --n3;
        }
        if (!this.rootVisible) {
            --n3;
        }
        int n4 = n2 / 2 - this.expandedIcon.getIconHeight() / 2;
        int n5 = this.levelIndent / 2 + n3 * this.levelIndent - this.expandedIcon.getIconWidth() / 2;
        JCDebug.println("tts", " p = " + point + "; x = " + n5 + "; y = " + n4);
        if (this.visualComponent instanceof JCTreeTable) {
            JCTreeTable jCTreeTable = (JCTreeTable)this.visualComponent;
            if (n != jCTreeTable.getTreeColumn()) {
                return false;
            }
            double d = 0.0;
            String string = System.getProperty("java.version");
            string.trim();
            if (string.lastIndexOf(".") > 2) {
                string = string.substring(0, 3);
            }
            try {
                d = Double.valueOf(string.trim());
            }
            catch (NumberFormatException numberFormatException) {}
            if (d < 1.3) {
                TableColumnModel tableColumnModel = jCTreeTable.getColumnModel();
                n5 += jCTreeTable.getIntercellSpacing().width / 2;
                int n6 = 0;
                while (n6 < n) {
                    n5 += tableColumnModel.getColumn(n6).getWidth() + jCTreeTable.getIntercellSpacing().width;
                    ++n6;
                }
                return point.x >= n5 && point.x < n5 + this.expandedIcon.getIconWidth() && point.y >= n4 && point.y < n4 + this.expandedIcon.getIconHeight();
            }
        }
        return true;
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    protected void mapTreeTable(boolean bl) {
        Object object = this.treetable.getRoot();
        this.rowMap = new RemovableVector();
        TreePath treePath = new TreePath(object);
        if (this.rootVisible) {
            this.rowMap.add(treePath);
        } else if (!this.treetable.isLeaf(object)) {
            this.expandedState.put(treePath, Boolean.TRUE);
        }
        Vector vector = new Vector();
        this.getExpandedKids(treePath, vector);
        this.rowMap.addAll(vector);
        if (bl) {
            this.postTableModelChanged(new TableModelEvent(this));
        }
    }

    protected void postTableModelChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null) {
            return;
        }
        Enumeration enumeration = JCListenerList.elements(this.tableListeners);
        while (enumeration.hasMoreElements()) {
            JCDebug.println("tts", "Posting table changed event to a listener");
            TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public void prepareCellForRender(Graphics graphics, int n, int n2) {
        graphics.setColor(this.tableBackground);
        graphics.fillRect(0, 0, n, n2);
    }

    public boolean processClickInTreeColumn(MouseEvent mouseEvent, int n, int n2, Point point, int n3) {
        if (n < 0 || n2 < 0) {
            return false;
        }
        if (this.view != 1) {
            return false;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return false;
        }
        if (this.treetable.isLeaf(this.getNode(n))) {
            return false;
        }
        if (this.isPointInControlBox(point, n2, n3, this.getLevel(n))) {
            this.toggleState(n);
            mouseEvent.consume();
        } else if (mouseEvent.getClickCount() == 2) {
            this.toggleState(n);
            mouseEvent.consume();
        } else {
            return false;
        }
        return true;
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.tableListeners = JCListenerList.remove(this.tableListeners, tableModelListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.treeExpansionListeners = JCListenerList.remove(this.treeExpansionListeners, treeExpansionListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.treeWillExpandListeners = JCListenerList.remove(this.treeWillExpandListeners, treeWillExpandListener);
    }

    public void renderHierarchy(Graphics graphics, Rectangle rectangle, TreePath treePath, Object object, Class clazz) {
        graphics.setColor(this.lineColor);
        Stroke stroke = null;
        if (this.lineStroke != null && graphics instanceof Graphics2D) {
            stroke = ((Graphics2D)graphics).getStroke();
            ((Graphics2D)graphics).setStroke(this.lineStroke);
        }
        int n = treePath.getPathCount() - 1;
        boolean bl = this.isExpanded(treePath);
        boolean bl2 = this.treetable.isLeaf(TreeTableSupport.getNode(treePath));
        int n2 = 0;
        if (this.rootVisible) {
            n2 = 0;
        } else if (!this.showsRootHandles) {
            n2 = 1;
        }
        int n3 = rectangle.y;
        int n4 = rectangle.height / 2 + n3;
        int n5 = rectangle.height + n3;
        int n6 = -1;
        TreePath treePath2 = treePath;
        int n7 = this.getNodeIndent(treePath);
        int n8 = 1;
        while (n8 < n - n2) {
            if (!TreeTableSupport.isLastChild(this.treetable, treePath2 = treePath2.getParentPath())) {
                n6 = n7 - n8 * this.levelIndent - this.levelIndent / 2;
                JCDebug.assert(n6 > 0);
                if (this.drawLines) {
                    graphics.drawLine(n6, n3, n6, n5);
                }
            }
            ++n8;
        }
        if ((n != 0 || this.showsRootHandles) && (n != 1 || this.rootVisible || this.showsRootHandles)) {
            n6 = n7 - this.levelIndent / 2;
            if (this.drawLines) {
                if (TreeTableSupport.isLastChild(this.treetable, treePath)) {
                    graphics.drawLine(n6, n3, n6, n4);
                } else {
                    graphics.drawLine(n6, n3, n6, n5);
                }
            }
            if (this.drawLines) {
                graphics.drawLine(n6, n4, n6 + this.levelIndent / 2, n4);
            }
            if (this.lineStroke != null && graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setStroke(stroke);
            }
            if (!bl2) {
                if (bl) {
                    this.expandedIcon.paintIcon(this.visualComponent, graphics, n6 - this.expandedIcon.getIconWidth() / 2, n4 - this.expandedIcon.getIconHeight() / 2);
                } else {
                    this.collapsedIcon.paintIcon(this.visualComponent, graphics, n6 - this.expandedIcon.getIconWidth() / 2, n4 - this.collapsedIcon.getIconHeight() / 2);
                }
            }
        }
        if (this.iconRenderer == null) {
            return;
        }
        Icon icon = null;
        icon = bl2 ? this.leafIcon : (bl ? this.openIcon : this.closedIcon);
        Icon icon2 = this.iconRenderer.getNodeIcon(this.treetable, TreeTableSupport.getNode(treePath), object, clazz, bl2, bl, icon);
        if (icon2 != null) {
            boolean bl3 = false;
            if (this.isMotif && bl2 && JCEnvironment.isWorking("MotifTreeLeafIcon") == 2) {
                bl3 = true;
                graphics.translate(this.getNodeIndent(treePath), 0);
            }
            icon2.paintIcon(this.visualComponent, graphics, this.getNodeIndent(treePath), rectangle.y);
            if (bl3) {
                graphics.translate(-this.getNodeIndent(treePath), 0);
            }
        }
    }

    public void scrollPathToVisible(TreePath treePath) {
    }

    public void setAutoSort(boolean bl) {
        if (this.autoSort == bl) {
            return;
        }
        this.autoSort = bl;
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setAutoSort(bl);
        }
    }

    public void setDataSorted(boolean bl) {
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setDataSorted(bl);
        }
    }

    public void setKeyColumns(int n, int[] nArray) {
        if (this.keyColumnsArray == null) {
            this.keyColumnsArray = new int[this.treetable.getColumnCount()][];
        }
        this.keyColumnsArray[n] = nArray;
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setKeyColumns(n, nArray);
        }
    }

    public void setRootVisible(boolean bl) {
        boolean bl2 = this.rootVisible;
        this.rootVisible = bl;
        this.visualComponent.firePropertyChange("rootVisible", bl2, bl);
        if (this.treetable != null) {
            this.mapTreeTable(true);
        }
    }

    public void setScrollsOnExpand(boolean bl) {
        boolean bl2 = this.scrollsOnExpand;
        this.scrollsOnExpand = bl;
        this.visualComponent.firePropertyChange("scrollsOnExpand", bl2, bl);
    }

    public void setShowNodeLines(int n) {
        if (this.showNodeLines == n) {
            return;
        }
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("invalid value for showNodeLines");
        }
        this.showNodeLines = n;
        if (this.showNodeLines == 3) {
            this.inferLookAndFeel();
        }
        this.drawLines = this.showNodeLines == 1;
    }

    public void setShowsRootHandles(boolean bl) {
        if (bl == this.showsRootHandles) {
            return;
        }
        boolean bl2 = this.showsRootHandles;
        this.showsRootHandles = bl;
        this.visualComponent.firePropertyChange("showsRootHandles", bl2, this.showsRootHandles);
        this.visualComponent.invalidate();
    }

    public void setSortColumn(int n) {
        if (!this.sortable) {
            return;
        }
        if (this.sortColumn == n) {
            return;
        }
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        this.sortColumn = n;
        if (jCRowSortModel != null) {
            jCRowSortModel.setSortColumn(n);
        }
    }

    public void setSortOrder(int n) {
        if (this.sortOrder == n) {
            return;
        }
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setSortOrder(n);
        }
        this.sortOrder = n;
    }

    public void setSortable(boolean bl) {
        this.sortable = bl;
        System.out.println(bl);
    }

    public void setTreeIconRenderer(JCTreeIconRenderer jCTreeIconRenderer) {
        this.iconRenderer = jCTreeIconRenderer;
    }

    public void setTreeTableModel(JCTreeTableModel jCTreeTableModel) {
        if (jCTreeTableModel == null) {
            jCTreeTableModel = new EmptyTreeTableModel(EmptyTreeTableModel.makeDefaultTree());
        }
        if (this.sortable && this.view == 1 && !(jCTreeTableModel instanceof JCRowSortModel)) {
            jCTreeTableModel = new TreeWithSortableChildren(jCTreeTableModel);
        }
        if (this.treetable == jCTreeTableModel) {
            return;
        }
        this.treetable = jCTreeTableModel;
        jCTreeTableModel.addTreeModelListener(this.treeListener);
        if (this.view == 2) {
            this.initTableViewModels();
        }
        Object object = jCTreeTableModel.getRoot();
        TreePath treePath = new TreePath(object);
        this.expandedState = new Hashtable();
        this.mapTreeTable(false);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.view == 1) {
            this.treetable.setValueAt(object, this.getNode(n), n2);
        } else if (this.table != null) {
            this.table.setValueAt(object, n, n2);
        }
    }

    public void setView(int n) {
        if (this.view == n) {
            return;
        }
        if (n != 2 && n != 1) {
            throw new IllegalArgumentException("view must be one of TREE or TABLE");
        }
        this.view = n;
        if (n == 2) {
            this.initTableViewModels();
        }
        this.postTableModelChanged(new TableModelEvent(this));
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        TableModelEvent tableModelEvent2 = new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType());
        Enumeration enumeration = JCListenerList.elements(this.tableListeners);
        while (enumeration.hasMoreElements()) {
            TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
            tableModelListener.tableChanged(tableModelEvent2);
        }
    }

    public void toggleSortOrder() {
        this.sortOrder = this.sortOrder == 1 ? -1 : 1;
        JCRowSortModel jCRowSortModel = this.getRowSortModel();
        if (jCRowSortModel != null) {
            jCRowSortModel.setSortOrder(this.sortOrder);
        }
    }

    protected void toggleState(int n) {
        if (this.isExpanded(this.getPathForRow(n))) {
            JCDebug.println("tts", "collapsing");
            this.collapseRow(n);
        } else {
            JCDebug.println("tts", "expanding");
            this.expandRow(n);
        }
    }

    class TreeListener
    implements TreeModelListener,
    Serializable {
        TreeListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            TreeTableSupport.this.mapTreeTable(true);
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            TreeTableSupport.this.mapTreeTable(true);
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreeTableSupport.this.mapTreeTable(true);
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            TreeTableSupport.this.mapTreeTable(true);
        }
    }

    class ToggleViewAction
    extends JCAction {
        public ToggleViewAction() {
            super("");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TreeTableSupport.this.view == 2) {
                TreeTableSupport.this.setView(1);
            } else {
                TreeTableSupport.this.setView(2);
            }
        }
    }

    class RemovableVector
    extends Vector {
        RemovableVector() {
        }

        public void remove(int n, int n2) {
            this.removeRange(n, n2);
        }
    }

    class DefaultIcon
    implements Icon {
        protected final int size = 9;
        protected final int halfsize = 4;
        protected boolean collapsed;

        public DefaultIcon(boolean bl) {
            this.collapsed = bl;
        }

        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.clearRect(n - 4, n2, 8, 8);
            graphics.drawRect(n - 4, n2, 8, 8);
            graphics.drawLine(n - 4 + 2, n2 + 4, n + 4 - 2, n2 + 4);
            if (this.collapsed) {
                graphics.drawLine(n, n2 + 2, n, n2 + 9 - 3);
            }
        }
    }
}

