/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.tools.ant.wsdl;

import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.util.HashMap;
import org.apache.axis.enum.Scope;
import org.apache.axis.tools.ant.wsdl.MappingSet;
import org.apache.axis.tools.ant.wsdl.NamespaceMapping;
import org.apache.axis.tools.ant.wsdl.TypeMappingVersionEnum;
import org.apache.axis.utils.DefaultAuthenticator;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;

public class Wsdl2javaAntTask
extends Task {
    private boolean verbose = false;
    private boolean debug = false;
    private boolean server = false;
    private boolean skeletonDeploy = false;
    private boolean testCase = false;
    private boolean noImports = false;
    private boolean all = false;
    private boolean helperGen = false;
    private String factory = null;
    private HashMap namespaceMap = new HashMap();
    private String output = ".";
    private String deployScope = "";
    private String url = "";
    private String typeMappingVersion = "1.1";
    private long timeout = 45000L;
    private File namespaceMappingFile = null;
    private MappingSet mappings = new MappingSet();
    private String username = null;
    private String password = null;
    private boolean printStackTraceOnFailure = true;
    private boolean failOnNetworkErrors = false;

    protected void validate() throws BuildException {
        if (this.url == null || this.url.length() == 0) {
            throw new BuildException("No url specified");
        }
        if (this.timeout < -1L) {
            throw new BuildException("negative timeout supplied");
        }
        File outdir = new File(this.output);
        if (!outdir.isDirectory() || !outdir.exists()) {
            throw new BuildException("output directory is not valid");
        }
    }

    public void traceParams(int logLevel) {
        this.log("Running Wsdl2javaAntTask with parameters:", logLevel);
        this.log("\tverbose:" + this.verbose, logLevel);
        this.log("\tdebug:" + this.debug, logLevel);
        this.log("\tserver-side:" + this.server, logLevel);
        this.log("\tskeletonDeploy:" + this.skeletonDeploy, logLevel);
        this.log("\thelperGen:" + this.helperGen, logLevel);
        this.log("\tfactory:" + this.factory, logLevel);
        this.log("\ttestCase:" + this.testCase, logLevel);
        this.log("\tnoImports:" + this.noImports, logLevel);
        this.log("\tNStoPkg:" + this.namespaceMap, logLevel);
        this.log("\toutput:" + this.output, logLevel);
        this.log("\tdeployScope:" + this.deployScope, logLevel);
        this.log("\tURL:" + this.url, logLevel);
        this.log("\tall:" + this.all, logLevel);
        this.log("\ttypeMappingVersion:" + this.typeMappingVersion, logLevel);
        this.log("\ttimeout:" + this.timeout, logLevel);
        this.log("\tfailOnNetworkErrors:" + this.failOnNetworkErrors, logLevel);
        this.log("\tprintStackTraceOnFailure:" + this.printStackTraceOnFailure, logLevel);
        this.log("\tnamespaceMappingFile:" + this.namespaceMappingFile, logLevel);
        this.log("\tusername:" + this.username, logLevel);
        this.log("\t:password" + this.password, logLevel);
        this.traceNetworkSettings(logLevel);
    }

    public void execute() throws BuildException {
        this.traceParams(3);
        this.validate();
        try {
            Emitter emitter = new Emitter();
            Scope scope = Scope.getScope(this.deployScope, null);
            if (scope != null) {
                emitter.setScope(scope);
            } else if (this.deployScope.length() != 0 && !"none".equalsIgnoreCase(this.deployScope)) {
                this.log("Unrecognized scope:  " + this.deployScope + ".  Ignoring it.", 3);
            }
            this.mappings.execute((ProjectComponent)this, this.namespaceMap, false);
            if (!this.namespaceMap.isEmpty()) {
                emitter.setNamespaceMap(this.namespaceMap);
            }
            emitter.setTestCaseWanted(this.testCase);
            emitter.setHelperWanted(this.helperGen);
            if (this.factory != null) {
                emitter.setFactory(this.factory);
            }
            emitter.setImports(!this.noImports);
            emitter.setAllWanted(this.all);
            emitter.setOutputDir(this.output);
            emitter.setServerSide(this.server);
            emitter.setSkeletonWanted(this.skeletonDeploy);
            emitter.setVerbose(this.verbose);
            emitter.setDebug(this.debug);
            emitter.setTypeMappingVersion(this.typeMappingVersion);
            if (this.namespaceMappingFile != null) {
                emitter.setNStoPkg(this.namespaceMappingFile.toString());
            }
            emitter.setTimeout(this.timeout);
            Authenticator.setDefault(new DefaultAuthenticator(this.username, this.password));
            this.log("WSDL2Java " + this.url, 2);
            try {
                emitter.run(this.url);
            }
            catch (Throwable e) {
                if (this.url.startsWith("http://")) {
                    if (!this.failOnNetworkErrors) {
                        this.log(e.toString(), 1);
                        return;
                    }
                    throw new BuildException("Could not build " + this.url, e);
                }
                throw e;
            }
        }
        catch (BuildException b) {
            throw b;
        }
        catch (Throwable t) {
            if (this.printStackTraceOnFailure) {
                this.traceParams(2);
                t.printStackTrace();
            }
            throw new BuildException("Error while processing WSDL in Wsdl2javaAntTask for " + this.url, t);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setServerSide(boolean parameter) {
        this.server = parameter;
    }

    public void setSkeletonDeploy(boolean parameter) {
        this.skeletonDeploy = parameter;
    }

    public void setTestCase(boolean parameter) {
        this.testCase = parameter;
    }

    public void setHelperGen(boolean parameter) {
        this.helperGen = parameter;
    }

    public void setFactory(String parameter) {
        this.factory = parameter;
    }

    public void setNoImports(boolean parameter) {
        this.noImports = parameter;
    }

    public void setOutput(File parameter) throws BuildException {
        try {
            this.output = parameter.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    public void setDeployScope(String scope) {
        this.deployScope = scope;
    }

    public void setURL(String parameter) {
        this.url = parameter;
    }

    public void setAll(boolean parameter) {
        this.all = parameter;
    }

    public void setTypeMappingVersion(TypeMappingVersionEnum parameter) {
        this.typeMappingVersion = parameter.getValue();
    }

    public void setTimeout(long parameter) {
        this.timeout = parameter;
    }

    public void addMapping(NamespaceMapping mapping) {
        this.mappings.addMapping(mapping);
    }

    public void addMappingSet(MappingSet mappingset) {
        this.mappings.addMappingSet(mappingset);
    }

    public void setNamespaceMappingFile(File namespaceMappingFile) {
        this.namespaceMappingFile = namespaceMappingFile;
    }

    public void setFailOnNetworkErrors(boolean failOnNetworkErrors) {
        this.failOnNetworkErrors = failOnNetworkErrors;
    }

    public void setPrintStackTraceOnFailure(boolean printStackTraceOnFailure) {
        this.printStackTraceOnFailure = printStackTraceOnFailure;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void traceSystemSetting(String setting, int logLevel) {
        String value = System.getProperty(setting);
        this.log("\t" + setting + "=" + value, logLevel);
    }

    private void traceNetworkSettings(int logLevel) {
        this.traceSystemSetting("http.proxyHost", logLevel);
        this.traceSystemSetting("http.proxyPort", logLevel);
        this.traceSystemSetting("http.proxyUser", logLevel);
        this.traceSystemSetting("http.proxyPassword", logLevel);
        this.traceSystemSetting("socks.proxyHost", logLevel);
        this.traceSystemSetting("socks.proxyPort", logLevel);
    }
}

