/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.HashMap;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.XmlCmlReader;
import org.jmol.adapter.smarter.XmlReader;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

class XmlMolproReader
extends XmlCmlReader {
    static String[] molProImplementedAttributes = new String[]{"id", "length", "type", "x3", "y3", "z3", "elementType", "name", "groups", "cartesianLength", "primitives", "minL", "maxL", "angular", "contractions", "occupation", "energy", "symmetryID", "wavenumber", "units"};
    int frequencyCount;

    XmlMolproReader(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, XMLReader xmlReader) {
        this.parent = parent;
        this.reader = reader;
        this.atomSetCollection = atomSetCollection;
        this.logger = parent.logger;
        new MolproHandler(xmlReader);
        this.parseReaderXML(xmlReader);
    }

    XmlMolproReader(XmlReader parent, AtomSetCollection atomSetCollection, JSObject DOMNode) {
        this.parent = parent;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = molProImplementedAttributes;
        new MolproHandler().walkDOMTree(DOMNode);
    }

    public void processStartElement2(String namespaceURI, String localName, String qName, HashMap atts) {
        if (localName.equals("normalCoordinate")) {
            String wavenumber = "";
            String units = "";
            this.atomSetCollection.cloneLastAtomSet();
            ++this.frequencyCount;
            if (atts.containsKey("wavenumber")) {
                wavenumber = (String)atts.get("wavenumber");
                if (atts.containsKey("units")) {
                    units = (String)atts.get("units");
                }
                this.atomSetCollection.setAtomSetProperty("Frequency", wavenumber + " " + units);
                this.keepChars = true;
            }
            return;
        }
        if (localName.equals("vibrations")) {
            this.frequencyCount = 0;
            return;
        }
    }

    public void processEndElement2(String uri, String localName, String qName) {
        if (localName.equals("normalCoordinate")) {
            int atomCount = this.atomSetCollection.getLastAtomSetAtomCount();
            this.tokens = this.getTokens(this.chars);
            int offset = this.tokens.length - atomCount * 3;
            for (int i = 0; i < atomCount; ++i) {
                Atom atom = this.atomSetCollection.atoms[i + this.atomSetCollection.currentAtomSetIndex * atomCount];
                atom.vectorX = this.parseFloat(this.tokens[offset++]);
                atom.vectorY = this.parseFloat(this.tokens[offset++]);
                atom.vectorZ = this.parseFloat(this.tokens[offset++]);
            }
        }
    }

    class MolproHandler
    extends XmlCmlReader.CmlHandler {
        MolproHandler() {
        }

        MolproHandler(XMLReader xmlReader) {
            this.setHandler(xmlReader, this);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
            super.startElement(namespaceURI, localName, qName, attributes);
            XmlMolproReader.this.processStartElement2(namespaceURI, localName, qName, this.atts);
        }

        public void endElement(String uri, String localName, String qName) {
            XmlMolproReader.this.processEndElement2(uri, localName, qName);
            super.endElement(uri, localName, qName);
        }
    }
}

