/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jmol.api.JmolViewer;
import org.jmol.applet.Jvm12;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;

class Console
implements ActionListener,
WindowListener {
    final JTextArea input = new ControlEnterTextArea();
    final JTextPane output = new JTextPane();
    final Document outputDocument = this.output.getDocument();
    final JFrame jf = new JFrame(GT._("Jmol Script Console"));
    final JButton runButton = new JButton(GT._("Execute"));
    final JButton clearOutButton = new JButton(GT._("Clear Output"));
    final JButton clearInButton = new JButton(GT._("Clear Input"));
    final JButton historyButton = new JButton(GT._("History"));
    final JButton stateButton = new JButton(GT._("State"));
    final JButton loadButton = new JButton(GT._("Load"));
    final SimpleAttributeSet attributesCommand = new SimpleAttributeSet();
    final JmolViewer viewer;
    final Jvm12 jvm12;

    Console(Component componentParent, JmolViewer viewer, Jvm12 jvm12) {
        this.viewer = viewer;
        this.jvm12 = jvm12;
        Logger.debug("Console constructor");
        this.setupInput();
        this.setupOutput();
        JScrollPane jscrollInput = new JScrollPane(this.input);
        jscrollInput.setMinimumSize(new Dimension(2, 100));
        JScrollPane jscrollOutput = new JScrollPane(this.output);
        jscrollOutput.setMinimumSize(new Dimension(2, 100));
        Container c = this.jf.getContentPane();
        JSplitPane jsp = new JSplitPane(0, jscrollOutput, jscrollInput);
        jsp.setResizeWeight(0.9);
        jsp.setDividerLocation(200);
        c.setLayout(new BoxLayout(c, 1));
        jsp.setAlignmentX(0.5f);
        c.add(jsp);
        Container c2 = new Container();
        c2.setLayout(new BoxLayout(c2, 0));
        c2.add(Box.createGlue());
        c2.add(this.runButton);
        c2.add(this.loadButton);
        c2.add(this.clearInButton);
        c2.add(this.clearOutButton);
        c2.add(this.historyButton);
        c2.add(this.stateButton);
        c2.add(Box.createGlue());
        c.add(c2);
        JLabel label1 = new JLabel(GT._("press CTRL-ENTER for new line or paste model data and press Load"), 0);
        label1.setAlignmentX(0.5f);
        c.add(label1);
        this.runButton.addActionListener(this);
        this.clearInButton.addActionListener(this);
        this.clearOutButton.addActionListener(this);
        this.historyButton.addActionListener(this);
        this.stateButton.addActionListener(this);
        this.loadButton.addActionListener(this);
        ((Component)this.jf).setSize(550, 400);
        this.jf.addWindowListener(this);
    }

    void setupInput() {
        this.input.setLineWrap(true);
        this.input.setWrapStyleWord(true);
        Keymap map = this.input.getKeymap();
        KeyStroke shiftA = KeyStroke.getKeyStroke(65, 1);
        map.removeKeyStrokeBinding(shiftA);
    }

    void setupOutput() {
        this.output.setEditable(false);
        StyleConstants.setBold(this.attributesCommand, true);
    }

    void setVisible(boolean visible) {
        Logger.debug("Console.setVisible(" + visible + ")");
        ((Component)this.jf).setVisible(visible);
        this.input.requestFocus();
    }

    void output(String message) {
        this.output(message, null);
    }

    void output(String message, AttributeSet att) {
        if (message == null || message.length() == 0) {
            this.output.setText("");
            return;
        }
        if (message.charAt(message.length() - 1) != '\n') {
            message = message + "\n";
        }
        try {
            this.outputDocument.insertString(this.outputDocument.getLength(), message, att);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.output.setCaretPosition(this.outputDocument.getLength());
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.runButton) {
            this.execute();
        }
        if (source == this.clearInButton) {
            this.input.setText("");
        }
        if (source == this.clearOutButton) {
            this.output.setText("");
        }
        if (source == this.historyButton) {
            this.output.setText(this.viewer.getSetHistory(Integer.MAX_VALUE));
        }
        if (source == this.stateButton) {
            this.output.setText(this.viewer.getStateInfo());
        }
        if (source == this.loadButton) {
            this.viewer.loadInline(this.input.getText());
        }
    }

    void execute() {
        String strCommand = this.input.getText();
        this.input.setText(null);
        this.output(strCommand, this.attributesCommand);
        String strErrorMessage = this.viewer.script(strCommand);
        if (strErrorMessage != null) {
            this.output(strErrorMessage);
        }
        this.input.requestFocus();
    }

    public void windowActivated(WindowEvent we) {
    }

    public void windowClosed(WindowEvent we) {
        this.jvm12.console = null;
    }

    public void windowClosing(WindowEvent we) {
        this.jvm12.console = null;
    }

    public void windowDeactivated(WindowEvent we) {
    }

    public void windowDeiconified(WindowEvent we) {
    }

    public void windowIconified(WindowEvent we) {
    }

    public void windowOpened(WindowEvent we) {
    }

    class ControlEnterTextArea
    extends JTextArea {
        ControlEnterTextArea() {
        }

        public void processComponentKeyEvent(KeyEvent ke) {
            switch (ke.getID()) {
                case 401: {
                    if (ke.getKeyCode() == 10 && !ke.isControlDown()) {
                        Console.this.execute();
                        return;
                    }
                    if (ke.getKeyCode() == 38) {
                        this.recallCommand(true);
                        return;
                    }
                    if (ke.getKeyCode() != 40) break;
                    this.recallCommand(false);
                    return;
                }
                case 402: {
                    if (ke.getKeyCode() != 10 || ke.isControlDown()) break;
                    return;
                }
            }
            if (ke.getKeyCode() == 10) {
                ke.setModifiers(0);
            }
            super.processComponentKeyEvent(ke);
        }

        private void recallCommand(boolean up) {
            String cmd = Console.this.viewer.getSetHistory(up ? -1 : 1);
            if (cmd == null) {
                return;
            }
            this.setText(cmd);
        }
    }
}

