/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.ProteinStructure;

class AlphaMonomer
extends Monomer {
    static final byte[] alphaOffsets = new byte[]{0};
    ProteinStructure proteinStructure;

    static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstIndex, int lastIndex, int[] specialAtomIndexes, Atom[] atoms) {
        if (firstIndex != lastIndex || specialAtomIndexes[2] != firstIndex) {
            return null;
        }
        return new AlphaMonomer(chain, group3, seqcode, firstIndex, lastIndex, alphaOffsets);
    }

    AlphaMonomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] offsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
    }

    boolean isAlphaMonomer() {
        return true;
    }

    void setStructure(ProteinStructure proteinStructure) {
        this.proteinStructure = proteinStructure;
    }

    ProteinStructure getProteinStructure() {
        return this.proteinStructure;
    }

    byte getProteinStructureType() {
        return this.proteinStructure == null ? (byte)0 : this.proteinStructure.type;
    }

    boolean isHelix() {
        return this.proteinStructure != null && this.proteinStructure.type == 3;
    }

    boolean isSheet() {
        return this.proteinStructure != null && this.proteinStructure.type == 2;
    }

    Atom getAtom(byte specialAtomID) {
        return specialAtomID == 2 ? this.getLeadAtom() : null;
    }

    Point3f getAtomPoint(byte specialAtomID) {
        return specialAtomID == 2 ? this.getLeadAtomPoint() : null;
    }

    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        if (!(possiblyPreviousMonomer instanceof AlphaMonomer)) {
            return false;
        }
        float distance = this.getLeadAtomPoint().distance(possiblyPreviousMonomer.getLeadAtomPoint());
        return distance <= 4.2f;
    }
}

