/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import org.jmol.util.ArrayUtil;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Group;
import org.jmol.viewer.Model;

final class Chain {
    Frame frame;
    Model model;
    char chainID;
    int groupCount;
    int selectedGroupCount;
    boolean isDna;
    boolean isRna;
    BitSet bsSelectedGroups;
    private static final BitSet bsNull = new BitSet();
    Group[] groups = new Group[16];

    Chain(Frame frame, Model model, char chainID) {
        this.frame = frame;
        this.model = model;
        this.chainID = chainID;
    }

    void freeze() {
        this.groups = (Group[])ArrayUtil.setLength(this.groups, this.groupCount);
    }

    boolean isDna() {
        return this.isDna;
    }

    boolean isRna() {
        return this.isRna;
    }

    void addGroup(Group group) {
        if (this.groupCount == this.groups.length) {
            this.groups = (Group[])ArrayUtil.doubleLength(this.groups);
        }
        this.groups[this.groupCount++] = group;
    }

    Group getGroup(int groupIndex) {
        return this.groups[groupIndex];
    }

    int getGroupCount() {
        return this.groupCount;
    }

    void selectAtoms(BitSet bs) {
        Frame frame = this.model.mmset.frame;
        Atom[] atoms = frame.getAtoms();
        int i = frame.getAtomCount();
        while (--i >= 0) {
            Atom atom = atoms[i];
            if (atom.getChain() != this) continue;
            bs.set(i);
        }
    }

    void calcSelectedGroupsCount(BitSet bsSelected) {
        this.selectedGroupCount = 0;
        if (this.bsSelectedGroups == null) {
            this.bsSelectedGroups = new BitSet();
        } else {
            this.bsSelectedGroups.and(bsNull);
        }
        int i = this.groupCount;
        while (--i >= 0) {
            if (!this.groups[i].isSelected(bsSelected)) continue;
            ++this.selectedGroupCount;
            this.bsSelectedGroups.set(i);
        }
    }

    void selectSeqcodeRange(int seqcodeA, int seqcodeB, BitSet bs) {
        int groupIndexB;
        int i = 0;
        if (seqcodeB == Integer.MAX_VALUE) {
            seqcodeB = this.getMaxSeqcode();
        }
        if ((groupIndexB = this.getNextSeqcodeIndex(0, seqcodeB)) < 0) {
            return;
        }
        do {
            int indexLast;
            int indexFirst;
            int groupIndexA;
            if ((groupIndexA = this.getNextSeqcodeIndex(i, seqcodeA)) < 0) {
                return;
            }
            if (groupIndexB < 0 && (groupIndexB = this.getNextSeqcodeIndex(i, seqcodeB)) < 0) {
                return;
            }
            if (groupIndexA <= groupIndexB) {
                indexFirst = groupIndexA;
                indexLast = groupIndexB;
            } else {
                indexFirst = groupIndexB;
                indexLast = groupIndexA;
            }
            groupIndexB = -1;
            for (i = indexFirst; i <= indexLast; ++i) {
                this.groups[i].selectAtoms(bs);
            }
        } while (i < this.groupCount);
    }

    int getMaxSeqcode() {
        int n = 0;
        for (int i = 0; i < this.groupCount; ++i) {
            if (this.groups[i].seqcode <= n) continue;
            n = this.groups[i].seqcode;
        }
        return n;
    }

    int getNextSeqcodeIndex(int iStart, int seqcode) {
        for (int i = iStart; i < this.groupCount; ++i) {
            if (this.groups[i].seqcode != seqcode) continue;
            return i;
        }
        return -1;
    }

    int getSelectedGroupCount() {
        return this.selectedGroupCount;
    }

    int getSelectedGroupIndex(Group group) {
        int selectedGroupIndex = 0;
        for (int i = 0; i < this.groupCount; ++i) {
            if (!this.bsSelectedGroups.get(i)) continue;
            if (this.groups[i] == group) {
                return selectedGroupIndex;
            }
            ++selectedGroupIndex;
        }
        return -1;
    }
}

