/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomShape;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Shape;
import org.jmol.viewer.Text;

class Labels
extends AtomShape {
    String[] strings;
    String[] formats;
    short[] bgcolixes;
    byte[] fids;
    int[] offsets;
    Hashtable atomLabels = new Hashtable();
    Text text;
    BitSet bsFontSet;
    BitSet bsBgColixSet;
    int defaultOffset;
    byte defaultFontId;
    short defaultColix;
    short defaultBgcolix;
    byte defaultPaletteID;
    int defaultAlignment;
    int defaultPointer;
    int defaultZpos;
    byte zeroFontId;
    int zeroOffset;
    boolean defaultsOnlyForNone = true;
    int labelOffsetX = 4;
    int labelOffsetY = 4;
    int pointsLabelFontSize = 13;
    static final int ZPOS_FLAGS = 48;
    static final int FRONT_FLAG = 32;
    static final int GROUP_FLAG = 16;
    static final int POINTER_FLAGS = 3;
    static final int ALIGN_FLAGS = 12;
    static final int FLAGS = 63;

    Labels() {
    }

    void initShape() {
        this.defaultFontId = this.zeroFontId = this.g3d.getFont3D((String)"SansSerif", (String)"Plain", (int)13).fid;
        this.defaultColix = 0;
        this.defaultBgcolix = 0;
        this.zeroOffset = 1028;
        this.defaultOffset = 1028;
        super.initShape();
    }

    void setProperty(String propertyName, Object value, BitSet bsSelected) {
        this.isActive = true;
        if ("color" == propertyName) {
            this.isActive = true;
            int n = 0;
            byte pid = JmolConstants.pidOf(value);
            short colix = Graphics3D.getColix(value);
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setColix(i, colix, pid, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultColix = colix;
                this.defaultPaletteID = pid;
            }
            return;
        }
        if ("label" == propertyName) {
            this.isActive = true;
            if (this.bsSizeSet == null) {
                this.bsSizeSet = new BitSet();
            }
            String strLabel = (String)value;
            int i = this.atomCount;
            while (--i >= 0) {
                Atom atom;
                if (!bsSelected.get(i)) continue;
                String label = (atom = this.atoms[i]).formatLabel(strLabel);
                atom.setShapeVisibility(this.myVisibilityFlag, label != null);
                if (this.strings == null || i >= this.strings.length) {
                    this.strings = ArrayUtil.ensureLength(this.strings, i + 1);
                }
                if (this.formats == null || i >= this.formats.length) {
                    this.formats = ArrayUtil.ensureLength(this.formats, i + 1);
                }
                this.strings[i] = label;
                this.formats[i] = strLabel;
                this.bsSizeSet.set(i, strLabel != null);
                this.text = (Text)this.atomLabels.get(this.atoms[i]);
                if (this.text != null) {
                    this.text.setText(label);
                }
                if (this.defaultOffset != this.zeroOffset) {
                    this.setOffsets(i, this.defaultOffset, -1);
                }
                if (this.defaultAlignment != 1) {
                    this.setAlignment(i, this.defaultAlignment, -1);
                }
                if (this.defaultPointer != 0) {
                    this.setPointer(i, this.defaultPointer, -1);
                }
                if (this.defaultColix != 0 || this.defaultPaletteID != 0) {
                    this.setColix(i, this.defaultColix, this.defaultPaletteID, -1);
                }
                if (this.defaultBgcolix != 0) {
                    this.setBgcolix(i, this.defaultBgcolix, -1);
                }
                if (this.defaultFontId == this.zeroFontId) continue;
                this.setFont(i, this.defaultFontId, -1);
            }
            return;
        }
        if ("bgcolor" == propertyName) {
            this.isActive = true;
            if (this.bsBgColixSet == null) {
                this.bsBgColixSet = new BitSet();
            }
            short bgcolix = Graphics3D.getColix(value);
            int n = 0;
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setBgcolix(i, bgcolix, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultBgcolix = bgcolix;
            }
            return;
        }
        if (this.bsFontSet == null) {
            this.bsFontSet = new BitSet();
        }
        if ("fontsize" == propertyName) {
            int fontsize = (Integer)value;
            if (fontsize < 0) {
                this.fids = null;
                return;
            }
            byte fid = this.g3d.getFontFid(fontsize);
            int n = 0;
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setFont(i, fid, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultFontId = fid;
            }
            return;
        }
        if ("font" == propertyName) {
            byte fid = ((Font3D)value).fid;
            int n = 0;
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setFont(i, fid, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultFontId = fid;
            }
            return;
        }
        if ("offset" == propertyName) {
            int offset = (Integer)value;
            if (offset == 0) {
                offset = Short.MAX_VALUE;
            } else if (offset == this.zeroOffset) {
                offset = 0;
            }
            int n = 0;
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setOffsets(i, offset, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultOffset = offset;
            }
            return;
        }
        if ("align" == propertyName) {
            String type = (String)value;
            int alignment = 1;
            if (type.equalsIgnoreCase("right")) {
                alignment = 3;
            } else if (type.equalsIgnoreCase("center")) {
                alignment = 2;
            }
            int n = 0;
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setAlignment(i, alignment, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultAlignment = alignment;
            }
            return;
        }
        if ("pointer" == propertyName) {
            int pointer = (Integer)value;
            int n = 0;
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setPointer(i, pointer, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultPointer = pointer;
            }
            return;
        }
        if ("front" == propertyName) {
            boolean TF = (Boolean)value;
            int n = 0;
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setFront(i, TF, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultZpos = TF ? 32 : 0;
            }
            return;
        }
        if ("group" == propertyName) {
            boolean TF = (Boolean)value;
            int n = 0;
            int i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.setGroup(i, TF, n++);
            }
            if (n == 0 || !this.defaultsOnlyForNone) {
                this.defaultZpos = TF ? 16 : 0;
            }
            return;
        }
        if ("toggleLabel" == propertyName) {
            int atomIndex = this.atomCount;
            while (--atomIndex >= 0) {
                if (!bsSelected.get(atomIndex)) continue;
                Atom atom = this.atoms[atomIndex];
                if (this.strings != null && this.strings.length > atomIndex && this.strings[atomIndex] != null) {
                    this.strings[atomIndex] = null;
                    this.formats[atomIndex] = null;
                    this.bsSizeSet.clear(atomIndex);
                } else {
                    String strLabel = this.viewer.getStandardLabelFormat();
                    this.strings = ArrayUtil.ensureLength(this.strings, atomIndex + 1);
                    this.strings[atomIndex] = atom.formatLabel(strLabel);
                    this.formats[atomIndex] = strLabel;
                    this.bsSizeSet.set(atomIndex);
                }
                atom.setShapeVisibility(this.myVisibilityFlag, this.strings[atomIndex] != null);
            }
            return;
        }
    }

    void setColix(int i, short colix, byte pid, int n) {
        this.setColixAndPalette(colix, pid, i);
        this.text = (Text)this.atomLabels.get(this.atoms[i]);
        if (this.text != null) {
            this.text.setColix(this.colixes[i]);
        }
    }

    void setBgcolix(int i, short bgcolix, int n) {
        if (this.bgcolixes == null || i >= this.bgcolixes.length) {
            if (bgcolix == 0) {
                return;
            }
            this.bgcolixes = ArrayUtil.ensureLength(this.bgcolixes, i + 1);
        }
        this.bgcolixes[i] = bgcolix;
        this.bsBgColixSet.set(i, bgcolix != 0);
        this.text = (Text)this.atomLabels.get(this.atoms[i]);
        if (this.text != null) {
            this.text.setBgColix(bgcolix);
        }
    }

    void setOffsets(int i, int offset, int n) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (offset == 0) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, i + 1);
        }
        this.offsets[i] = (this.offsets[i] & 0x3F) + (offset << 6);
        this.text = (Text)this.atomLabels.get(this.atoms[i]);
        if (this.text != null) {
            this.text.setOffset(offset);
        }
    }

    void setAlignment(int i, int alignment, int n) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (alignment == 1) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, i + 1);
        }
        this.offsets[i] = (this.offsets[i] & 0xFFFFFFF3) + (alignment << 2);
        this.text = (Text)this.atomLabels.get(this.atoms[i]);
        if (this.text != null) {
            this.text.setAlignment(alignment);
        }
    }

    void setPointer(int i, int pointer, int n) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (pointer == 0) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, i + 1);
        }
        this.offsets[i] = (this.offsets[i] & 0xFFFFFFFC) + pointer;
        this.text = (Text)this.atomLabels.get(this.atoms[i]);
        if (this.text != null) {
            this.text.setPointer(pointer);
        }
    }

    void setFront(int i, boolean TF, int n) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (!TF) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, i + 1);
        }
        this.offsets[i] = (this.offsets[i] & 0xFFFFFFCF) + (TF ? 32 : 0);
    }

    void setGroup(int i, boolean TF, int n) {
        if (this.offsets == null || i >= this.offsets.length) {
            if (!TF) {
                return;
            }
            this.offsets = ArrayUtil.ensureLength(this.offsets, i + 1);
        }
        this.offsets[i] = (this.offsets[i] & 0xFFFFFFCF) + (TF ? 16 : 0);
    }

    void setFont(int i, byte fid, int n) {
        if (this.fids == null || i >= this.fids.length) {
            if (fid == this.zeroFontId) {
                return;
            }
            this.fids = ArrayUtil.ensureLength(this.fids, i + 1);
        }
        this.fids[i] = fid;
        this.bsFontSet.set(i);
        this.text = (Text)this.atomLabels.get(this.atoms[i]);
        if (this.text != null) {
            this.text.setFid(fid);
        }
    }

    void setModelClickability() {
        if (this.strings == null) {
            return;
        }
        int i = this.strings.length;
        while (--i >= 0) {
            String label = this.strings[i];
            if (label == null || this.frame.atoms.length <= i || this.frame.bsHidden.get(i)) continue;
            this.frame.atoms[i].clickabilityFlags |= this.myVisibilityFlag;
        }
    }

    void getShapeState(StringBuffer s) {
        Shape.appendCmd(s, "\n# label defaults;\nselect none");
        Shape.appendCmd(s, this.getColorCommand("label", this.defaultPaletteID, this.defaultColix));
        Shape.appendCmd(s, "background label " + this.encodeColor(this.defaultBgcolix));
        Shape.appendCmd(s, "set labelOffset " + Text.getXOffset(this.defaultOffset) + " " + -Text.getYOffset(this.defaultOffset));
        String align = Text.getAlignment(this.defaultAlignment);
        Shape.appendCmd(s, "set labelAlignment " + (align.length() < 5 ? "left" : align));
        String pointer = Text.getPointer(this.defaultPointer);
        Shape.appendCmd(s, "set labelPointer " + (pointer.length() == 0 ? "off" : pointer));
        if ((this.defaultOffset & 0x20) != 0) {
            Shape.appendCmd(s, "set labelFront");
        }
        if ((this.defaultOffset & 0x10) != 0) {
            Shape.appendCmd(s, "set labelGroup");
        }
        Shape.appendCmd(s, Shape.getFontCommand("label", Font3D.getFont3D(this.defaultFontId)));
    }

    String getShapeState() {
        if (!this.isActive) {
            return "";
        }
        Hashtable temp = new Hashtable();
        Hashtable temp2 = new Hashtable();
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.bsSizeSet == null || !this.bsSizeSet.get(i)) continue;
            Shape.setStateInfo(temp, i, "label " + this.formats[i]);
            if (this.bsColixSet != null && this.bsColixSet.get(i)) {
                Shape.setStateInfo(temp2, i, this.getColorCommand("label", this.paletteIDs[i], this.colixes[i]));
            }
            if (this.bsBgColixSet != null && this.bsBgColixSet.get(i)) {
                Shape.setStateInfo(temp2, i, "background label " + this.encodeColor(this.bgcolixes[i]));
            }
            if (this.offsets != null && this.offsets.length > i) {
                String pointer;
                int offset = this.offsets[i];
                Shape.setStateInfo(temp2, i, "set labelOffset " + Text.getXOffset(offset >> 6) + " " + -Text.getYOffset(offset >> 6));
                String align = Text.getAlignment(offset >> 2);
                if (align.length() >= 5) {
                    Shape.setStateInfo(temp2, i, "set labelAlignment " + align);
                }
                if ((pointer = Text.getPointer(offset)).length() > 0) {
                    Shape.setStateInfo(temp2, i, "set labelPointer " + pointer);
                }
                if ((offset & 0x20) != 0) {
                    Shape.setStateInfo(temp2, i, "set labelFront");
                }
                if ((offset & 0x10) != 0) {
                    Shape.setStateInfo(temp2, i, "set labelGroup");
                }
            }
            if (this.bsFontSet == null || !this.bsFontSet.get(i)) continue;
            Shape.setStateInfo(temp2, i, Shape.getFontCommand("label", Font3D.getFont3D(this.fids[i])));
        }
        return Shape.getShapeCommands(temp, temp2, this.atomCount);
    }
}

