/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Font3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Measurement;
import org.jmol.viewer.Measures;
import org.jmol.viewer.PendingMeasurement;
import org.jmol.viewer.ShapeRenderer;

class MeasuresRenderer
extends ShapeRenderer {
    boolean showMeasurementNumbers;
    short measurementMad;
    Font3D font3d;
    Measurement measurement;
    boolean doJustify;
    AxisAngle4f aaT = new AxisAngle4f();
    Matrix3f matrixT = new Matrix3f();
    Point3f pointT = new Point3f();

    MeasuresRenderer() {
    }

    void render() {
        if (!this.viewer.getShowMeasurements()) {
            return;
        }
        Measures measures = (Measures)this.shape;
        this.doJustify = this.viewer.getJustifyMeasurements();
        this.measurementMad = measures.mad;
        this.font3d = measures.font3d;
        this.showMeasurementNumbers = measures.showMeasurementNumbers;
        measures.setVisibilityInfo();
        int i = measures.measurementCount;
        while (--i >= 0) {
            if (!measures.measurements[i].isVisible) continue;
            short colix = measures.measurements[i].colix;
            if (colix == 0) {
                colix = measures.colix;
            }
            if (colix == 0) {
                colix = this.viewer.getColixBackgroundContrast();
            }
            this.renderMeasurement(measures.measurements[i], colix);
        }
        this.renderPendingMeasurement(measures.pendingMeasurement);
    }

    void renderMeasurement(Measurement measurement, short colix) {
        this.renderMeasurement(measurement.count, measurement, colix, true);
    }

    void renderMeasurement(int count, Measurement measurement, short colix, boolean renderArcs) {
        this.measurement = measurement;
        switch (count) {
            case 2: {
                this.renderDistance(colix);
                break;
            }
            case 3: {
                this.renderAngle(colix, renderArcs);
                break;
            }
            case 4: {
                this.renderTorsion(colix, renderArcs);
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
    }

    int drawSegment(int x1, int y1, int z1, int x2, int y2, int z2, short colix) {
        if (this.measurementMad < 0) {
            this.g3d.drawDashedLine(colix, 4, 2, x1, y1, z1, x2, y2, z2);
            return 1;
        }
        short widthPixels = this.measurementMad;
        if (this.measurementMad >= 20) {
            widthPixels = this.viewer.scaleToScreen((z1 + z2) / 2, this.measurementMad);
        }
        this.g3d.fillCylinder(colix, (byte)2, widthPixels, x1, y1, z1, x2, y2, z2);
        return (widthPixels + 1) / 2;
    }

    void renderDistance(short colix) {
        this.renderDistance(this.frame.getAtomAt(this.measurement.countPlusIndices[1]), this.frame.getAtomAt(this.measurement.countPlusIndices[2]), colix);
    }

    void renderDistance(Atom atomA, Atom atomB, short colix) {
        int y;
        int x;
        int zA = atomA.screenZ - atomA.screenDiameter - 10;
        int zB = atomB.screenZ - atomB.screenDiameter - 10;
        int radius = this.drawSegment(atomA.screenX, atomA.screenY, zA, atomB.screenX, atomB.screenY, zB, colix);
        int z = (zA + zB) / 2;
        if (z < 1) {
            z = 1;
        }
        this.paintMeasurementString(x, y, z, radius, colix, ((x = (atomA.screenX + atomB.screenX) / 2) - atomA.screenX) * ((y = (atomA.screenY + atomB.screenY) / 2) - atomA.screenY) > 0, 0);
    }

    void renderAngle(short colix, boolean renderArcs) {
        this.renderAngle(this.frame.getAtomAt(this.measurement.countPlusIndices[1]), this.frame.getAtomAt(this.measurement.countPlusIndices[2]), this.frame.getAtomAt(this.measurement.countPlusIndices[3]), colix, renderArcs);
    }

    void renderAngle(Atom atomA, Atom atomB, Atom atomC, short colix, boolean renderArcs) {
        this.g3d.setColix(colix);
        int zA = atomA.screenZ - atomA.screenDiameter - 10;
        int zB = atomB.screenZ - atomB.screenDiameter - 10;
        int zC = atomC.screenZ - atomC.screenDiameter - 10;
        int zOffset = (zA + zB + zC) / 3;
        int radius = this.drawSegment(atomA.screenX, atomA.screenY, zA, atomB.screenX, atomB.screenY, zB, colix);
        radius += this.drawSegment(atomB.screenX, atomB.screenY, zB, atomC.screenX, atomC.screenY, zC, colix);
        radius = (radius + 1) / 2;
        if (!renderArcs) {
            return;
        }
        AxisAngle4f aa = this.measurement.aa;
        if (aa == null) {
            this.paintMeasurementString(atomB.screenX + 5, atomB.screenY - 5, zB, radius, colix, false, 0);
            return;
        }
        int dotCount = (int)((double)aa.angle / (Math.PI * 2) * 64.0);
        float stepAngle = aa.angle / (float)dotCount;
        this.aaT.set(aa);
        int iMid = dotCount / 2;
        int i = dotCount;
        while (--i >= 0) {
            this.aaT.angle = (float)i * stepAngle;
            this.matrixT.set(this.aaT);
            this.pointT.set(this.measurement.pointArc);
            this.matrixT.transform(this.pointT);
            this.pointT.add(atomB);
            Point3i screenArc = this.viewer.transformPoint(this.pointT);
            int zArc = screenArc.z - zOffset;
            if (zArc < 0) {
                zArc = 0;
            }
            this.g3d.drawPixel(screenArc.x, screenArc.y, zArc);
            if (i != iMid) continue;
            this.pointT.set(this.measurement.pointArc);
            this.pointT.scale(1.1f);
            this.matrixT.transform(this.pointT);
            this.pointT.add(atomB);
            Point3i screenLabel = this.viewer.transformPoint(this.pointT);
            int zLabel = screenLabel.z - zOffset;
            this.paintMeasurementString(screenLabel.x, screenLabel.y, zLabel, radius, colix, screenLabel.x < atomB.screenX, atomB.screenY);
        }
    }

    void renderTorsion(short colix, boolean renderArcs) {
        int[] countPlusIndices = this.measurement.countPlusIndices;
        this.renderTorsion(this.frame.getAtomAt(countPlusIndices[1]), this.frame.getAtomAt(countPlusIndices[2]), this.frame.getAtomAt(countPlusIndices[3]), this.frame.getAtomAt(countPlusIndices[4]), colix, renderArcs);
    }

    void renderTorsion(Atom atomA, Atom atomB, Atom atomC, Atom atomD, short colix, boolean renderArcs) {
        int zA = atomA.screenZ - atomA.screenDiameter - 10;
        int zB = atomB.screenZ - atomB.screenDiameter - 10;
        int zC = atomC.screenZ - atomC.screenDiameter - 10;
        int zD = atomD.screenZ - atomD.screenDiameter - 10;
        int radius = this.drawSegment(atomA.screenX, atomA.screenY, zA, atomB.screenX, atomB.screenY, zB, colix);
        radius += this.drawSegment(atomB.screenX, atomB.screenY, zB, atomC.screenX, atomC.screenY, zC, colix);
        radius += this.drawSegment(atomC.screenX, atomC.screenY, zC, atomD.screenX, atomD.screenY, zD, colix);
        this.paintMeasurementString((atomA.screenX + atomB.screenX + atomC.screenX + atomD.screenX) / 4, (atomA.screenY + atomB.screenY + atomC.screenY + atomD.screenY) / 4, (zA + zB + zC + zD) / 4, radius /= 3, colix, false, 0);
    }

    void paintMeasurementString(int x, int y, int z, int radius, short colix, boolean rightJustify, int yRef) {
        String strMeasurement;
        if (!this.showMeasurementNumbers) {
            return;
        }
        if (!this.doJustify) {
            rightJustify = false;
            yRef = y;
        }
        if ((strMeasurement = this.measurement.strMeasurement) == null) {
            return;
        }
        int xT = x;
        xT = rightJustify ? (xT -= radius / 2 + 2 + this.font3d.fontMetrics.stringWidth(strMeasurement)) : (xT += radius / 2 + 2);
        int yT = y + (yRef == 0 || yRef < y ? this.font3d.fontMetrics.getAscent() : -radius / 2);
        int zT = z - radius - 2;
        if (zT < 1) {
            zT = 1;
        }
        this.g3d.drawString(strMeasurement, this.font3d, colix, xT, yT, zT, zT);
    }

    void renderPendingMeasurement(PendingMeasurement pendingMeasurement) {
        int count = pendingMeasurement.count;
        int[] countPlusIndices = pendingMeasurement.countPlusIndices;
        if (!pendingMeasurement.isActive || count < 2) {
            return;
        }
        short colixRubberband = this.viewer.getColixRubberband();
        if (countPlusIndices[count] == -1) {
            this.renderPendingWithCursor(pendingMeasurement, colixRubberband);
        } else {
            this.renderMeasurement(pendingMeasurement, colixRubberband);
        }
    }

    void renderPendingWithCursor(PendingMeasurement pendingMeasurement, short colixRubberband) {
        int count = pendingMeasurement.count;
        if (count < 2) {
            return;
        }
        if (count > 2) {
            this.renderMeasurement(count - 1, pendingMeasurement, colixRubberband, false);
        }
        Atom atomLast = this.frame.getAtomAt(pendingMeasurement.countPlusIndices[count - 1]);
        int lastZ = atomLast.screenZ - atomLast.screenDiameter - 10;
        this.drawSegment(atomLast.screenX, atomLast.screenY, lastZ, this.viewer.getCursorX(), this.viewer.getCursorY(), 0, colixRubberband);
    }
}

